/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.bo2.Bo2LayerExporter;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectProvider;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public class Bo2Layer
extends CustomLayer {
    private Bo2ObjectProvider objectProvider;
    @Deprecated
    private int colour;
    @Deprecated
    private List<File> files = Collections.emptyList();
    private int density = 20;
    private static final long serialVersionUID = 1L;

    public Bo2Layer(Bo2ObjectProvider objectProvider, String description, int colour) {
        super(objectProvider.getName(), description, Layer.DataSize.NIBBLE, 50, colour);
        this.objectProvider = objectProvider;
    }

    public Bo2ObjectProvider getObjectProvider() {
        return this.objectProvider;
    }

    public void setObjectProvider(Bo2ObjectProvider objectProvider) {
        this.objectProvider = objectProvider;
        this.setName(objectProvider.getName());
        this.setDescription("Custom " + objectProvider.getName() + " objects");
        this.files = Collections.emptyList();
    }

    public List<File> getFiles() {
        return this.files;
    }

    @Override
    public Class<? extends LayerExporter> getExporterType() {
        return Bo2LayerExporter.class;
    }

    @Override
    public Bo2LayerExporter getExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        return new Bo2LayerExporter(dimension, platform, this);
    }

    public int getDensity() {
        return this.density;
    }

    public void setDensity(int density) {
        this.density = density;
    }

    @Override
    public String getType() {
        return "Custom Objects";
    }

    @Override
    public Bo2Layer clone() {
        Bo2Layer clone = (Bo2Layer)super.clone();
        clone.objectProvider = this.objectProvider.clone();
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.colour != 0) {
            this.setColour(this.colour);
            this.colour = 0;
        }
        if (this.density == 0) {
            this.density = 20;
        }
    }
}

