/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.importing;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.ChunkStore;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.util.LongAttributeKey;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.GameType;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_19Biomes;
import org.pepsoft.worldpainter.importing.MapImporter;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.Populate;
import org.pepsoft.worldpainter.layers.ReadOnly;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.exporters.FrostExporter;
import org.pepsoft.worldpainter.layers.exporters.ResourcesExporter;
import org.pepsoft.worldpainter.platforms.PlatformUtils;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.util.BiomeUtils;
import org.pepsoft.worldpainter.util.ChunkUtils;
import org.pepsoft.worldpainter.vo.EventVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMapImporter
extends MapImporter {
    private final Platform platform;
    private final TileFactory tileFactory;
    private final File levelDatFile;
    private final Set<MinecraftCoords> chunksToSkip;
    private final MapImporter.ReadOnlyOption readOnlyOption;
    private final Set<Integer> dimensionsToImport;
    private final boolean populateSupported;
    private String warnings;
    public static final Map<String, Terrain> TERRAIN_MAPPING = new HashMap<String, Terrain>();
    private static final Logger logger = LoggerFactory.getLogger(JavaMapImporter.class);
    private static final String EOL = System.getProperty("line.separator");
    private static final LongAttributeKey SEED = new LongAttributeKey("seed");

    public JavaMapImporter(Platform platform, TileFactory tileFactory, File levelDatFile, Set<MinecraftCoords> chunksToSkip, MapImporter.ReadOnlyOption readOnlyOption, Set<Integer> dimensionsToImport) {
        if (tileFactory == null || levelDatFile == null || readOnlyOption == null || dimensionsToImport == null) {
            throw new NullPointerException();
        }
        if (!levelDatFile.isFile()) {
            throw new IllegalArgumentException(levelDatFile + " does not exist or is not a regular file");
        }
        if (!platform.capabilities.contains((Object)Platform.Capability.BLOCK_BASED)) {
            throw new IllegalArgumentException("Non block based platform " + platform + " not supported");
        }
        this.platform = platform;
        this.tileFactory = tileFactory;
        this.levelDatFile = levelDatFile;
        this.chunksToSkip = chunksToSkip;
        this.readOnlyOption = readOnlyOption;
        this.dimensionsToImport = dimensionsToImport;
        this.populateSupported = platform.capabilities.contains((Object)Platform.Capability.POPULATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public World2 doImport(ProgressReceiver progressReceiver) throws IOException, ProgressReceiver.OperationCancelled {
        Configuration config;
        SimpleTheme theme;
        String dimWarnings;
        long start = System.currentTimeMillis();
        logger.info("Importing map from " + this.levelDatFile.getAbsolutePath());
        File worldDir = this.levelDatFile.getParentFile();
        int dimCount = this.dimensionsToImport.size();
        JavaLevel level = JavaLevel.load(this.levelDatFile);
        World2 world = this.importWorld(level);
        long minecraftSeed = world.getAttribute(SEED).orElse(new Random().nextLong());
        this.tileFactory.setSeed(minecraftSeed);
        Dimension dimension = new Dimension(world, "Surface", minecraftSeed, this.tileFactory, Dimension.Anchor.NORMAL_DETAIL);
        dimension.setEventsInhibited(true);
        try {
            dimension.setCoverSteepTerrain(false);
            dimension.setSubsurfaceMaterial(Terrain.STONE);
            dimension.setBorderLevel(62);
            FrostExporter.FrostSettings frostSettings = new FrostExporter.FrostSettings();
            frostSettings.setMode(0);
            dimension.setLayerSettings(Frost.INSTANCE, frostSettings);
            ResourcesExporter.ResourcesExporterSettings resourcesSettings = (ResourcesExporter.ResourcesExporterSettings)dimension.getLayerSettings(Resources.INSTANCE);
            resourcesSettings.setMinimumLevel(0);
            Configuration config2 = Configuration.getInstance();
            dimension.setGridEnabled(config2.isDefaultGridEnabled());
            dimension.setGridSize(config2.getDefaultGridSize());
            dimension.setContoursEnabled(config2.isDefaultContoursEnabled());
            dimension.setContourSeparation(config2.getDefaultContourSeparation());
            boolean dimensionHeaderAdded = false;
            try {
                dimension.setGenerator(level.getGenerator(0));
            }
            catch (IllegalArgumentException e) {
                dimension.setGenerator(new SuperflatGenerator(SuperflatPreset.defaultPreset(this.platform)));
                String warning = "Could not parse Superflat preset (details: \"" + e.getMessage() + "\"); Superflat preset reset to defaults" + EOL;
                logger.error(warning, (Throwable)e);
                this.warnings = this.warnings == null ? dimension.getName() + ':' + EOL + warning : this.warnings + EOL + dimension.getName() + ':' + EOL + warning;
                dimensionHeaderAdded = true;
            }
            dimWarnings = this.importDimension(worldDir, dimension, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, 0.0f, 1.0f / (float)dimCount) : null));
            if (dimWarnings != null) {
                this.warnings = this.warnings == null ? dimension.getName() + ':' + EOL + dimWarnings : this.warnings + (!dimensionHeaderAdded ? EOL + dimension.getName() + ':' + EOL : "") + dimWarnings;
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
        world.addDimension(dimension);
        int dimNo = 1;
        if (this.dimensionsToImport.contains(1)) {
            HeightMapTileFactory netherTileFactory = TileFactoryFactory.createNoiseTileFactory(minecraftSeed + 1L, Terrain.NETHERRACK, Math.max(0, world.getMinHeight()), Math.min(256, world.getMaxHeight()), 188, 192, true, false, 20.0f, 1.0);
            theme = (SimpleTheme)netherTileFactory.getTheme();
            SortedMap<Integer, Terrain> terrainRanges = theme.getTerrainRanges();
            terrainRanges.clear();
            terrainRanges.put(-1, Terrain.NETHERRACK);
            theme.setTerrainRanges(terrainRanges);
            theme.setLayerMap(null);
            dimension = new Dimension(world, "Nether", minecraftSeed + 1L, netherTileFactory, Dimension.Anchor.NETHER_DETAIL);
            dimension.setEventsInhibited(true);
            try {
                SubProgressReceiver subProgressReceiver;
                dimension.setCoverSteepTerrain(false);
                dimension.setSubsurfaceMaterial(Terrain.NETHERRACK);
                ResourcesExporter.ResourcesExporterSettings resourcesSettings = (ResourcesExporter.ResourcesExporterSettings)dimension.getLayerSettings(Resources.INSTANCE);
                resourcesSettings.setMinimumLevel(0);
                dimension.setGenerator(level.getGenerator(1));
                if (progressReceiver != null) {
                    ++dimNo;
                    subProgressReceiver = new SubProgressReceiver(progressReceiver, (float)dimNo / (float)dimCount, 1.0f / (float)dimCount);
                } else {
                    subProgressReceiver = null;
                }
                String dimWarnings2 = this.importDimension(worldDir, dimension, (ProgressReceiver)subProgressReceiver);
                if (dimWarnings2 != null) {
                    this.warnings = this.warnings == null ? dimension.getName() + ':' + EOL + dimWarnings2 : this.warnings + EOL + dimension.getName() + ':' + EOL + dimWarnings2;
                }
            }
            finally {
                dimension.setEventsInhibited(false);
            }
            world.addDimension(dimension);
        }
        if (this.dimensionsToImport.contains(2)) {
            HeightMapTileFactory endTileFactory = TileFactoryFactory.createNoiseTileFactory(minecraftSeed + 2L, Terrain.END_STONE, Math.max(0, world.getMinHeight()), Math.min(256, world.getMaxHeight()), 32, 0, false, false, 20.0f, 1.0);
            theme = (SimpleTheme)endTileFactory.getTheme();
            SortedMap<Integer, Terrain> terrainRanges = theme.getTerrainRanges();
            terrainRanges.clear();
            terrainRanges.put(-1, Terrain.END_STONE);
            theme.setTerrainRanges(terrainRanges);
            theme.setLayerMap(Collections.emptyMap());
            dimension = new Dimension(world, "End", minecraftSeed + 2L, endTileFactory, Dimension.Anchor.END_DETAIL);
            dimension.setEventsInhibited(true);
            try {
                dimension.setCoverSteepTerrain(false);
                dimension.setSubsurfaceMaterial(Terrain.END_STONE);
                dimension.setGenerator(level.getGenerator(2));
                dimWarnings = this.importDimension(worldDir, dimension, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, (float)dimNo / (float)dimCount, 1.0f / (float)dimCount) : null));
                if (dimWarnings != null) {
                    this.warnings = this.warnings == null ? dimension.getName() + ':' + EOL + dimWarnings : this.warnings + EOL + dimension.getName() + ':' + EOL + dimWarnings;
                }
            }
            finally {
                dimension.setEventsInhibited(false);
            }
            world.addDimension(dimension);
        }
        if ((config = Configuration.getInstance()) != null) {
            EventVO event = new EventVO("action.importMap").duration(System.currentTimeMillis() - start);
            event.setAttribute(EventVO.ATTRIBUTE_TIMESTAMP, (Serializable)new Date(start));
            event.setAttribute(Constants.ATTRIBUTE_KEY_MAX_HEIGHT, (Serializable)Integer.valueOf(world.getMaxHeight()));
            event.setAttribute(Constants.ATTRIBUTE_KEY_PLATFORM, (Serializable)((Object)world.getPlatform().displayName));
            event.setAttribute(Constants.ATTRIBUTE_KEY_PLATFORM_ID, (Serializable)((Object)world.getPlatform().id));
            event.setAttribute(Constants.ATTRIBUTE_KEY_MAP_FEATURES, (Serializable)Boolean.valueOf(world.isMapFeatures()));
            event.setAttribute(Constants.ATTRIBUTE_KEY_GAME_TYPE_NAME, (Serializable)((Object)world.getGameType().name()));
            event.setAttribute(Constants.ATTRIBUTE_KEY_ALLOW_CHEATS, (Serializable)Boolean.valueOf(world.isAllowCheats()));
            event.setAttribute(Constants.ATTRIBUTE_KEY_GENERATOR, (Serializable)((Object)world.getDimension(Dimension.Anchor.NORMAL_DETAIL).getGenerator().getType().name()));
            event.setAttribute(Constants.ATTRIBUTE_KEY_TILES, (Serializable)Integer.valueOf(dimension.getTileCount()));
            config.logEvent(event);
        }
        return world;
    }

    protected World2 importWorld(JavaLevel level) {
        String name = level.getName().trim();
        int minHeight = level.getMinHeight();
        int maxHeight = level.getMaxHeight();
        World2 world = new World2(this.platform, minHeight, maxHeight);
        world.addHistoryEntry(4, new Serializable[]{level.getName(), this.levelDatFile.getParentFile()});
        world.setCreateGoodiesChest(false);
        world.setName(name);
        world.setSpawnPoint(new Point(level.getSpawnX(), level.getSpawnZ()));
        world.setImportedFrom(this.levelDatFile);
        world.setMapFeatures(level.isMapFeatures());
        if (level.isHardcore()) {
            world.setGameType(GameType.HARDCORE);
        } else {
            world.setGameType(GameType.values()[level.getGameType()]);
        }
        world.setDifficulty(level.getDifficulty());
        if (this.platform != DefaultPlugin.JAVA_MCREGION && level.getBorderSize() > 0.0) {
            world.getBorderSettings().setCentreX((int)Math.round(level.getBorderCenterX()));
            world.getBorderSettings().setCentreY((int)Math.round(level.getBorderCenterZ()));
            world.getBorderSettings().setSize((int)Math.round(level.getBorderSize()));
            world.getBorderSettings().setSafeZone((int)Math.round(level.getBorderSafeZone()));
            world.getBorderSettings().setWarningBlocks((int)Math.round(level.getBorderWarningBlocks()));
            world.getBorderSettings().setWarningTime((int)Math.round(level.getBorderWarningTime()));
            world.getBorderSettings().setSizeLerpTarget((int)Math.round(level.getBorderSizeLerpTarget()));
            world.getBorderSettings().setSizeLerpTime((int)level.getBorderSizeLerpTime());
            world.getBorderSettings().setDamagePerBlock((float)level.getBorderDamagePerBlock());
        }
        world.setAttribute(SEED, level.getSeed());
        return world;
    }

    @Override
    public String getWarnings() {
        return this.warnings;
    }

    private String importDimension(File worldDir, final Dimension dimension, final ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        if (progressReceiver != null) {
            progressReceiver.setMessage(dimension.getName() + " dimension");
        }
        final int minHeight = dimension.getMinHeight();
        final int maxHeight = dimension.getMaxHeight();
        final int maxY = maxHeight - 1;
        final Set<Point> newChunks = Collections.synchronizedSet(new HashSet());
        final Set manMadeBlockTypes = Collections.synchronizedSet(new HashSet());
        final BiomeScheme standardBiomes = BiomeUtils.getBiomeScheme(this.platform);
        final Set unknownBiomes = Collections.synchronizedSet(new HashSet());
        final boolean importBiomes = this.platform.capabilities.contains((Object)Platform.Capability.BIOMES) || this.platform.capabilities.contains((Object)Platform.Capability.BIOMES_3D) || this.platform.capabilities.contains((Object)Platform.Capability.NAMED_BIOMES);
        final Set customNumberedBiomes = Collections.synchronizedSet(new HashSet());
        final Map customNamedBiomes = Collections.synchronizedMap(new HashMap());
        final AtomicInteger nextCustomBiomeId = new AtomicInteger(51);
        final Set allBiomes = Collections.synchronizedSet(new HashSet());
        final Set invalidBiomeIds = Collections.synchronizedSet(new HashSet());
        final AtomicBoolean deviatingBuildHeights = new AtomicBoolean();
        try (ChunkStore chunkStore = PlatformManager.getInstance().getChunkStore(this.platform, worldDir, dimension.getAnchor().dim);){
            Object object;
            ArrayList<CustomBiome> customBiomes;
            final int total = chunkStore.getChunkCount();
            final AtomicInteger count = new AtomicInteger();
            final StringBuffer reportBuilder = new StringBuffer();
            final Map nonNativePlatformsEncountered = Collections.synchronizedMap(new HashMap());
            if (!chunkStore.visitChunks(new ChunkStore.ChunkVisitor(){

                @Override
                public boolean visitChunk(Chunk chunk) {
                    try {
                        if (progressReceiver != null) {
                            progressReceiver.setProgress((float)count.getAndIncrement() / (float)total);
                        }
                        MinecraftCoords chunkCoords = chunk.getCoords();
                        if (JavaMapImporter.this.chunksToSkip != null && JavaMapImporter.this.chunksToSkip.contains(chunkCoords)) {
                            return true;
                        }
                        if (ChunkUtils.skipChunk(chunk)) {
                            return true;
                        }
                        Set<Platform> chunkNativePlatforms = PlatformUtils.determineNativePlatforms(chunk);
                        if (chunkNativePlatforms != null && !chunkNativePlatforms.contains(JavaMapImporter.this.platform)) {
                            chunkNativePlatforms.forEach(chunkNativePlatform -> nonNativePlatformsEncountered.computeIfAbsent(chunkNativePlatform, p -> new AtomicInteger()).incrementAndGet());
                        } else if (chunk.getMinHeight() > minHeight || chunk.getMaxHeight() < maxHeight) {
                            deviatingBuildHeights.set(true);
                        }
                        int chunkX = chunkCoords.x;
                        int chunkZ = chunkCoords.z;
                        int chunkMinHeight = Math.max(minHeight, chunk.getMinHeight());
                        Point tileCoords = new Point(chunkX >> 3, chunkZ >> 3);
                        Tile tile = dimension.getTile(tileCoords);
                        if (tile == null) {
                            tile = dimension.getTileFactory().createTile(tileCoords.x, tileCoords.y);
                            for (int xx = 0; xx < 8; ++xx) {
                                for (int yy = 0; yy < 8; ++yy) {
                                    newChunks.add(new Point(tileCoords.x << 7 | xx << 4, tileCoords.y << 7 | yy << 4));
                                }
                            }
                            dimension.addTile(tile);
                        }
                        if (JavaMapImporter.this.populateSupported && !chunk.isTerrainPopulated()) {
                            tile.setBitLayerValue(Populate.INSTANCE, chunkX << 4 & 0x7F, chunkZ << 4 & 0x7F, true);
                        }
                        boolean manMadeStructuresBelowGround = false;
                        boolean manMadeStructuresAboveGround = false;
                        boolean collectDebugInfo = logger.isDebugEnabled();
                        boolean markReadOnly = false;
                        try {
                            for (int xx = 0; xx < 16; ++xx) {
                                for (int zz = 0; zz < 16; ++zz) {
                                    String biomeStr;
                                    Material materialAbove;
                                    float height = -3.4028235E38f;
                                    int waterLevel = Integer.MIN_VALUE;
                                    boolean floodWithLava = false;
                                    boolean frost = false;
                                    Terrain terrain = Terrain.BEDROCK;
                                    for (int y = Math.min(maxY, chunk.getHighestNonAirBlock(xx, zz)); y >= chunkMinHeight; --y) {
                                        String name;
                                        Material material = chunk.getMaterial(xx, y, zz);
                                        if (!material.natural) {
                                            if (height == -3.4028235E38f) {
                                                manMadeStructuresAboveGround = true;
                                            } else {
                                                manMadeStructuresBelowGround = true;
                                            }
                                            if (collectDebugInfo) {
                                                manMadeBlockTypes.add(material.name);
                                            }
                                        }
                                        if ((name = material.name) == "minecraft:snow" || name == "minecraft:ice") {
                                            frost = true;
                                        }
                                        if (waterLevel == Integer.MIN_VALUE && (name == "minecraft:ice" || name == "minecraft:frosted_ice" || material.watery || (name == "minecraft:water" || name == "minecraft:lava") && material.getProperty(Material.LEVEL) == 0 || material.is(Material.WATERLOGGED))) {
                                            waterLevel = y;
                                            if (name != "minecraft:lava") continue;
                                            floodWithLava = true;
                                            continue;
                                        }
                                        if (height != -3.4028235E38f || !TERRAIN_MAPPING.containsKey(name)) continue;
                                        height = (float)y - 0.4375f;
                                        terrain = TERRAIN_MAPPING.get(name);
                                        if (waterLevel == Integer.MIN_VALUE) {
                                            int n = waterLevel = y >= 62 ? 62 : minHeight;
                                        }
                                        if (JavaMapImporter.this.readOnlyOption != MapImporter.ReadOnlyOption.MAN_MADE) break;
                                    }
                                    int intHeight = Math.round(height);
                                    if (height != -3.4028235E38f && intHeight < maxY && (materialAbove = chunk.getMaterial(xx, intHeight + 1, zz)).isNamed("minecraft:snow")) {
                                        int layers = materialAbove.getProperty(Material.LAYERS);
                                        height = (float)((double)height + (double)layers * 0.125);
                                    }
                                    if (waterLevel == Integer.MIN_VALUE) {
                                        waterLevel = height >= 61.5f ? 62 : minHeight;
                                    }
                                    int blockX = chunkX << 4 | xx;
                                    int blockY = chunkZ << 4 | zz;
                                    Point coords = new Point(blockX, blockY);
                                    dimension.setTerrainAt(coords, terrain);
                                    dimension.setHeightAt(coords, Math.max(height, (float)minHeight));
                                    dimension.setWaterLevelAt(blockX, blockY, waterLevel);
                                    if (frost) {
                                        dimension.setBitLayerValueAt(Frost.INSTANCE, blockX, blockY, true);
                                    }
                                    if (floodWithLava) {
                                        dimension.setBitLayerValueAt(FloodWithLava.INSTANCE, blockX, blockY, true);
                                    }
                                    if (height == -3.4028235E38f) {
                                        dimension.setBitLayerValueAt(Void.INSTANCE, blockX, blockY, true);
                                    }
                                    if (!importBiomes) continue;
                                    int biome = 255;
                                    if (chunk.isBiomesAvailable()) {
                                        biome = chunk.getBiome(xx, zz);
                                        if (!standardBiomes.isBiomePresent(biome) && !customNumberedBiomes.contains(biome)) {
                                            customNumberedBiomes.add(biome);
                                        }
                                    } else if (chunk.is3DBiomesAvailable()) {
                                        biome = chunk.get3DBiome(xx >> 2, dimension.getIntHeightAt(blockX, blockY) >> 2, zz >> 2);
                                        if (!standardBiomes.isBiomePresent(biome) && !customNumberedBiomes.contains(biome)) {
                                            customNumberedBiomes.add(biome);
                                        }
                                    } else if (chunk.isNamedBiomesAvailable() && (biomeStr = chunk.getNamedBiome(xx >> 2, dimension.getIntHeightAt(blockX, blockY) >> 2, zz >> 2)) != null) {
                                        if (collectDebugInfo) {
                                            allBiomes.add(biomeStr);
                                        }
                                        if (Minecraft1_19Biomes.BIOMES_BY_MODERN_ID.containsKey(biomeStr)) {
                                            biome = Minecraft1_19Biomes.BIOMES_BY_MODERN_ID.get(biomeStr);
                                        } else if (customNamedBiomes.containsKey(biomeStr)) {
                                            biome = (Integer)customNamedBiomes.get(biomeStr);
                                        } else {
                                            int customId;
                                            while (Minecraft1_19Biomes.MODERN_IDS[customId = nextCustomBiomeId.getAndIncrement()] != null && customId < 255) {
                                            }
                                            if (customId >= 255) {
                                                throw new RuntimeException("More unknown biomes in dimension than available custom biome ids");
                                            }
                                            biome = customId;
                                            customNamedBiomes.put(biomeStr, biome);
                                        }
                                    }
                                    if (collectDebugInfo && (biome > 255 || Minecraft1_19Biomes.BIOME_NAMES[biome] == null) && biome != 255) {
                                        unknownBiomes.add(biome);
                                    }
                                    if (biome == 255 || biome == dimension.getAutoBiome(blockX, blockY)) continue;
                                    if (biome < 0 || biome > 255) {
                                        if (!invalidBiomeIds.contains(biome)) {
                                            invalidBiomeIds.add(biome);
                                            reportBuilder.append("Unsupported biome ID " + biome + " encountered at location " + blockX + "," + blockY + "; ignoring biome and marking chunk(s) Read-Only" + EOL);
                                            logger.error("Unsupported biome ID {} encountered at location {},{}; ignoring biome and marking chunk(s) Read-Only", new Object[]{biome, blockX, blockY});
                                        }
                                        markReadOnly = true;
                                        continue;
                                    }
                                    dimension.setLayerValueAt(Biome.INSTANCE, blockX, blockY, biome);
                                }
                            }
                            newChunks.remove(new Point(chunkX << 4, chunkZ << 4));
                        }
                        catch (NullPointerException e) {
                            reportBuilder.append("Null pointer exception while reading chunk " + chunkX + "," + chunkZ + "; skipping chunk" + EOL);
                            logger.error("Null pointer exception while reading chunk {},{}; skipping chunk", new Object[]{chunkX, chunkZ, e});
                            return true;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            reportBuilder.append("Array index out of bounds while reading chunk " + chunkX + "," + chunkZ + " (message: \"" + e.getMessage() + "\"); skipping chunk" + EOL);
                            logger.error("Array index out of bounds while reading chunk {},{}; skipping chunk", new Object[]{chunkX, chunkZ, e});
                            return true;
                        }
                        if (markReadOnly || JavaMapImporter.this.readOnlyOption == MapImporter.ReadOnlyOption.MAN_MADE && (manMadeStructuresBelowGround || manMadeStructuresAboveGround) || JavaMapImporter.this.readOnlyOption == MapImporter.ReadOnlyOption.MAN_MADE_ABOVE_GROUND && manMadeStructuresAboveGround || JavaMapImporter.this.readOnlyOption == MapImporter.ReadOnlyOption.ALL) {
                            dimension.setBitLayerValueAt(ReadOnly.INSTANCE, chunkX << 4, chunkZ << 4, true);
                        }
                    }
                    catch (ProgressReceiver.OperationCancelled e) {
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean chunkError(MinecraftCoords coords, String message) {
                    reportBuilder.append("\"" + message + "\" while reading chunk " + coords.x + "," + coords.z + "; skipping chunk" + EOL);
                    return true;
                }
            })) {
                throw new ProgressReceiver.OperationCancelled("Operation cancelled");
            }
            if (!nonNativePlatformsEncountered.isEmpty()) {
                if (reportBuilder.length() > 0) {
                    reportBuilder.insert(0, EOL + EOL);
                }
                reportBuilder.insert(0, "This map contains chunks that belong to (an)other version(s) of Minecraft: " + EOL + nonNativePlatformsEncountered.entrySet().stream().map(e -> ((Platform)e.getKey()).displayName + " (" + ((AtomicInteger)e.getValue()).get() + " chunk(s))").collect(Collectors.joining(", ")) + EOL + "It may therefore not be possible to Merge your changes back to this map." + EOL + "It is highly recommended to use the Optimize function of" + EOL + this.platform + " to bring the map fully up to date." + EOL);
            } else if (deviatingBuildHeights.get()) {
                if (reportBuilder.length() > 0) {
                    reportBuilder.insert(0, EOL + EOL);
                }
                reportBuilder.insert(0, "This map contains chunks that have mismatching minimum or maximum build heights." + EOL + "They are most likely unoptimized chunks from a previous version of Minecraft." + EOL + "It may therefore not be possible to Merge your changes back to this map." + EOL + "It is highly recommended to use the Optimize function of" + EOL + this.platform + " to bring the map fully up to date." + EOL);
            }
            if (!customNumberedBiomes.isEmpty()) {
                customBiomes = new ArrayList<CustomBiome>(customNumberedBiomes.size());
                object = customNumberedBiomes.iterator();
                while (object.hasNext()) {
                    int n = (Integer)object.next();
                    customBiomes.add(new CustomBiome("Biome " + n, n));
                }
                dimension.setCustomBiomes(customBiomes);
            } else if (!customNamedBiomes.isEmpty()) {
                customBiomes = new ArrayList(customNamedBiomes.size());
                for (Map.Entry entry : customNamedBiomes.entrySet()) {
                    customBiomes.add(new CustomBiome((String)entry.getKey(), (Integer)entry.getValue()));
                }
                dimension.setCustomBiomes(customBiomes);
            }
            HashMap<Point, AtomicInteger> notPresentChunksCountPerTile = new HashMap<Point, AtomicInteger>();
            for (Point point : newChunks) {
                dimension.setBitLayerValueAt(NotPresent.INSTANCE, point.x, point.y, true);
                Point tileCoords = new Point(point.x >> 3, point.y >> 3);
                if (notPresentChunksCountPerTile.computeIfAbsent(tileCoords, k -> new AtomicInteger()).incrementAndGet() != 64) continue;
                dimension.removeTile(tileCoords);
            }
            if (progressReceiver != null) {
                progressReceiver.setProgress(1.0f);
            }
            if (logger.isDebugEnabled()) {
                if (!manMadeBlockTypes.isEmpty()) {
                    logger.debug("Man-made block types encountered: {}", (Object)String.join((CharSequence)", ", manMadeBlockTypes));
                }
                if (!unknownBiomes.isEmpty()) {
                    logger.debug("Unknown biome IDs encountered: {}", (Object)unknownBiomes.stream().map(Object::toString).collect(Collectors.joining(", ")));
                }
                if (!allBiomes.isEmpty()) {
                    logger.debug("All named biomes encountered: {}", allBiomes);
                }
            }
            object = reportBuilder.length() != 0 ? reportBuilder.toString() : null;
            return object;
        }
    }

    static {
        TERRAIN_MAPPING.put("minecraft:stone", Terrain.STONE);
        TERRAIN_MAPPING.put("minecraft:andesite", Terrain.ANDESITE);
        TERRAIN_MAPPING.put("minecraft:diorite", Terrain.DIORITE);
        TERRAIN_MAPPING.put("minecraft:granite", Terrain.GRANITE);
        TERRAIN_MAPPING.put("minecraft:grass_block", Terrain.BARE_GRASS);
        TERRAIN_MAPPING.put("minecraft:dirt", Terrain.DIRT);
        TERRAIN_MAPPING.put("minecraft:coarse_dirt", Terrain.PERMADIRT);
        TERRAIN_MAPPING.put("minecraft:podzol", Terrain.PODZOL);
        TERRAIN_MAPPING.put("minecraft:farmland", Terrain.DIRT);
        TERRAIN_MAPPING.put("minecraft:rooted_dirt", Terrain.DIRT);
        TERRAIN_MAPPING.put("minecraft:bedrock", Terrain.BEDROCK);
        TERRAIN_MAPPING.put("minecraft:sand", Terrain.SAND);
        TERRAIN_MAPPING.put("minecraft:red_sand", Terrain.RED_SAND);
        TERRAIN_MAPPING.put("minecraft:gravel", Terrain.GRAVEL);
        TERRAIN_MAPPING.put("minecraft:gold_ore", Terrain.STONE);
        TERRAIN_MAPPING.put("minecraft:iron_ore", Terrain.STONE);
        TERRAIN_MAPPING.put("minecraft:coal_ore", Terrain.STONE);
        TERRAIN_MAPPING.put("minecraft:lapis_ore", Terrain.STONE);
        TERRAIN_MAPPING.put("minecraft:diamond_ore", Terrain.STONE);
        TERRAIN_MAPPING.put("minecraft:redstone_ore", Terrain.STONE);
        TERRAIN_MAPPING.put("minecraft:copper_ore", Terrain.STONE);
        TERRAIN_MAPPING.put("minecraft:emerald_ore", Terrain.STONE);
        TERRAIN_MAPPING.put("minecraft:infested_stone", Terrain.STONE);
        TERRAIN_MAPPING.put("minecraft:sandstone", Terrain.SANDSTONE);
        TERRAIN_MAPPING.put("minecraft:red_sandstone", Terrain.RED_SANDSTONE);
        TERRAIN_MAPPING.put("minecraft:obsidian", Terrain.OBSIDIAN);
        TERRAIN_MAPPING.put("minecraft:snow_block", Terrain.DEEP_SNOW);
        TERRAIN_MAPPING.put("minecraft:clay", Terrain.CLAY);
        TERRAIN_MAPPING.put("minecraft:netherrack", Terrain.NETHERRACK);
        TERRAIN_MAPPING.put("minecraft:nether_quartz_ore", Terrain.NETHERRACK);
        TERRAIN_MAPPING.put("minecraft:nether_gold_ore", Terrain.NETHERRACK);
        TERRAIN_MAPPING.put("minecraft:ancient_debris", Terrain.NETHERRACK);
        TERRAIN_MAPPING.put("minecraft:soul_sand", Terrain.SOUL_SAND);
        TERRAIN_MAPPING.put("minecraft:mycelium", Terrain.MYCELIUM);
        TERRAIN_MAPPING.put("minecraft:end_stone", Terrain.END_STONE);
        TERRAIN_MAPPING.put("minecraft:terracotta", Terrain.HARDENED_CLAY);
        TERRAIN_MAPPING.put("minecraft:grass_path", Terrain.GRASS_PATH);
        TERRAIN_MAPPING.put("minecraft:dirt_path", Terrain.GRASS_PATH);
        TERRAIN_MAPPING.put("minecraft:magma_block", Terrain.MAGMA);
        TERRAIN_MAPPING.put("minecraft:white_terracotta", Terrain.WHITE_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:orange_terracotta", Terrain.ORANGE_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:magenta_terracotta", Terrain.MAGENTA_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:light_blue_terracotta", Terrain.LIGHT_BLUE_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:yellow_terracotta", Terrain.YELLOW_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:lime_terracotta", Terrain.LIME_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:pink_terracotta", Terrain.PINK_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:gray_terracotta", Terrain.GREY_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:light_gray_terracotta", Terrain.LIGHT_GREY_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:cyan_terracotta", Terrain.CYAN_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:purple_terracotta", Terrain.PURPLE_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:blue_terracotta", Terrain.BLUE_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:brown_terracotta", Terrain.BROWN_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:green_terracotta", Terrain.GREEN_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:red_terracotta", Terrain.RED_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:black_terracotta", Terrain.BLACK_STAINED_CLAY);
        TERRAIN_MAPPING.put("minecraft:deepslate", Terrain.DEEPSLATE);
        TERRAIN_MAPPING.put("minecraft:infested_deepslate", Terrain.DEEPSLATE);
        TERRAIN_MAPPING.put("minecraft:deepslate_coal_ore", Terrain.DEEPSLATE);
        TERRAIN_MAPPING.put("minecraft:deepslate_copper_ore", Terrain.DEEPSLATE);
        TERRAIN_MAPPING.put("minecraft:deepslate_lapis_ore", Terrain.DEEPSLATE);
        TERRAIN_MAPPING.put("minecraft:deepslate_iron_ore", Terrain.DEEPSLATE);
        TERRAIN_MAPPING.put("minecraft:deepslate_gold_ore", Terrain.DEEPSLATE);
        TERRAIN_MAPPING.put("minecraft:deepslate_redstone_ore", Terrain.DEEPSLATE);
        TERRAIN_MAPPING.put("minecraft:deepslate_diamond_ore", Terrain.DEEPSLATE);
        TERRAIN_MAPPING.put("minecraft:deepslate_emerald_ore", Terrain.DEEPSLATE);
        TERRAIN_MAPPING.put("minecraft:tuff", Terrain.TUFF);
        TERRAIN_MAPPING.put("minecraft:basalt", Terrain.BASALT);
        TERRAIN_MAPPING.put("minecraft:blackstone", Terrain.BLACKSTONE);
        TERRAIN_MAPPING.put("minecraft:soul_soil", Terrain.SOUL_SOIL);
        TERRAIN_MAPPING.put("minecraft:warped_nylium", Terrain.WARPED_NYLIUM);
        TERRAIN_MAPPING.put("minecraft:crimson_nylium", Terrain.CRIMSON_NYLIUM);
        TERRAIN_MAPPING.put("minecraft:calcite", Terrain.CALCITE);
        TERRAIN_MAPPING.put("minecraft:mud", Terrain.MUD);
        TERRAIN_MAPPING.put("minecraft:muddy_mangrove_roots", Terrain.MUD);
        TERRAIN_MAPPING.put("minecraft:moss_block", Terrain.MOSS);
        TERRAIN_MAPPING.forEach((name, terrain) -> {
            if (!Material.getPrototype((String)name).terrain) {
                throw new IllegalStateException("Material named \"" + name + "\" not marked as terrain");
            }
        });
        Material.getAllSimpleNamesForNamespace("minecraft").stream().map(name -> "minecraft:" + name).forEach(name -> Material.getSpecs(name).forEach(spec -> {
            if (Boolean.TRUE.equals(spec.get("terrain")) && !TERRAIN_MAPPING.containsKey(name)) {
                throw new IllegalStateException("Material \"" + name + "\" missing from terrain mapping");
            }
        }));
    }
}

