/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.DelegatingHeightMap;

public class ShelvingHeightMap
extends DelegatingHeightMap {
    private int shelveHeight = 32;
    private int shelveStrength = 8;
    private static final long serialVersionUID = 1L;
    private static final double DOUBLE_PI = Math.PI * 2;
    private static final Icon ICON_SHELVING_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/shelving.png");

    public ShelvingHeightMap(HeightMap baseHeightMap) {
        super(new String[]{"baseHeightMap"});
        this.setHeightMap(0, baseHeightMap);
    }

    public int getShelveHeight() {
        return this.shelveHeight;
    }

    public void setShelveHeight(int shelveHeight) {
        this.shelveHeight = shelveHeight;
    }

    public int getShelveStrength() {
        return this.shelveStrength;
    }

    public void setShelveStrength(int shelveStrength) {
        this.shelveStrength = shelveStrength;
    }

    @Override
    public double doGetHeight(float x, float y) {
        double value = this.children[0].getHeight(x, y);
        return value - Math.sin(value * (Math.PI * 2) / (double)this.shelveHeight) * (double)this.shelveStrength;
    }

    @Override
    public Icon getIcon() {
        return ICON_SHELVING_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        double[] range0 = this.children[0].getRange();
        return new double[]{range0[1] - Math.sin(range0[1] * (Math.PI * 2) / (double)this.shelveHeight) * (double)this.shelveStrength};
    }
}

