/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;

public abstract class DelegatingHeightMap
extends AbstractHeightMap {
    protected final HeightMap[] children;
    private final String[] roles;
    private final Map<String, Integer> indices = new HashMap<String, Integer>();
    protected transient double constantValue;
    protected transient boolean constant;
    protected transient int constantColour;
    private static final long serialVersionUID = 1L;

    protected DelegatingHeightMap(String ... roles) {
        this.roles = roles;
        this.children = new HeightMap[roles.length];
        for (int index = 0; index < roles.length; ++index) {
            this.indices.put(roles[index], index);
        }
    }

    public void recalculateConstantValue() {
        for (HeightMap child : this.children) {
            if (!(child instanceof DelegatingHeightMap)) continue;
            ((DelegatingHeightMap)child).recalculateConstantValue();
        }
        this.determineConstant();
    }

    public final int getHeightMapCount() {
        return this.children.length;
    }

    public final String getRole(int index) {
        return this.roles[index];
    }

    public final int getIndex(String role) {
        return this.indices.get(role);
    }

    public final int getIndex(HeightMap heightMap) {
        for (int index = 0; index < this.children.length; ++index) {
            if (this.children[index] != heightMap) continue;
            return index;
        }
        throw new IllegalArgumentException();
    }

    public final HeightMap getHeightMap(int index) {
        return this.children[index];
    }

    public final HeightMap getHeightMap(String role) {
        return this.children[this.indices.get(role)];
    }

    public final void setHeightMap(int index, HeightMap child) {
        if (this.children[index] != null) {
            throw new IllegalStateException();
        }
        this.children[index] = child;
        if (child instanceof AbstractHeightMap) {
            ((AbstractHeightMap)child).parent = this;
        }
        this.childrenChanged();
    }

    public final void setHeightMap(String role, HeightMap child) {
        this.setHeightMap(this.getIndex(role), child);
    }

    public final HeightMap replace(int index, HeightMap newChild) {
        HeightMap oldChild = this.children[index];
        this.children[index] = newChild;
        if (oldChild instanceof AbstractHeightMap) {
            ((AbstractHeightMap)oldChild).parent = null;
        }
        if (newChild instanceof AbstractHeightMap) {
            ((AbstractHeightMap)newChild).parent = this;
        }
        this.childrenChanged();
        return oldChild;
    }

    public final int replace(HeightMap oldChild, HeightMap newChild) {
        int index = this.getIndex(oldChild);
        this.children[index] = newChild;
        if (oldChild instanceof AbstractHeightMap) {
            ((AbstractHeightMap)oldChild).parent = null;
        }
        if (newChild instanceof AbstractHeightMap) {
            ((AbstractHeightMap)newChild).parent = this;
        }
        this.childrenChanged();
        return index;
    }

    @Override
    public final long getSeed() {
        return this.children[0].getSeed();
    }

    @Override
    public final void setSeed(long seed) {
        for (HeightMap child : this.children) {
            child.setSeed(seed);
        }
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public double getConstantValue() {
        return this.constantValue;
    }

    @Override
    public final double getHeight(float x, float y) {
        if (this.constant) {
            return this.constantValue;
        }
        return this.doGetHeight(x, y);
    }

    @Override
    public final double getHeight(int x, int y) {
        if (this.constant) {
            return this.constantValue;
        }
        return this.doGetHeight(x, y);
    }

    @Override
    public final int getColour(int x, int y) {
        if (this.constant) {
            return this.constantColour;
        }
        return this.doGetColour(x, y);
    }

    protected void childrenChanged() {
        this.determineConstant();
    }

    protected void determineConstant() {
        if (Arrays.stream(this.children).allMatch(m -> m != null && m.isConstant())) {
            this.constant = true;
            this.constantValue = this.doGetHeight(0, 0);
            this.constantColour = this.doGetColour(0, 0);
        } else {
            this.constant = false;
        }
    }

    protected int doGetColour(int x, int y) {
        int value = (int)MathUtils.clamp((long)0L, (long)Math.round(this.doGetHeight(x, y)), (long)255L);
        return value << 16 | value << 8 | value;
    }

    protected double doGetHeight(float x, float y) {
        return this.doGetHeight(Math.round(x), Math.round(y));
    }

    protected double doGetHeight(int x, int y) {
        return this.doGetHeight((float)x, (float)y);
    }

    protected Object readResolve() throws ObjectStreamException {
        this.determineConstant();
        return this;
    }
}

