/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.gardenofeden;

import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Random;
import javax.vecmath.Point3i;
import org.pepsoft.util.undo.Cloneable;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.gardenofeden.Garden;
import org.pepsoft.worldpainter.util.GeometryUtil;

public abstract class Seed
implements Serializable,
Cloneable<Seed> {
    public final Point3i location;
    public transient Garden garden;
    public final Seed parent;
    public final int category;
    public final long seed;
    private transient long id = nextId++;
    private int germinationTime;
    private boolean sprouted = false;
    private static long nextId = 1L;
    private static final Random staticRandom = new Random();
    private static final long serialVersionUID = 1L;

    public Seed(Garden garden, long seed, Seed parent, Point3i location, int germinationTime, int category) {
        this.garden = garden;
        this.parent = parent;
        this.location = location;
        if (germinationTime == 0) {
            this.germinationTime = 0;
            this.sprouted = true;
        } else {
            this.germinationTime = germinationTime < 0 ? -germinationTime : Math.max(1, (int)((double)germinationTime * (staticRandom.nextDouble() + 0.6)));
        }
        this.category = category;
        this.seed = seed;
    }

    public final Garden getGarden() {
        return this.garden;
    }

    public final Seed getParent() {
        return this.parent;
    }

    public final Point3i getLocation() {
        return this.location;
    }

    public final void tick() {
        if (this.parent != null && !this.parent.sprouted) {
            if (!this.parent.isFinished()) {
                return;
            }
            this.germinationTime = 0;
            return;
        }
        if (this.germinationTime > 0) {
            --this.germinationTime;
            if (this.germinationTime == 0) {
                this.sprouted = this.sprout();
                if (!this.sprouted) {
                    this.garden.removeSeed(this);
                }
            }
        }
    }

    public final boolean isFinished() {
        return this.germinationTime <= 0;
    }

    public final boolean isSprouted() {
        return this.sprouted;
    }

    public final void neutralise() {
        this.germinationTime = 0;
    }

    public void buildFirstPass(Dimension dimension, Tile tile, Platform platform, MinecraftWorld minecraftWorld) {
    }

    public void buildSecondPass(Dimension dimension, Tile tile, Platform platform, MinecraftWorld minecraftWorld) {
    }

    public void transform(CoordinateTransform rotation) {
        rotation.transformInPlace(this.location);
    }

    public Seed clone() {
        try {
            return (Seed)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Seed && this.id == ((Seed)obj).id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    protected abstract boolean sprout();

    protected final void drawLine(Point location1, Point location2, int diameter, boolean stopWhenOccupied, int category) {
        int length = Integer.MAX_VALUE;
        if (stopWhenOccupied) {
            length = this.scanLine(location1.x, location1.y, location2.x, location2.y);
        }
        this.drawLine(location1, location2, diameter, length, category);
    }

    protected final void drawLine(Point3i location1, Point3i location2, int diameter, boolean stopWhenOccupied, int category) {
        int length = Integer.MAX_VALUE;
        if (stopWhenOccupied) {
            length = this.scanLine(location1.x, location1.y, location2.x, location2.y);
        }
        this.drawLine(location1, location2, diameter, length, category);
    }

    protected final void drawLine(Point location1, Point location2, int diameter, int maxLength, int category) {
        if (diameter > 1) {
            int offset = diameter / 2;
            for (int dx = 0; dx < diameter; ++dx) {
                for (int dy = 0; dy < diameter; ++dy) {
                    if (dx == offset && dy == offset) continue;
                    this.drawLine(location1.x + dx - offset, location1.y + dy - offset, location2.x + dx - offset, location2.y + dy - offset, maxLength, category);
                }
            }
        } else {
            this.drawLine(location1.x, location1.y, location2.x, location2.y, maxLength, category);
        }
    }

    protected final void drawLine(Point3i location1, Point3i location2, int diameter, int maxLength, int category) {
        if (diameter > 1) {
            int offset = diameter / 2;
            for (int dx = 0; dx < diameter; ++dx) {
                for (int dy = 0; dy < diameter; ++dy) {
                    if (dx == offset && dy == offset) continue;
                    this.drawLine(location1.x + dx - offset, location1.y + dy - offset, location2.x + dx - offset, location2.y + dy - offset, maxLength, category);
                }
            }
        } else {
            this.drawLine(location1.x, location1.y, location2.x, location2.y, maxLength, category);
        }
    }

    protected final int scanLine(int x1, int y1, int x2, int y2) {
        if (x1 == x2 && y1 == y2) {
            return 1;
        }
        boolean[] armed = new boolean[]{false};
        int[] distance = new int[]{0};
        GeometryUtil.visitLine(x1, y1, x2, y2, (x, y, d) -> {
            if (armed[0] && this.garden.isOccupied(x, y)) {
                return false;
            }
            armed[0] = true;
            distance[0] = (int)d;
            return true;
        });
        return distance[0];
    }

    protected final void drawLine(int x1, int y1, int x2, int y2, int maxLength, int category) {
        GeometryUtil.visitLine(x1, y1, x2, y2, (x, y, d) -> {
            if (d <= (float)maxLength) {
                this.garden.setCategory(x, y, category);
                return true;
            }
            return false;
        });
    }

    protected final void drawLine(Point location1, Point location2, int category) {
        this.drawLine(location1.x, location1.y, location2.x, location2.y, Integer.MAX_VALUE, category);
    }

    protected final void fill(int x1, int y1, int width, int height, int category) {
        for (int x = x1; x < x1 + width; ++x) {
            for (int y = y1; y < y1 + height; ++y) {
                this.garden.setCategory(x, y, category);
            }
        }
    }

    protected final void doAlongLine(int x1, int y1, int x2, int y2, Task task) {
        GeometryUtil.visitLine(x1, y1, x2, y2, (x, y, d) -> task.perform(x, y));
    }

    protected final void doAlongLine(int x1, int y1, int x2, int y2, Task task, int every) {
        GeometryUtil.visitLine(x1, y1, x2, y2, every, (x, y, d) -> task.perform(x, y));
    }

    protected final void doAlongLine(int x1, int y1, int x2, int y2, boolean stopWhenOccupied, Task task) {
        this.doAlongLine(x1, y1, x2, y2, stopWhenOccupied, task, 1);
    }

    protected final void doAlongLine(int x1, int y1, int x2, int y2, boolean stopWhenOccupied, Task task, int every) {
        int length = stopWhenOccupied ? this.scanLine(x1, y1, x2, y2) : Integer.MAX_VALUE;
        this.doAlongLine(x1, y1, x2, y2, length, task, every);
    }

    protected final void doAlongLine(int x1, int y1, int x2, int y2, int maxLength, Task task) {
        GeometryUtil.visitLine(x1, y1, x2, y2, (x, y, d) -> d <= (float)maxLength && task.perform(x, y));
    }

    protected final void doAlongLine(int x1, int y1, int x2, int y2, int maxLength, Task task, int every) {
        GeometryUtil.visitLine(x1, y1, x2, y2, every, (x, y, d) -> d <= (float)maxLength && task.perform(x, y));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.id = nextId++;
    }

    @FunctionalInterface
    public static interface Task {
        public boolean perform(int var1, int var2);
    }
}

