/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.io.File;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.ChunkStore;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.plugins.BlockBasedPlatformProvider;
import org.pepsoft.worldpainter.plugins.PlatformManager;

public class WorldRegion
implements MinecraftWorld {
    private final int minHeight;
    private final int maxHeight;
    private final Platform platform;
    private final Chunk[][] chunks = new Chunk[34][34];
    private final int regionX;
    private final int regionZ;
    private final BlockBasedPlatformProvider platformProvider;
    public static final int CHUNKS_PER_SIDE = 32;

    public WorldRegion(int regionX, int regionZ, int minHeight, int maxHeight, Platform platform) {
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.platform = platform;
        this.platformProvider = (BlockBasedPlatformProvider)PlatformManager.getInstance().getPlatformProvider(platform);
    }

    public WorldRegion(File worldDir, int dimension, int regionX, int regionZ, int minHeight, int maxHeight, Platform platform) {
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.platform = platform;
        this.platformProvider = (BlockBasedPlatformProvider)PlatformManager.getInstance().getPlatformProvider(platform);
        int lowestX = (regionX << 5) - 1;
        int highestX = lowestX + 33;
        int lowestZ = (regionZ << 5) - 1;
        int highestZ = lowestZ + 33;
        ChunkStore chunkStore = PlatformManager.getInstance().getChunkStore(platform, worldDir, dimension);
        for (int x = lowestX; x <= highestX; ++x) {
            for (int z = lowestZ; z <= highestZ; ++z) {
                this.chunks[x - (regionX << 5) + 1][z - (regionZ << 5) + 1] = chunkStore.getChunkForEditing(x, z);
            }
        }
    }

    @Override
    public int getBlockTypeAt(int x, int y, int height) {
        if (height >= this.maxHeight) {
            return 0;
        }
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getBlockType(x & 0xF, height, y & 0xF);
        }
        return 0;
    }

    @Override
    public int getDataAt(int x, int y, int height) {
        if (height >= this.maxHeight) {
            return 0;
        }
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getDataValue(x & 0xF, height, y & 0xF);
        }
        return 0;
    }

    @Override
    public Material getMaterialAt(int x, int y, int height) {
        if (height >= this.maxHeight) {
            return Material.AIR;
        }
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getMaterial(x & 0xF, height, y & 0xF);
        }
        return Material.AIR;
    }

    @Override
    public void setBlockTypeAt(int x, int y, int height, int blockType) {
        if (height >= this.maxHeight) {
            return;
        }
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            chunk.setBlockType(x & 0xF, height, y & 0xF, blockType);
        }
    }

    @Override
    public void setDataAt(int x, int y, int height, int data) {
        if (height >= this.maxHeight) {
            return;
        }
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            chunk.setDataValue(x & 0xF, height, y & 0xF, data);
        }
    }

    @Override
    public void setMaterialAt(int x, int y, int height, Material material) {
        if (height >= this.maxHeight) {
            return;
        }
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            chunk.setMaterial(x & 0xF, height, y & 0xF, material);
        }
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public void addEntity(double x, double y, double height, Entity entity) {
        Chunk chunk = this.getChunkForEditing((int)Math.floor(x) >> 4, (int)Math.floor(y) >> 4);
        if (chunk != null) {
            Entity clone = entity.clone();
            clone.setPos(new double[]{x, height, y});
            chunk.getEntities().add(clone);
        }
    }

    @Override
    public void addTileEntity(int x, int y, int height, TileEntity tileEntity) {
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            TileEntity clone = (TileEntity)tileEntity.clone();
            clone.setX(x);
            clone.setY(height);
            clone.setZ(y);
            chunk.getTileEntities().add(clone);
        }
    }

    @Override
    public int getBlockLightLevel(int x, int y, int height) {
        if (height >= this.maxHeight) {
            return 0;
        }
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getBlockLightLevel(x & 0xF, height, y & 0xF);
        }
        return 0;
    }

    @Override
    public void setBlockLightLevel(int x, int y, int height, int blockLightLevel) {
        if (height >= this.maxHeight) {
            return;
        }
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            chunk.setBlockLightLevel(x & 0xF, height, y & 0xF, blockLightLevel);
        }
    }

    @Override
    public int getSkyLightLevel(int x, int y, int height) {
        if (height >= this.maxHeight) {
            return 15;
        }
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getSkyLightLevel(x & 0xF, height, y & 0xF);
        }
        return 0;
    }

    @Override
    public void setSkyLightLevel(int x, int y, int height, int skyLightLevel) {
        if (height >= this.maxHeight) {
            return;
        }
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            chunk.setSkyLightLevel(x & 0xF, height, y & 0xF, skyLightLevel);
        }
    }

    @Override
    public boolean isChunkPresent(int x, int z) {
        if ((x -= this.regionX << 5) < -1 || x >= 33 || (z -= this.regionZ << 5) < -1 || z >= 33) {
            return false;
        }
        return this.chunks[x + 1][z + 1] != null;
    }

    @Override
    public Chunk getChunk(int x, int z) {
        if ((x -= this.regionX << 5) < -1 || x >= 33 || (z -= this.regionZ << 5) < -1 || z >= 33) {
            return null;
        }
        return this.chunks[x + 1][z + 1];
    }

    @Override
    public Chunk getChunkForEditing(int x, int z) {
        return this.getChunk(x, z);
    }

    @Override
    public void close() {
    }

    @Override
    public void addChunk(Chunk chunk) {
        int localX = chunk.getxPos() - (this.regionX << 5);
        int localZ = chunk.getzPos() - (this.regionZ << 5);
        if (localX >= -1 && localX <= 32 && localZ >= -1 && localZ <= 32) {
            this.chunks[localX + 1][localZ + 1] = chunk;
        }
    }

    @Override
    public int getHighestNonAirBlock(int x, int y) {
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getHighestNonAirBlock(x & 0xF, y & 0xF);
        }
        return Integer.MIN_VALUE;
    }

    public void save(File worldDir, int dimension) {
        try (ChunkStore chunkStore = this.platformProvider.getChunkStore(this.platform, worldDir, dimension);){
            chunkStore.doInTransaction(() -> {
                for (int x = 0; x < 32; ++x) {
                    for (int z = 0; z < 32; ++z) {
                        Chunk chunk = this.chunks[x + 1][z + 1];
                        if (chunk == null) continue;
                        chunkStore.saveChunk(chunk);
                    }
                }
            });
        }
    }
}

