/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.util.List;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;

public class VirtualChunk
implements Chunk {
    private final MinecraftWorld world;
    private final int chunkOffsetX;
    private final int chunkOffsetZ;

    public VirtualChunk(MinecraftWorld world, int chunkX, int chunkZ) {
        this.world = world;
        this.chunkOffsetX = chunkX << 4;
        this.chunkOffsetZ = chunkZ << 4;
    }

    @Override
    public int getBlockLightLevel(int x, int y, int z) {
        return this.world.getBlockLightLevel(this.chunkOffsetX + x, this.chunkOffsetZ + z, y);
    }

    @Override
    public void setBlockLightLevel(int x, int y, int z, int blockLightLevel) {
        this.world.setBlockLightLevel(this.chunkOffsetX + x, this.chunkOffsetZ + z, y, blockLightLevel);
    }

    @Override
    public int getBlockType(int x, int y, int z) {
        return this.world.getBlockTypeAt(this.chunkOffsetX + x, this.chunkOffsetZ + z, y);
    }

    @Override
    public void setBlockType(int x, int y, int z, int blockType) {
        this.world.setBlockTypeAt(this.chunkOffsetX + x, this.chunkOffsetZ + z, y, blockType);
    }

    @Override
    public int getDataValue(int x, int y, int z) {
        return this.world.getDataAt(this.chunkOffsetX + x, this.chunkOffsetZ + z, y);
    }

    @Override
    public void setDataValue(int x, int y, int z, int dataValue) {
        this.world.setDataAt(this.chunkOffsetX + x, this.chunkOffsetZ + z, y, dataValue);
    }

    @Override
    public int getHeight(int x, int z) {
        return this.world.getMinHeight();
    }

    @Override
    public void setHeight(int x, int z, int height) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        return this.world.getSkyLightLevel(this.chunkOffsetX + x, this.chunkOffsetZ + z, y);
    }

    @Override
    public void setSkyLightLevel(int x, int y, int z, int skyLightLevel) {
        this.world.setSkyLightLevel(this.chunkOffsetX + x, this.chunkOffsetZ + z, y, skyLightLevel);
    }

    @Override
    public int getxPos() {
        return this.chunkOffsetX >> 4;
    }

    @Override
    public int getzPos() {
        return this.chunkOffsetZ >> 4;
    }

    @Override
    public MinecraftCoords getCoords() {
        return new MinecraftCoords(this.chunkOffsetX >> 4, this.chunkOffsetZ >> 4);
    }

    @Override
    public boolean isTerrainPopulated() {
        return false;
    }

    @Override
    public void setTerrainPopulated(boolean terrainPopulated) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        return this.world.getMaterialAt(this.chunkOffsetX + x, this.chunkOffsetZ + z, y);
    }

    @Override
    public void setMaterial(int x, int y, int z, Material material) {
        this.world.setMaterialAt(this.chunkOffsetX + x, this.chunkOffsetZ + z, y, material);
    }

    @Override
    public List<Entity> getEntities() {
        return null;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return null;
    }

    @Override
    public int getMaxHeight() {
        return this.world.getMaxHeight();
    }

    @Override
    public boolean is3DBiomesSupported() {
        return true;
    }

    @Override
    public void set3DBiome(int x, int y, int z, int biome) {
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isLightPopulated() {
        return false;
    }

    @Override
    public void setLightPopulated(boolean lightPopulated) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getInhabitedTime() {
        return 0L;
    }

    @Override
    public void setInhabitedTime(long inhabitedTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHighestNonAirBlock(int x, int z) {
        return this.world.getHighestNonAirBlock(this.chunkOffsetX + x, this.chunkOffsetZ + z);
    }

    @Override
    public int getHighestNonAirBlock() {
        int maxValue = this.world.getMaxHeight() - 1;
        int highestNonAirBlock = Integer.MIN_VALUE;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldHighestNonAirBlock = this.world.getHighestNonAirBlock(this.chunkOffsetX + x, this.chunkOffsetZ + z);
                if (worldHighestNonAirBlock <= highestNonAirBlock) continue;
                if (worldHighestNonAirBlock == maxValue) {
                    return maxValue;
                }
                highestNonAirBlock = worldHighestNonAirBlock;
            }
        }
        return highestNonAirBlock;
    }
}

