/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.awt.Rectangle;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.Box;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PostProcessor {
    public static final boolean enabled = !"false".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.enforceBlockRules"));
    private static final Logger logger = LoggerFactory.getLogger(PostProcessor.class);

    public void postProcess(MinecraftWorld minecraftWorld, Rectangle area, ExportSettings exportSettings, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        this.postProcess(minecraftWorld, new Box(area.x, area.x + area.width, area.y, area.y + area.height, minecraftWorld.getMinHeight(), minecraftWorld.getMaxHeight()), exportSettings, progressReceiver);
    }

    public abstract void postProcess(MinecraftWorld var1, Box var2, ExportSettings var3, ProgressReceiver var4) throws ProgressReceiver.OperationCancelled;

    protected final void dropBlock(MinecraftWorld world, int x, int y, int z) {
        int solidFloor;
        int minZ = world.getMinHeight();
        for (solidFloor = z - 1; solidFloor > minZ; --solidFloor) {
            Material material = world.getMaterialAt(x, y, solidFloor);
            if (material.insubstantial) {
                world.setMaterialAt(x, y, solidFloor, Material.AIR);
                continue;
            }
            if (material.isNotNamedOneOf("minecraft:air", "minecraft:water", "minecraft:lava")) break;
        }
        if (solidFloor < minZ) {
            world.setMaterialAt(x, y, z, Material.AIR);
        } else if (solidFloor < z - 1) {
            Material block = world.getMaterialAt(x, y, z);
            world.setMaterialAt(x, y, z, Material.AIR);
            world.setMaterialAt(x, y, solidFloor + 1, block);
        }
    }

    protected final void dropFluid(MinecraftWorld world, int x, int y, int z) {
        Material material;
        int solidFloor;
        int minZ = world.getMinHeight();
        boolean lava = world.getMaterialAt(x, y, z).isNamed("minecraft:lava");
        for (solidFloor = z - 1; solidFloor > minZ && ((material = world.getMaterialAt(x, y, solidFloor)) == Material.AIR || material.insubstantial && material.isNotNamed(lava ? "minecraft:lava" : "minecraft:water")); --solidFloor) {
            world.setMaterialAt(x, y, solidFloor, lava ? Material.FALLING_LAVA : Material.FALLING_WATER);
        }
        if (solidFloor >= minZ && solidFloor < z - 1 && world.getMaterialAt(x, y, solidFloor).isNamedOneOf("minecraft:grass_block", "minecraft:mycelium", "minecraft:farmland")) {
            world.setMaterialAt(x, y, solidFloor, Material.DIRT);
        }
    }

    protected final boolean isWaterContained(MinecraftWorld world, int x, int y, int z, Material materialBelow) {
        if (this.containsAnyWater(materialBelow)) {
            return true;
        }
        if (!materialBelow.containsWater() && !materialBelow.solid) {
            return false;
        }
        Material materialNorth = world.getMaterialAt(x, y - 1, z);
        Material materialEast = world.getMaterialAt(x + 1, y, z);
        Material materialSouth = world.getMaterialAt(x, y + 1, z);
        Material materialWest = world.getMaterialAt(x - 1, y, z);
        return !(!this.containsAnyWater(materialNorth) && !materialNorth.solid || !this.containsAnyWater(materialEast) && !materialEast.solid || !this.containsAnyWater(materialSouth) && !materialSouth.solid || !this.containsAnyWater(materialWest) && !materialWest.solid);
    }

    protected final boolean containsAnyWater(Material material) {
        return material.containsWater() || material.isNamed("minecraft:water");
    }

    protected final boolean isLavaContained(MinecraftWorld world, int x, int y, int z, Material materialBelow) {
        if (materialBelow.isNamed("minecraft:lava")) {
            return true;
        }
        if (!materialBelow.isNamed("minecraft:lava") && !materialBelow.solid) {
            return false;
        }
        Material materialNorth = world.getMaterialAt(x, y - 1, z);
        Material materialEast = world.getMaterialAt(x + 1, y, z);
        Material materialSouth = world.getMaterialAt(x, y + 1, z);
        Material materialWest = world.getMaterialAt(x - 1, y, z);
        return !(!materialNorth.isNamed("minecraft:lava") && !materialNorth.solid || !materialEast.isNamed("minecraft:lava") && !materialEast.solid || !materialSouth.isNamed("minecraft:lava") && !materialSouth.solid || !materialWest.isNamed("minecraft:lava") && !materialWest.solid);
    }

    static {
        if (!enabled) {
            logger.warn("Block rule enforcement disabled");
        }
    }
}

