/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.awt.Point;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pepsoft.minecraft.ChunkFactory;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.mdc.MDCUtils;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.GameType;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.AbstractWorldExporter;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.platforms.JavaPlatformProvider;
import org.pepsoft.worldpainter.util.BiomeUtils;
import org.pepsoft.worldpainter.util.FileInUseException;
import org.pepsoft.worldpainter.vo.EventVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaWorldExporter
extends AbstractWorldExporter {
    protected final JavaPlatformProvider platformProvider;
    private static final Logger logger = LoggerFactory.getLogger(JavaWorldExporter.class);

    public JavaWorldExporter(World2 world, WorldExportSettings exportSettings) {
        super(world, exportSettings, world.getPlatform());
        this.platformProvider = (JavaPlatformProvider)((AbstractWorldExporter)this).platformProvider;
        if (!DefaultPlugin.DEFAULT_JAVA_PLATFORMS.contains(world.getPlatform())) {
            throw new IllegalArgumentException("Unsupported platform " + this.platform);
        }
    }

    protected JavaWorldExporter(World2 world, WorldExportSettings exportSettings, Platform platform) {
        super(world, exportSettings, platform);
        this.platformProvider = (JavaPlatformProvider)((AbstractWorldExporter)this).platformProvider;
    }

    protected JavaLevel createWorld(File worldDir, String name) throws IOException {
        Dimension dim0 = this.world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        JavaLevel level = JavaLevel.create(this.platform, this.world.getMinHeight(), this.world.getMaxHeight());
        level.setSeed(dim0.getMinecraftSeed());
        level.setName(name);
        Set<Integer> selectedDimensions = this.worldExportSettings.getDimensionsToExport();
        if (selectedDimensions == null || selectedDimensions.contains(0)) {
            Object spawnPoint = this.world.getSpawnPoint();
            Set<Point> selectedTiles = this.worldExportSettings.getTilesToExport();
            if (selectedTiles != null && !selectedTiles.contains(new Point(((Point)spawnPoint).x >> 7, ((Point)spawnPoint).y >> 7))) {
                int minX = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (Point tileCoords : selectedTiles) {
                    if (tileCoords.x << 7 < minX) {
                        minX = tileCoords.x << 7;
                    }
                    if ((tileCoords.x << 7) + 128 - 1 > maxX) {
                        maxX = (tileCoords.x << 7) + 128 - 1;
                    }
                    if (tileCoords.y << 7 < minY) {
                        minY = tileCoords.y << 7;
                    }
                    if ((tileCoords.y << 7) + 128 - 1 <= maxY) continue;
                    maxY = (tileCoords.y << 7) + 128 - 1;
                }
                spawnPoint = new Point((minX + maxX) / 2, (minY + maxY) / 2);
            }
            level.setSpawn(((Point)spawnPoint).x, Math.max(this.getIntHeightAt(0, ((Point)spawnPoint).x, ((Point)spawnPoint).y), this.getWaterLevelAt(0, ((Point)spawnPoint).x, ((Point)spawnPoint).y)) + 1, ((Point)spawnPoint).y);
        }
        if (this.world.getGameType() == GameType.HARDCORE) {
            level.setGameType(0);
            level.setHardcore(true);
            level.setDifficulty(3);
            level.setDifficultyLocked(true);
            level.setAllowCommands(false);
        } else {
            level.setGameType(this.world.getGameType().ordinal());
            level.setHardcore(false);
            level.setDifficulty(this.world.getDifficulty());
            level.setAllowCommands(this.world.isAllowCheats());
        }
        for (Dimension dimension : this.world.getDimensions()) {
            Dimension.Anchor anchor = dimension.getAnchor();
            if (anchor.invert || anchor.role != Dimension.Role.DETAIL || !this.platform.capabilities.contains((Object)Platform.Capability.GENERATOR_PER_DIMENSION) && anchor.dim != 0) continue;
            Dimension.Border dimensionBorder = dimension.getBorder();
            if (dimensionBorder != null && dimensionBorder.isEndless()) {
                SuperflatPreset.Builder superflatPresetBuilder;
                SuperflatPreset.Structure[] structures;
                int biome;
                switch (anchor.dim) {
                    case 1: {
                        biome = 8;
                        structures = null;
                        break;
                    }
                    case 2: {
                        biome = 9;
                        structures = null;
                        break;
                    }
                    default: {
                        switch (dimensionBorder) {
                            case ENDLESS_WATER: {
                                biome = 0;
                                break;
                            }
                            case ENDLESS_VOID: 
                            case ENDLESS_BARRIER: {
                                biome = BiomeUtils.getBiomeScheme(this.platform).isBiomePresent(127) ? 127 : 1;
                                break;
                            }
                            default: {
                                biome = 1;
                            }
                        }
                        structures = new SuperflatPreset.Structure[]{SuperflatPreset.Structure.MINESHAFT, SuperflatPreset.Structure.BIOME_1, SuperflatPreset.Structure.DUNGEON, SuperflatPreset.Structure.DECORATION, SuperflatPreset.Structure.OCEANMONUMENT};
                    }
                }
                switch (dimensionBorder) {
                    case ENDLESS_WATER: 
                    case ENDLESS_LAVA: {
                        superflatPresetBuilder = SuperflatPreset.builder(biome, structures);
                        boolean bottomless = dimension.isBottomless();
                        int borderLevel = dimension.getBorderLevel() - dimension.getMinHeight() + 1;
                        int oceanDepth = Math.max(Math.min(borderLevel / 2, 20), 1);
                        int deepSlateDepth = dimension.getMinHeight() < 0 ? Math.min(Math.max(borderLevel - oceanDepth - (bottomless ? 0 : 1) - 5, 0), bottomless ? 64 : 63) : 0;
                        int stoneDepth = Math.max(borderLevel - oceanDepth - deepSlateDepth - (bottomless ? 0 : 1) - 5, 0);
                        int dirtDepth = Math.max(borderLevel - oceanDepth - deepSlateDepth - stoneDepth - (bottomless ? 0 : 1), 0);
                        if (!bottomless) {
                            superflatPresetBuilder.addLayer("minecraft:bedrock", 1);
                        }
                        if (deepSlateDepth > 0) {
                            superflatPresetBuilder.addLayer("minecraft:deepslate", deepSlateDepth);
                        }
                        if (stoneDepth > 0) {
                            superflatPresetBuilder.addLayer("minecraft:stone", stoneDepth);
                        }
                        if (dirtDepth > 0) {
                            superflatPresetBuilder.addLayer("minecraft:dirt", dirtDepth);
                        }
                        if (oceanDepth <= 0) break;
                        superflatPresetBuilder.addLayer(dimensionBorder == Dimension.Border.ENDLESS_WATER ? "minecraft:water" : "minecraft:lava", oceanDepth);
                        break;
                    }
                    case ENDLESS_VOID: {
                        superflatPresetBuilder = SuperflatPreset.builder(biome, new SuperflatPreset.Structure[0]);
                        superflatPresetBuilder.addLayer("minecraft:air", 1);
                        break;
                    }
                    case ENDLESS_BARRIER: {
                        superflatPresetBuilder = SuperflatPreset.builder(biome, new SuperflatPreset.Structure[0]);
                        superflatPresetBuilder.addLayer("minecraft:barrier", dimension.getMaxHeight() - dimension.getMinHeight() - (dimension.getRoofType() == Dimension.WallType.BEDROCK ? 1 : 0));
                        if (dimension.getRoofType() != Dimension.WallType.BEDROCK) break;
                        superflatPresetBuilder.addLayer("minecraft:bedrock", 1);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                if (dimension.getRoofType() != null && dimensionBorder != Dimension.Border.ENDLESS_BARRIER) {
                    int totalDepth = superflatPresetBuilder.getLayerDepth();
                    superflatPresetBuilder.addLayer("minecraft:air", dimension.getMaxHeight() - dimension.getMinHeight() - totalDepth - 1);
                    superflatPresetBuilder.addLayer(dimension.getRoofType() == Dimension.WallType.BEDROCK ? "minecraft:bedrock" : "minecraft:barrier", 1);
                }
                level.setGenerator(anchor.dim, new SuperflatGenerator(superflatPresetBuilder.build()));
                continue;
            }
            level.setGenerator(anchor.dim, dimension.getGenerator());
        }
        level.setMapFeatures(this.world.isMapFeatures());
        if (this.platform != DefaultPlugin.JAVA_MCREGION) {
            World2.BorderSettings borderSettings = this.world.getBorderSettings();
            level.setBorderCenterX(borderSettings.getCentreX());
            level.setBorderCenterZ(borderSettings.getCentreY());
            level.setBorderSize(borderSettings.getSize());
            level.setBorderSafeZone(borderSettings.getSafeZone());
            level.setBorderWarningBlocks(borderSettings.getWarningBlocks());
            level.setBorderWarningTime(borderSettings.getWarningTime());
            level.setBorderSizeLerpTarget(borderSettings.getSizeLerpTarget());
            level.setBorderSizeLerpTime(borderSettings.getSizeLerpTime());
            level.setBorderDamagePerBlock(borderSettings.getDamagePerBlock());
        }
        level.save(worldDir);
        return level;
    }

    @Override
    public Map<Integer, ChunkFactory.Stats> export(File baseDir, String name, File backupDir, ProgressReceiver progressReceiver) throws IOException, ProgressReceiver.OperationCancelled {
        return (Map)MDCUtils.doWithMdcContext(() -> {
            Set<Point> selectedTiles = this.worldExportSettings.getTilesToExport();
            Set<Integer> selectedDimensions = this.worldExportSettings.getDimensionsToExport();
            if (selectedTiles != null && (selectedDimensions == null || selectedDimensions.size() != 1)) {
                throw new IllegalArgumentException("If a tile selection is active then exactly one dimension must be selected");
            }
            File worldDir = new File(baseDir, FileUtils.sanitiseName((String)name));
            logger.info("Exporting world " + this.world.getName() + " to map at " + worldDir + " in " + this.platform.displayName + " format");
            if (worldDir.isDirectory()) {
                if (backupDir != null) {
                    logger.info("Directory already exists; backing up to " + backupDir);
                    if (!worldDir.renameTo(backupDir)) {
                        throw new FileInUseException("Could not move " + worldDir + " to " + backupDir);
                    }
                } else {
                    throw new IllegalStateException("Directory already exists and no backup directory specified");
                }
            }
            long start = System.currentTimeMillis();
            JavaLevel level = this.createWorld(worldDir, name);
            File levelDatFile = new File(worldDir, "level.dat");
            JavaLevel.setCachedLevel(levelDatFile, level);
            try {
                try (RandomAccessFile lockedFile = new RandomAccessFile(levelDatFile, "rw");){
                    Serializable dimension2;
                    int selectedDimension;
                    lockedFile.getChannel().lock();
                    this.copyDataPacks(worldDir);
                    HashMap<Integer, ChunkFactory.Stats> stats = new HashMap<Integer, ChunkFactory.Stats>();
                    if (selectedTiles == null) {
                        selectedDimension = -1;
                        boolean first = true;
                        for (Serializable dimension2 : this.world.getDimensionsWithRole(Dimension.Role.DETAIL, false, 0)) {
                            if (selectedDimensions != null && !selectedDimensions.contains(((Dimension)dimension2).getAnchor().dim)) continue;
                            if (first) {
                                first = false;
                            } else if (progressReceiver != null) {
                                progressReceiver.reset();
                            }
                            stats.put(((Dimension)dimension2).getAnchor().dim, this.exportDimension(worldDir, (Dimension)dimension2, progressReceiver));
                        }
                    } else {
                        selectedDimension = selectedDimensions.iterator().next();
                        stats.put(selectedDimension, this.exportDimension(worldDir, this.world.getDimension(new Dimension.Anchor(selectedDimension, Dimension.Role.DETAIL, false, 0)), progressReceiver));
                    }
                    File sessionLockFile = new File(worldDir, "session.lock");
                    DataOutputStream sessionOut = new DataOutputStream(new FileOutputStream(sessionLockFile));
                    dimension2 = null;
                    try {
                        sessionOut.writeLong(System.currentTimeMillis());
                    }
                    catch (Throwable throwable) {
                        dimension2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (sessionOut != null) {
                            if (dimension2 != null) {
                                try {
                                    sessionOut.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)dimension2).addSuppressed(throwable);
                                }
                            } else {
                                sessionOut.close();
                            }
                        }
                    }
                    if (selectedTiles == null) {
                        this.world.addHistoryEntry(9, new Serializable[]{name, worldDir});
                    } else {
                        this.world.addHistoryEntry(10, new Serializable[]{name, worldDir, this.world.getDimension(new Dimension.Anchor(selectedDimension, Dimension.Role.DETAIL, false, 0)).getName()});
                    }
                    Configuration config = Configuration.getInstance();
                    if (config != null) {
                        EventVO event = new EventVO("action.exportWorld").duration(System.currentTimeMillis() - start);
                        event.setAttribute(EventVO.ATTRIBUTE_TIMESTAMP, (Serializable)new Date(start));
                        event.setAttribute(Constants.ATTRIBUTE_KEY_MAX_HEIGHT, (Serializable)Integer.valueOf(this.world.getMaxHeight()));
                        event.setAttribute(Constants.ATTRIBUTE_KEY_PLATFORM, (Serializable)((Object)this.platform.displayName));
                        event.setAttribute(Constants.ATTRIBUTE_KEY_PLATFORM_ID, (Serializable)((Object)this.platform.id));
                        event.setAttribute(Constants.ATTRIBUTE_KEY_MAP_FEATURES, (Serializable)Boolean.valueOf(this.world.isMapFeatures()));
                        event.setAttribute(Constants.ATTRIBUTE_KEY_GAME_TYPE_NAME, (Serializable)((Object)this.world.getGameType().name()));
                        event.setAttribute(Constants.ATTRIBUTE_KEY_ALLOW_CHEATS, (Serializable)Boolean.valueOf(this.world.isAllowCheats()));
                        event.setAttribute(Constants.ATTRIBUTE_KEY_GENERATOR, (Serializable)((Object)this.world.getDimension(Dimension.Anchor.NORMAL_DETAIL).getGenerator().getType().name()));
                        Dimension dimension3 = this.world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
                        event.setAttribute(Constants.ATTRIBUTE_KEY_TILES, (Serializable)Integer.valueOf(dimension3.getTileCount()));
                        this.logLayers(dimension3, event, "");
                        dimension3 = this.world.getDimension(Dimension.Anchor.NETHER_DETAIL);
                        if (dimension3 != null) {
                            event.setAttribute(Constants.ATTRIBUTE_KEY_NETHER_TILES, (Serializable)Integer.valueOf(dimension3.getTileCount()));
                            this.logLayers(dimension3, event, "nether.");
                        }
                        if ((dimension3 = this.world.getDimension(Dimension.Anchor.END_DETAIL)) != null) {
                            event.setAttribute(Constants.ATTRIBUTE_KEY_END_TILES, (Serializable)Integer.valueOf(dimension3.getTileCount()));
                            this.logLayers(dimension3, event, "end.");
                        }
                        if (selectedDimension != -1) {
                            event.setAttribute(Constants.ATTRIBUTE_KEY_EXPORTED_DIMENSION, (Serializable)Integer.valueOf(selectedDimension));
                            event.setAttribute(Constants.ATTRIBUTE_KEY_EXPORTED_DIMENSION_TILES, (Serializable)Integer.valueOf(selectedTiles.size()));
                        }
                        if (this.world.getImportedFrom() != null) {
                            event.setAttribute(Constants.ATTRIBUTE_KEY_IMPORTED_WORLD, (Serializable)Boolean.valueOf(true));
                        }
                        config.logEvent(event);
                    }
                    HashMap<Integer, ChunkFactory.Stats> hashMap = stats;
                    return hashMap;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                JavaLevel.setCachedLevel(null, null);
            }
        }, (Object[])new Object[]{"world.name", this.world.getName(), "platform.id", this.platform.id, "world.minHeight", this.world.getMinHeight(), "world.maxHeight", this.world.getMaxHeight(), "baseDir", baseDir});
    }

    protected ChunkFactory.Stats exportDimension(File worldDir, Dimension dimension, ProgressReceiver progressReceiver) {
        return (ChunkFactory.Stats)MDCUtils.doWithMdcContext(() -> {
            File dimensionDir;
            Dimension.Anchor anchor = dimension.getAnchor();
            switch (anchor.dim) {
                case 0: {
                    dimensionDir = worldDir;
                    break;
                }
                case 1: {
                    dimensionDir = new File(worldDir, "DIM-1");
                    break;
                }
                case 2: {
                    dimensionDir = new File(worldDir, "DIM1");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Dimension " + anchor.dim + " not supported");
                }
            }
            for (DataType dataType : this.platformProvider.getDataTypes(this.platform)) {
                File regionDir = new File(dimensionDir, dataType.name().toLowerCase());
                if (regionDir.exists() || regionDir.mkdirs()) continue;
                throw new RuntimeException("Could not create directory " + regionDir);
            }
            ChunkFactory.Stats collectedStats = this.parallelExportRegions(dimension, worldDir, progressReceiver);
            if (progressReceiver != null) {
                progressReceiver.setProgress(1.0f);
            }
            return collectedStats;
        }, (Object[])new Object[]{"dimension.anchor", dimension.getAnchor(), "dimension.minHeight", dimension.getMinHeight(), "dimension.maxHeight", dimension.getMaxHeight()});
    }

    private void copyDataPacks(File worldDir) throws IOException {
        if (this.world.getDataPacks() != null) {
            File dataPacksDir = new File(worldDir, "datapacks");
            for (File dataPackFile : this.world.getDataPacks()) {
                if (!dataPackFile.exists()) {
                    logger.error("Data pack file " + dataPackFile + " does not exist; skipping data pack");
                    continue;
                }
                if (!dataPackFile.isFile()) {
                    logger.error("Data pack file " + dataPackFile + " is not a regular file; skipping data pack");
                    continue;
                }
                if (!dataPackFile.canRead()) {
                    logger.error("Access denied to data pack file " + dataPackFile + "; skipping data pack");
                    continue;
                }
                if (!dataPacksDir.exists() && !dataPacksDir.mkdirs()) {
                    throw new IOException("Could not create data packs directory");
                }
                FileUtils.copyFileToDir((File)dataPackFile, (File)dataPacksDir);
            }
        }
    }
}

