/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.awt.Point;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.ChunkStore;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.jobqueue.HashList;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.merging.InvalidMapException;
import org.pepsoft.worldpainter.plugins.PlatformManager;

public class CachingMinecraftWorld
implements MinecraftWorld {
    private final Map<Point, Chunk> cache;
    private final HashList<Point> lruList;
    private final Set<Point> dirtyChunks;
    private final int minHeight;
    private final int maxHeight;
    private final int cacheSize;
    private final ChunkStore chunkStore;
    private Chunk cachedChunk;
    private int cachedX = Integer.MIN_VALUE;
    private int cachedZ = Integer.MIN_VALUE;
    private boolean cachedForEditing;
    private int lowestX;
    private int highestX;
    private int lowestZ;
    private int highestZ;
    private final boolean readOnly;
    private static final Chunk NON_EXISTANT_CHUNK = new Chunk(){

        @Override
        public int getBlockLightLevel(int x, int y, int z) {
            return 0;
        }

        @Override
        public int getBlockType(int x, int y, int z) {
            return 0;
        }

        @Override
        public void setBlockType(int x, int y, int z, int blockType) {
        }

        @Override
        public int getDataValue(int x, int y, int z) {
            return 0;
        }

        @Override
        public void setDataValue(int x, int y, int z, int dataValue) {
        }

        @Override
        public int getHeight(int x, int z) {
            return 0;
        }

        @Override
        public int getSkyLightLevel(int x, int y, int z) {
            return 0;
        }

        @Override
        public int getxPos() {
            return 0;
        }

        @Override
        public int getzPos() {
            return 0;
        }

        @Override
        public boolean isTerrainPopulated() {
            return false;
        }

        @Override
        public void setBlockLightLevel(int x, int y, int z, int blockLightLevel) {
        }

        @Override
        public void setHeight(int x, int z, int height) {
        }

        @Override
        public MinecraftCoords getCoords() {
            return null;
        }

        @Override
        public void setSkyLightLevel(int x, int y, int z, int skyLightLevel) {
        }

        @Override
        public Material getMaterial(int x, int y, int z) {
            return null;
        }

        @Override
        public void setMaterial(int x, int y, int z, Material material) {
        }

        @Override
        public List<Entity> getEntities() {
            return null;
        }

        @Override
        public List<TileEntity> getTileEntities() {
            return null;
        }

        @Override
        public int getMaxHeight() {
            return 0;
        }

        @Override
        public void setTerrainPopulated(boolean terrainPopulated) {
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isLightPopulated() {
            return false;
        }

        @Override
        public void setLightPopulated(boolean lightPopulated) {
        }

        @Override
        public long getInhabitedTime() {
            return 0L;
        }

        @Override
        public void setInhabitedTime(long inhabitedTime) {
        }

        @Override
        public int getHighestNonAirBlock(int x, int z) {
            return 0;
        }

        @Override
        public int getHighestNonAirBlock() {
            return 0;
        }
    };

    public CachingMinecraftWorld(File worldDir, int dimension, int minHeight, int maxHeight, Platform platform, boolean readOnly, int cacheSize) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.cacheSize = cacheSize;
        this.readOnly = readOnly;
        this.cache = new HashMap<Point, Chunk>(cacheSize);
        this.lruList = new HashList(cacheSize);
        this.dirtyChunks = new HashSet<Point>(cacheSize);
        this.chunkStore = PlatformManager.getInstance().getChunkStore(platform, worldDir, dimension);
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getBlockTypeAt(int x, int y, int height) {
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getBlockType(x & 0xF, height, y & 0xF);
        }
        return 0;
    }

    @Override
    public void setBlockTypeAt(int x, int y, int height, int blockType) {
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            chunk.setBlockType(x & 0xF, height, y & 0xF, blockType);
        }
    }

    @Override
    public int getDataAt(int x, int y, int height) {
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getDataValue(x & 0xF, height, y & 0xF);
        }
        return 0;
    }

    @Override
    public void setDataAt(int x, int y, int height, int data) {
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            chunk.setDataValue(x & 0xF, height, y & 0xF, data);
        }
    }

    @Override
    public Material getMaterialAt(int x, int y, int height) {
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getMaterial(x & 0xF, height, y & 0xF);
        }
        return Material.AIR;
    }

    @Override
    public void setMaterialAt(int x, int y, int height, Material material) {
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            chunk.setMaterial(x & 0xF, height, y & 0xF, material);
        }
    }

    @Override
    public int getBlockLightLevel(int x, int y, int height) {
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getBlockLightLevel(x & 0xF, height, y & 0xF);
        }
        return 0;
    }

    @Override
    public void setBlockLightLevel(int x, int y, int height, int blockLightLevel) {
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            chunk.setBlockLightLevel(x & 0xF, height, y & 0xF, blockLightLevel);
        }
    }

    @Override
    public int getSkyLightLevel(int x, int y, int height) {
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getSkyLightLevel(x & 0xF, height, y & 0xF);
        }
        return 0;
    }

    @Override
    public void setSkyLightLevel(int x, int y, int height, int skyLightLevel) {
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null) {
            chunk.setSkyLightLevel(x & 0xF, height, y & 0xF, skyLightLevel);
        }
    }

    @Override
    public boolean isChunkPresent(int x, int z) {
        if (x == this.cachedX && z == this.cachedZ) {
            return true;
        }
        Chunk chunk = this.cache.get(new Point(x, z));
        if (chunk == null) {
            return this.chunkStore.isChunkPresent(x, z);
        }
        return chunk != NON_EXISTANT_CHUNK;
    }

    @Override
    public synchronized void addChunk(Chunk chunk) {
        int chunkZ;
        if (this.readOnly) {
            throw new IllegalStateException("Read only");
        }
        int chunkX = chunk.getxPos();
        if (this.isChunkPresent(chunkX, chunkZ = chunk.getzPos())) {
            throw new IllegalStateException("Existing chunk at " + chunkX + ", " + chunkZ);
        }
        this.maintainCache();
        Point coords = new Point(chunkX, chunkZ);
        this.cache.put(coords, chunk);
        this.dirtyChunks.add(coords);
        this.lruList.addToEnd((Object)coords);
        if (chunkX == this.cachedX && chunkZ == this.cachedZ) {
            this.cachedChunk = chunk;
            this.cachedForEditing = true;
        }
        if (chunkX < this.lowestX) {
            this.lowestX = chunkX;
        }
        if (chunkX > this.highestX) {
            this.highestX = chunkX;
        }
        if (chunkZ < this.lowestZ) {
            this.lowestZ = chunkZ;
        }
        if (chunkZ > this.highestZ) {
            this.highestZ = chunkZ;
        }
    }

    public synchronized void replaceChunk(Chunk chunk) {
        int chunkZ;
        if (this.readOnly) {
            throw new IllegalStateException("Read only");
        }
        int chunkX = chunk.getxPos();
        if (!this.isChunkPresent(chunkX, chunkZ = chunk.getzPos())) {
            throw new IllegalStateException("No existing chunk at " + chunkX + ", " + chunkZ);
        }
        this.maintainCache();
        Point coords = new Point(chunkX, chunkZ);
        this.cache.put(coords, chunk);
        this.dirtyChunks.add(coords);
        this.lruList.addToEnd((Object)coords);
        if (chunkX == this.cachedX && chunkZ == this.cachedZ) {
            this.cachedChunk = chunk;
            this.cachedForEditing = true;
        }
    }

    @Override
    public int getHighestNonAirBlock(int x, int y) {
        Chunk chunk = this.getChunk(x >> 4, y >> 4);
        if (chunk != null) {
            return chunk.getHighestNonAirBlock(x & 0xF, y & 0xF);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public synchronized Chunk getChunk(int x, int z) {
        if (x == this.cachedX && z == this.cachedZ) {
            return this.cachedChunk;
        }
        this.cachedX = x;
        this.cachedZ = z;
        this.cachedForEditing = false;
        Point coords = new Point(x, z);
        this.cachedChunk = this.cache.get(coords);
        if (this.cachedChunk == null) {
            this.cachedChunk = this.chunkStore.getChunk(x, z);
            this.maintainCache();
            if (this.cachedChunk != null) {
                if (this.cachedChunk.getMinHeight() > this.minHeight) {
                    throw new InvalidMapException("At least one of the existing chunks to be merged has a higher minimum build height (" + this.cachedChunk.getMinHeight() + ") than the dimension being merged (" + this.minHeight + ").");
                }
                if (this.cachedChunk.getMaxHeight() < this.maxHeight) {
                    throw new InvalidMapException("At least one of the existing chunks to be merged has a lower maximum build height (" + this.cachedChunk.getMaxHeight() + ") than the dimension being merged (" + this.maxHeight + ").");
                }
                this.cache.put(coords, this.cachedChunk);
            } else {
                this.cache.put(coords, NON_EXISTANT_CHUNK);
            }
        } else if (this.cachedChunk == NON_EXISTANT_CHUNK) {
            this.cachedChunk = null;
        }
        this.lruList.addToEnd((Object)coords);
        return this.cachedChunk;
    }

    @Override
    public synchronized Chunk getChunkForEditing(int x, int z) {
        if (this.readOnly) {
            throw new IllegalStateException("Read only");
        }
        if (x == this.cachedX && z == this.cachedZ) {
            if (!this.cachedForEditing && this.cachedChunk != null && !this.cachedChunk.isReadOnly()) {
                this.dirtyChunks.add(new Point(x, z));
                this.cachedForEditing = true;
            }
            return this.cachedChunk;
        }
        Point coords = new Point(x, z);
        this.cachedChunk = this.getChunk(x, z);
        if (this.cachedChunk != null && !this.cachedChunk.isReadOnly()) {
            this.dirtyChunks.add(coords);
        }
        this.cachedForEditing = true;
        return this.cachedChunk;
    }

    public synchronized void flush() {
        this.saveDirtyChunks();
        this.chunkStore.flush();
    }

    @Override
    public void addEntity(double x, double y, double height, Entity entity) {
        if (this.readOnly) {
            throw new IllegalStateException("Read only");
        }
        Chunk chunk = this.getChunkForEditing((int)x >> 4, (int)y >> 4);
        if (chunk != null && !chunk.isReadOnly()) {
            Entity clone = entity.clone();
            clone.setPos(new double[]{x, height, y});
            chunk.getEntities().add(clone);
        }
    }

    @Override
    public void addTileEntity(int x, int y, int height, TileEntity tileEntity) {
        if (this.readOnly) {
            throw new IllegalStateException("Read only");
        }
        Chunk chunk = this.getChunkForEditing(x >> 4, y >> 4);
        if (chunk != null && !chunk.isReadOnly()) {
            TileEntity clone = (TileEntity)tileEntity.clone();
            clone.setX(x);
            clone.setY(height);
            clone.setZ(y);
            chunk.getTileEntities().add(clone);
        }
    }

    @Override
    public void close() {
        this.flush();
        this.chunkStore.close();
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public void saveDirtyChunks() {
        this.chunkStore.doInTransaction(() -> {
            for (Point coords : this.dirtyChunks) {
                this.chunkStore.saveChunk(this.cache.get(coords));
            }
        });
        this.dirtyChunks.clear();
        this.cachedForEditing = false;
    }

    private void maintainCache() {
        this.chunkStore.doInTransaction(() -> {
            while (this.cache.size() >= this.cacheSize) {
                Point lruCoords = (Point)this.lruList.remove(0);
                Chunk lruChunk = this.cache.remove(lruCoords);
                if (!this.dirtyChunks.contains(lruCoords)) continue;
                this.chunkStore.saveChunk(lruChunk);
                this.dirtyChunks.remove(lruCoords);
            }
        });
    }
}

