/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.util.Arrays;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.Box;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.BlockBasedExportSettings;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;

public class BlockPropertiesCalculator {
    private final MinecraftWorld world;
    private final boolean skyLight;
    private final boolean blockLight;
    private final boolean leafDistance;
    private final boolean removeFloatingLeaves;
    private final int minHeight;
    private final int maxHeight;
    private final int waterOpacity;
    private Box originalDirtyArea;
    private Box dirtyArea;
    private int[][] maxHeights;
    private int maxHeightsXOffset;
    private int maxHeightsZOffset;
    private final boolean[][] DAYLIGHT = new boolean[16][16];
    private final int[][] HEIGHT = new int[16][16];

    public BlockPropertiesCalculator(MinecraftWorld world, Platform platform, WorldExportSettings worldExportSettings, BlockBasedExportSettings exportSettings) {
        this.world = world;
        this.skyLight = BlockPropertiesCalculator.isSkyLightNeeded(platform, worldExportSettings, exportSettings);
        this.blockLight = BlockPropertiesCalculator.isBlockLightNeeded(platform, worldExportSettings, exportSettings);
        this.leafDistance = BlockPropertiesCalculator.isLeafDistanceNeeded(platform, worldExportSettings, exportSettings);
        boolean bl = this.removeFloatingLeaves = this.leafDistance && exportSettings.isRemoveFloatingLeaves();
        if (!(this.skyLight || this.blockLight || this.leafDistance)) {
            throw new IllegalArgumentException("Nothing to do");
        }
        this.minHeight = world.getMinHeight();
        this.maxHeight = world.getMaxHeight();
        this.waterOpacity = platform.getAttribute(Platform.ATTRIBUTE_WATER_OPACITY);
    }

    public Box getDirtyArea() {
        return this.dirtyArea;
    }

    public void setDirtyArea(Box dirtyArea) {
        this.dirtyArea = dirtyArea;
        this.originalDirtyArea = dirtyArea.clone();
        int x1InChunks = dirtyArea.getX1() >> 4;
        int z1InChunks = dirtyArea.getZ1() >> 4;
        int x2InChunks = dirtyArea.getX2() - 1 >> 4;
        int z2InChunks = dirtyArea.getZ2() - 1 >> 4;
        this.maxHeightsXOffset = x1InChunks;
        this.maxHeightsZOffset = z1InChunks;
        for (int[] row : this.maxHeights = new int[z2InChunks - z1InChunks + 1][x2InChunks - x1InChunks + 1]) {
            Arrays.fill(row, Integer.MIN_VALUE);
        }
        for (int chunkZ = z1InChunks; chunkZ <= z2InChunks; ++chunkZ) {
            for (int chunkX = x1InChunks; chunkX <= x2InChunks; ++chunkX) {
                Chunk chunk = this.world.getChunk(chunkX, chunkZ);
                int highestPossibleAffectedBlock = chunk != null ? Math.min(chunk.getHighestNonAirBlock() + 15, this.maxHeight - 1) : Integer.MIN_VALUE;
                for (int dz = -1; dz <= 1; ++dz) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        int xInMaxHeightsMap = chunkX + dx - this.maxHeightsXOffset;
                        int zInMaxHeightsMap = chunkZ + dz - this.maxHeightsZOffset;
                        if (xInMaxHeightsMap < 0 || zInMaxHeightsMap < 0 || zInMaxHeightsMap >= this.maxHeights.length || xInMaxHeightsMap >= this.maxHeights[0].length) continue;
                        this.maxHeights[zInMaxHeightsMap][xInMaxHeightsMap] = Math.max(this.maxHeights[zInMaxHeightsMap][xInMaxHeightsMap], highestPossibleAffectedBlock);
                    }
                }
            }
        }
    }

    public boolean secondPass() {
        int x1InChunks = this.dirtyArea.getX1() >> 4;
        int z1InChunks = this.dirtyArea.getZ1() >> 4;
        int x2InChunks = this.dirtyArea.getX2() - 1 >> 4;
        int z2InChunks = this.dirtyArea.getZ2() - 1 >> 4;
        int lowestY = Integer.MAX_VALUE;
        int highestY = Integer.MIN_VALUE;
        boolean changed = false;
        for (int chunkX = x1InChunks; chunkX <= x2InChunks; ++chunkX) {
            for (int chunkZ = z1InChunks; chunkZ <= z2InChunks; ++chunkZ) {
                Chunk chunk = this.world.getChunk(chunkX, chunkZ);
                if (chunk == null) continue;
                int maxY = Math.min(this.dirtyArea.getY2() - 1, this.maxHeights[chunkZ - this.maxHeightsZOffset][chunkX - this.maxHeightsXOffset]);
                for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                    for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                        int x = chunkX << 4 | xInChunk;
                        int z = chunkZ << 4 | zInChunk;
                        for (int y = maxY; y >= this.dirtyArea.getY1(); --y) {
                            int currentBlockLightLevel;
                            int newBlockLightLevel;
                            int currentDistance;
                            int distance;
                            boolean changedBlock = false;
                            Material material = chunk.getMaterial(xInChunk, y, zInChunk);
                            if (this.leafDistance && material.leafBlock && (distance = Math.min(currentDistance = material.getProperty(Material.DISTANCE, 8).intValue(), this.calculateDistance(chunk, x, y, z))) != currentDistance) {
                                material = material.withProperty(Material.DISTANCE, distance);
                                chunk.setMaterial(xInChunk, y, zInChunk, material);
                                changedBlock = true;
                            }
                            if (this.skyLight) {
                                int newSkyLightLevel;
                                int currentSkylightLevel = chunk.getSkyLightLevel(xInChunk, y, zInChunk);
                                if (material.opaque) {
                                    newSkyLightLevel = 0;
                                } else {
                                    int n = newSkyLightLevel = currentSkylightLevel < 15 ? this.calculateSkyLightLevel(chunk, x, y, z, material) : 15;
                                }
                                if (newSkyLightLevel != currentSkylightLevel) {
                                    chunk.setSkyLightLevel(xInChunk, y, zInChunk, newSkyLightLevel);
                                    changedBlock = true;
                                }
                            }
                            if (this.blockLight && (newBlockLightLevel = material.opaque ? (material.blockLight > 0 ? currentBlockLightLevel : 0) : Math.max(currentBlockLightLevel, this.calculateBlockLightLevel(chunk, x, y, z))) != (currentBlockLightLevel = chunk.getBlockLightLevel(xInChunk, y, zInChunk))) {
                                chunk.setBlockLightLevel(xInChunk, y, zInChunk, newBlockLightLevel);
                                changedBlock = true;
                            }
                            if (!changedBlock) continue;
                            changed = true;
                            if (y - 1 < lowestY) {
                                lowestY = y - 1;
                            }
                            if (y + 1 <= highestY) continue;
                            highestY = y + 1;
                        }
                    }
                }
            }
        }
        if (changed) {
            this.dirtyArea.setY1(Math.max(lowestY, this.minHeight));
            this.dirtyArea.setY2(Math.min(highestY + 1, this.maxHeight));
        }
        return changed;
    }

    public int[] firstPass(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            Arrays.fill(this.DAYLIGHT[x], true);
            Arrays.fill(this.HEIGHT[x], MathUtils.clamp((int)this.minHeight, (int)chunk.getHighestNonAirBlock(), (int)(this.maxHeight - 1)));
        }
        int dirtyVolumeHighMark = this.minHeight;
        int dirtyVolumeLowMark = this.maxHeight - 1;
        int maxY = MathUtils.clamp((int)(this.minHeight - 1), (int)chunk.getHighestNonAirBlock(), (int)(this.maxHeight - 1));
        for (int y = maxY = ((maxY >> 4) + 1 << 4) - 1; y >= this.minHeight; --y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int newBlockLightLevel;
                    Material material = chunk.getMaterial(x, y, z);
                    if (this.leafDistance && material.leafBlock) {
                        if (material.isPropertySet("distance")) {
                            material = material.withoutProperty("distance");
                            chunk.setMaterial(x, y, z, material);
                        }
                        if (y < dirtyVolumeLowMark) {
                            dirtyVolumeLowMark = y;
                        }
                        if (y > dirtyVolumeHighMark) {
                            dirtyVolumeHighMark = y;
                        }
                    }
                    if (this.skyLight) {
                        int newSkyLightLevel;
                        int skyLightLevel = chunk.getSkyLightLevel(x, y, z);
                        if (!material.opaque) {
                            int opacity;
                            if (y < dirtyVolumeLowMark) {
                                dirtyVolumeLowMark = y;
                            }
                            if ((opacity = this.getOpacity(material)) == 0 && this.DAYLIGHT[x][z]) {
                                newSkyLightLevel = 15;
                                this.HEIGHT[x][z] = y;
                            } else {
                                if (opacity > 0 && y > dirtyVolumeHighMark) {
                                    dirtyVolumeHighMark = y;
                                }
                                newSkyLightLevel = 0;
                                this.DAYLIGHT[x][z] = false;
                            }
                        } else {
                            if (y > dirtyVolumeHighMark) {
                                dirtyVolumeHighMark = y;
                            }
                            newSkyLightLevel = 0;
                            this.DAYLIGHT[x][z] = false;
                        }
                        if (newSkyLightLevel != skyLightLevel) {
                            chunk.setSkyLightLevel(x, y, z, newSkyLightLevel);
                        }
                    }
                    if (!this.blockLight) continue;
                    int blockLightLevel = chunk.getBlockLightLevel(x, y, z);
                    if (material.blockLight > 0) {
                        if (y > dirtyVolumeHighMark) {
                            dirtyVolumeHighMark = y;
                        }
                        if (y < dirtyVolumeLowMark) {
                            dirtyVolumeLowMark = y;
                        }
                        newBlockLightLevel = material.blockLight;
                    } else {
                        newBlockLightLevel = 0;
                    }
                    if (newBlockLightLevel == blockLightLevel) continue;
                    chunk.setBlockLightLevel(x, y, z, newBlockLightLevel);
                }
            }
        }
        if (this.skyLight) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (chunk.getHeight(x, z) == this.HEIGHT[x][z]) continue;
                    chunk.setHeight(x, z, this.HEIGHT[x][z]);
                }
            }
        }
        return new int[]{dirtyVolumeLowMark, dirtyVolumeHighMark};
    }

    public void firstPass() {
        int x1InChunks = this.dirtyArea.getX1() >> 4;
        int z1InChunks = this.dirtyArea.getZ1() >> 4;
        int x2InChunks = this.dirtyArea.getX2() - 1 >> 4;
        int z2InChunks = this.dirtyArea.getZ2() - 1 >> 4;
        for (int chunkX = x1InChunks; chunkX <= x2InChunks; ++chunkX) {
            for (int chunkZ = z1InChunks; chunkZ <= z2InChunks; ++chunkZ) {
                Chunk chunk = this.world.getChunk(chunkX, chunkZ);
                if (chunk == null) continue;
                int maxY = MathUtils.clamp((int)(this.minHeight - 1), (int)chunk.getHighestNonAirBlock(), (int)this.dirtyArea.getY2());
                for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                    for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                        int x = chunkX << 4 | xInChunk;
                        int z = chunkZ << 4 | zInChunk;
                        int skyLightLevelAbove = maxY >= this.world.getMaxHeight() - 1 ? 15 : this.world.getSkyLightLevel(x, z, maxY + 1);
                        for (int y = maxY; y >= this.dirtyArea.getY1(); --y) {
                            int blockLightLevel;
                            int newBlockLightLevel;
                            Material material = chunk.getMaterial(xInChunk, y, zInChunk);
                            if (this.leafDistance && material.leafBlock && material.isPropertySet("distance")) {
                                material = material.withoutProperty("distance");
                                chunk.setMaterial(xInChunk, y, zInChunk, material);
                            }
                            if (this.skyLight) {
                                int transparency;
                                int skyLightLevel = chunk.getSkyLightLevel(xInChunk, y, zInChunk);
                                int newSkyLightLevel = !material.opaque ? ((transparency = this.getOpacity(material)) == 0 && skyLightLevelAbove == 15 ? 15 : Math.max(skyLightLevelAbove - Math.max(transparency, 1), 0)) : 0;
                                skyLightLevelAbove = newSkyLightLevel;
                                if (newSkyLightLevel != skyLightLevel) {
                                    chunk.setSkyLightLevel(xInChunk, y, zInChunk, newSkyLightLevel);
                                }
                            }
                            if (!this.blockLight || (newBlockLightLevel = material.blockLight) == (blockLightLevel = chunk.getBlockLightLevel(xInChunk, y, zInChunk))) continue;
                            chunk.setBlockLightLevel(xInChunk, y, zInChunk, newBlockLightLevel);
                        }
                    }
                }
            }
        }
    }

    public void finalise() {
        if (!this.removeFloatingLeaves && !this.skyLight) {
            return;
        }
        int x1InChunks = this.originalDirtyArea.getX1() >> 4;
        int z1InChunks = this.originalDirtyArea.getZ1() >> 4;
        int x2InChunks = this.originalDirtyArea.getX2() - 1 >> 4;
        int z2InChunks = this.originalDirtyArea.getZ2() - 1 >> 4;
        for (int chunkX = x1InChunks; chunkX <= x2InChunks; ++chunkX) {
            for (int chunkZ = z1InChunks; chunkZ <= z2InChunks; ++chunkZ) {
                Chunk chunk = this.world.getChunkForEditing(chunkX, chunkZ);
                if (chunk == null) continue;
                int maxY = Math.min(this.originalDirtyArea.getY2() - 1, this.maxHeights[chunkZ - this.maxHeightsZOffset][chunkX - this.maxHeightsXOffset]);
                for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                    for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                        int x = chunkX << 4 | xInChunk;
                        int z = chunkZ << 4 | zInChunk;
                        for (int y = maxY; y >= this.originalDirtyArea.getY1(); --y) {
                            Material material = chunk.getMaterial(xInChunk, y, zInChunk);
                            if (this.removeFloatingLeaves && material.leafBlock && material.isPropertySet("distance") && material.getProperty(Material.DISTANCE) > 6 && !material.is(Material.PERSISTENT)) {
                                material = Material.AIR;
                                chunk.setMaterial(xInChunk, y, zInChunk, material);
                                if (this.skyLight) {
                                    int newSkyLightLevel;
                                    int currentSkylightLevel = chunk.getSkyLightLevel(xInChunk, y, zInChunk);
                                    int n = newSkyLightLevel = currentSkylightLevel < 15 ? this.calculateSkyLightLevel(chunk, x, y, z, material) : 15;
                                    if (newSkyLightLevel != currentSkylightLevel) {
                                        chunk.setSkyLightLevel(xInChunk, y, zInChunk, newSkyLightLevel);
                                        if (newSkyLightLevel == 15) {
                                            for (int y2 = y - 1; y2 >= this.originalDirtyArea.getY1() && chunk.getMaterial((int)xInChunk, (int)y2, (int)zInChunk).transparent; --y2) {
                                                chunk.setSkyLightLevel(xInChunk, y, zInChunk, newSkyLightLevel);
                                            }
                                        }
                                    }
                                }
                                if (!this.blockLight) continue;
                                int currentBlockLightLevel = chunk.getBlockLightLevel(xInChunk, y, zInChunk);
                                int newBlockLightLevel = this.calculateBlockLightLevel(chunk, x, y, z);
                                if (newBlockLightLevel == currentBlockLightLevel) continue;
                                chunk.setBlockLightLevel(xInChunk, y, zInChunk, newBlockLightLevel);
                                continue;
                            }
                            if (!this.skyLight || !material.receivesLight) continue;
                            int skyLightAbove = y < this.maxHeight - 1 ? chunk.getSkyLightLevel(xInChunk, y + 1, zInChunk) : 15;
                            int newSkyLight = skyLightAbove == 15 ? 15 : Math.max(skyLightAbove - 1, 0);
                            chunk.setSkyLightLevel(xInChunk, y, zInChunk, newSkyLight);
                        }
                    }
                }
            }
        }
    }

    public static boolean isBlockPropertiesPassNeeded(Platform platform, WorldExportSettings worldExportSettings, BlockBasedExportSettings exportSettings) {
        boolean skyLight = BlockPropertiesCalculator.isSkyLightNeeded(platform, worldExportSettings, exportSettings);
        boolean blockLight = BlockPropertiesCalculator.isBlockLightNeeded(platform, worldExportSettings, exportSettings);
        boolean leafDistance = BlockPropertiesCalculator.isLeafDistanceNeeded(platform, worldExportSettings, exportSettings);
        return skyLight || blockLight || leafDistance;
    }

    private static boolean isLeafDistanceNeeded(Platform platform, WorldExportSettings worldExportSettings, BlockBasedExportSettings exportSettings) {
        return (worldExportSettings == null || worldExportSettings.getStepsToSkip() == null || !worldExportSettings.getStepsToSkip().contains((Object)WorldExportSettings.Step.LEAVES)) && exportSettings.isCalculateLeafDistance() && platform.capabilities.contains((Object)Platform.Capability.LEAF_DISTANCES);
    }

    private static boolean isBlockLightNeeded(Platform platform, WorldExportSettings worldExportSettings, BlockBasedExportSettings exportSettings) {
        return (worldExportSettings == null || worldExportSettings.getStepsToSkip() == null || !worldExportSettings.getStepsToSkip().contains((Object)WorldExportSettings.Step.LIGHTING)) && exportSettings.isCalculateBlockLight() && platform.capabilities.contains((Object)Platform.Capability.PRECALCULATED_LIGHT);
    }

    private static boolean isSkyLightNeeded(Platform platform, WorldExportSettings worldExportSettings, BlockBasedExportSettings exportSettings) {
        return (worldExportSettings == null || worldExportSettings.getStepsToSkip() == null || !worldExportSettings.getStepsToSkip().contains((Object)WorldExportSettings.Step.LIGHTING)) && exportSettings.isCalculateSkyLight() && platform.capabilities.contains((Object)Platform.Capability.PRECALCULATED_LIGHT);
    }

    private int getOpacity(Material material) {
        if (material.containsWater()) {
            return this.waterOpacity;
        }
        return material.opacity;
    }

    private int calculateSkyLightLevel(Chunk chunk, int x, int y, int z, Material material) {
        int skyLightLevel = this.getSkyLightLevelAt(chunk, x, y + 1, z);
        if (skyLightLevel == 15 && this.waterOpacity == 1 && material.isNamed("minecraft:water") && (y >= this.maxHeight - 1 || this.world.getMaterialAt(x, z, y + 1) == Material.AIR)) {
            return 15;
        }
        int highestSurroundingSkyLight = skyLightLevel;
        if (highestSurroundingSkyLight < 15) {
            skyLightLevel = this.getSkyLightLevelAt(chunk, x - 1, y, z);
            if (skyLightLevel > highestSurroundingSkyLight) {
                highestSurroundingSkyLight = skyLightLevel;
            }
            if (highestSurroundingSkyLight < 15) {
                skyLightLevel = this.getSkyLightLevelAt(chunk, x + 1, y, z);
                if (skyLightLevel > highestSurroundingSkyLight) {
                    highestSurroundingSkyLight = skyLightLevel;
                }
                if (highestSurroundingSkyLight < 15) {
                    skyLightLevel = this.getSkyLightLevelAt(chunk, x, y, z - 1);
                    if (skyLightLevel > highestSurroundingSkyLight) {
                        highestSurroundingSkyLight = skyLightLevel;
                    }
                    if (highestSurroundingSkyLight < 15) {
                        skyLightLevel = this.getSkyLightLevelAt(chunk, x, y, z + 1);
                        if (skyLightLevel > highestSurroundingSkyLight) {
                            highestSurroundingSkyLight = skyLightLevel;
                        }
                        if (highestSurroundingSkyLight < 15 && (skyLightLevel = this.getSkyLightLevelAt(chunk, x, y - 1, z)) > highestSurroundingSkyLight) {
                            highestSurroundingSkyLight = skyLightLevel;
                        }
                    }
                }
            }
        }
        return Math.max(highestSurroundingSkyLight - Math.max(this.getOpacity(material), 1), 0);
    }

    private int calculateBlockLightLevel(Chunk chunk, int x, int y, int z) {
        Material material = chunk.getMaterial(x & 0xF, y, z & 0xF);
        int blockLightLevel = this.getBlockLightLevelAt(chunk, x, y + 1, z);
        int highestSurroundingBlockLight = blockLightLevel;
        if (highestSurroundingBlockLight < 15) {
            blockLightLevel = this.getBlockLightLevelAt(chunk, x - 1, y, z);
            if (blockLightLevel > highestSurroundingBlockLight) {
                highestSurroundingBlockLight = blockLightLevel;
            }
            if (highestSurroundingBlockLight < 15) {
                blockLightLevel = this.getBlockLightLevelAt(chunk, x + 1, y, z);
                if (blockLightLevel > highestSurroundingBlockLight) {
                    highestSurroundingBlockLight = blockLightLevel;
                }
                if (highestSurroundingBlockLight < 15) {
                    blockLightLevel = this.getBlockLightLevelAt(chunk, x, y, z - 1);
                    if (blockLightLevel > highestSurroundingBlockLight) {
                        highestSurroundingBlockLight = blockLightLevel;
                    }
                    if (highestSurroundingBlockLight < 15) {
                        blockLightLevel = this.getBlockLightLevelAt(chunk, x, y, z + 1);
                        if (blockLightLevel > highestSurroundingBlockLight) {
                            highestSurroundingBlockLight = blockLightLevel;
                        }
                        if (highestSurroundingBlockLight < 15 && (blockLightLevel = this.getBlockLightLevelAt(chunk, x, y - 1, z)) > highestSurroundingBlockLight) {
                            highestSurroundingBlockLight = blockLightLevel;
                        }
                    }
                }
            }
        }
        return Math.max(highestSurroundingBlockLight - Math.max(this.getOpacity(material), 1), 0);
    }

    private int getSkyLightLevelAt(Chunk chunk, int x, int y, int z) {
        if (y < this.minHeight) {
            return 0;
        }
        if (y >= this.maxHeight) {
            return 15;
        }
        if (x >> 4 == chunk.getxPos() && z >> 4 == chunk.getzPos()) {
            return chunk.getSkyLightLevel(x & 0xF, y, z & 0xF);
        }
        return this.world.getSkyLightLevel(x, z, y);
    }

    private int getBlockLightLevelAt(Chunk chunk, int x, int y, int z) {
        if (y < this.minHeight || y >= this.maxHeight) {
            return 0;
        }
        if (x >> 4 == chunk.getxPos() && z >> 4 == chunk.getzPos()) {
            return chunk.getBlockLightLevel(x & 0xF, y, z & 0xF);
        }
        return this.world.getBlockLightLevel(x, z, y);
    }

    private int calculateDistance(Chunk chunk, int x, int y, int z) {
        int distance = this.getLeafDistanceTo(chunk, x, y, z + 1);
        if (distance == 1) {
            return distance;
        }
        if ((distance = Math.min(distance, this.getLeafDistanceTo(chunk, x - 1, y, z))) == 1) {
            return distance;
        }
        if ((distance = Math.min(distance, this.getLeafDistanceTo(chunk, x, y - 1, z))) == 1) {
            return distance;
        }
        if ((distance = Math.min(distance, this.getLeafDistanceTo(chunk, x + 1, y, z))) == 1) {
            return distance;
        }
        if ((distance = Math.min(distance, this.getLeafDistanceTo(chunk, x, y + 1, z))) == 1) {
            return distance;
        }
        return Math.min(distance, this.getLeafDistanceTo(chunk, x, y, z - 1));
    }

    private int getLeafDistanceTo(Chunk chunk, int x, int y, int z) {
        if (y < this.minHeight || y >= this.maxHeight) {
            return 7;
        }
        Material material = x >> 4 == chunk.getxPos() && z >> 4 == chunk.getzPos() ? chunk.getMaterial(x & 0xF, y, z & 0xF) : this.world.getMaterialAt(x, z, y);
        if (material.sustainsLeaves) {
            return 1;
        }
        if (material.leafBlock && material.isPropertySet("distance")) {
            return material.getProperty(Material.DISTANCE) + 1;
        }
        return 7;
    }
}

