/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pepsoft.util.ObjectMapperHolder;
import org.pepsoft.worldpainter.biomeschemes.AbstractMinecraft1_7BiomeScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinecraftRuntimeUtils {
    private static final Set<String> IGNORED_LIBRARY_NAMES = new HashSet<String>(Arrays.asList("log4j-api", "log4j-core", "commons-logging"));
    private static final Logger logger = LoggerFactory.getLogger(AbstractMinecraft1_7BiomeScheme.class);

    MinecraftRuntimeUtils() {
    }

    static ClassLoader getClassLoader(File minecraftJar, File libDir) {
        ArrayList<URL> classpath = new ArrayList<URL>(25);
        try {
            classpath.add(minecraftJar.toURI().toURL());
            File minecraftJarDir = minecraftJar.getParentFile();
            String minecraftJarName = minecraftJar.getName();
            String jsonFileName = minecraftJarName.substring(0, minecraftJarName.length() - 4) + ".json";
            File jsonFile = new File(minecraftJarDir, jsonFileName);
            try (FileReader in = new FileReader(jsonFile);){
                Map rootNode = (Map)ObjectMapperHolder.OBJECT_MAPPER.readValue((Reader)in, Map.class);
                List librariesNode = (List)rootNode.get("libraries");
                for (Map libraryNode : librariesNode) {
                    if (libraryNode.containsKey("rules")) continue;
                    String libraryDescriptor = (String)libraryNode.get("name");
                    String[] parts = libraryDescriptor.split(":");
                    String libraryGroup = parts[0];
                    String libraryName = parts[1];
                    if (IGNORED_LIBRARY_NAMES.contains(libraryName)) continue;
                    String libraryVersion = parts[2];
                    File libraryDir = new File(libDir, libraryGroup.replace('.', '/') + '/' + libraryName + '/' + libraryVersion);
                    File libraryFile = new File(libraryDir, libraryName + '-' + libraryVersion + ".jar");
                    if (logger.isTraceEnabled()) {
                        logger.trace("Adding to biome scheme classpath: {}", (Object)libraryFile);
                    }
                    classpath.add(libraryFile.toURI().toURL());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while trying to load Minecraft jar descriptor json file", e);
        }
        return new URLClassLoader(classpath.toArray(new URL[classpath.size()]));
    }
}

