/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.pepsoft.util.Checksum;
import org.pepsoft.util.FileUtils;
import org.pepsoft.worldpainter.biomeschemes.AbstractMinecraft1_1BiomeScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MinecraftJarBiomeScheme
extends AbstractMinecraft1_1BiomeScheme {
    private final Method getLandscapesMethod;
    private final Method getBiomesMethod;
    private final Method clearBuffersMethod;
    private Object landscape;
    private long seed = Long.MIN_VALUE;
    private static final Logger logger = LoggerFactory.getLogger(MinecraftJarBiomeScheme.class);

    public MinecraftJarBiomeScheme(File minecraftJar, Checksum md5Sum, Map<Checksum, String[]> hashesToClassNames, String version) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating biome scheme using Minecraft jar {}", (Object)minecraftJar);
        }
        if (md5Sum == null) {
            try {
                md5Sum = FileUtils.getMD5((File)minecraftJar);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O error calculating hash for " + minecraftJar, e);
            }
        }
        String[] classNames = hashesToClassNames.get(md5Sum);
        String landscapeClassName = classNames[0];
        String bufferManagerClassName = classNames[1];
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{minecraftJar.toURI().toURL()});
            Class<?> landscapeClass = classLoader.loadClass(landscapeClassName);
            this.getLandscapesMethod = landscapeClass.getMethod("a", Long.TYPE);
            this.getBiomesMethod = landscapeClass.getMethod("a", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Class<?> bufferManagerClass = classLoader.loadClass(bufferManagerClassName);
            this.clearBuffersMethod = bufferManagerClass.getMethod("a", new Class[0]);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL exception while loading minecraft.jar", e);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Not a valid " + version + " minecraft.jar", e);
        }
    }

    @Override
    public final void setSeed(long seed) {
        if (seed != this.seed || this.landscape == null) {
            try {
                this.landscape = ((Object[])this.getLandscapesMethod.invoke(null, seed))[1];
                this.seed = seed;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Access denied while trying to set the seed", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Exception thrown while trying to set the seed", e);
            }
        }
    }

    @Override
    public final synchronized void getBiomes(int x, int y, int width, int height, int[] buffer) {
        try {
            int[] biomes = (int[])this.getBiomesMethod.invoke(this.landscape, x, y, width, height);
            this.clearBuffersMethod.invoke(null, new Object[0]);
            System.arraycopy(biomes, 0, buffer, 0, Math.min(biomes.length, buffer.length));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access denied while trying to calculate biomes", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception thrown while trying to calculate biomes", e);
        }
    }
}

