/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.pepsoft.util.Checksum;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_2JarBiomeScheme;

public final class Minecraft1_3LargeBiomeScheme
extends Minecraft1_2JarBiomeScheme {
    private static Object largeBiomesGenerator;
    private static final Map<Checksum, String[]> HASHES_TO_CLASSNAMES;

    public Minecraft1_3LargeBiomeScheme(File minecraftJar, Checksum md5Sum) {
        super(minecraftJar, null, md5Sum, HASHES_TO_CLASSNAMES, "1.5.2 (or 1.3.1 - 1.5.1) Large Biomes");
        try {
            Field field = this.worldGeneratorClass.getField("d");
            largeBiomesGenerator = field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Not a valid 1.5.2 (or 1.3.1 - 1.5.1) minecraft.jar", e);
        }
    }

    @Override
    public final void setSeed(long seed) {
        if (seed != this.seed || this.landscape == null) {
            try {
                this.landscape = ((Object[])this.getLandscapesMethod.invoke(null, seed, largeBiomesGenerator))[1];
                this.seed = seed;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Access denied while trying to set the seed", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Exception thrown while trying to set the seed", e);
            }
        }
    }

    static {
        HASHES_TO_CLASSNAMES = new HashMap<Checksum, String[]>();
        HASHES_TO_CLASSNAMES.put(new Checksum(new byte[]{38, 108, -53, -55, 121, -118, -3, 46, -83, -13, -42, -64, 27, 76, 86, 42}), new String[]{"adb", "acz", "uz"});
        HASHES_TO_CLASSNAMES.put(new Checksum(new byte[]{-106, -106, -103, -15, 62, 91, -66, 127, 18, -28, 10, -60, -13, 43, 125, -102}), new String[]{"adc", "ada", "va"});
        HASHES_TO_CLASSNAMES.put(new Checksum(new byte[]{119, 17, 117, -64, 23, 120, -22, 103, 57, 91, -58, -111, -102, 90, -99, -59}), new String[]{"afu", "afs", "xp"});
        HASHES_TO_CLASSNAMES.put(new Checksum(new byte[]{-114, -128, -5, 1, -77, 33, -58, -77, -57, -17, -54, 57, 122, 62, -22, 53}), new String[]{"agw", "agu", "yn"});
        HASHES_TO_CLASSNAMES.put(new Checksum(new byte[]{92, 18, 25, -40, 105, -72, 125, 35, 61, -29, 3, 54, -120, -20, 117, 103}), new String[]{"ait", "air", "aal"});
        HASHES_TO_CLASSNAMES.put(new Checksum(new byte[]{104, -105, -61, 40, 127, -71, 113, -55, -13, 98, -21, 58, -78, 15, 93, -35}), new String[]{"ait", "air", "aal"});
    }
}

