/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.pepsoft.util.Checksum;
import org.pepsoft.util.FileUtils;
import org.pepsoft.worldpainter.biomeschemes.AbstractMinecraft1_7BiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.MinecraftRuntimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Minecraft1_12JarBiomeScheme
extends AbstractMinecraft1_7BiomeScheme {
    Class<?> worldGeneratorClass;
    Method getLandscapesMethod;
    Method getBiomesMethod;
    Method clearBuffersMethod;
    Object landscape;
    long seed = Long.MIN_VALUE;
    private static final Logger logger = LoggerFactory.getLogger(Minecraft1_12JarBiomeScheme.class);

    public Minecraft1_12JarBiomeScheme(File minecraftJar, File libDir, Checksum md5Sum, Map<Checksum, String[]> hashesToClassNames) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating biome scheme using Minecraft jar {}", (Object)minecraftJar);
        }
        if (md5Sum == null) {
            try {
                md5Sum = FileUtils.getMD5((File)minecraftJar);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O error calculating hash for " + minecraftJar, e);
            }
        }
        try {
            this.init(hashesToClassNames.get(md5Sum), MinecraftRuntimeUtils.getClassLoader(minecraftJar, libDir));
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException("Not a valid minecraft.jar of the correct version", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access denied while trying to initialise Minecraft", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception thrown while trying to initialise Minecraft", e);
        }
    }

    @Override
    public void setSeed(long seed) {
        if (this.landscape == null || seed != this.seed) {
            try {
                this.landscape = ((Object[])this.getLandscapesMethod.invoke(null, seed, null, null))[1];
                this.seed = seed;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Access denied while trying to set the seed", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Exception thrown while trying to set the seed", e);
            }
        }
    }

    @Override
    public final synchronized void getBiomes(int x, int y, int width, int height, int[] buffer) {
        try {
            int[] biomes = (int[])this.getBiomesMethod.invoke(this.landscape, x, y, width, height);
            this.clearBuffersMethod.invoke(null, new Object[0]);
            System.arraycopy(biomes, 0, buffer, 0, Math.min(biomes.length, buffer.length));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access denied while trying to calculate biomes", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception thrown while trying to calculate biomes", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(String[] classNames, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        String landscapeClassName = classNames[0];
        String bufferManagerClassName = classNames[1];
        String worldGeneratorClassName = classNames[2];
        String initClassName = classNames[3];
        String generatorSettingsClassName = classNames[4];
        Class<?> landscapeClass = classLoader.loadClass(landscapeClassName);
        this.worldGeneratorClass = classLoader.loadClass(worldGeneratorClassName);
        Class<?> generatorSettingsClass = classLoader.loadClass(generatorSettingsClassName);
        this.getLandscapesMethod = landscapeClass.getMethod("a", Long.TYPE, this.worldGeneratorClass, generatorSettingsClass);
        this.getBiomesMethod = landscapeClass.getMethod("a", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        Class<?> bufferManagerClass = classLoader.loadClass(bufferManagerClassName);
        this.clearBuffersMethod = bufferManagerClass.getMethod("a", new Class[0]);
        InputStream in = System.in;
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            Class<?> initClass = classLoader.loadClass(initClassName);
            Method initMethod = initClass.getMethod("c", new Class[0]);
            initMethod.invoke(null, new Object[0]);
        }
        finally {
            System.setIn(in);
            System.setOut(out);
            System.setErr(err);
        }
    }
}

