/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_17Biomes;

public class CustomBiomeManager {
    private final List<CustomBiomeListener> listeners = new ArrayList<CustomBiomeListener>();
    private final List<CustomBiome> customBiomes = new ArrayList<CustomBiome>(256);

    public synchronized List<CustomBiome> getCustomBiomes() {
        return this.customBiomes;
    }

    public synchronized void setCustomBiomes(List<CustomBiome> customBiomes) {
        ArrayList<CustomBiome> oldCustomBiomes = new ArrayList<CustomBiome>(this.customBiomes);
        this.customBiomes.clear();
        this.customBiomes.addAll(customBiomes);
        for (CustomBiome customBiome : oldCustomBiomes) {
            for (CustomBiomeListener listener : this.listeners) {
                listener.customBiomeRemoved(customBiome);
            }
        }
        for (CustomBiome customBiome : customBiomes) {
            for (CustomBiomeListener listener : this.listeners) {
                listener.customBiomeAdded(customBiome);
            }
        }
    }

    public synchronized void clearCustomBiomes() {
        this.setCustomBiomes(Collections.emptyList());
    }

    public synchronized int getNextId() {
        block0: for (int i = 51; i < 256; ++i) {
            for (CustomBiome customBiome : this.customBiomes) {
                if (customBiome.getId() != i) continue;
                continue block0;
            }
            if (CustomBiomeManager.isBiomePresent(i)) continue;
            return i;
        }
        return -1;
    }

    public synchronized boolean addCustomBiome(Window parent, CustomBiome customBiome) {
        if (CustomBiomeManager.isBiomePresent(customBiome.getId())) {
            if (parent != null) {
                JOptionPane.showMessageDialog(parent, "The specified ID (" + customBiome.getId() + ") is already a regular biome (named " + Minecraft1_17Biomes.BIOME_NAMES[customBiome.getId()] + ")", "ID Already In Use", 0);
            }
            return false;
        }
        for (CustomBiome existingCustomBiome : this.customBiomes) {
            if (existingCustomBiome.getId() != customBiome.getId()) continue;
            if (parent != null) {
                JOptionPane.showMessageDialog(parent, "You already configured a custom biome with that ID (named " + existingCustomBiome.getName() + ")", "ID Already In Use", 0);
            }
            return false;
        }
        this.customBiomes.add(customBiome);
        for (CustomBiomeListener listener : this.listeners) {
            listener.customBiomeAdded(customBiome);
        }
        return true;
    }

    public synchronized void editCustomBiome(CustomBiome customBiome) {
        for (CustomBiome existingCustomBiome : this.customBiomes) {
            if (existingCustomBiome.getId() != customBiome.getId()) continue;
            for (CustomBiomeListener listener : this.listeners) {
                listener.customBiomeChanged(customBiome);
            }
            return;
        }
        throw new IllegalArgumentException("There is no custom biome installed with ID " + customBiome.getId());
    }

    public synchronized void removeCustomBiome(CustomBiome customBiome) {
        Iterator<CustomBiome> i = this.customBiomes.iterator();
        while (i.hasNext()) {
            CustomBiome existingCustomBiome = i.next();
            if (existingCustomBiome.getId() != customBiome.getId()) continue;
            i.remove();
            for (CustomBiomeListener listener : this.listeners) {
                listener.customBiomeRemoved(customBiome);
            }
            return;
        }
        throw new IllegalArgumentException("There is no custom biome installed with ID " + customBiome.getId());
    }

    public synchronized void addListener(CustomBiomeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(CustomBiomeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.remove(listener);
    }

    private static boolean isBiomePresent(int biome) {
        return biome <= 175 && Minecraft1_17Biomes.BIOME_NAMES[biome] != null;
    }

    public static interface CustomBiomeListener {
        public void customBiomeAdded(CustomBiome var1);

        public void customBiomeChanged(CustomBiome var1);

        public void customBiomeRemoved(CustomBiome var1);
    }
}

