/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;

public final class MixedMaterial
implements Serializable,
Comparable<MixedMaterial>,
Cloneable {
    private final UUID id = UUID.randomUUID();
    private String name;
    private int biome;
    private Row[] rows;
    @Deprecated
    private final boolean noise = false;
    private float scale;
    private Integer colour;
    private Mode mode;
    private NoiseSettings variation;
    private boolean repeat;
    private double layerXSlope;
    private double layerYSlope;
    private transient Row[] sortedRows;
    private transient PerlinNoise[] noiseGenerators;
    private transient Material[] materials;
    private transient Random random;
    private transient Material simpleMaterial;
    private transient NoiseHeightMap layerNoiseheightMap;
    private transient int layerNoiseOffset;
    private transient int patternHeight;
    private transient int totalCount;
    private static final BufferedImage UNKNOWN_ICON = IconUtils.loadScaledImage((String)"org/pepsoft/worldpainter/icons/unknown_pattern.png");
    private static final long NOISE_SEED_OFFSET = 55904327L;
    private static final ThreadLocal<Boolean> DUPLICATE_MATERIALS = ThreadLocal.withInitial(() -> false);
    private static final long serialVersionUID = 1L;

    public MixedMaterial(String name, Row row, int biome, Integer colour) {
        this(name, new Row[]{row}, biome, Mode.SIMPLE, 1.0f, colour, null, 0.0, 0.0, false);
    }

    public MixedMaterial(String name, Row[] rows, int biome, Integer colour) {
        this(name, rows, biome, Mode.NOISE, 1.0f, colour, null, 0.0, 0.0, false);
    }

    public MixedMaterial(String name, Row[] rows, int biome, Integer colour, float scale) {
        this(name, rows, biome, Mode.BLOBS, scale, colour, null, 0.0, 0.0, false);
    }

    public MixedMaterial(String name, Row[] rows, int biome, Integer colour, NoiseSettings variation, double layerXSlope, double layerYSlope, boolean repeat) {
        this(name, rows, biome, Mode.LAYERED, 1.0f, colour, variation, layerXSlope, layerYSlope, repeat);
    }

    MixedMaterial(String name, Row[] rows, int biome, Mode mode, float scale, Integer colour, NoiseSettings variation, double layerXSlope, double layerYSlope, boolean repeat) {
        this.name = name;
        this.rows = rows;
        this.biome = biome;
        this.mode = mode;
        this.scale = scale;
        this.colour = colour;
        this.variation = variation;
        this.layerXSlope = layerXSlope;
        this.layerYSlope = layerYSlope;
        this.repeat = repeat;
        this.init();
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getBiome() {
        return this.biome;
    }

    public Mode getMode() {
        return this.mode;
    }

    public float getScale() {
        return this.scale;
    }

    public Integer getColour() {
        return this.colour;
    }

    public NoiseSettings getVariation() {
        return this.variation;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public double getLayerXSlope() {
        return this.layerXSlope;
    }

    public double getLayerYSlope() {
        return this.layerYSlope;
    }

    public BufferedImage getIcon(ColourScheme colourScheme) {
        if (colourScheme != null) {
            BufferedImage icon = new BufferedImage(16 * GUIUtils.getUIScaleInt(), 16 * GUIUtils.getUIScaleInt(), 1);
            if (this.colour != null) {
                for (int x = 1; x < 16 * GUIUtils.getUIScaleInt() - 1; ++x) {
                    for (int y = 1; y < 16 * GUIUtils.getUIScaleInt() - 1; ++y) {
                        icon.setRGB(x, y, this.colour);
                    }
                }
            } else {
                for (int x = 1; x < 16 * GUIUtils.getUIScaleInt() - 1; ++x) {
                    for (int y = 1; y < 16 * GUIUtils.getUIScaleInt() - 1; ++y) {
                        icon.setRGB(x, y, colourScheme.getColour(this.getMaterial(0L, x * 2, 0, 15.0f - (float)y * 2.0f)));
                    }
                }
            }
            return icon;
        }
        return UNKNOWN_ICON;
    }

    public Material getMaterial(long seed, int x, int y, float z) {
        switch (this.mode) {
            case SIMPLE: {
                return this.simpleMaterial;
            }
            case NOISE: {
                return this.materials[this.random.nextInt(this.totalCount)];
            }
            case BLOBS: {
                double xx = (float)x / 4.099f;
                double yy = (float)y / 4.099f;
                double zz = z / 4.099f;
                if (seed + 1L != this.noiseGenerators[0].getSeed()) {
                    for (int i = 0; i < this.noiseGenerators.length; ++i) {
                        this.noiseGenerators[i].setSeed(seed + (long)i + 1L);
                    }
                }
                Material material = this.sortedRows[this.sortedRows.length - 1].material;
                for (int i = this.noiseGenerators.length - 1; i >= 0; --i) {
                    float rowScale = this.sortedRows[i].scale * this.scale;
                    if (!(this.noiseGenerators[i].getPerlinNoise(xx / (double)rowScale, yy / (double)rowScale, zz / (double)rowScale) >= this.sortedRows[i].chance)) continue;
                    material = this.sortedRows[i].material;
                }
                return material;
            }
            case LAYERED: {
                if (this.layerNoiseheightMap != null) {
                    if (this.layerNoiseheightMap.getSeed() != seed) {
                        this.layerNoiseheightMap.setSeed(seed);
                    }
                    z = (float)((double)z + (this.layerNoiseheightMap.getValue(x, y, z) - (double)this.layerNoiseOffset));
                }
                if (this.repeat) {
                    if (this.layerXSlope != 0.0) {
                        z = (float)((double)z + this.layerXSlope * (double)x);
                    }
                    if (this.layerYSlope != 0.0) {
                        z = (float)((double)z + this.layerYSlope * (double)y);
                    }
                    return this.materials[Math.floorMod(Math.round(z), this.materials.length)];
                }
                int iZ = Math.round(z);
                if (iZ < 0) {
                    return this.materials[0];
                }
                if (iZ >= this.materials.length) {
                    return this.materials[this.materials.length - 1];
                }
                return this.materials[iZ];
            }
        }
        throw new InternalError();
    }

    public Material getMaterial(long seed, int x, int y, int z) {
        switch (this.mode) {
            case SIMPLE: {
                return this.simpleMaterial;
            }
            case NOISE: {
                return this.materials[this.random.nextInt(this.totalCount)];
            }
            case BLOBS: {
                double xx = (float)x / 4.099f;
                double yy = (float)y / 4.099f;
                double zz = (float)z / 4.099f;
                if (seed + 1L != this.noiseGenerators[0].getSeed()) {
                    for (int i = 0; i < this.noiseGenerators.length; ++i) {
                        this.noiseGenerators[i].setSeed(seed + (long)i + 1L);
                    }
                }
                Material material = this.sortedRows[this.sortedRows.length - 1].material;
                for (int i = this.noiseGenerators.length - 1; i >= 0; --i) {
                    float rowScale = this.sortedRows[i].scale * this.scale;
                    if (!(this.noiseGenerators[i].getPerlinNoise(xx / (double)rowScale, yy / (double)rowScale, zz / (double)rowScale) >= this.sortedRows[i].chance)) continue;
                    material = this.sortedRows[i].material;
                }
                return material;
            }
            case LAYERED: {
                float fZ = z;
                if (this.layerNoiseheightMap != null) {
                    if (this.layerNoiseheightMap.getSeed() != seed) {
                        this.layerNoiseheightMap.setSeed(seed);
                    }
                    fZ = (float)((double)fZ + (this.layerNoiseheightMap.getValue(x, y, z) - (double)this.layerNoiseOffset));
                }
                if (this.repeat) {
                    if (this.layerXSlope != 0.0) {
                        fZ = (float)((double)fZ + this.layerXSlope * (double)x);
                    }
                    if (this.layerYSlope != 0.0) {
                        fZ = (float)((double)fZ + this.layerYSlope * (double)y);
                    }
                    return this.materials[Math.floorMod(Math.round(fZ), this.materials.length)];
                }
                int iZ = Math.round(fZ);
                if (iZ < 0) {
                    return this.materials[0];
                }
                if (iZ >= this.materials.length) {
                    return this.materials[this.materials.length - 1];
                }
                return this.materials[iZ];
            }
        }
        throw new InternalError();
    }

    public Material getSingleMaterial() {
        return this.simpleMaterial;
    }

    public Row[] getRows() {
        return this.rows;
    }

    public int getPatternHeight() {
        return this.patternHeight;
    }

    void edit(String name, Row[] rows, int biome, Mode mode, float scale, Integer colour, NoiseSettings variation, double layerXSlope, double layerYSlope, boolean repeat) {
        this.name = name;
        this.rows = rows;
        this.biome = biome;
        this.mode = mode;
        this.scale = scale;
        this.colour = colour;
        this.variation = variation;
        this.layerXSlope = layerXSlope;
        this.layerYSlope = layerYSlope;
        this.repeat = repeat;
        this.init();
    }

    @Override
    public int compareTo(MixedMaterial o) {
        if (this.name != null) {
            return o.name != null ? this.name.compareTo(o.name) : 1;
        }
        return o.name != null ? -1 : 0;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MixedMaterial && this.id.equals(((MixedMaterial)obj).id);
    }

    public MixedMaterial clone() {
        return new MixedMaterial(this.name.startsWith("Copy of ") ? this.name : "Copy of " + this.name, this.rows, this.biome, this.mode, this.scale, this.colour, this.variation != null ? this.variation.clone() : null, this.layerXSlope, this.layerYSlope, this.repeat);
    }

    public static MixedMaterial create(Platform platform, int blockType) {
        return MixedMaterial.create(platform, Material.get(blockType));
    }

    public static MixedMaterial create(Platform platform, Material material) {
        return MixedMaterial.create(platform.capabilities.contains((Object)Platform.Capability.NAME_BASED) ? material.toString() : material.toLegacyString(), material);
    }

    public static MixedMaterial create(String name, Material material) {
        return new MixedMaterial(name, new Row(material, 3, 1.0f), -1, null);
    }

    public static <V> V duplicateNewMaterialsWhile(Callable<V> task) {
        DUPLICATE_MATERIALS.set(true);
        try {
            V v = task.call();
            return v;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DUPLICATE_MATERIALS.set(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.mode == null) {
            this.mode = this.rows.length == 1 ? Mode.SIMPLE : Mode.BLOBS;
        }
        this.init();
    }

    private Object readResolve() throws ObjectStreamException {
        return DUPLICATE_MATERIALS.get() != false ? MixedMaterialManager.getInstance().registerAsNew(this) : MixedMaterialManager.getInstance().register(this);
    }

    private void init() {
        this.totalCount = 0;
        for (Row row : this.rows) {
            this.totalCount += row.occurrence;
        }
        switch (this.mode) {
            case SIMPLE: {
                if (this.rows.length != 1) {
                    throw new IllegalArgumentException("Only one row allowed for SIMPLE mode");
                }
                this.simpleMaterial = this.rows[0].material;
                this.patternHeight = -1;
                break;
            }
            case NOISE: {
                if (this.rows.length < 2) {
                    throw new IllegalArgumentException("Multiple rows required for NOISE mode");
                }
                this.materials = new Material[this.totalCount];
                int index = 0;
                for (Row row : this.rows) {
                    for (int i = 0; i < row.occurrence; ++i) {
                        this.materials[index++] = row.material;
                    }
                }
                this.random = new Random();
                this.patternHeight = -1;
                break;
            }
            case BLOBS: {
                if (this.rows.length < 2) {
                    throw new IllegalArgumentException("Multiple rows required for BLOBS mode");
                }
                this.sortedRows = Arrays.copyOf(this.rows, this.rows.length);
                Arrays.sort(this.sortedRows, (r1, r2) -> r1.occurrence - r2.occurrence);
                this.noiseGenerators = new PerlinNoise[this.rows.length - 1];
                float cumulativePermillage = 0.0f;
                for (int i = 0; i < this.noiseGenerators.length; ++i) {
                    this.noiseGenerators[i] = new PerlinNoise(0L);
                    float permillage = (float)this.sortedRows[i].occurrence * 1000.0f / (float)this.totalCount;
                    cumulativePermillage += permillage * (1000.0f - cumulativePermillage) / 1000.0f;
                    this.sortedRows[i].chance = PerlinNoise.getLevelForPromillage((float)cumulativePermillage);
                }
                this.patternHeight = -1;
                break;
            }
            case LAYERED: {
                if (this.rows.length < 2) {
                    throw new IllegalArgumentException("Multiple rows required for LAYERED mode");
                }
                if (!(this.repeat || this.layerXSlope == 0.0 && this.layerYSlope == 0.0)) {
                    throw new IllegalArgumentException("Angle may not be non-zero if repeat is false");
                }
                this.materials = new Material[this.totalCount];
                int index = this.totalCount - 1;
                for (Row row : this.rows) {
                    for (int i = 0; i < row.occurrence; ++i) {
                        this.materials[index--] = row.material;
                    }
                }
                if (this.variation != null) {
                    this.layerNoiseheightMap = new NoiseHeightMap(this.variation, 55904327L);
                    this.layerNoiseOffset = this.variation.getRange();
                } else {
                    this.layerNoiseheightMap = null;
                    this.layerNoiseOffset = 0;
                }
                this.patternHeight = this.totalCount;
            }
        }
    }

    public static enum Mode {
        SIMPLE,
        BLOBS,
        NOISE,
        LAYERED;

    }

    public static class Row
    implements Serializable {
        public final Material material;
        public final int occurrence;
        public final float scale;
        float chance;
        private static final long serialVersionUID = 1L;

        public Row(Material material, int count, float scale) {
            this.material = material;
            this.occurrence = count;
            this.scale = scale;
        }

        public int hashCode() {
            int hash = 5;
            hash = 23 * hash + (this.material != null ? this.material.hashCode() : 0);
            hash = 23 * hash + this.occurrence;
            hash = 23 * hash + Float.floatToIntBits(this.scale);
            hash = 23 * hash + Float.floatToIntBits(this.chance);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Row other = (Row)obj;
            if (!(this.material == other.material || this.material != null && this.material.equals(other.material))) {
                return false;
            }
            if (this.occurrence != other.occurrence) {
                return false;
            }
            if (Float.floatToIntBits(this.scale) != Float.floatToIntBits(other.scale)) {
                return false;
            }
            return Float.floatToIntBits(this.chance) == Float.floatToIntBits(other.chance);
        }

        public String toString() {
            return this.material.toString();
        }
    }
}

