/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Rectangle;
import javax.swing.Icon;
import org.pepsoft.worldpainter.heightMaps.BicubicHeightMap;
import org.pepsoft.worldpainter.heightMaps.ConstantHeightMap;
import org.pepsoft.worldpainter.heightMaps.DifferenceHeightMap;
import org.pepsoft.worldpainter.heightMaps.MaximisingHeightMap;
import org.pepsoft.worldpainter.heightMaps.MinimisingHeightMap;
import org.pepsoft.worldpainter.heightMaps.ProductHeightMap;
import org.pepsoft.worldpainter.heightMaps.SumHeightMap;
import org.pepsoft.worldpainter.heightMaps.TransformingHeightMap;

public interface HeightMap {
    public String getName();

    public long getSeed();

    public void setSeed(long var1);

    public double getHeight(int var1, int var2);

    public double getHeight(float var1, float var2);

    public double getBaseHeight();

    public HeightMap clone();

    public Rectangle getExtent();

    public int getColour(int var1, int var2);

    public boolean isConstant();

    public double getConstantValue();

    public Icon getIcon();

    public double[] getRange();

    default public HeightMap plus(HeightMap addend) {
        return new SumHeightMap(this, addend);
    }

    default public HeightMap plus(double addend) {
        return new SumHeightMap(this, new ConstantHeightMap(addend));
    }

    default public HeightMap minus(HeightMap subtrahend) {
        return new DifferenceHeightMap(this, subtrahend);
    }

    default public HeightMap minus(double subtrahend) {
        return new DifferenceHeightMap(this, new ConstantHeightMap(subtrahend));
    }

    default public HeightMap times(HeightMap subtrahend) {
        return new ProductHeightMap(this, subtrahend);
    }

    default public HeightMap times(double factor) {
        return new ProductHeightMap(this, new ConstantHeightMap(factor));
    }

    default public HeightMap smoothed() {
        return new BicubicHeightMap(this);
    }

    default public HeightMap scaled(float scale) {
        return TransformingHeightMap.build().withHeightMap(this).withScale(scale).now();
    }

    default public HeightMap clamped(double min, double max) {
        return new MaximisingHeightMap(new MinimisingHeightMap(this, new ConstantHeightMap(max)), new ConstantHeightMap(min));
    }
}

