/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pepsoft.util.undo.Snapshot;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileSnapshot;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public final class DimensionSnapshot
extends Dimension {
    private final Dimension dimension;
    private final Snapshot snapshot;
    private final int width;
    private final int height;
    private final int lowestX;
    private final int highestX;
    private final int lowestY;
    private final int highestY;
    private final Map<Point, TileSnapshot> tileSnapshots = new HashMap<Point, TileSnapshot>();
    private static final long serialVersionUID = 2011101501L;

    public DimensionSnapshot(Dimension dimension, Snapshot snapshot) {
        super(dimension.getWorld(), dimension.getName(), dimension.getMinecraftSeed(), dimension.getTileFactory(), dimension.getAnchor());
        this.dimension = dimension;
        this.snapshot = snapshot;
        super.setBorder(dimension.getBorder());
        super.setBorderSize(dimension.getBorderSize());
        super.setBorderLevel(dimension.getBorderLevel());
        super.setMinecraftSeed(dimension.getMinecraftSeed());
        super.setSubsurfaceMaterial(dimension.getSubsurfaceMaterial());
        super.setWallType(dimension.getWallType());
        super.setRoofType(dimension.getRoofType());
        super.setPopulate(dimension.isPopulate());
        this.width = dimension.getWidth();
        this.height = dimension.getHeight();
        this.lowestX = dimension.getLowestX();
        this.highestX = dimension.getHighestX();
        this.lowestY = dimension.getLowestY();
        this.highestY = dimension.getHighestY();
    }

    @Override
    public void addDimensionListener(Dimension.Listener listener) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    @Override
    public void addTile(Tile tile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTheme(int x, int y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTheme(Point coords) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterUndoManager() {
    }

    @Override
    public void clearRedo() {
    }

    @Override
    public void armSavePoint() {
    }

    @Override
    public void clearUndo() {
    }

    @Override
    public boolean undoChanges() {
        return false;
    }

    @Override
    public void registerUndoManager(UndoManager undoManager) {
    }

    @Override
    public boolean isUndoAvailable() {
        return false;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getHighestX() {
        return this.highestX;
    }

    @Override
    public int getHighestY() {
        return this.highestY;
    }

    @Override
    public ExporterSettings getLayerSettings(Layer layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Layer, ExporterSettings> getAllLayerSettings() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLowestX() {
        return this.lowestX;
    }

    @Override
    public int getLowestY() {
        return this.lowestY;
    }

    @Override
    public Tile getTile(Point coords) {
        Tile tile;
        TileSnapshot tileSnapshot = this.tileSnapshots.get(coords);
        if (tileSnapshot == null && (tile = this.dimension.getTile(coords)) != null) {
            tileSnapshot = new TileSnapshot(tile, this.snapshot);
            this.tileSnapshots.put(coords, tileSnapshot);
        }
        return tileSnapshot;
    }

    @Override
    public Collection<? extends Tile> getTiles() {
        Collection<? extends Tile> tiles = this.dimension.getTiles();
        for (Tile tile : tiles) {
            Point coords = new Point(tile.getX(), tile.getY());
            if (this.tileSnapshots.containsKey(coords)) continue;
            TileSnapshot tileSnapshot = new TileSnapshot(tile, this.snapshot);
            this.tileSnapshots.put(coords, tileSnapshot);
        }
        return Collections.unmodifiableCollection(this.tileSnapshots.values());
    }

    @Override
    public Set<Point> getTileCoords() {
        return this.dimension.getTileCoords();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean isEventsInhibited() {
        return false;
    }

    @Override
    public void removeTile(Tile tile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBitLayerValueAt(Layer layer, int x, int y, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBorder(Dimension.Border border) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBorderLevel(int borderLevel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBorderSize(int borderSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEventsInhibited(boolean eventsInhibited) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHeightAt(int x, int y, float height) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHeightAt(Point coords, float height) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLayerSettings(Layer layer, ExporterSettings settings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLayerValueAt(Layer layer, int x, int y, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMinecraftSeed(long minecraftSeed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int addOverlay(Overlay overlay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOverlay(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWallType(Dimension.WallType wallType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRoofType(Dimension.WallType roofType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPopulate(boolean populate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSubsurfaceMaterial(Terrain subsurfaceMaterial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTerrainAt(int x, int y, Terrain terrain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTerrainAt(Point coords, Terrain terrain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWaterLevelAt(int x, int y, int waterLevel) {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream out) throws NotSerializableException {
        throw new NotSerializableException("Serialization of DimensionSnapshot not supported");
    }
}

