/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.EventLogger;
import org.pepsoft.worldpainter.GameType;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.WPContext;
import org.pepsoft.worldpainter.layers.Caverns;
import org.pepsoft.worldpainter.layers.Caves;
import org.pepsoft.worldpainter.layers.Chasms;
import org.pepsoft.worldpainter.layers.DeciduousForest;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Jungle;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.PineForest;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.SwampLand;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.plugins.AbstractPlugin;
import org.pepsoft.worldpainter.plugins.ContextProvider;
import org.pepsoft.worldpainter.plugins.LayerProvider;
import org.pepsoft.worldpainter.util.MinecraftJarProvider;

public class DefaultPlugin
extends AbstractPlugin
implements LayerProvider,
ContextProvider,
WPContext {
    public static final AttributeKey<Integer> ATTRIBUTE_EXPORT_DATA_VERSION = new AttributeKey("org.pepsoft.exportDataVersion");
    public static final AttributeKey<Integer> ATTRIBUTE_LATEST_DATA_VERSION = new AttributeKey("org.pepsoft.latestDataVersion");
    public static final AttributeKey<org.pepsoft.util.Version> ATTRIBUTE_MC_VERSION = new AttributeKey("org.pepsoft.minecraftVersion", (Object)Constants.V_1_12_2);
    public static final Platform JAVA_MCREGION = new Platform("org.pepsoft.mcregion", "Minecraft 1.1 (MCRegion)", 32, 128, 2048, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Arrays.asList(GameType.SURVIVAL, GameType.CREATIVE), Arrays.asList(Generator.DEFAULT, Generator.FLAT, Generator.NETHER, Generator.END), Arrays.asList(0, 1, 2), EnumSet.of(Platform.Capability.PRECALCULATED_LIGHT, Platform.Capability.SET_SPAWN_POINT, Platform.Capability.BLOCK_BASED, Platform.Capability.SEED, Platform.Capability.POPULATE), ATTRIBUTE_MC_VERSION, new org.pepsoft.util.Version(new int[]{1, 1}), Platform.ATTRIBUTE_GRASS_BLOCK_NAME, "minecraft:grass", Platform.ATTRIBUTE_WATER_OPACITY, 3);
    public static final Platform JAVA_ANVIL = new Platform("org.pepsoft.anvil", "Minecraft 1.2 - 1.12", 256, 256, 256, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Arrays.asList(GameType.SURVIVAL, GameType.CREATIVE, GameType.ADVENTURE, GameType.HARDCORE), Arrays.asList(Generator.DEFAULT, Generator.FLAT, Generator.LARGE_BIOMES, Generator.AMPLIFIED, Generator.CUSTOM, Generator.NETHER, Generator.END), Arrays.asList(0, 1, 2), EnumSet.of(Platform.Capability.BIOMES, new Platform.Capability[]{Platform.Capability.PRECALCULATED_LIGHT, Platform.Capability.SET_SPAWN_POINT, Platform.Capability.BLOCK_BASED, Platform.Capability.SEED, Platform.Capability.POPULATE}), ATTRIBUTE_MC_VERSION, new org.pepsoft.util.Version(new int[]{1, 2}), ATTRIBUTE_EXPORT_DATA_VERSION, 1343, ATTRIBUTE_LATEST_DATA_VERSION, 1343, Platform.ATTRIBUTE_GRASS_BLOCK_NAME, "minecraft:grass", Platform.ATTRIBUTE_WATER_OPACITY, 3);
    public static final Platform JAVA_ANVIL_1_15 = new Platform("org.pepsoft.anvil.1.13", "Minecraft 1.15 - 1.16", 256, 256, 256, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Arrays.asList(GameType.SURVIVAL, GameType.CREATIVE, GameType.ADVENTURE, GameType.HARDCORE), Arrays.asList(Generator.DEFAULT, Generator.FLAT, Generator.LARGE_BIOMES, Generator.AMPLIFIED, Generator.CUSTOM, Generator.NETHER, Generator.END), Arrays.asList(0, 1, 2), EnumSet.of(Platform.Capability.BIOMES, new Platform.Capability[]{Platform.Capability.PRECALCULATED_LIGHT, Platform.Capability.SET_SPAWN_POINT, Platform.Capability.BLOCK_BASED, Platform.Capability.NAME_BASED, Platform.Capability.SEED, Platform.Capability.LEAF_DISTANCES, Platform.Capability.DATA_PACKS}), ATTRIBUTE_MC_VERSION, new org.pepsoft.util.Version(new int[]{1, 15}), ATTRIBUTE_EXPORT_DATA_VERSION, 2230, ATTRIBUTE_LATEST_DATA_VERSION, 2586);
    public static final Platform JAVA_ANVIL_1_17 = new Platform("org.pepsoft.anvil.1.17", "Minecraft 1.17", new int[]{256, 320, 512, 1024, 1536, 2032}, 256, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, Arrays.asList(GameType.SURVIVAL, GameType.CREATIVE, GameType.ADVENTURE, GameType.HARDCORE), Arrays.asList(Generator.DEFAULT, Generator.FLAT, Generator.LARGE_BIOMES, Generator.AMPLIFIED, Generator.CUSTOM, Generator.NETHER, Generator.END), Arrays.asList(0, 1, 2), EnumSet.of(Platform.Capability.PRECALCULATED_LIGHT, new Platform.Capability[]{Platform.Capability.SET_SPAWN_POINT, Platform.Capability.BLOCK_BASED, Platform.Capability.NAME_BASED, Platform.Capability.SEED, Platform.Capability.BIOMES_3D, Platform.Capability.GENERATOR_PER_DIMENSION, Platform.Capability.LEAF_DISTANCES, Platform.Capability.DATA_PACKS}), ATTRIBUTE_MC_VERSION, new org.pepsoft.util.Version(new int[]{1, 17}), ATTRIBUTE_EXPORT_DATA_VERSION, 2724, ATTRIBUTE_LATEST_DATA_VERSION, 2730);
    public static final Platform JAVA_ANVIL_1_18 = new Platform("org.pepsoft.anvil.1.18", "Minecraft 1.18", new int[]{256, 320, 512, 1024, 1536, 2032}, 320, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, new int[]{0, -64, -128, -256, -512, -1024, -2032}, -64, Arrays.asList(GameType.SURVIVAL, GameType.CREATIVE, GameType.ADVENTURE, GameType.HARDCORE), Arrays.asList(Generator.DEFAULT, Generator.FLAT, Generator.LARGE_BIOMES, Generator.AMPLIFIED, Generator.CUSTOM, Generator.NETHER, Generator.END), Arrays.asList(0, 1, 2), EnumSet.of(Platform.Capability.PRECALCULATED_LIGHT, new Platform.Capability[]{Platform.Capability.SET_SPAWN_POINT, Platform.Capability.BLOCK_BASED, Platform.Capability.NAME_BASED, Platform.Capability.SEED, Platform.Capability.NAMED_BIOMES, Platform.Capability.POPULATE, Platform.Capability.GENERATOR_PER_DIMENSION, Platform.Capability.LEAF_DISTANCES, Platform.Capability.DATA_PACKS}), ATTRIBUTE_MC_VERSION, new org.pepsoft.util.Version(new int[]{1, 18}), ATTRIBUTE_EXPORT_DATA_VERSION, 2860, ATTRIBUTE_LATEST_DATA_VERSION, 2975);
    public static final Platform JAVA_ANVIL_1_19 = new Platform("org.pepsoft.anvil.1.19", "Minecraft 1.19 or later", new int[]{256, 320, 512, 1024, 1536, 2032}, 320, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, new int[]{0, -64, -128, -256, -512, -1024, -2032}, -64, Arrays.asList(GameType.SURVIVAL, GameType.CREATIVE, GameType.ADVENTURE, GameType.HARDCORE), Arrays.asList(Generator.DEFAULT, Generator.FLAT, Generator.LARGE_BIOMES, Generator.AMPLIFIED, Generator.CUSTOM, Generator.NETHER, Generator.END), Arrays.asList(0, 1, 2), EnumSet.of(Platform.Capability.PRECALCULATED_LIGHT, new Platform.Capability[]{Platform.Capability.SET_SPAWN_POINT, Platform.Capability.BLOCK_BASED, Platform.Capability.NAME_BASED, Platform.Capability.SEED, Platform.Capability.NAMED_BIOMES, Platform.Capability.POPULATE, Platform.Capability.GENERATOR_PER_DIMENSION, Platform.Capability.LEAF_DISTANCES, Platform.Capability.WATERLOGGED_LEAVES, Platform.Capability.DATA_PACKS}), ATTRIBUTE_MC_VERSION, new org.pepsoft.util.Version(new int[]{1, 19}), ATTRIBUTE_EXPORT_DATA_VERSION, 3105);
    public static List<Platform> DEFAULT_JAVA_PLATFORMS = ImmutableList.of((Object)JAVA_MCREGION, (Object)JAVA_ANVIL, (Object)JAVA_ANVIL_1_15, (Object)JAVA_ANVIL_1_17, (Object)JAVA_ANVIL_1_18, (Object)JAVA_ANVIL_1_19);

    public DefaultPlugin() {
        super("Default", Version.VERSION);
    }

    @Override
    public List<Layer> getLayers() {
        return Arrays.asList(Frost.INSTANCE, Caves.INSTANCE, Caverns.INSTANCE, Chasms.INSTANCE, DeciduousForest.INSTANCE, PineForest.INSTANCE, SwampLand.INSTANCE, Jungle.INSTANCE, Void.INSTANCE, Resources.INSTANCE);
    }

    @Override
    public WPContext getWPContextInstance() {
        return this;
    }

    @Override
    public EventLogger getStatisticsRecorder() {
        return Configuration.getInstance();
    }

    @Override
    public MinecraftJarProvider getMinecraftJarProvider() {
        return Configuration.getInstance();
    }
}

