/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.MissingCustomTerrainException;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Terrain;

public class CustomTerrainHelper {
    private final int index;
    private static final BufferedImage UNKNOWN_ICON;
    private static final Integer UNKNOWN_COLOUR;

    public CustomTerrainHelper(int index) {
        this.index = index;
    }

    public Material getMaterial(long seed, int x, int y, float z, int height) {
        if (z - (float)height >= 0.5f) {
            return Material.AIR;
        }
        MixedMaterial material = Terrain.customMaterials[this.index];
        if (material != null) {
            return material.getMaterial(seed, x, y, z);
        }
        throw new MissingCustomTerrainException("Custom terrain " + this.index + " not configured", this.index);
    }

    public Material getMaterial(long seed, int x, int y, int z, int height) {
        if (z - height > 0) {
            return Material.AIR;
        }
        MixedMaterial material = Terrain.customMaterials[this.index];
        if (material != null) {
            return material.getMaterial(seed, x, y, z);
        }
        throw new MissingCustomTerrainException("Custom terrain " + this.index + " not configured", this.index);
    }

    public BufferedImage getIcon(ColourScheme colourScheme) {
        MixedMaterial material = Terrain.customMaterials[this.index];
        return material != null ? material.getIcon(colourScheme) : UNKNOWN_ICON;
    }

    public int getDefaultBiome() {
        return Terrain.customMaterials[this.index].getBiome();
    }

    public boolean isConfigured() {
        return Terrain.customMaterials[this.index] != null;
    }

    public String getName() {
        MixedMaterial material = Terrain.customMaterials[this.index];
        return material != null ? material.getName() : "Custom " + (this.index + 1);
    }

    public int getCustomTerrainIndex() {
        return this.index;
    }

    public int getColour(long seed, int x, int y, float z, int height, ColourScheme colourScheme) {
        MixedMaterial material = Terrain.customMaterials[this.index];
        Integer colour = material != null ? material.getColour() : UNKNOWN_COLOUR;
        return colour != null ? colour.intValue() : colourScheme.getColour(this.getMaterial(seed, x, y, z, height));
    }

    public int getColour(long seed, int x, int y, int z, int height, ColourScheme colourScheme) {
        MixedMaterial material = Terrain.customMaterials[this.index];
        Integer colour = material != null ? material.getColour() : UNKNOWN_COLOUR;
        return colour != null ? colour.intValue() : colourScheme.getColour(this.getMaterial(seed, x, y, z, height));
    }

    static {
        UNKNOWN_COLOUR = 0xFF00FF;
        try {
            InputStream iconStream = CustomTerrainHelper.class.getResourceAsStream("/org/pepsoft/worldpainter/icons/unknown_pattern.png");
            UNKNOWN_ICON = iconStream != null ? ImageIO.read(iconStream) : null;
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error loading unknown_pattern.png from classpath", e);
        }
    }
}

