/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.UUID;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.util.CollectionUtils;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.util.XDG;
import org.pepsoft.util.swing.TiledImageViewer;
import org.pepsoft.worldpainter.AccelerationType;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.EventLogger;
import org.pepsoft.worldpainter.GameType;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.World;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.exporters.FrostExporter;
import org.pepsoft.worldpainter.themes.Filter;
import org.pepsoft.worldpainter.themes.HeightFilter;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.Theme;
import org.pepsoft.worldpainter.util.MinecraftJarProvider;
import org.pepsoft.worldpainter.vo.EventVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Configuration
implements Serializable,
EventLogger,
MinecraftJarProvider {
    private Rectangle windowBounds;
    private boolean maximised;
    private boolean hilly = true;
    private boolean lava;
    private boolean goodies = true;
    private boolean populate;
    private boolean beaches = true;
    @Deprecated
    private boolean mergeWarningDisplayed;
    @Deprecated
    private boolean importWarningDisplayed;
    private int level = 58;
    private int waterLevel = 62;
    private int borderLevel = 62;
    private Terrain surface = Terrain.GRASS;
    private Terrain underground = Terrain.RESOURCES;
    private File worldDirectory;
    @Deprecated
    private File exportDirectory;
    private File savesDirectory;
    private File customObjectsDirectory;
    @Deprecated
    private World.Border border;
    private Dimension.Border border2;
    private Boolean pingAllowed;
    @Deprecated
    private Material[] customMaterials = new Material[]{Material.DIRT, Material.DIRT, Material.DIRT, Material.DIRT, Material.DIRT};
    @Deprecated
    private int colourschemeIndex;
    private int launchCount;
    private Map<Integer, File> minecraftJars = new HashMap<Integer, File>();
    private DonationStatus donationStatus;
    private UUID uuid = UUID.randomUUID();
    private boolean checkForUpdates = true;
    private boolean undoEnabled = true;
    private boolean defaultGridEnabled;
    private boolean defaultContoursEnabled = true;
    private boolean defaultViewDistanceEnabled;
    private boolean defaultWalkingDistanceEnabled;
    private int undoLevels = 100;
    private int defaultGridSize = 128;
    private int defaultContourSeparation = 10;
    private int defaultWidth = 5;
    private int defaultHeight = 5;
    private int defaultMaxHeight = 256;
    private Dimension defaultTerrainAndLayerSettings;
    private boolean toolbarsLocked;
    private int version;
    private int worldFileBackups;
    private float defaultRange;
    private float uiScale;
    private double defaultScale;
    private TileRenderer.LightOrigin defaultLightOrigin;
    private int maximumBrushSize;
    private List<EventVO> eventLog;
    private List<CustomLayer> customLayers;
    private List<MixedMaterial> mixedMaterials;
    private boolean defaultExtendedBlockIds;
    private File layerDirectory;
    private File terrainDirectory;
    private File heightMapsDirectory;
    private File masksDirectory;
    private File backgroundImage;
    private Theme heightMapDefaultTheme;
    private boolean defaultCreateGoodiesChest;
    private boolean defaultMapFeatures;
    private boolean defaultAllowCheats;
    @Deprecated
    private Generator defaultGenerator;
    @Deprecated
    private int defaultGameType;
    @Deprecated
    private String defaultGeneratorOptions;
    private byte[] defaultJideLayoutData;
    private Map<String, byte[]> jideLayoutData;
    private LookAndFeel lookAndFeel;
    private OverlayType overlayType;
    private int showCalloutCount;
    private List<File> recentFiles;
    private List<File> recentScriptFiles;
    private TiledImageViewer.BackgroundImageMode backgroundImageMode;
    private int backgroundColour;
    private boolean showBorders;
    private boolean showBiomes;
    private GameType defaultGameTypeObj;
    @Deprecated
    private Platform defaultPlatform;
    @Deprecated
    private Map<Platform, File> exportDirectories;
    private boolean autosaveEnabled;
    private int autosaveDelay;
    private int autosaveInterval;
    private String defaultPlatformId;
    private Map<String, File> exportDirectoriesById;
    @Deprecated
    private boolean snapshotWarningDisplayed;
    @Deprecated
    private boolean beta118WarningDisplayed;
    private int minimumFreeSpaceForMaps;
    private boolean autoDeleteBackups;
    private MapGenerator defaultGeneratorObj;
    private ExportSettings defaultExportSettings;
    private int defaultResourcesMinimumLevel;
    private int showDonationDialogAfter;
    private Integer merchStoreDialogDisplayed;
    private Map<String, List<MessageDisplayed>> displayedMessages;
    private File overlaysDirectory;
    private Integer maxThreadCount;
    private int viewDistance;
    private transient AccelerationType accelerationType;
    private transient boolean autosaveInhibited;
    private transient boolean safeMode;
    private transient int previousVersion;
    private static Configuration instance;
    private static final Logger logger;
    private static final long serialVersionUID = 2011041801L;
    private static final int CIRCULAR_WORLD = -1;
    private static final int CURRENT_VERSION = 24;
    public static final String ADVANCED_SETTING_PREFIX = "org.pepsoft.worldpainter";
    public static final Platform DEFAULT_PLATFORM;

    public Configuration() {
        this.defaultTerrainAndLayerSettings = new World2(DEFAULT_PLATFORM, 27594263L, TileFactoryFactory.createNoiseTileFactory(new Random().nextLong(), this.surface, Configuration.DEFAULT_PLATFORM.minZ, this.defaultMaxHeight, this.level, this.waterLevel, this.lava, this.beaches, 20.0f, 1.0)).getDimension(Dimension.Anchor.NORMAL_DETAIL);
        this.version = 24;
        this.worldFileBackups = 3;
        this.defaultRange = 20.0f;
        this.defaultScale = 1.0;
        this.defaultLightOrigin = TileRenderer.LightOrigin.NORTHWEST;
        this.maximumBrushSize = 300;
        this.eventLog = new LinkedList<EventVO>();
        this.customLayers = new ArrayList<CustomLayer>();
        this.mixedMaterials = new ArrayList<MixedMaterial>();
        this.defaultCreateGoodiesChest = true;
        this.defaultMapFeatures = true;
        this.overlayType = OverlayType.OPTIMISE_ON_LOAD;
        this.showCalloutCount = 3;
        this.backgroundImageMode = TiledImageViewer.BackgroundImageMode.REPEAT;
        this.backgroundColour = -1;
        this.showBorders = true;
        this.showBiomes = true;
        this.defaultGameTypeObj = GameType.SURVIVAL;
        this.autosaveEnabled = true;
        this.autosaveDelay = 60000;
        this.autosaveInterval = 600000;
        this.defaultPlatformId = Configuration.DEFAULT_PLATFORM.id;
        this.exportDirectoriesById = new HashMap<String, File>();
        this.minimumFreeSpaceForMaps = 1;
        this.autoDeleteBackups = true;
        this.defaultGeneratorObj = new SeededGenerator(Generator.LARGE_BIOMES, 27594263L);
        this.defaultResourcesMinimumLevel = 8;
        this.showDonationDialogAfter = 5;
        this.merchStoreDialogDisplayed = 0;
        this.displayedMessages = new HashMap<String, List<MessageDisplayed>>();
        this.viewDistance = 192;
        this.previousVersion = -1;
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new configuration");
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public synchronized boolean isHilly() {
        return this.hilly;
    }

    public synchronized void setHilly(boolean hilly) {
        this.hilly = hilly;
    }

    public synchronized boolean isLava() {
        return this.lava;
    }

    public synchronized void setLava(boolean lava) {
        this.lava = lava;
    }

    public synchronized int getLevel() {
        return this.level;
    }

    public synchronized void setLevel(int level) {
        this.level = level;
    }

    public synchronized boolean isMaximised() {
        return this.maximised;
    }

    public synchronized void setMaximised(boolean maximised) {
        this.maximised = maximised;
    }

    public synchronized Terrain getSurface() {
        return this.surface;
    }

    public synchronized void setSurface(Terrain surface) {
        this.surface = surface;
    }

    public synchronized int getWaterLevel() {
        return this.waterLevel;
    }

    public synchronized void setWaterLevel(int waterLevel) {
        this.waterLevel = waterLevel;
    }

    public synchronized Rectangle getWindowBounds() {
        return this.windowBounds;
    }

    public synchronized void setWindowBounds(Rectangle windowBounds) {
        this.windowBounds = windowBounds;
    }

    public synchronized File getExportDirectory(Platform platform) {
        return this.exportDirectoriesById.get(platform.id);
    }

    public synchronized void setExportDirectory(Platform platform, File exportDirectory) {
        this.exportDirectoriesById.put(platform.id, exportDirectory);
    }

    public synchronized File getSavesDirectory() {
        return this.savesDirectory;
    }

    public synchronized void setSavesDirectory(File savesDirectory) {
        this.savesDirectory = savesDirectory;
    }

    public synchronized File getWorldDirectory() {
        return this.worldDirectory;
    }

    public synchronized void setWorldDirectory(File worldDirectory) {
        this.worldDirectory = worldDirectory;
    }

    public synchronized Dimension.Border getBorder() {
        return this.border2;
    }

    public synchronized void setBorder(Dimension.Border border) {
        this.border2 = border;
    }

    public synchronized boolean isGoodies() {
        return this.goodies;
    }

    public synchronized void setGoodies(boolean goodies) {
        this.goodies = goodies;
    }

    public synchronized boolean isPopulate() {
        return this.populate;
    }

    public synchronized void setPopulate(boolean populate) {
        this.populate = populate;
    }

    public synchronized Terrain getUnderground() {
        return this.underground;
    }

    public synchronized void setUnderground(Terrain underground) {
        this.underground = underground;
    }

    public synchronized int getBorderLevel() {
        return this.borderLevel;
    }

    public synchronized void setBorderLevel(int borderLevel) {
        this.borderLevel = borderLevel;
    }

    public synchronized boolean isBeaches() {
        return this.beaches;
    }

    public synchronized void setBeaches(boolean beaches) {
        this.beaches = beaches;
    }

    public synchronized Boolean getPingAllowed() {
        return this.pingAllowed;
    }

    public synchronized void setPingAllowed(Boolean pingAllowed) {
        this.pingAllowed = pingAllowed;
        if (Boolean.TRUE.equals(pingAllowed) && this.eventLog == null) {
            this.eventLog = new LinkedList<EventVO>();
        } else if (Boolean.FALSE.equals(pingAllowed)) {
            this.eventLog = null;
        }
    }

    public synchronized int getColourschemeIndex() {
        return this.colourschemeIndex;
    }

    public synchronized void setColourschemeIndex(int colourschemeIndex) {
        this.colourschemeIndex = colourschemeIndex;
    }

    public synchronized Map<Integer, File> getMinecraftJars() {
        return this.minecraftJars;
    }

    @Override
    public synchronized File getMinecraftJar(int biomeAlgorithm) {
        return this.minecraftJars.get(biomeAlgorithm);
    }

    public synchronized void setMinecraftJar(int biomeAlgorithm, File minecraftJar) {
        if (minecraftJar != null) {
            this.minecraftJars.put(biomeAlgorithm, minecraftJar);
        } else {
            this.minecraftJars.remove(biomeAlgorithm);
        }
    }

    public synchronized void setMinecraftJars(Map<Integer, File> minecraftJars) {
        if (minecraftJars == null) {
            throw new NullPointerException();
        }
        this.minecraftJars = minecraftJars;
    }

    public synchronized DonationStatus getDonationStatus() {
        return this.donationStatus;
    }

    public synchronized void setDonationStatus(DonationStatus donationStatus) {
        this.donationStatus = donationStatus;
    }

    public synchronized int getLaunchCount() {
        return this.launchCount;
    }

    public synchronized void setLaunchCount(int launchCount) {
        this.launchCount = launchCount;
    }

    public synchronized File getCustomObjectsDirectory() {
        return this.customObjectsDirectory;
    }

    public synchronized void setCustomObjectsDirectory(File customObjectsDirectory) {
        this.customObjectsDirectory = customObjectsDirectory;
    }

    public synchronized boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    public synchronized void setCheckForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
    }

    public synchronized int getDefaultContourSeparation() {
        return this.defaultContourSeparation;
    }

    public synchronized void setDefaultContourSeparation(int defaultContourSeparation) {
        this.defaultContourSeparation = defaultContourSeparation;
    }

    public synchronized boolean isDefaultContoursEnabled() {
        return this.defaultContoursEnabled;
    }

    public synchronized void setDefaultContoursEnabled(boolean defaultContoursEnabled) {
        this.defaultContoursEnabled = defaultContoursEnabled;
    }

    public synchronized boolean isDefaultGridEnabled() {
        return this.defaultGridEnabled;
    }

    public synchronized void setDefaultGridEnabled(boolean defaultGridEnabled) {
        this.defaultGridEnabled = defaultGridEnabled;
    }

    public synchronized int getDefaultGridSize() {
        return this.defaultGridSize;
    }

    public synchronized void setDefaultGridSize(int defaultGridSize) {
        this.defaultGridSize = defaultGridSize;
    }

    public synchronized int getDefaultHeight() {
        return this.defaultHeight != -1 ? this.defaultHeight : this.defaultWidth;
    }

    public synchronized void setDefaultHeight(int defaultHeight) {
        if (this.defaultHeight != -1) {
            this.defaultHeight = defaultHeight;
        }
    }

    public synchronized int getDefaultMaxHeight() {
        return this.defaultMaxHeight;
    }

    public synchronized void setDefaultMaxHeight(int defaultMaxHeight) {
        this.defaultMaxHeight = defaultMaxHeight;
    }

    public synchronized boolean isDefaultViewDistanceEnabled() {
        return this.defaultViewDistanceEnabled;
    }

    public synchronized void setDefaultViewDistanceEnabled(boolean defaultViewDistanceEnabled) {
        this.defaultViewDistanceEnabled = defaultViewDistanceEnabled;
    }

    public synchronized boolean isDefaultWalkingDistanceEnabled() {
        return this.defaultWalkingDistanceEnabled;
    }

    public synchronized void setDefaultWalkingDistanceEnabled(boolean defaultWalkingDistanceEnabled) {
        this.defaultWalkingDistanceEnabled = defaultWalkingDistanceEnabled;
    }

    public synchronized int getDefaultWidth() {
        return this.defaultWidth;
    }

    public synchronized void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public synchronized boolean isUndoEnabled() {
        return this.undoEnabled;
    }

    public synchronized void setUndoEnabled(boolean undoEnabled) {
        this.undoEnabled = undoEnabled;
    }

    public synchronized int getUndoLevels() {
        return this.undoLevels;
    }

    public synchronized void setUndoLevels(int undoLevels) {
        this.undoLevels = undoLevels;
    }

    public synchronized Dimension getDefaultTerrainAndLayerSettings() {
        return this.defaultTerrainAndLayerSettings;
    }

    public synchronized void setDefaultTerrainAndLayerSettings(Dimension defaultTerrainAndLayerSettings) {
        if (defaultTerrainAndLayerSettings.getLayerSettings(Resources.INSTANCE) != null) {
            defaultTerrainAndLayerSettings.setLayerSettings(Resources.INSTANCE, null);
        }
        this.defaultTerrainAndLayerSettings = defaultTerrainAndLayerSettings;
    }

    public synchronized boolean isToolbarsLocked() {
        return this.toolbarsLocked;
    }

    public synchronized void setToolbarsLocked(boolean toolbarsLocked) {
        this.toolbarsLocked = toolbarsLocked;
    }

    public synchronized int getWorldFileBackups() {
        return this.worldFileBackups;
    }

    public synchronized void setWorldFileBackups(int worldFileBackups) {
        this.worldFileBackups = worldFileBackups;
    }

    public synchronized float getDefaultRange() {
        return this.defaultRange;
    }

    public synchronized void setDefaultRange(float defaultRange) {
        this.defaultRange = defaultRange;
    }

    public synchronized double getDefaultScale() {
        return this.defaultScale;
    }

    public synchronized void setDefaultScale(double defaultScale) {
        this.defaultScale = defaultScale;
    }

    public synchronized TileRenderer.LightOrigin getDefaultLightOrigin() {
        return this.defaultLightOrigin;
    }

    public synchronized void setDefaultLightOrigin(TileRenderer.LightOrigin defaultLightOrigin) {
        this.defaultLightOrigin = defaultLightOrigin;
    }

    public synchronized boolean isDefaultCircularWorld() {
        return this.defaultHeight == -1;
    }

    public synchronized void setDefaultCircularWorld(boolean defaultCircularWorld) {
        if (defaultCircularWorld && this.defaultHeight != -1) {
            this.defaultHeight = -1;
        } else if (!defaultCircularWorld && this.defaultHeight == -1) {
            this.defaultHeight = this.defaultWidth;
        }
    }

    public synchronized int getMaximumBrushSize() {
        return this.maximumBrushSize;
    }

    public synchronized void setMaximumBrushSize(int maximumBrushSize) {
        this.maximumBrushSize = maximumBrushSize;
    }

    public synchronized List<CustomLayer> getCustomLayers() {
        return this.customLayers;
    }

    public synchronized List<MixedMaterial> getMixedMaterials() {
        return this.mixedMaterials;
    }

    public synchronized boolean isEasyMode() {
        return false;
    }

    public synchronized boolean isDefaultExtendedBlockIds() {
        return this.defaultExtendedBlockIds;
    }

    public synchronized void setDefaultExtendedBlockIds(boolean defaultExtendedBlockIds) {
        this.defaultExtendedBlockIds = defaultExtendedBlockIds;
    }

    public synchronized File getLayerDirectory() {
        return this.layerDirectory;
    }

    public synchronized void setLayerDirectory(File layerDirectory) {
        this.layerDirectory = layerDirectory;
    }

    public synchronized File getTerrainDirectory() {
        return this.terrainDirectory;
    }

    public synchronized void setTerrainDirectory(File terrainDirectory) {
        this.terrainDirectory = terrainDirectory;
    }

    public synchronized File getHeightMapsDirectory() {
        return this.heightMapsDirectory;
    }

    public synchronized void setHeightMapsDirectory(File heightMapsDirectory) {
        this.heightMapsDirectory = heightMapsDirectory;
    }

    public synchronized File getOverlaysDirectory() {
        return this.overlaysDirectory;
    }

    public synchronized void setOverlaysDirectory(File overlaysDirectory) {
        this.overlaysDirectory = overlaysDirectory;
    }

    public synchronized Theme getHeightMapDefaultTheme() {
        return this.heightMapDefaultTheme;
    }

    public synchronized void setHeightMapDefaultTheme(Theme heightMapDefaultTheme) {
        this.heightMapDefaultTheme = heightMapDefaultTheme;
    }

    public synchronized boolean isDefaultCreateGoodiesChest() {
        return this.defaultCreateGoodiesChest;
    }

    public synchronized void setDefaultCreateGoodiesChest(boolean defaultCreateGoodiesChest) {
        this.defaultCreateGoodiesChest = defaultCreateGoodiesChest;
    }

    public synchronized boolean isDefaultMapFeatures() {
        return this.defaultMapFeatures;
    }

    public synchronized void setDefaultMapFeatures(boolean defaultMapFeatures) {
        this.defaultMapFeatures = defaultMapFeatures;
    }

    public synchronized boolean isDefaultAllowCheats() {
        return this.defaultAllowCheats;
    }

    public synchronized void setDefaultAllowCheats(boolean defaultAllowCheats) {
        this.defaultAllowCheats = defaultAllowCheats;
    }

    public synchronized MapGenerator getDefaultGenerator() {
        return this.defaultGeneratorObj;
    }

    public synchronized void setDefaultGenerator(MapGenerator defaultGenerator) {
        this.defaultGeneratorObj = defaultGenerator;
    }

    public synchronized GameType getDefaultGameType() {
        return this.defaultGameTypeObj;
    }

    public synchronized void setDefaultGameType(GameType defaultGameType) {
        this.defaultGameTypeObj = defaultGameType;
    }

    public synchronized byte[] getDefaultJideLayoutData() {
        return this.defaultJideLayoutData;
    }

    public synchronized void setDefaultJideLayoutData(byte[] defaultJideLayoutData) {
        this.defaultJideLayoutData = defaultJideLayoutData;
    }

    public synchronized Map<String, byte[]> getJideLayoutData() {
        return this.jideLayoutData;
    }

    public synchronized void setJideLayoutData(Map<String, byte[]> jideLayoutData) {
        this.jideLayoutData = jideLayoutData;
    }

    public synchronized LookAndFeel getLookAndFeel() {
        return this.lookAndFeel;
    }

    public synchronized void setLookAndFeel(LookAndFeel lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public synchronized AccelerationType getAccelerationType() {
        return this.accelerationType;
    }

    public synchronized void setAccelerationType(AccelerationType accelerationType) {
        this.accelerationType = accelerationType;
    }

    public synchronized OverlayType getOverlayType() {
        return this.overlayType;
    }

    public synchronized void setOverlayType(OverlayType overlayType) {
        this.overlayType = overlayType;
    }

    public synchronized int getShowCalloutCount() {
        return this.showCalloutCount;
    }

    public synchronized void setShowCalloutCount(int showCalloutCount) {
        this.showCalloutCount = showCalloutCount;
    }

    public synchronized List<File> getRecentFiles() {
        return this.recentFiles;
    }

    public synchronized void setRecentFiles(List<File> recentFiles) {
        this.recentFiles = recentFiles;
    }

    public synchronized List<File> getRecentScriptFiles() {
        return this.recentScriptFiles;
    }

    public synchronized void setRecentScriptFiles(List<File> recentScriptFiles) {
        this.recentScriptFiles = recentScriptFiles;
    }

    public synchronized File getMasksDirectory() {
        return this.masksDirectory;
    }

    public synchronized void setMasksDirectory(File masksDirectory) {
        this.masksDirectory = masksDirectory;
    }

    public synchronized File getBackgroundImage() {
        return this.backgroundImage;
    }

    public synchronized void setBackgroundImage(File backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public synchronized TiledImageViewer.BackgroundImageMode getBackgroundImageMode() {
        return this.backgroundImageMode;
    }

    public synchronized void setBackgroundImageMode(TiledImageViewer.BackgroundImageMode backgroundImageMode) {
        this.backgroundImageMode = backgroundImageMode;
    }

    public synchronized int getBackgroundColour() {
        return this.backgroundColour;
    }

    public synchronized void setBackgroundColour(int backgroundColour) {
        this.backgroundColour = backgroundColour;
    }

    public synchronized boolean isShowBorders() {
        return this.showBorders;
    }

    public synchronized void setShowBorders(boolean showBorders) {
        this.showBorders = showBorders;
    }

    public synchronized boolean isShowBiomes() {
        return this.showBiomes;
    }

    public synchronized void setShowBiomes(boolean showBiomes) {
        this.showBiomes = showBiomes;
    }

    public synchronized Platform getDefaultPlatform() {
        return Platform.getById(this.defaultPlatformId);
    }

    public synchronized void setDefaultPlatform(Platform defaultPlatform) {
        this.defaultPlatformId = defaultPlatform.id;
    }

    public synchronized boolean isAutosaveEnabled() {
        return this.autosaveEnabled;
    }

    public synchronized void setAutosaveEnabled(boolean autosaveEnabled) {
        this.autosaveEnabled = autosaveEnabled;
    }

    public synchronized int getAutosaveDelay() {
        return this.autosaveDelay;
    }

    public synchronized void setAutosaveDelay(int autosaveDelay) {
        this.autosaveDelay = autosaveDelay;
    }

    public synchronized int getAutosaveInterval() {
        return this.autosaveInterval;
    }

    public synchronized void setAutosaveInterval(int autosaveInterval) {
        this.autosaveInterval = autosaveInterval;
    }

    public synchronized int getMinimumFreeSpaceForMaps() {
        return this.minimumFreeSpaceForMaps;
    }

    public synchronized void setMinimumFreeSpaceForMaps(int minimumFreeSpaceForMaps) {
        this.minimumFreeSpaceForMaps = minimumFreeSpaceForMaps;
    }

    public synchronized boolean isAutoDeleteBackups() {
        return this.autoDeleteBackups;
    }

    public synchronized void setAutoDeleteBackups(boolean autoDeleteBackups) {
        this.autoDeleteBackups = autoDeleteBackups;
    }

    public synchronized ExportSettings getDefaultExportSettings() {
        return this.defaultExportSettings;
    }

    public synchronized void setDefaultExportSettings(ExportSettings defaultExportSettings) {
        this.defaultExportSettings = defaultExportSettings;
    }

    public synchronized boolean isMessageDisplayed(String messageKey) {
        return this.displayedMessages.containsKey(messageKey);
    }

    public synchronized boolean isMessageDisplayedCountAtLeast(String messageKey, int count) {
        return this.displayedMessages.containsKey(messageKey) && this.displayedMessages.get(messageKey).size() >= count;
    }

    public synchronized void setMessageDisplayed(String messageKey) {
        this.displayedMessages.computeIfAbsent(messageKey, k -> new ArrayList()).add(new MessageDisplayed(this.launchCount));
    }

    public synchronized Integer getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public synchronized void setMaxThreadCount(Integer maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public synchronized int getViewDistance() {
        return this.viewDistance;
    }

    public synchronized void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }

    public boolean isAutosaveInhibited() {
        return this.autosaveInhibited;
    }

    public void setAutosaveInhibited(boolean autosaveInhibited) {
        this.autosaveInhibited = autosaveInhibited;
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public float getUiScale() {
        return this.uiScale;
    }

    public void setUiScale(float uiScale) {
        this.uiScale = uiScale;
    }

    public int getDefaultResourcesMinimumLevel() {
        return this.defaultResourcesMinimumLevel;
    }

    public void setDefaultResourcesMinimumLevel(int defaultResourcesMinimumLevel) {
        this.defaultResourcesMinimumLevel = defaultResourcesMinimumLevel;
    }

    public Integer getMerchStoreDialogDisplayed() {
        return this.merchStoreDialogDisplayed;
    }

    public void setMerchStoreDialogDisplayed(Integer merchStoreDialogDisplayed) {
        this.merchStoreDialogDisplayed = merchStoreDialogDisplayed;
    }

    public int getShowDonationDialogAfter() {
        return this.showDonationDialogAfter;
    }

    public void setShowDonationDialogAfter(int showDonationDialogAfter) {
        this.showDonationDialogAfter = showDonationDialogAfter;
    }

    public <T> T getAdvancedSetting(AttributeKey<T> key) {
        String value = System.getProperty("org.pepsoft.worldpainter." + key.key);
        if (value != null) {
            return (T)key.toValue(value);
        }
        return (T)key.defaultValue;
    }

    public int getVersion() {
        return this.version;
    }

    public int getPreviousVersion() {
        return this.previousVersion;
    }

    @Override
    public synchronized void logEvent(EventVO event) {
        if (this.eventLog != null) {
            this.eventLog.add(event);
        }
    }

    public synchronized List<EventVO> getEventLog() {
        return CollectionUtils.copyOf(this.eventLog);
    }

    public synchronized void removeEvents(Collection<EventVO> events) {
        if (this.eventLog != null) {
            this.eventLog.removeAll(events);
        }
    }

    public synchronized void clearStatistics() {
        if (this.eventLog != null) {
            this.eventLog = new LinkedList<EventVO>();
        }
    }

    public synchronized void save() throws IOException {
        logger.info("Saving configuration to " + Configuration.getConfigFile().getAbsolutePath());
        if (!Configuration.getConfigDir().isDirectory()) {
            Configuration.getConfigDir().mkdirs();
        }
        this.save(Configuration.getConfigFile());
    }

    public synchronized void save(File configFile) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(configFile));){
            out.writeObject(this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object theme;
        FrostExporter.FrostSettings frostSettings;
        in.defaultReadObject();
        this.previousVersion = this.version;
        if (this.border != null && this.border2 == null) {
            this.border2 = Dimension.Border.valueOf(this.border.name());
            this.border = null;
        }
        if (this.customMaterials == null) {
            this.customMaterials = new Material[]{Material.DIRT, Material.DIRT, Material.DIRT, Material.DIRT, Material.DIRT};
        }
        if (this.minecraftJars == null) {
            this.minecraftJars = new HashMap<Integer, File>();
        }
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        if (this.undoLevels == 0) {
            this.checkForUpdates = true;
            this.undoEnabled = true;
            this.defaultContoursEnabled = true;
            this.undoLevels = 100;
            this.defaultGridSize = 128;
            this.defaultContourSeparation = 10;
            this.defaultWidth = 5;
            this.defaultHeight = 5;
            this.defaultMaxHeight = 256;
        }
        if (this.defaultTerrainAndLayerSettings == null) {
            this.defaultTerrainAndLayerSettings = new World2(DefaultPlugin.JAVA_ANVIL_1_15, 27594263L, TileFactoryFactory.createNoiseTileFactory(new Random().nextLong(), this.surface, DefaultPlugin.JAVA_ANVIL_1_15.minZ, this.defaultMaxHeight, this.level, this.waterLevel, this.lava, this.beaches, 20.0f, 1.0)).getDimension(Dimension.Anchor.NORMAL_DETAIL);
        }
        if (this.viewDistance == 0) {
            this.viewDistance = 192;
        }
        if (this.version < 1) {
            this.worldFileBackups = 3;
        }
        if (this.version < 2) {
            this.defaultRange = 20.0f;
            this.defaultScale = 1.0;
            this.defaultLightOrigin = TileRenderer.LightOrigin.NORTHWEST;
        }
        if (this.version < 3) {
            String maxRadiusStr = System.getProperty("org.pepsoft.worldpainter.maxRadius");
            if (maxRadiusStr != null && !maxRadiusStr.trim().isEmpty()) {
                try {
                    this.maximumBrushSize = Integer.parseInt(maxRadiusStr);
                }
                catch (NumberFormatException e) {
                    this.maximumBrushSize = 300;
                }
            } else {
                this.maximumBrushSize = 300;
            }
        }
        if (this.version < 4 && (frostSettings = (FrostExporter.FrostSettings)this.defaultTerrainAndLayerSettings.getLayerSettings(Frost.INSTANCE)) != null) {
            frostSettings.setMode(2);
        }
        if (this.version < 6 && !Boolean.FALSE.equals(this.pingAllowed)) {
            this.eventLog = new LinkedList<EventVO>();
        }
        if (this.version < 7) {
            this.customLayers = new ArrayList<CustomLayer>();
            this.mixedMaterials = new ArrayList<MixedMaterial>();
        }
        if (this.version < 8 && this.defaultTerrainAndLayerSettings.getTileFactory() instanceof HeightMapTileFactory && ((HeightMapTileFactory)this.defaultTerrainAndLayerSettings.getTileFactory()).getTheme() instanceof SimpleTheme && ((SimpleTheme)(theme = (SimpleTheme)((HeightMapTileFactory)this.defaultTerrainAndLayerSettings.getTileFactory()).getTheme())).getTerrainRanges() != null) {
            SortedMap<Integer, Terrain> terrainRanges = ((SimpleTheme)theme).getTerrainRanges();
            HashMap<Filter, Layer> layerMap = new HashMap<Filter, Layer>();
            boolean frostAdded = false;
            for (Map.Entry<Integer, Terrain> entry2 : terrainRanges.entrySet()) {
                if (entry2.getValue() != Terrain.SNOW) continue;
                if (!frostAdded) {
                    layerMap.put(new HeightFilter(0, this.defaultMaxHeight, entry2.getKey(), this.defaultMaxHeight - 1, ((SimpleTheme)theme).isRandomise()), Frost.INSTANCE);
                    frostAdded = true;
                }
                entry2.setValue(Terrain.STONE_MIX);
            }
            if (!layerMap.isEmpty()) {
                ((SimpleTheme)theme).setLayerMap(layerMap);
            }
        }
        if (this.version < 9) {
            this.defaultCreateGoodiesChest = true;
            this.defaultGenerator = Generator.DEFAULT;
            this.defaultMapFeatures = true;
            this.defaultGameType = 0;
        }
        if (this.version < 10 && this.defaultTerrainAndLayerSettings.getSubsurfaceMaterial() == Terrain.STONE) {
            this.defaultTerrainAndLayerSettings.setSubsurfaceMaterial(Terrain.STONE_MIX);
        }
        if (this.version < 11) {
            switch (SystemUtils.getOS()) {
                case WINDOWS: {
                    this.accelerationType = AccelerationType.DIRECT3D;
                    break;
                }
                case MAC: {
                    this.accelerationType = AccelerationType.DEFAULT;
                    break;
                }
                case LINUX: {
                    this.accelerationType = AccelerationType.XRENDER;
                    break;
                }
                default: {
                    this.accelerationType = AccelerationType.DEFAULT;
                }
            }
            this.overlayType = OverlayType.SCALE_ON_LOAD;
        }
        if (this.version < 12) {
            this.defaultJideLayoutData = null;
            this.jideLayoutData = null;
            this.showCalloutCount = 3;
        }
        if (this.version < 13) {
            this.backgroundImageMode = TiledImageViewer.BackgroundImageMode.REPEAT;
            this.backgroundColour = -1;
            this.showBorders = true;
            this.showBiomes = true;
        }
        if (this.version < 14) {
            if (this.defaultGameType >= 0) {
                this.defaultGameTypeObj = GameType.values()[this.defaultGameType];
                this.defaultGameType = -1;
            } else {
                this.defaultGameTypeObj = GameType.SURVIVAL;
                this.defaultGameType = -1;
            }
        }
        if (this.version < 15) {
            this.defaultPlatform = DefaultPlugin.JAVA_ANVIL;
            this.exportDirectories = new HashMap<Platform, File>();
            if (this.exportDirectory != null) {
                this.exportDirectories.put(DefaultPlugin.JAVA_ANVIL, this.exportDirectory);
                this.exportDirectories.put(DefaultPlugin.JAVA_MCREGION, this.exportDirectory);
                this.exportDirectory = null;
            }
        }
        if (this.version < 16) {
            this.autosaveEnabled = true;
            this.autosaveDelay = 10000;
            this.autosaveInterval = 300000;
        }
        if (this.version < 17) {
            this.defaultPlatformId = this.defaultPlatform.id;
            this.exportDirectoriesById = new HashMap<String, File>();
            theme = this.exportDirectories.entrySet().iterator();
            while (theme.hasNext()) {
                Map.Entry entry3 = (Map.Entry)theme.next();
                this.exportDirectoriesById.put(((Platform)entry3.getKey()).id, (File)entry3.getValue());
            }
            this.defaultPlatform = null;
            this.exportDirectories = null;
        }
        if (this.version < 18) {
            // empty if block
        }
        if (this.version < 19 && this.defaultPlatformId.equals(DefaultPlugin.JAVA_ANVIL.id)) {
            this.defaultPlatformId = DefaultPlugin.JAVA_ANVIL_1_15.id;
        }
        if (this.version < 20 && this.defaultTerrainAndLayerSettings.getTileFactory() instanceof HeightMapTileFactory && ((HeightMapTileFactory)this.defaultTerrainAndLayerSettings.getTileFactory()).getTheme() instanceof SimpleTheme && ((SimpleTheme)(theme = (SimpleTheme)((HeightMapTileFactory)this.defaultTerrainAndLayerSettings.getTileFactory()).getTheme())).getTerrainRanges() != null) {
            ((SimpleTheme)theme).getTerrainRanges().entrySet().forEach(entry -> {
                if (entry.getValue() == Terrain.ROCK) {
                    entry.setValue(Terrain.STONE_MIX);
                }
            });
        }
        if (this.version < 21) {
            if (this.minimumFreeSpaceForMaps == 0) {
                this.minimumFreeSpaceForMaps = 5;
                this.autoDeleteBackups = true;
            }
            if (this.defaultGeneratorObj == null) {
                this.defaultGeneratorObj = MapGenerator.fromLegacySettings(this.defaultGenerator, 27594263L, null, this.defaultGeneratorOptions, Platform.getById(this.defaultPlatformId), null);
                this.defaultGenerator = null;
                this.defaultGeneratorOptions = null;
            }
            if (this.defaultGeneratorObj.getType() == Generator.DEFAULT && this.getDefaultPlatform().supportedGenerators.contains((Object)Generator.LARGE_BIOMES)) {
                this.defaultGeneratorObj = new SeededGenerator(Generator.LARGE_BIOMES, 27594263L);
            }
        }
        if (this.version < 22) {
            this.defaultResourcesMinimumLevel = 8;
        }
        if (this.version < 23) {
            this.showDonationDialogAfter = this.launchCount < 5 ? 5 : (this.donationStatus == DonationStatus.DONATED ? Math.max(this.launchCount + 5, 100) : Math.max(this.launchCount + 5, 50));
        }
        if (this.version < 24) {
            this.displayedMessages = new HashMap<String, List<MessageDisplayed>>();
            if (this.mergeWarningDisplayed) {
                this.displayedMessages.put("org.pepsoft.worldpainter.mergeWarning", new ArrayList<MessageDisplayed>(Collections.singletonList(new MessageDisplayed(0))));
                this.mergeWarningDisplayed = false;
            }
            if (this.importWarningDisplayed) {
                this.displayedMessages.put("org.pepsoft.worldpainter.importWarning", new ArrayList<MessageDisplayed>(Collections.singletonList(new MessageDisplayed(0))));
                this.importWarningDisplayed = false;
            }
            if (this.snapshotWarningDisplayed) {
                this.displayedMessages.put("org.pepsoft.worldpainter.snapshotWarning", new ArrayList<MessageDisplayed>(Collections.singletonList(new MessageDisplayed(0))));
                this.snapshotWarningDisplayed = false;
            }
            if (this.beta118WarningDisplayed) {
                this.displayedMessages.put("org.pepsoft.worldpainter.beta118Warning", new ArrayList<MessageDisplayed>(Collections.singletonList(new MessageDisplayed(0))));
                this.beta118WarningDisplayed = false;
            }
        }
        if (this.defaultTerrainAndLayerSettings.getLayerSettings(Resources.INSTANCE) != null) {
            this.defaultTerrainAndLayerSettings.setLayerSettings(Resources.INSTANCE, null);
        }
        this.version = 24;
        TileFactory tileFactory = this.defaultTerrainAndLayerSettings.getTileFactory();
        if (tileFactory instanceof HeightMapTileFactory && ((HeightMapTileFactory)tileFactory).getTheme() instanceof SimpleTheme) {
            SortedMap<Integer, Terrain> defaultTerrainRanges = ((SimpleTheme)((HeightMapTileFactory)tileFactory).getTheme()).getTerrainRanges();
            int surfaceLevel = defaultTerrainRanges.headMap(this.waterLevel + 3).lastKey();
            defaultTerrainRanges.put(surfaceLevel, this.surface);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.worldDirectory = FileUtils.absolutise((File)this.worldDirectory);
        this.savesDirectory = FileUtils.absolutise((File)this.savesDirectory);
        this.customObjectsDirectory = FileUtils.absolutise((File)this.customObjectsDirectory);
        this.minecraftJars = FileUtils.absolutise(this.minecraftJars);
        this.layerDirectory = FileUtils.absolutise((File)this.layerDirectory);
        this.terrainDirectory = FileUtils.absolutise((File)this.terrainDirectory);
        this.heightMapsDirectory = FileUtils.absolutise((File)this.heightMapsDirectory);
        this.recentFiles = (List)FileUtils.absolutise(this.recentFiles);
        this.recentScriptFiles = (List)FileUtils.absolutise(this.recentScriptFiles);
        this.masksDirectory = FileUtils.absolutise((File)this.masksDirectory);
        this.backgroundImage = FileUtils.absolutise((File)this.backgroundImage);
        this.exportDirectoriesById = FileUtils.absolutise(this.exportDirectoriesById);
        this.overlaysDirectory = FileUtils.absolutise((File)this.overlaysDirectory);
        out.defaultWriteObject();
    }

    public static synchronized Configuration load() throws IOException, ClassNotFoundException {
        File oldConfigFile;
        File configFile = Configuration.getConfigFile();
        if (!configFile.isFile() && (oldConfigFile = new File(System.getProperty("user.home"), ".worldpainter/config")).isFile()) {
            Configuration.migrateConfiguration();
        }
        if (configFile.isFile()) {
            logger.info("Loading configuration from " + configFile.getAbsolutePath());
            return Configuration.load(configFile);
        }
        return null;
    }

    public static synchronized Configuration load(File configFile) throws IOException, ClassNotFoundException {
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(configFile));){
            Configuration configuration = (Configuration)in.readObject();
            return configuration;
        }
    }

    public static synchronized Configuration getInstance() {
        return instance;
    }

    public static synchronized void setInstance(Configuration instance) {
        Configuration.instance = instance;
    }

    public static File getConfigDir() {
        String appDataStr;
        if (SystemUtils.isMac()) {
            return new File(System.getProperty("user.home"), "Library/Application Support/WorldPainter" + (Version.isSnapshot() ? " [SNAPSHOT]" : ""));
        }
        if (SystemUtils.isWindows() && (appDataStr = System.getenv("APPDATA")) != null) {
            return new File(appDataStr, "WorldPainter" + (Version.isSnapshot() ? " [SNAPSHOT]" : ""));
        }
        File defaultDir = new File(XDG.HOME, ".worldpainter" + (Version.isSnapshot() ? "-snapshot" : ""));
        if (defaultDir.isDirectory()) {
            return defaultDir;
        }
        return new File(XDG.XDG_DATA_HOME, "worldpainter" + (Version.isSnapshot() ? "-snapshot" : ""));
    }

    public static File getConfigFile() {
        return new File(Configuration.getConfigDir(), "config");
    }

    private static void migrateConfiguration() throws IOException {
        File[] oldContents;
        File newConfigDir = Configuration.getConfigDir();
        File oldConfigDir = new File(System.getProperty("user.home"), ".worldpainter");
        logger.info("Configuration found in old location (" + oldConfigDir + "); migrating it to new location (" + newConfigDir + ")");
        for (File oldFile : oldContents = oldConfigDir.listFiles((dir, name) -> !name.startsWith("logfile"))) {
            if (oldFile.isDirectory()) {
                FileUtils.copyDir((File)oldFile, (File)new File(newConfigDir, oldFile.getName()));
                continue;
            }
            if (oldFile.isFile()) {
                FileUtils.copyFileToDir((File)oldFile, (File)newConfigDir);
                continue;
            }
            logger.warn("Directory entry encountered which was neither file nor directory: " + oldFile);
        }
        FileUtils.deleteDir((File)oldConfigDir);
    }

    static {
        logger = LoggerFactory.getLogger(Configuration.class);
        DEFAULT_PLATFORM = DefaultPlugin.JAVA_ANVIL_1_15;
    }

    public static class MessageDisplayed
    implements Serializable {
        public int launchCount;
        public Date timestamp;

        public MessageDisplayed(int launchCount) {
            this.launchCount = launchCount;
            this.timestamp = new Date();
        }
    }

    public static enum OverlayType {
        SCALE_ON_LOAD,
        OPTIMISE_ON_LOAD,
        SCALE_ON_PAINT;

    }

    public static enum LookAndFeel {
        SYSTEM,
        METAL,
        NIMBUS,
        DARK_METAL,
        DARK_NIMBUS;

    }

    public static enum DonationStatus {
        DONATED,
        NO_THANK_YOU;

    }
}

