/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.plugins.PluginManager;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTool {
    private static final Logger logger;

    protected static void initialisePlatform() {
        File dynmapDir;
        Locale.setDefault(Locale.US);
        File configDir = Configuration.getConfigDir();
        logger.info("Starting WorldPainter " + Version.VERSION + " (" + Version.BUILD + ")");
        logger.info("Running on {} version {}; architecture: {}", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
        logger.info("Running on {} Java version {}; maximum heap size: {} MB", new Object[]{System.getProperty("java.vendor"), System.getProperty("java.specification.version"), Runtime.getRuntime().maxMemory() / 1000000L});
        try {
            Class.forName("org.pepsoft.worldpainter.DefaultPlugin");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Configuration config = null;
        try {
            config = Configuration.load();
        }
        catch (IOException | ClassNotFoundException | Error | RuntimeException e) {
            AbstractTool.configError(e);
        }
        if (config == null) {
            if (!logger.isDebugEnabled()) {
                logger.info("Creating new configuration");
            }
            config = new Configuration();
        }
        Configuration.setInstance(config);
        logger.info("Installation ID: " + config.getUuid());
        if (config.getPreviousVersion() >= 0 && config.getPreviousVersion() < 18 && (dynmapDir = new File(Configuration.getConfigDir(), "dynmap")).isDirectory()) {
            FileUtils.deleteDir((File)dynmapDir);
        }
        X509Certificate trustedCert = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            trustedCert = (X509Certificate)certificateFactory.generateCertificate(AbstractTool.class.getResourceAsStream("/wproot.pem"));
        }
        catch (CertificateException e) {
            logger.error("Certificate exception while loading trusted root certificate", (Throwable)e);
        }
        if (trustedCert != null) {
            PluginManager.loadPlugins((File)new File(configDir, "plugins"), (PublicKey)trustedCert.getPublicKey(), (String)"org.pepsoft.worldpainter.plugins", (org.pepsoft.util.Version)Version.VERSION_OBJ, (boolean)false);
        } else {
            logger.error("Trusted root certificate not available; not loading plugins");
        }
        WPPluginManager.initialise(config.getUuid());
        for (Platform platform : PlatformManager.getInstance().getAllPlatforms()) {
            logger.info("Available platform: {}", (Object)platform.displayName);
        }
        String httpAgent = "WorldPainter " + Version.VERSION + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ";";
        System.setProperty("http.agent", httpAgent);
    }

    private static void configError(Throwable e) {
        File configFile = Configuration.getConfigFile();
        if (configFile.isFile() && configFile.canRead()) {
            File backupConfigFile = new File(configFile.getParentFile(), configFile.getName() + ".old");
            try {
                FileUtils.copyFileToFile((File)configFile, (File)backupConfigFile, (boolean)true);
            }
            catch (IOException e1) {
                logger.error("I/O error while trying to preserve faulty config file", (Throwable)e1);
            }
        }
        logger.error("Exception while initialising configuration", e);
    }

    static {
        System.setProperty("logback.configurationFile", "logback-tools.xml");
        logger = LoggerFactory.getLogger(AbstractTool.class);
    }
}

