/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.mapexplorer;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.pepsoft.minecraft.mapexplorer.DirectoryNode;
import org.pepsoft.minecraft.mapexplorer.FileSystemNode;
import org.pepsoft.minecraft.mapexplorer.NBTFileNode;
import org.pepsoft.minecraft.mapexplorer.RegionFileNode;
import org.pepsoft.worldpainter.mapexplorer.Node;

public class JavaMinecraftDirectoryNode
extends DirectoryNode {
    private final Pattern regionFilenamePatternVersion1 = Pattern.compile("r\\.-?\\d+\\.-?\\d+\\.mcr");
    private final Pattern regionFilenamePatternVersion2 = Pattern.compile("r\\.-?\\d+\\.-?\\d+\\.mca");

    public JavaMinecraftDirectoryNode(File dir) {
        super(dir);
    }

    @Override
    protected Node[] loadChildren() {
        File[] contents = this.file.listFiles();
        ArrayList<FileSystemNode> children = new ArrayList<FileSystemNode>(contents.length);
        for (File file : contents) {
            if (file.isDirectory()) {
                children.add(new JavaMinecraftDirectoryNode(file));
                continue;
            }
            if (!file.isFile()) continue;
            String name = file.getName();
            if (this.regionFilenamePatternVersion1.matcher(name).matches() || this.regionFilenamePatternVersion2.matcher(name).matches()) {
                children.add(new RegionFileNode(file));
                continue;
            }
            String lowercaseName = name.toLowerCase();
            if (lowercaseName.endsWith(".nbt") || lowercaseName.endsWith(".dat") || lowercaseName.endsWith(".dat_old")) {
                children.add(new NBTFileNode(file));
                continue;
            }
            if (this.isGzip(file)) {
                children.add(new NBTFileNode(file));
                continue;
            }
            children.add(new FileSystemNode(file));
        }
        children.sort((node1, node2) -> DirectoryNode.COLLATOR.compare(node1.getName(), node2.getName()));
        return children.toArray(new Node[children.size()]);
    }
}

