/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.mapexplorer;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import org.jnbt.NBTInputStream;
import org.jnbt.Tag;
import org.pepsoft.minecraft.RegionFile;
import org.pepsoft.minecraft.mapexplorer.TagNode;
import org.pepsoft.worldpainter.mapexplorer.AbstractNode;
import org.pepsoft.worldpainter.mapexplorer.Node;

public class ChunkNode
extends AbstractNode {
    private final RegionFile regionFile;
    private final int x;
    private final int z;

    ChunkNode(RegionFile regionFile, int x, int z) {
        this.regionFile = regionFile;
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    @Override
    public String getName() {
        return "Chunk " + this.x + ", " + this.z;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Node[] loadChildren() {
        try (NBTInputStream in = new NBTInputStream((InputStream)this.regionFile.getChunkDataInputStream(this.x, this.z));){
            Tag tag = in.readTag();
            Node[] nodeArray = new Node[]{new TagNode(tag)};
            return nodeArray;
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error reading from region file", e);
        }
    }
}

