/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.datapack;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.pepsoft.minecraft.datapack.Descriptor;
import org.pepsoft.minecraft.datapack.Dimension;
import org.pepsoft.minecraft.datapack.Meta;
import org.pepsoft.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPack {
    private final Map<String, Descriptor> descriptors = new HashMap<String, Descriptor>();
    private static final Logger logger = LoggerFactory.getLogger(DataPack.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public void write(OutputStream out) throws IOException {
        try (ZipOutputStream zip = new ZipOutputStream(out);){
            ObjectWriter writer = OBJECT_MAPPER.writer().withoutFeatures(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
            for (Map.Entry<String, Descriptor> entry : this.descriptors.entrySet()) {
                zip.putNextEntry(new ZipEntry(entry.getKey()));
                writer.writeValue((OutputStream)zip, (Object)entry.getValue());
            }
        }
    }

    public void addDescriptor(String name, Descriptor descriptor) {
        this.descriptors.put(name, descriptor);
    }

    public Map<String, Descriptor> getDescriptors() {
        return Collections.unmodifiableMap(this.descriptors);
    }

    public static DataPack load(File dir, String name) throws IOException {
        DataPack dataPack = new DataPack();
        File packFile = new File(dir, "datapacks/" + name.substring(5));
        ObjectReader reader = OBJECT_MAPPER.reader().withoutFeatures(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE}).withoutFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
        if (packFile.isFile()) {
            try (ZipFile in = new ZipFile(packFile);){
                in.stream().filter(entry -> !entry.isDirectory()).forEach(entry -> {
                    String descName = entry.getName();
                    try {
                        if (descName.equals("pack.mcmeta")) {
                            dataPack.addDescriptor(descName, (Descriptor)reader.readValue(in.getInputStream((ZipEntry)entry), Meta.class));
                        } else if (descName.startsWith("data/minecraft/dimension_type")) {
                            dataPack.addDescriptor(descName, (Descriptor)reader.readValue(in.getInputStream((ZipEntry)entry), Dimension.class));
                        } else {
                            logger.trace("Ignoring descriptor {} from data pack {}", (Object)descName, (Object)name);
                        }
                    }
                    catch (IOException e) {
                        logger.error("{} while reading descriptor {} from data pack {} in map {} (message: {})", new Object[]{e.getClass().getSimpleName(), descName, name, dir, e.getMessage()});
                    }
                });
            }
        } else if (packFile.isDirectory()) {
            FileUtils.visitFilesRecursively((File)packFile, file -> {
                block28: {
                    String descName = file.getName();
                    String descPath = file.getParent();
                    try {
                        if (descName.equals("pack.mcmeta")) {
                            try (FileInputStream in = new FileInputStream((File)file);){
                                dataPack.addDescriptor(descName, (Descriptor)reader.readValue((InputStream)in, Meta.class));
                                break block28;
                            }
                        }
                        if (descPath.contains("data" + File.separatorChar + "minecraft" + File.separatorChar + "dimension_type")) {
                            try (FileInputStream in = new FileInputStream((File)file);){
                                dataPack.addDescriptor(descName, (Descriptor)reader.readValue((InputStream)in, Dimension.class));
                                break block28;
                            }
                        }
                        logger.trace("Ignoring descriptor {} from data pack {}", (Object)descName, (Object)name);
                    }
                    catch (IOException e) {
                        logger.error("{} while reading descriptor {} from data pack {} in map {} (message: {})", new Object[]{e.getClass().getSimpleName(), descName, name, dir, e.getMessage()});
                    }
                }
            });
        } else {
            logger.error("Data pack {} is not a file or a directory; returning empty data pack", (Object)packFile);
        }
        return dataPack;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDataPackFile(File packFile) {
        try (ZipFile in = new ZipFile(packFile);){
            boolean bl = in.getEntry("pack.mcmeta") != null;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

