/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;

public final class RegionFile
implements AutoCloseable {
    private static final int VERSION_GZIP = 1;
    private static final int VERSION_DEFLATE = 2;
    private static final int SECTOR_BYTES = 4096;
    private static final int SECTOR_INTS = 1024;
    static final int CHUNK_HEADER_SIZE = 5;
    private static final byte[] emptySector = new byte[4096];
    private final File fileName;
    private final RandomAccessFile file;
    private final int[] offsets;
    private final int[] chunkTimestamps;
    private final ArrayList<Boolean> sectorFree;
    private final boolean readOnly;
    private int sizeDelta;
    private long lastModified = 0L;
    private final int x;
    private final int z;

    public RegionFile() {
        this.fileName = null;
        this.file = null;
        this.offsets = null;
        this.chunkTimestamps = null;
        this.sectorFree = null;
        this.x = 0;
        this.z = 0;
        this.readOnly = true;
    }

    public RegionFile(File path) throws IOException {
        this(path, false);
    }

    public RegionFile(File path, boolean readOnly) throws IOException {
        int i;
        this.readOnly = readOnly;
        this.offsets = new int[1024];
        this.chunkTimestamps = new int[1024];
        this.fileName = path;
        this.debugln("REGION LOAD " + this.fileName);
        String[] nameParts = this.fileName.getName().split("\\.");
        this.x = Integer.parseInt(nameParts[1]);
        this.z = Integer.parseInt(nameParts[2]);
        this.sizeDelta = 0;
        if (path.exists()) {
            this.lastModified = path.lastModified();
        } else if (readOnly) {
            throw new IllegalStateException("Can't open non-existent region file in read only mode");
        }
        RandomAccessFile randomAccessFile = this.file = readOnly ? new RandomAccessFile(path, "r") : new RandomAccessFile(path, "rw");
        if (!readOnly) {
            int i2;
            if (this.file.length() < 4096L) {
                for (i2 = 0; i2 < 1024; ++i2) {
                    this.file.writeInt(0);
                }
                for (i2 = 0; i2 < 1024; ++i2) {
                    this.file.writeInt(0);
                }
                this.sizeDelta += 8192;
            }
            if ((this.file.length() & 0xFFFL) != 0L) {
                i2 = 0;
                while ((long)i2 < (this.file.length() & 0xFFFL)) {
                    this.file.write(0);
                    ++i2;
                }
            }
        }
        int nSectors = (this.file.length() & 0xFFFL) == 0L ? (int)this.file.length() / 4096 : (int)((this.file.length() >> 12) + 1L << 12) / 4096;
        this.sectorFree = new ArrayList(nSectors);
        for (i = 0; i < nSectors; ++i) {
            this.sectorFree.add(true);
        }
        this.file.seek(0L);
        if (this.sectorFree.size() > 0) {
            this.sectorFree.set(0, false);
            for (i = 0; i < 1024; ++i) {
                int offset;
                this.offsets[i] = offset = this.file.readInt();
                if (offset == 0 || (offset >> 8) + (offset & 0xFF) > this.sectorFree.size()) continue;
                for (int sectorNum = 0; sectorNum < (offset & 0xFF); ++sectorNum) {
                    this.sectorFree.set((offset >> 8) + sectorNum, false);
                }
            }
        }
        if (this.sectorFree.size() > 1) {
            this.sectorFree.set(1, false);
            for (i = 0; i < 1024; ++i) {
                int lastModValue;
                this.chunkTimestamps[i] = lastModValue = this.file.readInt();
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public synchronized int getSizeDelta() {
        int ret = this.sizeDelta;
        this.sizeDelta = 0;
        return ret;
    }

    public synchronized DataInputStream getChunkDataInputStream(int x, int z) throws IOException {
        if (this.outOfBounds(x, z)) {
            this.debugln("READ", x, z, "out of bounds");
            return null;
        }
        int offset = this.getOffset(x, z);
        if (offset == 0) {
            return null;
        }
        int sectorNumber = offset >> 8;
        int numSectors = offset & 0xFF;
        if (sectorNumber + numSectors > this.sectorFree.size()) {
            this.debugln("READ", x, z, "invalid sector");
            throw new InvalidRegionFileException(String.format("READ %d,%d: invalid sector in region %d,%d", x, z, this.x, this.z));
        }
        this.file.seek(sectorNumber * 4096);
        int length = this.file.readInt();
        if (length > 4096 * numSectors) {
            this.debugln("READ", x, z, "invalid length: " + length + " > 4096 * " + numSectors);
            throw new InvalidRegionFileException(String.format("READ %d,%d: invalid length: %d > 4096 * %d in region %d,%d", x, z, length, numSectors, this.x, this.z));
        }
        byte version = this.file.readByte();
        if (version == 1) {
            byte[] data = new byte[length - 1];
            for (int bytesToRead = data.length; bytesToRead > 0; bytesToRead -= this.file.read(data, data.length - bytesToRead, bytesToRead)) {
            }
            DataInputStream ret = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(data)));
            return ret;
        }
        if (version == 2) {
            byte[] data = new byte[length - 1];
            for (int bytesToRead = data.length; bytesToRead > 0; bytesToRead -= this.file.read(data, data.length - bytesToRead, bytesToRead)) {
            }
            DataInputStream ret = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(data)));
            return ret;
        }
        throw new IllegalArgumentException("unknown version " + version);
    }

    public DataOutputStream getChunkDataOutputStream(int x, int z) {
        if (this.readOnly) {
            throw new IllegalStateException("Read only mode");
        }
        if (this.outOfBounds(x, z)) {
            return null;
        }
        return new DataOutputStream(new DeflaterOutputStream(new ChunkBuffer(x, z)));
    }

    public boolean containsChunk(int x, int z) {
        if (this.outOfBounds(x, z)) {
            return false;
        }
        int offset = this.getOffset(x, z);
        return offset != 0;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getChunkCount() {
        int count = 0;
        for (int offset : this.offsets) {
            if (offset == 0) continue;
            ++count;
        }
        return count;
    }

    public synchronized void delete(int x, int z) throws IOException {
        int offset = this.getOffset(x, z);
        int sectorNumber = offset >> 8;
        int sectorsAllocated = offset & 0xFF;
        for (int i = 0; i < sectorsAllocated; ++i) {
            this.sectorFree.set(sectorNumber + i, true);
        }
        this.setOffset(x, z, 0);
        this.setTimestamp(x, z, (int)(System.currentTimeMillis() / 1000L));
    }

    public String toString() {
        return this.fileName.getPath();
    }

    protected synchronized void write(int x, int z, byte[] data, int length) throws IOException {
        int offset = this.getOffset(x, z);
        int sectorNumber = offset >> 8;
        int sectorsAllocated = offset & 0xFF;
        int sectorsNeeded = (length + 5) / 4096 + 1;
        if (sectorsNeeded >= 256) {
            throw new IllegalArgumentException("Maximum chunk size is 1MB");
        }
        if (sectorNumber != 0 && sectorsAllocated == sectorsNeeded) {
            this.debug("SAVE", x, z, length, "rewrite");
            this.write(sectorNumber, data, length);
        } else {
            int i;
            for (int i2 = 0; i2 < sectorsAllocated; ++i2) {
                this.sectorFree.set(sectorNumber + i2, true);
            }
            int runStart = this.sectorFree.indexOf(true);
            int runLength = 0;
            if (runStart != -1) {
                for (i = runStart; i < this.sectorFree.size(); ++i) {
                    if (runLength != 0) {
                        runLength = this.sectorFree.get(i).booleanValue() ? ++runLength : 0;
                    } else if (this.sectorFree.get(i).booleanValue()) {
                        runStart = i;
                        runLength = 1;
                    }
                    if (runLength >= sectorsNeeded) break;
                }
            }
            if (runLength >= sectorsNeeded) {
                this.debug("SAVE", x, z, length, "reuse");
                sectorNumber = runStart;
                this.setOffset(x, z, sectorNumber << 8 | sectorsNeeded);
                for (i = 0; i < sectorsNeeded; ++i) {
                    this.sectorFree.set(sectorNumber + i, false);
                }
                this.write(sectorNumber, data, length);
            } else {
                this.debug("SAVE", x, z, length, "grow");
                this.file.seek(this.file.length());
                sectorNumber = this.sectorFree.size();
                for (i = 0; i < sectorsNeeded; ++i) {
                    this.file.write(emptySector);
                    this.sectorFree.add(false);
                }
                this.sizeDelta += 4096 * sectorsNeeded;
                this.write(sectorNumber, data, length);
                this.setOffset(x, z, sectorNumber << 8 | sectorsNeeded);
            }
        }
        this.setTimestamp(x, z, (int)(System.currentTimeMillis() / 1000L));
    }

    private void debug(String in) {
    }

    private void debugln(String in) {
        this.debug(in + "\n");
    }

    private void debug(String mode, int x, int z, String in) {
        this.debug("REGION " + mode + " " + this.fileName.getName() + "[" + x + "," + z + "] = " + in);
    }

    private void debug(String mode, int x, int z, int count, String in) {
        this.debug("REGION " + mode + " " + this.fileName.getName() + "[" + x + "," + z + "] " + count + "B = " + in);
    }

    private void debugln(String mode, int x, int z, String in) {
        this.debug(mode, x, z, in + "\n");
    }

    private void write(int sectorNumber, byte[] data, int length) throws IOException {
        this.debugln(" " + sectorNumber);
        this.file.seek(sectorNumber * 4096);
        this.file.writeInt(length + 1);
        this.file.writeByte(2);
        this.file.write(data, 0, length);
    }

    private boolean outOfBounds(int x, int z) {
        return x < 0 || x >= 32 || z < 0 || z >= 32;
    }

    private int getOffset(int x, int z) {
        return this.offsets[x + z * 32];
    }

    private void setOffset(int x, int z, int offset) throws IOException {
        this.offsets[x + z * 32] = offset;
        this.file.seek((x + z * 32) * 4);
        this.file.writeInt(offset);
    }

    private void setTimestamp(int x, int z, int value) throws IOException {
        this.chunkTimestamps[x + z * 32] = value;
        this.file.seek(4096 + (x + z * 32) * 4);
        this.file.writeInt(value);
    }

    public static class InvalidRegionFileException
    extends MDCCapturingRuntimeException {
        InvalidRegionFileException(String message) {
            super(message);
        }
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private int x;
        private int z;

        public ChunkBuffer(int x, int z) {
            super(8096);
            this.x = x;
            this.z = z;
        }

        @Override
        public void close() throws IOException {
            RegionFile.this.write(this.x, this.z, this.buf, this.count);
        }
    }
}

