/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.MCRegionChunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;

public class MemoryChunk
implements Chunk,
MinecraftWorld,
Serializable {
    public final boolean readOnly;
    final Section[] sections;
    final int[] heightMap;
    final int xPos;
    final int zPos;
    byte[] biomes;
    byte[] biomes3d;
    boolean terrainPopulated;
    boolean lightPopulated;
    final List<Entity> entities;
    final List<TileEntity> tileEntities;
    final int minHeight;
    final int maxHeight;
    long inhabitedTime;
    private static final long serialVersionUID = 1L;

    public MemoryChunk(int xPos, int zPos, int minHeight, int maxHeight) {
        this.xPos = xPos;
        this.zPos = zPos;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.sections = new Section[maxHeight >> 4];
        this.heightMap = new int[256];
        this.entities = new ArrayList<Entity>();
        this.tileEntities = new ArrayList<TileEntity>();
        this.readOnly = false;
        this.lightPopulated = true;
    }

    public boolean isSectionPresent(int y) {
        return this.sections[y] != null;
    }

    public Section[] getSections() {
        return this.sections;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getxPos() {
        return this.xPos;
    }

    @Override
    public int getzPos() {
        return this.zPos;
    }

    @Override
    public MinecraftCoords getCoords() {
        return new MinecraftCoords(this.xPos, this.zPos);
    }

    @Override
    public int getBlockType(int x, int y, int z) {
        Section section = this.sections[y >> 4];
        if (section == null) {
            return 0;
        }
        Material mat = section.blocks[this.blockOffset(x, y, z)];
        return mat != null ? mat.blockType : 0;
    }

    @Override
    public void setBlockType(int x, int y, int z, int blockType) {
        if (this.readOnly) {
            return;
        }
        if (this.sections[y >> 4] == null && blockType == 0) {
            return;
        }
        throw new UnsupportedOperationException("Setting block type no longer supported");
    }

    @Override
    public int getDataValue(int x, int y, int z) {
        Section section = this.sections[y >> 4];
        if (section == null) {
            return 0;
        }
        Material mat = section.blocks[this.blockOffset(x, y, z)];
        return mat != null ? mat.data : 0;
    }

    @Override
    public void setDataValue(int x, int y, int z, int dataValue) {
        if (this.readOnly) {
            return;
        }
        if (this.sections[y >> 4] == null && dataValue == 0) {
            return;
        }
        throw new UnsupportedOperationException("Setting block type no longer supported");
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        int level = y >> 4;
        if (this.sections[level] == null) {
            return 0;
        }
        return this.getDataByte(this.sections[level].skyLight, x, y, z);
    }

    @Override
    public void setSkyLightLevel(int x, int y, int z, int skyLightLevel) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (skyLightLevel == 0) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        this.setDataByte(section.skyLight, x, y, z, skyLightLevel);
    }

    @Override
    public int getBlockLightLevel(int x, int y, int z) {
        int level = y >> 4;
        if (this.sections[level] == null) {
            return 0;
        }
        return this.getDataByte(this.sections[level].blockLight, x, y, z);
    }

    @Override
    public void setBlockLightLevel(int x, int y, int z, int blockLightLevel) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (blockLightLevel == 0) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        this.setDataByte(section.blockLight, x, y, z, blockLightLevel);
    }

    @Override
    public int getHeight(int x, int z) {
        return this.heightMap[x + z * 16];
    }

    @Override
    public void setHeight(int x, int z, int height) {
        if (this.readOnly) {
            return;
        }
        this.heightMap[x + z * 16] = height;
    }

    @Override
    public boolean isBiomesSupported() {
        return true;
    }

    @Override
    public boolean isBiomesAvailable() {
        return this.biomes != null;
    }

    @Override
    public boolean is3DBiomesSupported() {
        return true;
    }

    @Override
    public boolean is3DBiomesAvailable() {
        return this.biomes3d != null;
    }

    @Override
    public int getBiome(int x, int z) {
        return this.biomes[x + z * 16] & 0xFF;
    }

    @Override
    public void setBiome(int x, int z, int biome) {
        if (this.readOnly) {
            return;
        }
        if (this.biomes == null) {
            this.biomes = new byte[256];
        }
        this.biomes[x + z * 16] = (byte)biome;
    }

    @Override
    public int get3DBiome(int x, int y, int z) {
        return this.biomes3d[x + z * 4 + y * 16] & 0xFF;
    }

    @Override
    public void set3DBiome(int x, int y, int z, int biome) {
        if (this.readOnly) {
            return;
        }
        if (this.biomes3d == null) {
            this.biomes3d = new byte[1024];
        }
        this.biomes3d[x + z * 4 + y * 16] = (byte)biome;
    }

    @Override
    public boolean isTerrainPopulated() {
        return this.terrainPopulated;
    }

    @Override
    public void setTerrainPopulated(boolean terrainPopulated) {
        if (this.readOnly) {
            return;
        }
        this.terrainPopulated = terrainPopulated;
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        Section section = this.sections[y >> 4];
        if (section == null) {
            return Material.AIR;
        }
        Material mat = section.blocks[this.blockOffset(x, y, z)];
        return mat != null ? mat : Material.AIR;
    }

    @Override
    public void setMaterial(int x, int y, int z, Material material) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (material == Material.AIR) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        section.blocks[this.blockOffset((int)x, (int)y, (int)z)] = material;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isLightPopulated() {
        return this.lightPopulated;
    }

    @Override
    public void setLightPopulated(boolean lightPopulated) {
        this.lightPopulated = lightPopulated;
    }

    @Override
    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    @Override
    public void setInhabitedTime(long inhabitedTime) {
        this.inhabitedTime = inhabitedTime;
    }

    @Override
    public int getHighestNonAirBlock(int x, int z) {
        for (int yy = this.sections.length - 1; yy >= 0; --yy) {
            if (this.sections[yy] == null) continue;
            Material[] blocks = this.sections[yy].blocks;
            int base = this.blockOffset(x, 0, z);
            for (int i = this.blockOffset(x, 15, z); i >= base; i -= 256) {
                if (blocks[i] == null || blocks[i] == Material.AIR) continue;
                return yy << 4 | i - base >> 8;
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getHighestNonAirBlock() {
        for (int yy = this.sections.length - 1; yy >= 0; --yy) {
            if (this.sections[yy] == null) continue;
            Material[] blocks = this.sections[yy].blocks;
            for (int i = blocks.length - 1; i >= 0; --i) {
                if (blocks[i] == null || blocks[i] == Material.AIR) continue;
                return yy << 4 | i >> 8;
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getBlockTypeAt(int x, int y, int height) {
        return this.getBlockType(x, height, y);
    }

    @Override
    public int getDataAt(int x, int y, int height) {
        return this.getDataValue(x, height, y);
    }

    @Override
    public Material getMaterialAt(int x, int y, int height) {
        return this.getMaterial(x, height, y);
    }

    @Override
    public void setBlockTypeAt(int x, int y, int height, int blockType) {
        this.setBlockType(x, height, y, blockType);
    }

    @Override
    public void setDataAt(int x, int y, int height, int data) {
        this.setDataValue(x, height, y, data);
    }

    @Override
    public void setMaterialAt(int x, int y, int height, Material material) {
        this.setMaterial(x, height, y, material);
    }

    @Override
    public boolean isChunkPresent(int x, int y) {
        return x == this.xPos && y == this.zPos;
    }

    @Override
    public void addChunk(Chunk chunk) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void addEntity(double x, double y, double height, Entity entity) {
        entity = entity.clone();
        entity.setPos(new double[]{x, height, y});
        this.getEntities().add(entity);
    }

    @Override
    public void addTileEntity(int x, int y, int height, TileEntity tileEntity) {
        tileEntity = (TileEntity)tileEntity.clone();
        tileEntity.setX(x);
        tileEntity.setZ(y);
        tileEntity.setY(height);
        this.getTileEntities().add(tileEntity);
    }

    @Override
    public Chunk getChunk(int x, int z) {
        if (x == this.xPos && z == this.zPos) {
            return this;
        }
        return null;
    }

    @Override
    public Chunk getChunkForEditing(int x, int z) {
        return this.getChunk(x, z);
    }

    @Override
    public void close() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryChunk other = (MemoryChunk)obj;
        if (this.xPos != other.xPos) {
            return false;
        }
        return this.zPos == other.zPos;
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + this.xPos;
        hash = 37 * hash + this.zPos;
        return hash;
    }

    public MCRegionChunk clone() {
        throw new UnsupportedOperationException("ChunkImlp2.clone() not supported");
    }

    private int getDataByte(byte[] array, int x, int y, int z) {
        int blockOffset = this.blockOffset(x, y, z);
        byte dataByte = array[blockOffset / 2];
        if (blockOffset % 2 == 0) {
            return dataByte & 0xF;
        }
        return (dataByte & 0xF0) >> 4;
    }

    private void setDataByte(byte[] array, int x, int y, int z, int dataValue) {
        int blockOffset = this.blockOffset(x, y, z);
        int offset = blockOffset / 2;
        byte dataByte = array[offset];
        if (blockOffset % 2 == 0) {
            dataByte = (byte)(dataByte & 0xF0);
            dataByte = (byte)(dataByte | dataValue & 0xF);
        } else {
            dataByte = (byte)(dataByte & 0xF);
            dataByte = (byte)(dataByte | (dataValue & 0xF) << 4);
        }
        array[offset] = dataByte;
    }

    private int blockOffset(int x, int y, int z) {
        return x | (z | (y & 0xF) << 4) << 4;
    }

    public static class Section
    implements Serializable {
        final byte level;
        final Material[] blocks;
        final byte[] skyLight;
        final byte[] blockLight;
        private static final long serialVersionUID = 1L;

        Section(byte level) {
            this.level = level;
            this.blocks = new Material[4096];
            this.skyLight = new byte[2048];
            Arrays.fill(this.skyLight, (byte)-1);
            this.blockLight = new byte[2048];
        }

        boolean isEmpty() {
            for (Material b : this.blocks) {
                if (b == null || b == Material.AIR) continue;
                return false;
            }
            for (byte b : this.skyLight) {
                if (b == -1) continue;
                return false;
            }
            for (byte b : this.blockLight) {
                if (b == 0) continue;
                return false;
            }
            return true;
        }
    }
}

