/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.pepsoft.minecraft.Block;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.HorizontalOrientationScheme;
import org.pepsoft.minecraft.MaterialImporter;
import org.pepsoft.minecraft.Property;
import org.pepsoft.minecraft.VerticalOrientationScheme;
import org.pepsoft.util.CSVDataSource;
import org.pepsoft.util.ObjectMapperHolder;
import org.pepsoft.util.Pair;
import org.pepsoft.worldpainter.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Material
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Material.class);
    public final transient int opacity;
    public final transient String name;
    public final transient boolean transparent;
    public final transient boolean translucent;
    public final transient boolean opaque;
    public final transient boolean receivesLight;
    public final transient boolean terrain;
    public final transient boolean insubstantial;
    public final transient boolean veryInsubstantial;
    public final transient boolean solid;
    public final transient boolean resource;
    public final transient boolean tileEntity;
    public final transient String tileEntityId;
    public final transient boolean treeRelated;
    public final transient boolean vegetation;
    public final transient int blockLight;
    public final transient boolean lightSource;
    public final transient boolean natural;
    public final transient boolean watery;
    public final transient HorizontalOrientationScheme[] horizontalOrientationSchemes;
    public final transient VerticalOrientationScheme verticalOrientationScheme;
    public final transient int category;
    public final int blockType;
    public final int data;
    public final transient int index;
    public final transient String simpleName;
    public final transient String namespace;
    public final transient boolean canSupportSnow;
    public final transient int colour;
    public final transient SortedMap<String, PropertyDescriptor> propertyDescriptors;
    public final transient boolean modded;
    public final transient boolean leafBlock;
    public final transient boolean sustainsLeaves;
    public final transient boolean hasPropertySnowy;
    public final Identity identity;
    private final transient String stringRep;
    private final transient String legacyStringRep;
    private transient Map<PropertyAndValue, Material> variants;
    private transient HorizontalOrientationScheme[] legacyHorizontalOrientationSchemesForMirroring;
    private transient boolean legacyHorizontalOrientationSchemesForMirroringSet;
    private transient HorizontalOrientationScheme[] legacyHorizontalOrientationSchemesForRotating;
    private transient boolean legacyHorizontalOrientationSchemesForRotatingSet;
    private transient VerticalOrientationScheme legacyVerticalOrientationScheme;
    private transient boolean legacyVerticalOrientationSchemeSet;
    private static final Map<Integer, Map<String, Object>> LEGACY_BLOCK_SPECS_BY_COMBINED_ID = new HashMap<Integer, Map<String, Object>>();
    private static final Map<String, Set<Map<String, Object>>> LEGACY_BLOCK_SPECS_BY_NAME = new HashMap<String, Set<Map<String, Object>>>();
    private static final Map<String, Set<Map<String, Object>>> MATERIAL_SPECS = new HashMap<String, Set<Map<String, Object>>>();
    private static final Map<String, Material> PROTOTYPES = new ConcurrentHashMap<String, Material>();
    private static final Material[] LEGACY_MATERIALS = new Material[4096];
    private static final Map<Identity, Material> ALL_MATERIALS = new HashMap<Identity, Material>();
    private static final Map<String, Set<String>> SIMPLE_NAMES_BY_NAMESPACE = new HashMap<String, Set<String>>();
    private static final Map<String, Material> DEFAULT_MATERIALS_BY_NAME = new HashMap<String, Material>();
    public static final String MINECRAFT = "minecraft";
    public static final String LEGACY = "legacy";
    private static final Set<String> SNOW_ON;
    private static final Set<String> NO_SNOW_ON;
    public static final Material AIR;
    public static final Material DANDELION;
    public static final Material ROSE;
    public static final Material GRASS_BLOCK;
    public static final Material DIRT;
    public static final Material STONE;
    public static final Material GRANITE;
    public static final Material DIORITE;
    public static final Material ANDESITE;
    public static final Material COBBLESTONE;
    public static final Material SNOW;
    public static final Material SNOW_EIGHT_LAYERS;
    public static final Material DEAD_SHRUBS;
    public static final Material CACTUS;
    public static final Material SAND;
    public static final Material FIRE;
    public static final Material GLOWSTONE;
    public static final Material SOUL_SAND;
    public static final Material LAVA;
    public static final Material NETHERRACK;
    public static final Material END_STONE;
    public static final Material CHORUS_PLANT;
    public static final Material COAL;
    public static final Material GRAVEL;
    public static final Material REDSTONE_ORE;
    public static final Material IRON_ORE;
    public static final Material WATER;
    public static final Material GOLD_ORE;
    public static final Material LAPIS_LAZULI_ORE;
    public static final Material DIAMOND_ORE;
    public static final Material BEDROCK;
    public static final Material STATIONARY_WATER;
    public static final Material STATIONARY_LAVA;
    public static final Material SNOW_BLOCK;
    public static final Material SANDSTONE;
    public static final Material CLAY;
    public static final Material MOSSY_COBBLESTONE;
    public static final Material OBSIDIAN;
    public static final Material FENCE;
    public static final Material GLASS_PANE;
    public static final Material STONE_BRICKS;
    public static final Material BRICKS;
    public static final Material COBWEB;
    public static final Material DIAMOND_BLOCK;
    public static final Material GOLD_BLOCK;
    public static final Material IRON_BLOCK;
    public static final Material LAPIS_LAZULI_BLOCK;
    public static final Material MYCELIUM;
    public static final Material FARMLAND;
    public static final Material ICE;
    public static final Material FROSTED_ICE;
    public static final Material PACKED_ICE;
    public static final Material TORCH;
    public static final Material COBBLESTONE_STAIRS;
    public static final Material GLASS;
    public static final Material WOODEN_STAIRS;
    public static final Material CHEST_NORTH;
    public static final Material CHEST_SOUTH;
    public static final Material CHEST_WEST;
    public static final Material CHEST_EAST;
    public static final Material WALL_SIGN;
    public static final Material BRICK_STAIRS;
    public static final Material STONE_BRICK_STAIRS;
    public static final Material LADDER;
    public static final Material TRAPDOOR;
    public static final Material WHEAT;
    public static final Material LILY_PAD;
    public static final Material RED_MUSHROOM;
    public static final Material BROWN_MUSHROOM;
    public static final Material SUGAR_CANE;
    public static final Material EMERALD_ORE;
    public static final Material EMERALD_BLOCK;
    public static final Material PERMADIRT;
    public static final Material PODZOL;
    public static final Material RED_SAND;
    public static final Material HARDENED_CLAY;
    public static final Material WHITE_CLAY;
    public static final Material ORANGE_CLAY;
    public static final Material MAGENTA_CLAY;
    public static final Material LIGHT_BLUE_CLAY;
    public static final Material YELLOW_CLAY;
    public static final Material LIME_CLAY;
    public static final Material PINK_CLAY;
    public static final Material GREY_CLAY;
    public static final Material LIGHT_GREY_CLAY;
    public static final Material CYAN_CLAY;
    public static final Material PURPLE_CLAY;
    public static final Material BLUE_CLAY;
    public static final Material BROWN_CLAY;
    public static final Material GREEN_CLAY;
    public static final Material RED_CLAY;
    public static final Material BLACK_CLAY;
    public static final Material RED_SANDSTONE;
    public static final Material QUARTZ_ORE;
    public static final Material GRASS;
    public static final Material FERN;
    public static final Material WOOD_OAK;
    public static final Material WOOD_BIRCH;
    public static final Material WOOD_PINE;
    public static final Material WOOD_JUNGLE;
    public static final Material WOOD_ACACIA;
    public static final Material WOOD_DARK_OAK;
    public static final Material LEAVES_OAK;
    public static final Material LEAVES_BIRCH;
    public static final Material LEAVES_PINE;
    public static final Material LEAVES_JUNGLE;
    public static final Material LEAVES_ACACIA;
    public static final Material LEAVES_DARK_OAK;
    public static final Material WOODEN_PLANK_OAK;
    public static final Material WOODEN_PLANK_BIRCH;
    public static final Material WOODEN_PLANK_PINE;
    public static final Material WOODEN_PLANK_JUNGLE;
    public static final Material WOODEN_PLANK_ACACIA;
    public static final Material WOODEN_PLANK_DARK_WOOD;
    public static final Material WOOL_WHITE;
    public static final Material WOOL_ORANGE;
    public static final Material WOOL_MAGENTA;
    public static final Material WOOL_LIGHT_BLUE;
    public static final Material WOOL_YELLOW;
    public static final Material WOOL_LIME;
    public static final Material WOOL_PINK;
    public static final Material WOOL_GREY;
    public static final Material WOOL_LIGHT_GREY;
    public static final Material WOOL_CYAN;
    public static final Material WOOL_PURPLE;
    public static final Material WOOL_BLUE;
    public static final Material WOOL_BROWN;
    public static final Material WOOL_GREEN;
    public static final Material WOOL_RED;
    public static final Material WOOL_BLACK;
    public static final Material[] WOOLS;
    public static final Material COBBLESTONE_SLAB;
    public static final Material DOOR_OPEN_LEFT_BOTTOM;
    public static final Material DOOR_OPEN_LEFT_TOP;
    public static final Material DOOR_OPEN_RIGHT_BOTTOM;
    public static final Material DOOR_OPEN_RIGHT_TOP;
    public static final Material DOOR_CLOSED_LEFT_BOTTOM;
    public static final Material DOOR_CLOSED_LEFT_TOP;
    public static final Material DOOR_CLOSED_RIGHT_BOTTOM;
    public static final Material DOOR_CLOSED_RIGHT_TOP;
    public static final Material BED_FOOT;
    public static final Material BED_HEAD;
    public static final Material COCOA_PLANT;
    public static final Material COCOA_PLANT_HALF_RIPE;
    public static final Material COCOA_PLANT_RIPE;
    @Deprecated
    public static final Material PUMPKIN_NO_FACE;
    public static final Material CARVED_PUMPKIN_NORTH_FACE;
    public static final Material CARVED_PUMPKIN_EAST_FACE;
    public static final Material CARVED_PUMPKIN_SOUTH_FACE;
    public static final Material CARVED_PUMPKIN_WEST_FACE;
    public static final Material MELON;
    public static final Material JACK_O_LANTERN_NORTH_FACE;
    public static final Material JACK_O_LANTERN_EAST_FACE;
    public static final Material JACK_O_LANTERN_SOUTH_FACE;
    public static final Material JACK_O_LANTERN_WEST_FACE;
    public static final Material FLOWING_LAVA;
    public static final Material FLOWING_WATER;
    public static final Material FALLING_LAVA;
    public static final Material FALLING_WATER;
    public static final Property<Boolean> SNOWY;
    public static final Property<Boolean> NORTH;
    public static final Property<Boolean> EAST;
    public static final Property<Boolean> SOUTH;
    public static final Property<Boolean> WEST;
    public static final Property<Boolean> UP;
    public static final Property<Boolean> DOWN;
    public static final Property<Integer> LAYERS;
    public static final Property<String> HALF;
    public static final Property<Integer> LEVEL;
    public static final Property<Boolean> WATERLOGGED;
    public static final Property<Integer> AGE;
    public static final Property<Boolean> PERSISTENT;
    public static final Property<Direction> FACING;
    public static final Property<String> AXIS;
    public static final Property<String> TYPE;
    public static final Property<Integer> PICKLES;
    public static final Property<Integer> MOISTURE;
    public static final Property<Integer> ROTATION;
    public static final Property<String> SHAPE;
    public static final Property<String> HINGE;
    public static final Property<Boolean> BERRIES;
    public static final Property<Integer> DISTANCE;
    public static final Property<String> VERTICAL_DIRECTION;
    public static final Material VINE;
    public static final Material TERRACOTTA;
    public static final Material BLUE_ORCHID;
    public static final Material ALLIUM;
    public static final Material AZURE_BLUET;
    public static final Material RED_TULIP;
    public static final Material ORANGE_TULIP;
    public static final Material WHITE_TULIP;
    public static final Material PINK_TULIP;
    public static final Material OXEYE_DAISY;
    public static final Material SUNFLOWER_LOWER;
    public static final Material LILAC_LOWER;
    public static final Material TALL_GRASS_LOWER;
    public static final Material LARGE_FERN_LOWER;
    public static final Material ROSE_BUSH_LOWER;
    public static final Material PEONY_LOWER;
    public static final Material OAK_SAPLING;
    public static final Material DARK_OAK_SAPLING;
    public static final Material PINE_SAPLING;
    public static final Material BIRCH_SAPLING;
    public static final Material JUNGLE_SAPLING;
    public static final Material ACACIA_SAPLING;
    public static final Material CARROTS;
    public static final Material POTATOES;
    public static final Material PUMPKIN_STEM;
    public static final Material MELON_STEM;
    public static final Material BEETROOTS;
    public static final Material NETHER_WART;
    public static final Material CHORUS_FLOWER;
    public static final Material OAK_FENCE;
    public static final Material NETHER_BRICK_FENCE;
    public static final Material SPRUCE_FENCE;
    public static final Material BIRCH_FENCE;
    public static final Material JUNGLE_FENCE;
    public static final Material DARK_OAK_FENCE;
    public static final Material ACACIA_FENCE;
    public static final Material COBBLESTONE_WALL;
    public static final Material IRON_BARS;
    public static final Material TUBE_CORAL;
    public static final Material BRAIN_CORAL;
    public static final Material BUBBLE_CORAL;
    public static final Material FIRE_CORAL;
    public static final Material HORN_CORAL;
    public static final Material DEAD_TUBE_CORAL;
    public static final Material DEAD_BRAIN_CORAL;
    public static final Material DEAD_BUBBLE_CORAL;
    public static final Material DEAD_FIRE_CORAL;
    public static final Material DEAD_HORN_CORAL;
    public static final Material TUBE_CORAL_BLOCK;
    public static final Material BRAIN_CORAL_BLOCK;
    public static final Material BUBBLE_CORAL_BLOCK;
    public static final Material FIRE_CORAL_BLOCK;
    public static final Material HORN_CORAL_BLOCK;
    public static final Material DEAD_TUBE_CORAL_BLOCK;
    public static final Material DEAD_BRAIN_CORAL_BLOCK;
    public static final Material DEAD_BUBBLE_CORAL_BLOCK;
    public static final Material DEAD_FIRE_CORAL_BLOCK;
    public static final Material DEAD_HORN_CORAL_BLOCK;
    public static final Material TUBE_CORAL_FAN;
    public static final Material BRAIN_CORAL_FAN;
    public static final Material BUBBLE_CORAL_FAN;
    public static final Material FIRE_CORAL_FAN;
    public static final Material HORN_CORAL_FAN;
    public static final Material DEAD_TUBE_CORAL_FAN;
    public static final Material DEAD_BRAIN_CORAL_FAN;
    public static final Material DEAD_BUBBLE_CORAL_FAN;
    public static final Material DEAD_FIRE_CORAL_FAN;
    public static final Material DEAD_HORN_CORAL_FAN;
    public static final Material TUBE_CORAL_WALL_FAN;
    public static final Material BRAIN_CORAL_WALL_FAN;
    public static final Material BUBBLE_CORAL_WALL_FAN;
    public static final Material FIRE_CORAL_WALL_FAN;
    public static final Material HORN_CORAL_WALL_FAN;
    public static final Material DEAD_TUBE_CORAL_WALL_FAN;
    public static final Material DEAD_BRAIN_CORAL_WALL_FAN;
    public static final Material DEAD_BUBBLE_CORAL_WALL_FAN;
    public static final Material DEAD_FIRE_CORAL_WALL_FAN;
    public static final Material DEAD_HORN_CORAL_WALL_FAN;
    public static final Material KELP;
    public static final Material KELP_PLANT;
    public static final Material SEAGRASS;
    public static final Material TALL_SEAGRASS_LOWER;
    public static final Material SEA_PICKLE_1;
    public static final Material CORNFLOWER;
    public static final Material LILY_OF_THE_VALLEY;
    public static final Material WITHER_ROSE;
    public static final Material SWEET_BERRY_BUSH;
    public static final Material OAK_SIGN;
    public static final Material DEEPSLATE_X;
    public static final Material DEEPSLATE_Y;
    public static final Material DEEPSLATE_Z;
    public static final Material DEEPSLATE_COAL_ORE;
    public static final Material DEEPSLATE_COPPER_ORE;
    public static final Material DEEPSLATE_LAPIS_ORE;
    public static final Material DEEPSLATE_IRON_ORE;
    public static final Material DEEPSLATE_GOLD_ORE;
    public static final Material DEEPSLATE_REDSTONE_ORE;
    public static final Material DEEPSLATE_DIAMOND_ORE;
    public static final Material DEEPSLATE_EMERALD_ORE;
    public static final Material TUFF;
    public static final Material COPPER_ORE;
    public static final Material NETHER_GOLD_ORE;
    public static final Material ANCIENT_DEBRIS;
    public static final Material BASALT;
    public static final Material BLACKSTONE;
    public static final Material SOUL_SOIL;
    public static final Material GRASS_PATH;
    public static final Material DIRT_PATH;
    public static final Material WARPED_NYLIUM;
    public static final Material CRIMSON_NYLIUM;
    public static final Material ROOTED_DIRT;
    public static final Material INFESTED_DEEPSLATE;
    public static final Material BAMBOO_NO_LEAVES;
    public static final Material BAMBOO_SMALL_LEAVES;
    public static final Material BAMBOO_LARGE_LEAVES;
    public static final Material AZALEA;
    public static final Material FLOWERING_AZALEA;
    public static final Material CRIMSON_FUNGUS;
    public static final Material WARPED_FUNGUS;
    public static final Material CRIMSON_ROOTS;
    public static final Material WARPED_ROOTS;
    public static final Material NETHER_SPROUTS;
    public static final Material TWISTING_VINES_PLANT;
    public static final Material TWISTING_VINES_25;
    public static final Material GLOW_LICHEN_NONE;
    public static final Material GLOW_LICHEN_DOWN;
    public static final Material GLOW_LICHEN_UP;
    public static final Material MOSS_CARPET;
    public static final Material BIG_DRIPLEAF_STEM_SOUTH;
    public static final Material BIG_DRIPLEAF_SOUTH;
    public static final Material PUMPKIN;
    public static final Material CALCITE;
    public static final Material SPORE_BLOSSOM;
    public static final Material WEEPING_VINES;
    public static final Material WEEPING_VINES_PLANT;
    public static final Material HANGING_ROOTS;
    public static final Material CAVE_VINES_NO_BERRIES;
    public static final Material CAVE_VINES_PLANT_NO_BERRIES;
    public static final Material SMALL_DRIPLEAF_SOUTH_LOWER;
    public static final Material BARRIER;
    public static final Material POINTED_DRIPSTONE_UP_TIP;
    public static final Material POINTED_DRIPSTONE_UP_FRUSTUM;
    public static final Material POINTED_DRIPSTONE_UP_MIDDLE;
    public static final Material POINTED_DRIPSTONE_UP_BASE;
    public static final Material POINTED_DRIPSTONE_DOWN_TIP;
    public static final Material POINTED_DRIPSTONE_DOWN_FRUSTUM;
    public static final Material POINTED_DRIPSTONE_DOWN_MIDDLE;
    public static final Material POINTED_DRIPSTONE_DOWN_BASE;
    public static final Material MOSS_BLOCK;
    public static final Material DRIPSTONE_BLOCK;
    public static final Material MUD;
    public static final Material INFESTED_STONE;
    public static final Material MANGROVE_PROPAGULE;
    public static final int CATEGORY_AIR = 0;
    public static final int CATEGORY_FLUID = 1;
    public static final int CATEGORY_INSUBSTANTIAL = 2;
    public static final int CATEGORY_MAN_MADE = 3;
    public static final int CATEGORY_RESOURCE = 4;
    public static final int CATEGORY_NATURAL_SOLID = 5;
    public static final int CATEGORY_UNKNOWN = 6;
    public static final Set<Material> STONE_ORES;
    public static final Set<Material> DEEPSLATE_ORES;
    public static final Map<String, Set<String>> TILE_ENTITY_MAP;
    private static final long serialVersionUID = 2011101001L;

    private Material(int blockType, int data) {
        this.blockType = blockType;
        this.data = data;
        this.index = blockType << 4 | data;
        Map<String, Object> blockSpec = LEGACY_BLOCK_SPECS_BY_COMBINED_ID.get(this.index);
        if (blockSpec != null) {
            HashMap<String, String> properties;
            String name = ((String)blockSpec.get("name")).intern();
            int p = name.indexOf(58);
            if (p != -1) {
                this.namespace = name.substring(0, p).intern();
                this.simpleName = name.substring(p + 1).intern();
            } else {
                this.namespace = null;
                this.simpleName = name;
            }
            if (blockSpec.containsKey("properties")) {
                properties = new HashMap<String, String>();
                for (Map.Entry entry : ((Map)blockSpec.get("properties")).entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    properties.put(key, value);
                }
            } else {
                properties = null;
            }
            this.identity = new Identity(name, properties);
        } else {
            this.namespace = LEGACY;
            this.simpleName = ("block_" + blockType).intern();
            this.identity = new Identity(this.namespace + ":" + this.simpleName, Collections.singletonMap("data_value", Integer.toString(data)));
        }
        this.name = this.identity.name;
        this.stringRep = this.createStringRep();
        this.legacyStringRep = this.createLegacyStringRep();
        this.horizontalOrientationSchemes = this.determineHorizontalOrientations(this.identity);
        this.verticalOrientationScheme = this.determineVerticalOrientation(this.identity);
        this.modded = this.namespace != MINECRAFT;
        this.leafBlock = this.simpleName.endsWith("_leaves");
        this.sustainsLeaves = this.simpleName.endsWith("_log") || this.simpleName.endsWith("_wood") || this.simpleName == "minecraft:crimson_hyphae" || this.simpleName == "minecraft:crimson_stem" || this.simpleName == "minecraft:warped_hyphae" || this.simpleName == "minecraft:warped_stem";
        Map<String, Object> spec = this.findSpec(this.identity);
        if (spec != null) {
            this.opacity = (Integer)spec.get("opacity");
            this.receivesLight = (Boolean)spec.get("receivesLight");
            this.terrain = (Boolean)spec.get("terrain");
            this.insubstantial = (Boolean)spec.get("insubstantial");
            this.veryInsubstantial = (Boolean)spec.get("veryInsubstantial");
            this.resource = (Boolean)spec.get("resource");
            this.tileEntity = (Boolean)spec.get("tileEntity");
            this.tileEntityId = this.tileEntity ? (String)spec.get("tileEntityId") : null;
            this.treeRelated = (Boolean)spec.get("treeRelated");
            this.vegetation = (Boolean)spec.get("vegetation");
            this.blockLight = (Integer)spec.get("blockLight");
            this.natural = (Boolean)spec.get("natural");
            this.watery = (Boolean)spec.get("watery");
            this.colour = spec.containsKey("colour") ? (Integer)spec.get("colour") : 0xFF00FF;
            this.category = this.determineCategory();
            this.propertyDescriptors = (SortedMap)spec.get("properties");
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("Legacy material " + blockType + ":" + data + " not found in materials database");
            }
            this.opacity = Material.guessOpacity(this.name);
            this.receivesLight = Material.guessReceivesLight(this.name);
            this.terrain = false;
            this.insubstantial = false;
            this.veryInsubstantial = false;
            this.resource = Material.guessResource(this.name);
            this.tileEntity = false;
            this.tileEntityId = null;
            this.treeRelated = this.leafBlock || this.sustainsLeaves || Material.guessTreeRelated(this.name);
            this.vegetation = false;
            this.blockLight = 0;
            this.natural = false;
            this.watery = false;
            this.colour = 0xFF00FF;
            this.category = 6;
            this.propertyDescriptors = null;
        }
        this.lightSource = this.blockLight > 0;
        this.transparent = this.opacity == 0;
        this.translucent = this.opacity < 15;
        this.opaque = this.opacity == 15;
        this.solid = !this.veryInsubstantial;
        this.hasPropertySnowy = this.hasProperty("snowy");
        this.canSupportSnow = this.determineCanSupportSnow();
        if (this.namespace != null) {
            SIMPLE_NAMES_BY_NAMESPACE.computeIfAbsent(this.namespace, s -> new HashSet()).add(this.simpleName);
        }
        if (!DEFAULT_MATERIALS_BY_NAME.containsKey(this.identity.name)) {
            DEFAULT_MATERIALS_BY_NAME.put(this.identity.name, this);
        }
    }

    private Material(Identity identity) {
        int legacyIndex = -1;
        if (LEGACY_BLOCK_SPECS_BY_NAME.containsKey(identity.name)) {
            block0: for (Map<String, Object> blockSpec : LEGACY_BLOCK_SPECS_BY_NAME.get(identity.name)) {
                if (blockSpec.containsKey("properties")) {
                    if (identity.properties == null) continue;
                    for (Map.Entry entry : ((Map)blockSpec.get("properties")).entrySet()) {
                        if (((String)entry.getValue()).equals(identity.properties.get(entry.getKey()))) continue;
                        continue block0;
                    }
                    legacyIndex = ((Number)blockSpec.get("blockId")).intValue() << 4 | ((Number)blockSpec.get("dataValue")).intValue();
                    break;
                }
                legacyIndex = ((Number)blockSpec.get("blockId")).intValue() << 4 | ((Number)blockSpec.get("dataValue")).intValue();
                break;
            }
        }
        this.index = legacyIndex;
        if (this.index != -1) {
            this.blockType = this.index >> 4;
            this.data = this.index & 0xF;
            if (logger.isDebugEnabled()) {
                logger.debug("Matched " + identity + " to " + Block.BLOCK_TYPE_NAMES[this.blockType] + "(" + this.blockType + "):" + this.data);
            }
        } else if (identity.name.startsWith("legacy:block_") && identity.properties != null && Material.isValidDataValue(identity.properties.get("data_value"))) {
            this.blockType = Integer.parseInt(identity.name.substring(13));
            this.data = Integer.parseInt(identity.properties.get("data_value"));
            if (logger.isDebugEnabled()) {
                logger.debug("Matched " + identity + " to legacy non-vanilla block with ID " + this.blockType + " and data value " + this.data);
            }
        } else {
            this.blockType = -1;
            this.data = -1;
            if (logger.isTraceEnabled()) {
                logger.trace("Did not match " + identity + " to legacy block");
            }
        }
        this.identity = identity;
        this.name = identity.name;
        int p = this.name.indexOf(58);
        if (p != -1) {
            this.namespace = this.name.substring(0, p).intern();
            this.simpleName = this.name.substring(p + 1).intern();
        } else {
            this.namespace = null;
            this.simpleName = this.name;
        }
        this.stringRep = this.createStringRep();
        this.legacyStringRep = this.createLegacyStringRep();
        this.horizontalOrientationSchemes = this.determineHorizontalOrientations(identity);
        this.verticalOrientationScheme = this.determineVerticalOrientation(identity);
        this.modded = this.namespace != MINECRAFT;
        this.leafBlock = this.simpleName.endsWith("_leaves");
        this.sustainsLeaves = this.simpleName.endsWith("_log") || this.simpleName.endsWith("_wood") || this.simpleName == "minecraft:crimson_hyphae" || this.simpleName == "minecraft:crimson_stem" || this.simpleName == "minecraft:warped_hyphae" || this.simpleName == "minecraft:warped_stem";
        Map<String, Object> spec = this.findSpec(identity);
        if (spec != null) {
            this.opacity = (Integer)spec.get("opacity");
            this.receivesLight = (Boolean)spec.get("receivesLight");
            this.terrain = (Boolean)spec.get("terrain");
            this.insubstantial = (Boolean)spec.get("insubstantial");
            this.veryInsubstantial = (Boolean)spec.get("veryInsubstantial");
            this.resource = (Boolean)spec.get("resource");
            this.tileEntity = (Boolean)spec.get("tileEntity");
            this.tileEntityId = this.tileEntity ? (String)spec.get("tileEntityId") : null;
            this.treeRelated = (Boolean)spec.get("treeRelated");
            this.vegetation = (Boolean)spec.get("vegetation");
            this.blockLight = (Integer)spec.get("blockLight");
            this.natural = (Boolean)spec.get("natural");
            this.watery = (Boolean)spec.get("watery");
            this.colour = spec.containsKey("colour") ? (Integer)spec.get("colour") : 0xFF00FF;
            this.category = this.determineCategory();
            this.propertyDescriptors = (SortedMap)spec.get("properties");
        } else {
            if (logger.isDebugEnabled()) {
                if (this.namespace != null && this.namespace.equals(MINECRAFT)) {
                    logger.warn("Modern material {} not found in materials database", (Object)identity);
                } else {
                    logger.debug("Modern material {} not found in materials database", (Object)identity);
                }
            }
            this.opacity = Material.guessOpacity(this.name);
            this.receivesLight = Material.guessReceivesLight(this.name);
            this.terrain = false;
            this.insubstantial = false;
            this.veryInsubstantial = false;
            this.resource = Material.guessResource(this.name);
            this.tileEntity = false;
            this.tileEntityId = null;
            this.treeRelated = this.leafBlock || this.sustainsLeaves || Material.guessTreeRelated(this.name);
            this.vegetation = false;
            this.blockLight = 0;
            this.natural = false;
            this.watery = false;
            this.colour = 0xFF00FF;
            this.category = 6;
            this.propertyDescriptors = null;
        }
        this.lightSource = this.blockLight > 0;
        this.transparent = this.opacity == 0;
        this.translucent = this.opacity < 15;
        this.opaque = this.opacity == 15;
        this.solid = !this.veryInsubstantial;
        this.hasPropertySnowy = this.hasProperty("snowy");
        this.canSupportSnow = this.determineCanSupportSnow();
        SIMPLE_NAMES_BY_NAMESPACE.computeIfAbsent(this.namespace, s -> new HashSet()).add(this.simpleName);
        if (!DEFAULT_MATERIALS_BY_NAME.containsKey(this.name)) {
            DEFAULT_MATERIALS_BY_NAME.put(this.name, this);
        }
    }

    private Map<String, Object> findSpec(Identity identity) {
        Set<Map<String, Object>> specs = MATERIAL_SPECS.get(identity.name);
        if (specs != null) {
            if (specs.size() == 1) {
                return specs.iterator().next();
            }
            block0: for (Map<String, Object> spec : specs) {
                Set discriminator = (Set)spec.get("discriminator");
                if (discriminator == null) {
                    throw new RuntimeException("Multiple specs found for " + identity.name + "; missing discriminator for at least one (possible cause: overlapping custom material definition files)");
                }
                for (String property : discriminator) {
                    String value;
                    String key;
                    int p = property.indexOf(61);
                    if (!(p != -1 ? !identity.containsPropertyWithValue(key = property.substring(0, p), value = property.substring(p + 1)) : !identity.properties.containsKey(property))) continue;
                    continue block0;
                }
                return spec;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("There were multiple specs for identity " + identity + " but its properties did not match any of them");
            }
            return null;
        }
        return null;
    }

    public Map<String, String> getProperties() {
        return this.identity.properties;
    }

    public boolean hasProperty(Property<?> property) {
        return this.propertyDescriptors != null && this.propertyDescriptors.containsKey(property.name);
    }

    public <T> T getProperty(Property<T> property) {
        return this.getProperty(property, null);
    }

    public <T> T getProperty(Property<T> property, T defaultValue) {
        return this.identity.properties != null && this.identity.properties.containsKey(property.name) ? property.fromString(this.identity.properties.get(property.name)) : defaultValue;
    }

    public boolean is(Property<Boolean> property) {
        if (this.identity.properties != null) {
            return "true".equals(this.identity.properties.get(property.name));
        }
        return false;
    }

    public <T> Material withProperty(Property<T> property, T value) {
        if (this.variants == null) {
            this.variants = new ConcurrentHashMap<PropertyAndValue, Material>();
        }
        return this.variants.computeIfAbsent(new PropertyAndValue(property.name, value.toString()), key -> {
            HashMap<String, String> newProperties = new HashMap<String, String>();
            if (this.identity.properties != null) {
                newProperties.putAll(this.identity.properties);
            }
            newProperties.put(property.name, value.toString());
            return Material.get(this.identity.name, newProperties);
        });
    }

    public boolean hasProperty(String name) {
        return this.propertyDescriptors != null && this.propertyDescriptors.containsKey(name);
    }

    public boolean isPropertySet(String name) {
        return this.identity.properties != null && this.identity.properties.containsKey(name);
    }

    public String getProperty(String name) {
        return this.identity.properties != null ? this.identity.properties.get(name) : null;
    }

    public Material withProperty(String name, String value) {
        if (this.variants == null) {
            this.variants = new ConcurrentHashMap<PropertyAndValue, Material>();
        }
        return this.variants.computeIfAbsent(new PropertyAndValue(name, value), key -> {
            HashMap<String, String> newProperties = new HashMap<String, String>();
            if (this.identity.properties != null) {
                newProperties.putAll(this.identity.properties);
            }
            newProperties.put(name, value);
            return Material.get(this.identity.name, newProperties);
        });
    }

    public Material withoutProperty(String name) {
        HashMap<String, String> newProperties;
        if (this.identity.properties != null) {
            newProperties = new HashMap<String, String>(this.identity.properties);
            newProperties.remove(name);
            if (newProperties.isEmpty()) {
                newProperties = null;
            }
        } else {
            newProperties = null;
        }
        return Material.get(this.identity.name, newProperties);
    }

    public Material withProperties(String name1, String value1, String name2, String value2, String name3, String value3, String name4, String value4) {
        HashMap<String, String> newProperties = new HashMap<String, String>();
        if (this.identity.properties != null) {
            newProperties.putAll(this.identity.properties);
        }
        newProperties.put(name1, value1);
        newProperties.put(name2, value2);
        newProperties.put(name3, value3);
        newProperties.put(name4, value4);
        return Material.get(this.identity.name, newProperties);
    }

    public Direction getDirection() {
        if (this.horizontalOrientationSchemes != null) {
            for (HorizontalOrientationScheme horizontalOrientationScheme : this.horizontalOrientationSchemes) {
                Direction direction = horizontalOrientationScheme.getDirection(this);
                if (direction == null) continue;
                return direction;
            }
        }
        return null;
    }

    public Material setDirection(Direction direction) {
        if (this.horizontalOrientationSchemes != null) {
            Material material = this;
            for (HorizontalOrientationScheme horizontalOrientationScheme : this.horizontalOrientationSchemes) {
                material = horizontalOrientationScheme.setDirection(material, direction);
            }
            return material;
        }
        throw new IllegalArgumentException("Block type " + this.blockType + " has no direction");
    }

    public Material rotate(int steps, Platform platform) {
        if ((this.horizontalOrientationSchemes != null || this.legacyHorizontalOrientationSchemesForRotating != null) && steps % 4 != 0) {
            Material material = this;
            if (platform.capabilities.contains((Object)Platform.Capability.NAME_BASED)) {
                if (this.horizontalOrientationSchemes != null) {
                    for (HorizontalOrientationScheme horizontalOrientationScheme : this.horizontalOrientationSchemes) {
                        material = horizontalOrientationScheme.rotate(material, steps);
                    }
                }
            } else {
                if (!this.legacyHorizontalOrientationSchemesForRotatingSet) {
                    this.legacyHorizontalOrientationSchemesForRotating = this.determineLegacyHorizontalOrientationsForRotating();
                    this.legacyHorizontalOrientationSchemesForRotatingSet = true;
                }
                if (this.legacyHorizontalOrientationSchemesForRotating != null) {
                    for (HorizontalOrientationScheme horizontalOrientationScheme : this.legacyHorizontalOrientationSchemesForRotating) {
                        material = horizontalOrientationScheme.rotate(material, steps);
                    }
                }
            }
            return material;
        }
        return this;
    }

    public Material mirror(Direction axis, Platform platform) {
        if (this.horizontalOrientationSchemes != null || this.legacyHorizontalOrientationSchemesForMirroring != null) {
            Material material = this;
            if (platform.capabilities.contains((Object)Platform.Capability.NAME_BASED)) {
                if (this.horizontalOrientationSchemes != null) {
                    for (HorizontalOrientationScheme horizontalOrientationScheme : this.horizontalOrientationSchemes) {
                        material = horizontalOrientationScheme.mirror(material, axis);
                    }
                }
            } else {
                if (!this.legacyHorizontalOrientationSchemesForMirroringSet) {
                    this.legacyHorizontalOrientationSchemesForMirroring = this.determineLegacyHorizontalOrientationsForMirroring();
                    this.legacyHorizontalOrientationSchemesForMirroringSet = true;
                }
                if (this.legacyHorizontalOrientationSchemesForMirroring != null) {
                    for (HorizontalOrientationScheme horizontalOrientationScheme : this.legacyHorizontalOrientationSchemesForMirroring) {
                        material = horizontalOrientationScheme.mirror(material, axis);
                    }
                }
            }
            return material;
        }
        return this;
    }

    public Material invert(Platform platform) {
        if (this.verticalOrientationScheme != null || this.legacyVerticalOrientationScheme != null) {
            VerticalOrientationScheme scheme;
            if (platform.capabilities.contains((Object)Platform.Capability.NAME_BASED)) {
                scheme = this.verticalOrientationScheme;
            } else {
                if (!this.legacyVerticalOrientationSchemeSet) {
                    this.legacyVerticalOrientationScheme = this.determineLegacyVerticalOrientation();
                    this.legacyVerticalOrientationSchemeSet = true;
                }
                scheme = this.legacyVerticalOrientationScheme;
            }
            if (scheme != null) {
                switch (scheme) {
                    case HALF: {
                        return this.withProperty(HALF, this.getProperty(HALF).equals("top") ? "bottom" : "top");
                    }
                    case TYPE: {
                        return this.withProperty(TYPE, this.getProperty(TYPE).equals("top") ? "bottom" : "top");
                    }
                    case UP: {
                        return this.withProperty(UP, this.getProperty(UP) == false);
                    }
                    case UP_DOWN: {
                        return this.withProperty(UP, this.getProperty(DOWN)).withProperty(DOWN, this.getProperty(UP));
                    }
                    case VERTICAL_DIRECTION: {
                        return this.withProperty(VERTICAL_DIRECTION, this.getProperty(VERTICAL_DIRECTION).equals("up") ? "down" : "up");
                    }
                }
                throw new InternalError();
            }
        }
        return this;
    }

    public boolean isNamed(String name) {
        return name == this.name || name.equals(this.name);
    }

    public boolean isNamedOneOf(String name1, String name2) {
        return name1 == this.name || name2 == this.name || name1.equals(this.name) || name2.equals(this.name);
    }

    public boolean isNamedOneOf(String name1, String name2, String name3) {
        return name1 == this.name || name2 == this.name || name3 == this.name || name1.equals(this.name) || name2.equals(this.name) || name3.equals(this.name);
    }

    public boolean isNamedOneOf(String name1, String name2, String name3, String name4) {
        return name1 == this.name || name2 == this.name || name3 == this.name || name4 == this.name || name1.equals(this.name) || name2.equals(this.name) || name3.equals(this.name) || name4.equals(this.name);
    }

    public boolean isNamedOneOf(String name1, String name2, String name3, String name4, String name5) {
        return name1 == this.name || name2 == this.name || name3 == this.name || name4 == this.name || name5 == this.name || name1.equals(this.name) || name2.equals(this.name) || name3.equals(this.name) || name4.equals(this.name) || name5.equals(this.name);
    }

    public boolean isNamedOneOf(String ... names) {
        for (String name : names) {
            if (name != this.name && !name.equals(this.name)) continue;
            return true;
        }
        return false;
    }

    public boolean isNamedOneOf(Collection<String> names) {
        for (String name : names) {
            if (name != this.name && !name.equals(this.name)) continue;
            return true;
        }
        return false;
    }

    public boolean isNotNamed(String name) {
        return name != this.name && !name.equals(this.name);
    }

    public boolean isNotNamedOneOf(String ... names) {
        for (String name : names) {
            if (name != this.name && !name.equals(this.name)) continue;
            return false;
        }
        return true;
    }

    public boolean isNamedSameAs(Material material) {
        return material.name == this.name;
    }

    public boolean isNotNamedSameAs(Material material) {
        return material.name != this.name;
    }

    public boolean containsWater() {
        return this.watery || this.is(WATERLOGGED) || this.isNamed("minecraft:water") && this.getProperty(LEVEL, 0) == 0;
    }

    private HorizontalOrientationScheme[] determineHorizontalOrientations(Identity identity) {
        if (identity.properties != null) {
            ArrayList<HorizontalOrientationScheme> horizontalOrientationSchemes = new ArrayList<HorizontalOrientationScheme>();
            if (identity.properties.keySet().containsAll((Collection<?>)ImmutableSet.of((Object)"north", (Object)"east", (Object)"south", (Object)"west"))) {
                horizontalOrientationSchemes.add(HorizontalOrientationScheme.CARDINAL_DIRECTIONS);
            }
            if (identity.containsPropertyWithValues("axis", "x", "y", "z")) {
                horizontalOrientationSchemes.add(HorizontalOrientationScheme.AXIS);
            }
            if (identity.containsPropertyWithValues("facing", "north", "east", "south", "west")) {
                horizontalOrientationSchemes.add(HorizontalOrientationScheme.FACING);
            }
            if (identity.containsPropertyWithValues("rotation", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15")) {
                horizontalOrientationSchemes.add(HorizontalOrientationScheme.ROTATION);
            }
            if (identity.containsPropertyWithValues("shape", "east_west", "south_west", "north_south", "north_east", "north_west", "south_east", "ascending_north", "ascending_east", "ascending_south", "ascending_west")) {
                horizontalOrientationSchemes.add(HorizontalOrientationScheme.SHAPE);
            }
            if (identity.containsPropertyWithValues("shape", "inner_left", "inner_right", "outer_left", "outer_right")) {
                horizontalOrientationSchemes.add(HorizontalOrientationScheme.STAIR_CORNER);
            }
            if (identity.containsPropertyWithValues("type", "left", "right")) {
                horizontalOrientationSchemes.add(HorizontalOrientationScheme.TYPE);
            }
            if (identity.containsPropertyWithValues("hinge", "left", "right")) {
                horizontalOrientationSchemes.add(HorizontalOrientationScheme.HINGE);
            }
            if (horizontalOrientationSchemes.isEmpty()) {
                return null;
            }
            return horizontalOrientationSchemes.toArray(new HorizontalOrientationScheme[0]);
        }
        return null;
    }

    private HorizontalOrientationScheme[] determineLegacyHorizontalOrientationsForRotating() {
        if (this.horizontalOrientationSchemes != null) {
            ArrayList<HorizontalOrientationScheme> legacySchemes = new ArrayList<HorizontalOrientationScheme>(this.horizontalOrientationSchemes.length);
            for (HorizontalOrientationScheme horizontalOrientationScheme : this.horizontalOrientationSchemes) {
                if (this.isLegacyMaterial(horizontalOrientationScheme.rotate(this, 1)) && this.isLegacyMaterial(horizontalOrientationScheme.rotate(this, 2)) && this.isLegacyMaterial(horizontalOrientationScheme.rotate(this, 3))) {
                    legacySchemes.add(horizontalOrientationScheme);
                    continue;
                }
                logger.info("Disabling horizontal orientation scheme " + (Object)((Object)horizontalOrientationScheme) + " for rotating legacy material " + this.name);
            }
            return legacySchemes.isEmpty() ? null : legacySchemes.toArray(new HorizontalOrientationScheme[0]);
        }
        return null;
    }

    private HorizontalOrientationScheme[] determineLegacyHorizontalOrientationsForMirroring() {
        if (this.horizontalOrientationSchemes != null) {
            ArrayList<HorizontalOrientationScheme> legacySchemes = new ArrayList<HorizontalOrientationScheme>(this.horizontalOrientationSchemes.length);
            for (HorizontalOrientationScheme horizontalOrientationScheme : this.horizontalOrientationSchemes) {
                if (this.isLegacyMaterial(horizontalOrientationScheme.mirror(this, Direction.NORTH)) && this.isLegacyMaterial(horizontalOrientationScheme.mirror(this, Direction.EAST))) {
                    legacySchemes.add(horizontalOrientationScheme);
                    continue;
                }
                logger.info("Disabling horizontal orientation scheme " + (Object)((Object)horizontalOrientationScheme) + " for mirroring legacy material " + this.name);
            }
            return legacySchemes.isEmpty() ? null : legacySchemes.toArray(new HorizontalOrientationScheme[0]);
        }
        return null;
    }

    private VerticalOrientationScheme determineLegacyVerticalOrientation() {
        if (this.verticalOrientationScheme != null) {
            Material invertedMaterial;
            switch (this.verticalOrientationScheme) {
                case HALF: {
                    invertedMaterial = this.withProperty(HALF, this.getProperty(HALF).equals("top") ? "bottom" : "top");
                    break;
                }
                case TYPE: {
                    invertedMaterial = this.withProperty(TYPE, this.getProperty(TYPE).equals("top") ? "bottom" : "top");
                    break;
                }
                case UP: {
                    invertedMaterial = this.withProperty(UP, this.getProperty(UP) == false);
                    break;
                }
                case UP_DOWN: {
                    invertedMaterial = this.withProperty(UP, this.getProperty(DOWN)).withProperty(DOWN, this.getProperty(UP));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            if (this.isLegacyMaterial(invertedMaterial)) {
                return this.verticalOrientationScheme;
            }
            logger.info("Disabling vertical orientation scheme " + (Object)((Object)this.verticalOrientationScheme) + " for legacy material " + this.name);
            return null;
        }
        return null;
    }

    private boolean isLegacyMaterial(Material material) {
        return material.blockType != -1;
    }

    private VerticalOrientationScheme determineVerticalOrientation(Identity identity) {
        if (identity.containsPropertyWithValues("half", "top", "bottom")) {
            return VerticalOrientationScheme.HALF;
        }
        if (identity.containsPropertyWithValues("up", "true", "false")) {
            if (identity.containsPropertyWithValues("down", "true", "false")) {
                return VerticalOrientationScheme.UP_DOWN;
            }
            return VerticalOrientationScheme.UP;
        }
        if (identity.containsPropertyWithValues("type", "top", "bottom")) {
            return VerticalOrientationScheme.TYPE;
        }
        if (identity.containsPropertyWithValues("vertical_direction", "up", "down")) {
            return VerticalOrientationScheme.VERTICAL_DIRECTION;
        }
        return null;
    }

    private int determineCategory() {
        if (this.name == "minecraft:air" || this.name == "minecraft:cave_air") {
            return 0;
        }
        if (this.name == "minecraft:water" || this.name == "minecraft:lava") {
            return 1;
        }
        if (this.veryInsubstantial) {
            return 2;
        }
        if (!this.natural) {
            return 3;
        }
        if (this.resource) {
            return 4;
        }
        return 5;
    }

    private boolean determineCanSupportSnow() {
        return this.hasPropertySnowy || this.solid && this.opaque && (!"bottom".equals(this.getProperty("type")) || !this.name.endsWith("_slab") && !this.name.endsWith("_stairs")) && !NO_SNOW_ON.contains(this.name) || SNOW_ON.contains(this.name) || this.leafBlock;
    }

    private String createStringRep() {
        StringBuilder sb = new StringBuilder();
        if (!this.namespace.equals(MINECRAFT)) {
            sb.append(this.namespace);
            sb.append(':');
        }
        sb.append(this.simpleName);
        if (this.identity.properties != null) {
            boolean[] first = new boolean[]{true};
            this.identity.properties.forEach((key, value) -> {
                if (!value.equals("false") && !value.equals("0")) {
                    if (first[0]) {
                        sb.append('(');
                        first[0] = false;
                    } else {
                        sb.append(", ");
                    }
                    if (value.equals("true")) {
                        sb.append((String)key);
                    } else {
                        sb.append((String)key);
                        sb.append(": ");
                        sb.append((String)value);
                    }
                }
            });
            if (!first[0]) {
                sb.append(')');
            }
        }
        return sb.toString();
    }

    private String createLegacyStringRep() {
        if (this.blockType < 0) {
            return this.createStringRep();
        }
        if (this.blockType < Block.BLOCK_TYPE_NAMES.length && Block.BLOCK_TYPE_NAMES[this.blockType] != null) {
            if (this.data > 0) {
                return Block.BLOCK_TYPE_NAMES[this.blockType] + " (" + this.data + ")";
            }
            return Block.BLOCK_TYPE_NAMES[this.blockType];
        }
        if (this.data > 0) {
            return this.blockType + " (" + this.data + ")";
        }
        return Integer.toString(this.blockType);
    }

    public static Material get(int blockType) {
        return Material.getByCombinedIndex(blockType << 4);
    }

    public static Material get(int blockType, int data) {
        return Material.getByCombinedIndex(blockType << 4 | data);
    }

    public static Material getByCombinedIndex(int index) {
        if (index >= LEGACY_MATERIALS.length) {
            return Material.get(new Identity("legacy:block_" + (index >> 4), Collections.singletonMap("data_value", Integer.toString(index & 0xF))));
        }
        return LEGACY_MATERIALS[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Material get(Identity identity) {
        Map<Identity, Material> map = ALL_MATERIALS;
        synchronized (map) {
            Material material = ALL_MATERIALS.get(identity);
            if (material == null) {
                material = new Material(identity);
                ALL_MATERIALS.put(identity, material);
            }
            return material;
        }
    }

    public static Material get(String name, Map<String, String> properties) {
        return Material.get(new Identity(name, properties));
    }

    public static Material get(String name, Object ... properties) {
        HashMap<String, String> propertyMap;
        if (properties != null) {
            propertyMap = new HashMap<String, String>();
            for (int i = 0; i < properties.length; i += 2) {
                propertyMap.put((String)properties[i], properties[i + 1].toString());
            }
        } else {
            propertyMap = null;
        }
        return Material.get(name, propertyMap);
    }

    public static Material getPrototype(String name) {
        return PROTOTYPES.computeIfAbsent(name, key -> {
            Map<String, Object> spec;
            Set<Map<String, Object>> specs = MATERIAL_SPECS.get(name);
            if (specs != null && (spec = specs.iterator().next()).containsKey("properties")) {
                return Material.get(name, ((Map)spec.get("properties")).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                    PropertyDescriptor descriptor = (PropertyDescriptor)entry.getValue();
                    switch (descriptor.type) {
                        case BOOLEAN: {
                            return "false";
                        }
                        case INTEGER: {
                            return Integer.toString(descriptor.minValue);
                        }
                        case ENUM: {
                            return descriptor.enumValues[0];
                        }
                    }
                    throw new IllegalArgumentException("Unknown property type: " + (Object)((Object)descriptor.type));
                })));
            }
            return Material.get(new Identity(name, null));
        });
    }

    public static Set<String> getAllNamespaces() {
        return Collections.unmodifiableSet(SIMPLE_NAMES_BY_NAMESPACE.keySet());
    }

    public static Set<String> getAllSimpleNamesForNamespace(String namespace) {
        return SIMPLE_NAMES_BY_NAMESPACE.containsKey(namespace) ? Collections.unmodifiableSet(SIMPLE_NAMES_BY_NAMESPACE.get(namespace)) : Collections.emptySet();
    }

    public static Set<String> getAllNames() {
        return ALL_MATERIALS.values().stream().map(material -> material.name).collect(Collectors.toSet());
    }

    public static Collection<Material> getAllMaterials() {
        return Collections.unmodifiableCollection(ALL_MATERIALS.values());
    }

    public static Set<Map<String, Object>> getSpecs(String name) {
        if (MATERIAL_SPECS.containsKey(name)) {
            return MATERIAL_SPECS.get(name).stream().map(Collections::unmodifiableMap).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static boolean isValidDataValue(String dataValue) {
        try {
            int intValue = Integer.parseInt(dataValue);
            return intValue >= 0 && intValue <= 15;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Material)) {
            return false;
        }
        if (!(this.blockType == -1 && ((Material)o).blockType == -1 || this.blockType == ((Material)o).blockType && this.data == ((Material)o).data)) {
            return false;
        }
        return this.identity.equals(((Material)o).identity);
    }

    public int hashCode() {
        return (this.blockType != -1 ? this.blockType * 17 + this.data : 1) * 4099 + this.identity.hashCode();
    }

    public String toString() {
        return this.stringRep;
    }

    public String toLegacyString() {
        return this.legacyStringRep;
    }

    public String toFullString() {
        return this.identity.toString() + (this.blockType != -1 ? " (id=" + this.blockType + "; data=" + this.data + ")" : "");
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.identity != null) {
            return Material.get(this.identity);
        }
        int index = this.blockType << 4 | this.data;
        if (index >= LEGACY_MATERIALS.length) {
            return Material.get(new Identity("legacy:block_" + this.blockType, Collections.singletonMap("data_value", Integer.toString(this.data))));
        }
        return LEGACY_MATERIALS[index];
    }

    public static int guessOpacity(String name) {
        if (name.endsWith("_slab") || name.endsWith("_stairs") || name.contains("block") || name.endsWith("_log") || name.endsWith("_wood") || name.endsWith("_stem") || name.endsWith("_hyphea") || name.contains("bricks")) {
            return 15;
        }
        if (name.contains("leaves")) {
            return 1;
        }
        return 0;
    }

    public static boolean guessReceivesLight(String name) {
        return name.endsWith("_slab") || name.endsWith("_stairs");
    }

    public static boolean guessResource(String name) {
        return name.contains("ore");
    }

    public static boolean guessTreeRelated(String name) {
        return name.endsWith("_log") || name.endsWith("_wood") || name.endsWith("_stem") || name.endsWith("_hyphea") || name.endsWith("_leaves") || name.endsWith("_sapling");
    }

    static {
        try {
            InputStreamReader in = new InputStreamReader(Objects.requireNonNull(Material.class.getResourceAsStream("legacy-mc-blocks.json")), StandardCharsets.UTF_8);
            Object object = null;
            try {
                List list = (List)ObjectMapperHolder.OBJECT_MAPPER.readValue((Reader)in, List.class);
                for (Object item : list) {
                    if (item instanceof String && ((String)item).trim().startsWith("#")) continue;
                    if (item instanceof Map) {
                        Map blockSpec = (Map)item;
                        String name = (String)blockSpec.get("name");
                        int blockId = ((Number)blockSpec.get("blockId")).intValue();
                        int dataValue = ((Number)blockSpec.get("dataValue")).intValue();
                        LEGACY_BLOCK_SPECS_BY_COMBINED_ID.put(blockId << 4 | dataValue, blockSpec);
                        LEGACY_BLOCK_SPECS_BY_NAME.computeIfAbsent(name, s -> new HashSet()).add(blockSpec);
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected item encountered: " + item);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            ((Reader)in).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((Reader)in).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while reading Minecraft block database legacy-mc-blocks.json from classpath", e);
        }
        Set minecraftNames = SIMPLE_NAMES_BY_NAMESPACE.computeIfAbsent(MINECRAFT, s -> new HashSet());
        try {
            Throwable throwable = null;
            try (InputStreamReader in = new InputStreamReader(Objects.requireNonNull(Material.class.getResourceAsStream("mc-materials.csv")), StandardCharsets.UTF_8);){
                CSVDataSource csvDataSource = new CSVDataSource();
                csvDataSource.openForReading((Reader)in);
                do {
                    HashMap<String, Object> materialSpecs = new HashMap<String, Object>();
                    String name = csvDataSource.getString("name");
                    materialSpecs.put("name", name);
                    String str = csvDataSource.getString("discriminator");
                    if (!Strings.isNullOrEmpty((String)str)) {
                        materialSpecs.put("discriminator", ImmutableSet.copyOf((Object[])str.split(",")));
                    }
                    if (!Strings.isNullOrEmpty((String)(str = csvDataSource.getString("properties")))) {
                        materialSpecs.put("properties", Arrays.stream(str.split(",")).map(PropertyDescriptor::fromString).collect(ImmutableSortedMap.toImmutableSortedMap(String::compareTo, d -> d.name, Function.identity())));
                    }
                    materialSpecs.put("opacity", csvDataSource.getInt("opacity"));
                    materialSpecs.put("receivesLight", csvDataSource.getBoolean("receivesLight"));
                    materialSpecs.put("terrain", csvDataSource.getBoolean("terrain"));
                    materialSpecs.put("insubstantial", csvDataSource.getBoolean("insubstantial"));
                    materialSpecs.put("veryInsubstantial", csvDataSource.getBoolean("veryInsubstantial"));
                    materialSpecs.put("resource", csvDataSource.getBoolean("resource"));
                    materialSpecs.put("tileEntity", csvDataSource.getBoolean("tileEntity"));
                    str = csvDataSource.getString("tileEntityId");
                    if (!Strings.isNullOrEmpty((String)str)) {
                        materialSpecs.put("tileEntityId", str);
                    }
                    materialSpecs.put("treeRelated", csvDataSource.getBoolean("treeRelated"));
                    materialSpecs.put("vegetation", csvDataSource.getBoolean("vegetation"));
                    materialSpecs.put("blockLight", csvDataSource.getInt("blockLight"));
                    materialSpecs.put("natural", csvDataSource.getBoolean("natural"));
                    materialSpecs.put("watery", csvDataSource.getBoolean("watery"));
                    str = csvDataSource.getString("colour");
                    if (!Strings.isNullOrEmpty((String)str)) {
                        materialSpecs.put("colour", Integer.parseUnsignedInt(str, 16));
                    }
                    if (!Strings.isNullOrEmpty((String)(str = csvDataSource.getString("colourOrigin")))) {
                        materialSpecs.put("colourOrigin", str);
                    }
                    MATERIAL_SPECS.computeIfAbsent(name, s -> new HashSet()).add(materialSpecs);
                    minecraftNames.add(name.substring(name.indexOf(58) + 1));
                    csvDataSource.next();
                } while (!csvDataSource.isEndOfFile());
            }
            catch (Throwable csvDataSource) {
                Throwable throwable2 = csvDataSource;
                throw csvDataSource;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while reading Minecraft materials database materials.csv from classpath", e);
        }
        MaterialImporter.importCustomMaterials(MATERIAL_SPECS, SIMPLE_NAMES_BY_NAMESPACE);
        SNOW_ON = ImmutableSet.of((Object)"minecraft:snow_block", (Object)"minecraft:powder_snow");
        NO_SNOW_ON = ImmutableSet.of((Object)"minecraft:end_portal_frame", (Object)"minecraft:packed_ice", (Object)"minecraft:grass_path", (Object)"minecraft:dirt_path", (Object)"minecraft:farmland", (Object)"minecraft:magma_block", (Object[])new String[0]);
        for (int i = 0; i < 4096; ++i) {
            Material.LEGACY_MATERIALS[i] = new Material(i >> 4, i & 0xF);
            ALL_MATERIALS.put(Material.LEGACY_MATERIALS[i].identity, LEGACY_MATERIALS[i]);
        }
        AIR = LEGACY_MATERIALS[0];
        DANDELION = LEGACY_MATERIALS[592];
        ROSE = LEGACY_MATERIALS[608];
        GRASS_BLOCK = LEGACY_MATERIALS[32];
        DIRT = LEGACY_MATERIALS[48];
        STONE = LEGACY_MATERIALS[16];
        GRANITE = LEGACY_MATERIALS[17];
        DIORITE = LEGACY_MATERIALS[19];
        ANDESITE = LEGACY_MATERIALS[21];
        COBBLESTONE = LEGACY_MATERIALS[64];
        SNOW = LEGACY_MATERIALS[1248];
        SNOW_EIGHT_LAYERS = LEGACY_MATERIALS[1255];
        DEAD_SHRUBS = LEGACY_MATERIALS[512];
        CACTUS = LEGACY_MATERIALS[1296];
        SAND = LEGACY_MATERIALS[192];
        FIRE = LEGACY_MATERIALS[816];
        GLOWSTONE = LEGACY_MATERIALS[1424];
        SOUL_SAND = LEGACY_MATERIALS[1408];
        LAVA = LEGACY_MATERIALS[160];
        NETHERRACK = LEGACY_MATERIALS[1392];
        END_STONE = LEGACY_MATERIALS[1936];
        CHORUS_PLANT = LEGACY_MATERIALS[3184];
        COAL = LEGACY_MATERIALS[256];
        GRAVEL = LEGACY_MATERIALS[208];
        REDSTONE_ORE = LEGACY_MATERIALS[1168];
        IRON_ORE = LEGACY_MATERIALS[240];
        WATER = LEGACY_MATERIALS[128];
        GOLD_ORE = LEGACY_MATERIALS[224];
        LAPIS_LAZULI_ORE = LEGACY_MATERIALS[336];
        DIAMOND_ORE = LEGACY_MATERIALS[896];
        BEDROCK = LEGACY_MATERIALS[112];
        STATIONARY_WATER = LEGACY_MATERIALS[144];
        STATIONARY_LAVA = LEGACY_MATERIALS[176];
        SNOW_BLOCK = LEGACY_MATERIALS[1280];
        SANDSTONE = LEGACY_MATERIALS[384];
        CLAY = LEGACY_MATERIALS[1312];
        MOSSY_COBBLESTONE = LEGACY_MATERIALS[768];
        OBSIDIAN = LEGACY_MATERIALS[784];
        FENCE = LEGACY_MATERIALS[1360];
        GLASS_PANE = LEGACY_MATERIALS[1632];
        STONE_BRICKS = LEGACY_MATERIALS[1568];
        BRICKS = LEGACY_MATERIALS[720];
        COBWEB = LEGACY_MATERIALS[480];
        DIAMOND_BLOCK = LEGACY_MATERIALS[912];
        GOLD_BLOCK = LEGACY_MATERIALS[656];
        IRON_BLOCK = LEGACY_MATERIALS[672];
        LAPIS_LAZULI_BLOCK = LEGACY_MATERIALS[352];
        MYCELIUM = LEGACY_MATERIALS[1760];
        FARMLAND = LEGACY_MATERIALS[960];
        ICE = LEGACY_MATERIALS[1264];
        FROSTED_ICE = LEGACY_MATERIALS[3392];
        PACKED_ICE = LEGACY_MATERIALS[2784];
        TORCH = LEGACY_MATERIALS[800];
        COBBLESTONE_STAIRS = LEGACY_MATERIALS[1072];
        GLASS = LEGACY_MATERIALS[320];
        WOODEN_STAIRS = LEGACY_MATERIALS[848];
        CHEST_NORTH = LEGACY_MATERIALS[866];
        CHEST_SOUTH = LEGACY_MATERIALS[867];
        CHEST_WEST = LEGACY_MATERIALS[868];
        CHEST_EAST = LEGACY_MATERIALS[869];
        WALL_SIGN = LEGACY_MATERIALS[1088];
        BRICK_STAIRS = LEGACY_MATERIALS[1728];
        STONE_BRICK_STAIRS = LEGACY_MATERIALS[1744];
        LADDER = LEGACY_MATERIALS[1040];
        TRAPDOOR = LEGACY_MATERIALS[1536];
        WHEAT = LEGACY_MATERIALS[944];
        LILY_PAD = LEGACY_MATERIALS[1776];
        RED_MUSHROOM = LEGACY_MATERIALS[640];
        BROWN_MUSHROOM = LEGACY_MATERIALS[624];
        SUGAR_CANE = LEGACY_MATERIALS[1328];
        EMERALD_ORE = LEGACY_MATERIALS[2064];
        EMERALD_BLOCK = LEGACY_MATERIALS[2128];
        PERMADIRT = LEGACY_MATERIALS[49];
        PODZOL = LEGACY_MATERIALS[50];
        RED_SAND = LEGACY_MATERIALS[193];
        HARDENED_CLAY = LEGACY_MATERIALS[2752];
        WHITE_CLAY = LEGACY_MATERIALS[2544];
        ORANGE_CLAY = LEGACY_MATERIALS[2545];
        MAGENTA_CLAY = LEGACY_MATERIALS[2546];
        LIGHT_BLUE_CLAY = LEGACY_MATERIALS[2547];
        YELLOW_CLAY = LEGACY_MATERIALS[2548];
        LIME_CLAY = LEGACY_MATERIALS[2549];
        PINK_CLAY = LEGACY_MATERIALS[2550];
        GREY_CLAY = LEGACY_MATERIALS[2551];
        LIGHT_GREY_CLAY = LEGACY_MATERIALS[2552];
        CYAN_CLAY = LEGACY_MATERIALS[2553];
        PURPLE_CLAY = LEGACY_MATERIALS[2554];
        BLUE_CLAY = LEGACY_MATERIALS[2555];
        BROWN_CLAY = LEGACY_MATERIALS[2556];
        GREEN_CLAY = LEGACY_MATERIALS[2557];
        RED_CLAY = LEGACY_MATERIALS[2558];
        BLACK_CLAY = LEGACY_MATERIALS[2559];
        RED_SANDSTONE = LEGACY_MATERIALS[2864];
        QUARTZ_ORE = LEGACY_MATERIALS[2448];
        GRASS = LEGACY_MATERIALS[497];
        FERN = LEGACY_MATERIALS[498];
        WOOD_OAK = LEGACY_MATERIALS[272];
        WOOD_BIRCH = LEGACY_MATERIALS[274];
        WOOD_PINE = LEGACY_MATERIALS[273];
        WOOD_JUNGLE = LEGACY_MATERIALS[275];
        WOOD_ACACIA = LEGACY_MATERIALS[2592];
        WOOD_DARK_OAK = LEGACY_MATERIALS[2593];
        LEAVES_OAK = LEGACY_MATERIALS[288];
        LEAVES_BIRCH = LEGACY_MATERIALS[290];
        LEAVES_PINE = LEGACY_MATERIALS[289];
        LEAVES_JUNGLE = LEGACY_MATERIALS[291];
        LEAVES_ACACIA = LEGACY_MATERIALS[2576];
        LEAVES_DARK_OAK = LEGACY_MATERIALS[2577];
        WOODEN_PLANK_OAK = LEGACY_MATERIALS[80];
        WOODEN_PLANK_BIRCH = LEGACY_MATERIALS[82];
        WOODEN_PLANK_PINE = LEGACY_MATERIALS[81];
        WOODEN_PLANK_JUNGLE = LEGACY_MATERIALS[83];
        WOODEN_PLANK_ACACIA = LEGACY_MATERIALS[84];
        WOODEN_PLANK_DARK_WOOD = LEGACY_MATERIALS[85];
        WOOL_WHITE = LEGACY_MATERIALS[560];
        WOOL_ORANGE = LEGACY_MATERIALS[561];
        WOOL_MAGENTA = LEGACY_MATERIALS[562];
        WOOL_LIGHT_BLUE = LEGACY_MATERIALS[563];
        WOOL_YELLOW = LEGACY_MATERIALS[564];
        WOOL_LIME = LEGACY_MATERIALS[565];
        WOOL_PINK = LEGACY_MATERIALS[566];
        WOOL_GREY = LEGACY_MATERIALS[567];
        WOOL_LIGHT_GREY = LEGACY_MATERIALS[568];
        WOOL_CYAN = LEGACY_MATERIALS[569];
        WOOL_PURPLE = LEGACY_MATERIALS[570];
        WOOL_BLUE = LEGACY_MATERIALS[571];
        WOOL_BROWN = LEGACY_MATERIALS[572];
        WOOL_GREEN = LEGACY_MATERIALS[573];
        WOOL_RED = LEGACY_MATERIALS[574];
        WOOL_BLACK = LEGACY_MATERIALS[575];
        WOOLS = new Material[]{WOOL_WHITE, WOOL_ORANGE, WOOL_MAGENTA, WOOL_LIGHT_BLUE, WOOL_YELLOW, WOOL_LIME, WOOL_PINK, WOOL_GREY, WOOL_LIGHT_GREY, WOOL_CYAN, WOOL_PURPLE, WOOL_BLUE, WOOL_BROWN, WOOL_GREEN, WOOL_RED, WOOL_BLACK};
        COBBLESTONE_SLAB = LEGACY_MATERIALS[707];
        DOOR_OPEN_LEFT_BOTTOM = LEGACY_MATERIALS[1028];
        DOOR_OPEN_LEFT_TOP = LEGACY_MATERIALS[1033];
        DOOR_OPEN_RIGHT_BOTTOM = LEGACY_MATERIALS[1028];
        DOOR_OPEN_RIGHT_TOP = LEGACY_MATERIALS[1032];
        DOOR_CLOSED_LEFT_BOTTOM = LEGACY_MATERIALS[1024];
        DOOR_CLOSED_LEFT_TOP = LEGACY_MATERIALS[1033];
        DOOR_CLOSED_RIGHT_BOTTOM = LEGACY_MATERIALS[1024];
        DOOR_CLOSED_RIGHT_TOP = LEGACY_MATERIALS[1032];
        BED_FOOT = LEGACY_MATERIALS[416];
        BED_HEAD = LEGACY_MATERIALS[424];
        COCOA_PLANT = LEGACY_MATERIALS[2032];
        COCOA_PLANT_HALF_RIPE = LEGACY_MATERIALS[2036];
        COCOA_PLANT_RIPE = LEGACY_MATERIALS[2040];
        PUMPKIN_NO_FACE = LEGACY_MATERIALS[1380];
        CARVED_PUMPKIN_NORTH_FACE = LEGACY_MATERIALS[1378];
        CARVED_PUMPKIN_EAST_FACE = LEGACY_MATERIALS[1379];
        CARVED_PUMPKIN_SOUTH_FACE = LEGACY_MATERIALS[1376];
        CARVED_PUMPKIN_WEST_FACE = LEGACY_MATERIALS[1377];
        MELON = LEGACY_MATERIALS[1648];
        JACK_O_LANTERN_NORTH_FACE = LEGACY_MATERIALS[1458];
        JACK_O_LANTERN_EAST_FACE = LEGACY_MATERIALS[1459];
        JACK_O_LANTERN_SOUTH_FACE = LEGACY_MATERIALS[1456];
        JACK_O_LANTERN_WEST_FACE = LEGACY_MATERIALS[1457];
        FLOWING_LAVA = LEGACY_MATERIALS[178];
        FLOWING_WATER = LEGACY_MATERIALS[145];
        FALLING_LAVA = LEGACY_MATERIALS[186];
        FALLING_WATER = LEGACY_MATERIALS[153];
        SNOWY = new Property<Boolean>("snowy", Boolean.class);
        NORTH = new Property<Boolean>("north", Boolean.class);
        EAST = new Property<Boolean>("east", Boolean.class);
        SOUTH = new Property<Boolean>("south", Boolean.class);
        WEST = new Property<Boolean>("west", Boolean.class);
        UP = new Property<Boolean>("up", Boolean.class);
        DOWN = new Property<Boolean>("down", Boolean.class);
        LAYERS = new Property<Integer>("layers", Integer.class);
        HALF = new Property<String>("half", String.class);
        LEVEL = new Property<Integer>("level", Integer.class);
        WATERLOGGED = new Property<Boolean>("waterlogged", Boolean.class);
        AGE = new Property<Integer>("age", Integer.class);
        PERSISTENT = new Property<Boolean>("persistent", Boolean.class);
        FACING = new Property<Direction>("facing", Direction.class);
        AXIS = new Property<String>("axis", String.class);
        TYPE = new Property<String>("type", String.class);
        PICKLES = new Property<Integer>("pickles", Integer.class);
        MOISTURE = new Property<Integer>("moisture", Integer.class);
        ROTATION = new Property<Integer>("rotation", Integer.class);
        SHAPE = new Property<String>("shape", String.class);
        HINGE = new Property<String>("hinge", String.class);
        BERRIES = new Property<Boolean>("berries", Boolean.class);
        DISTANCE = new Property<Integer>("distance", Integer.class);
        VERTICAL_DIRECTION = new Property<String>("vertical_direction", String.class);
        VINE = Material.get("minecraft:vine", "north", false, "east", false, "south", false, "west", false, "up", false, "down", false);
        TERRACOTTA = Material.get("minecraft:terracotta", new Object[0]);
        BLUE_ORCHID = Material.get("minecraft:blue_orchid", new Object[0]);
        ALLIUM = Material.get("minecraft:allium", new Object[0]);
        AZURE_BLUET = Material.get("minecraft:azure_bluet", new Object[0]);
        RED_TULIP = Material.get("minecraft:red_tulip", new Object[0]);
        ORANGE_TULIP = Material.get("minecraft:orange_tulip", new Object[0]);
        WHITE_TULIP = Material.get("minecraft:white_tulip", new Object[0]);
        PINK_TULIP = Material.get("minecraft:pink_tulip", new Object[0]);
        OXEYE_DAISY = Material.get("minecraft:oxeye_daisy", new Object[0]);
        SUNFLOWER_LOWER = Material.get("minecraft:sunflower", "half", "lower");
        LILAC_LOWER = Material.get("minecraft:lilac", "half", "lower");
        TALL_GRASS_LOWER = Material.get("minecraft:tall_grass", "half", "lower");
        LARGE_FERN_LOWER = Material.get("minecraft:large_fern", "half", "lower");
        ROSE_BUSH_LOWER = Material.get("minecraft:rose_bush", "half", "lower");
        PEONY_LOWER = Material.get("minecraft:peony", "half", "lower");
        OAK_SAPLING = Material.get("minecraft:oak_sapling", "stage", 0);
        DARK_OAK_SAPLING = Material.get("minecraft:dark_oak_sapling", "stage", 0);
        PINE_SAPLING = Material.get("minecraft:spruce_sapling", "stage", 0);
        BIRCH_SAPLING = Material.get("minecraft:birch_sapling", "stage", 0);
        JUNGLE_SAPLING = Material.get("minecraft:jungle_sapling", "stage", 0);
        ACACIA_SAPLING = Material.get("minecraft:acacia_sapling", "stage", 0);
        CARROTS = Material.get("minecraft:carrots", "age", 0);
        POTATOES = Material.get("minecraft:potatoes", "age", 0);
        PUMPKIN_STEM = Material.get("minecraft:pumpkin_stem", "age", 0);
        MELON_STEM = Material.get("minecraft:melon_stem", "age", 0);
        BEETROOTS = Material.get("minecraft:beetroots", "age", 0);
        NETHER_WART = Material.get("minecraft:nether_wart", "age", 0);
        CHORUS_FLOWER = Material.get("minecraft:chorus_flower", "age", 0);
        OAK_FENCE = Material.get("minecraft:oak_fence", new Object[0]);
        NETHER_BRICK_FENCE = Material.get("minecraft:nether_brick_fence", new Object[0]);
        SPRUCE_FENCE = Material.get("minecraft:spruce_fence", new Object[0]);
        BIRCH_FENCE = Material.get("minecraft:birch_fence", new Object[0]);
        JUNGLE_FENCE = Material.get("minecraft:jungle_fence", new Object[0]);
        DARK_OAK_FENCE = Material.get("minecraft:dark_oak_fence", new Object[0]);
        ACACIA_FENCE = Material.get("minecraft:acacia_fence", new Object[0]);
        COBBLESTONE_WALL = Material.get("minecraft:cobblestone_wall", new Object[0]);
        IRON_BARS = Material.get("minecraft:iron_bars", new Object[0]);
        TUBE_CORAL = Material.get("minecraft:tube_coral", new Object[0]);
        BRAIN_CORAL = Material.get("minecraft:brain_coral", new Object[0]);
        BUBBLE_CORAL = Material.get("minecraft:bubble_coral", new Object[0]);
        FIRE_CORAL = Material.get("minecraft:fire_coral", new Object[0]);
        HORN_CORAL = Material.get("minecraft:horn_coral", new Object[0]);
        DEAD_TUBE_CORAL = Material.get("minecraft:dead_tube_coral", new Object[0]);
        DEAD_BRAIN_CORAL = Material.get("minecraft:dead_brain_coral", new Object[0]);
        DEAD_BUBBLE_CORAL = Material.get("minecraft:dead_bubble_coral", new Object[0]);
        DEAD_FIRE_CORAL = Material.get("minecraft:dead_fire_coral", new Object[0]);
        DEAD_HORN_CORAL = Material.get("minecraft:dead_horn_coral", new Object[0]);
        TUBE_CORAL_BLOCK = Material.get("minecraft:tube_coral_block", new Object[0]);
        BRAIN_CORAL_BLOCK = Material.get("minecraft:brain_coral_block", new Object[0]);
        BUBBLE_CORAL_BLOCK = Material.get("minecraft:bubble_coral_block", new Object[0]);
        FIRE_CORAL_BLOCK = Material.get("minecraft:fire_coral_block", new Object[0]);
        HORN_CORAL_BLOCK = Material.get("minecraft:horn_coral_block", new Object[0]);
        DEAD_TUBE_CORAL_BLOCK = Material.get("minecraft:dead_tube_coral_block", new Object[0]);
        DEAD_BRAIN_CORAL_BLOCK = Material.get("minecraft:dead_brain_coral_block", new Object[0]);
        DEAD_BUBBLE_CORAL_BLOCK = Material.get("minecraft:dead_bubble_coral_block", new Object[0]);
        DEAD_FIRE_CORAL_BLOCK = Material.get("minecraft:dead_fire_coral_block", new Object[0]);
        DEAD_HORN_CORAL_BLOCK = Material.get("minecraft:dead_horn_coral_block", new Object[0]);
        TUBE_CORAL_FAN = Material.get("minecraft:tube_coral_fan", new Object[0]);
        BRAIN_CORAL_FAN = Material.get("minecraft:brain_coral_fan", new Object[0]);
        BUBBLE_CORAL_FAN = Material.get("minecraft:bubble_coral_fan", new Object[0]);
        FIRE_CORAL_FAN = Material.get("minecraft:fire_coral_fan", new Object[0]);
        HORN_CORAL_FAN = Material.get("minecraft:horn_coral_fan", new Object[0]);
        DEAD_TUBE_CORAL_FAN = Material.get("minecraft:dead_tube_coral_fan", new Object[0]);
        DEAD_BRAIN_CORAL_FAN = Material.get("minecraft:dead_brain_coral_fan", new Object[0]);
        DEAD_BUBBLE_CORAL_FAN = Material.get("minecraft:dead_bubble_coral_fan", new Object[0]);
        DEAD_FIRE_CORAL_FAN = Material.get("minecraft:dead_fire_coral_fan", new Object[0]);
        DEAD_HORN_CORAL_FAN = Material.get("minecraft:dead_horn_coral_fan", new Object[0]);
        TUBE_CORAL_WALL_FAN = Material.get("minecraft:tube_coral_wall_fan", new Object[0]);
        BRAIN_CORAL_WALL_FAN = Material.get("minecraft:brain_coral_wall_fan", new Object[0]);
        BUBBLE_CORAL_WALL_FAN = Material.get("minecraft:bubble_coral_wall_fan", new Object[0]);
        FIRE_CORAL_WALL_FAN = Material.get("minecraft:fire_coral_wall_fan", new Object[0]);
        HORN_CORAL_WALL_FAN = Material.get("minecraft:horn_coral_wall_fan", new Object[0]);
        DEAD_TUBE_CORAL_WALL_FAN = Material.get("minecraft:dead_tube_coral_wall_fan", new Object[0]);
        DEAD_BRAIN_CORAL_WALL_FAN = Material.get("minecraft:dead_brain_coral_wall_fan", new Object[0]);
        DEAD_BUBBLE_CORAL_WALL_FAN = Material.get("minecraft:dead_bubble_coral_wall_fan", new Object[0]);
        DEAD_FIRE_CORAL_WALL_FAN = Material.get("minecraft:dead_fire_coral_wall_fan", new Object[0]);
        DEAD_HORN_CORAL_WALL_FAN = Material.get("minecraft:dead_horn_coral_wall_fan", new Object[0]);
        KELP = Material.get("minecraft:kelp", "age", 0);
        KELP_PLANT = Material.get("minecraft:kelp_plant", new Object[0]);
        SEAGRASS = Material.get("minecraft:seagrass", new Object[0]);
        TALL_SEAGRASS_LOWER = Material.get("minecraft:tall_seagrass", "half", "lower");
        SEA_PICKLE_1 = Material.get("minecraft:sea_pickle", "waterlogged", true, "pickles", 1);
        CORNFLOWER = Material.get("minecraft:cornflower", new Object[0]);
        LILY_OF_THE_VALLEY = Material.get("minecraft:lily_of_the_valley", new Object[0]);
        WITHER_ROSE = Material.get("minecraft:wither_rose", new Object[0]);
        SWEET_BERRY_BUSH = Material.get("minecraft:sweet_berry_bush", "age", 0);
        OAK_SIGN = Material.get("minecraft:oak_sign", new Object[0]);
        DEEPSLATE_X = Material.get("minecraft:deepslate", "axis", "x");
        DEEPSLATE_Y = Material.get("minecraft:deepslate", "axis", "y");
        DEEPSLATE_Z = Material.get("minecraft:deepslate", "axis", "z");
        DEEPSLATE_COAL_ORE = Material.get("minecraft:deepslate_coal_ore", new Object[0]);
        DEEPSLATE_COPPER_ORE = Material.get("minecraft:deepslate_copper_ore", new Object[0]);
        DEEPSLATE_LAPIS_ORE = Material.get("minecraft:deepslate_lapis_ore", new Object[0]);
        DEEPSLATE_IRON_ORE = Material.get("minecraft:deepslate_iron_ore", new Object[0]);
        DEEPSLATE_GOLD_ORE = Material.get("minecraft:deepslate_gold_ore", new Object[0]);
        DEEPSLATE_REDSTONE_ORE = Material.get("minecraft:deepslate_redstone_ore", new Object[0]);
        DEEPSLATE_DIAMOND_ORE = Material.get("minecraft:deepslate_diamond_ore", new Object[0]);
        DEEPSLATE_EMERALD_ORE = Material.get("minecraft:deepslate_emerald_ore", new Object[0]);
        TUFF = Material.get("minecraft:tuff", new Object[0]);
        COPPER_ORE = Material.get("minecraft:copper_ore", new Object[0]);
        NETHER_GOLD_ORE = Material.get("minecraft:nether_gold_ore", new Object[0]);
        ANCIENT_DEBRIS = Material.get("minecraft:ancient_debris", new Object[0]);
        BASALT = Material.get("minecraft:basalt", new Object[0]);
        BLACKSTONE = Material.get("minecraft:blackstone", new Object[0]);
        SOUL_SOIL = Material.get("minecraft:soul_soil", new Object[0]);
        GRASS_PATH = Material.get("minecraft:grass_path", new Object[0]);
        DIRT_PATH = Material.get("minecraft:dirt_path", new Object[0]);
        WARPED_NYLIUM = Material.get("minecraft:warped_nylium", new Object[0]);
        CRIMSON_NYLIUM = Material.get("minecraft:crimson_nylium", new Object[0]);
        ROOTED_DIRT = Material.get("minecraft:rooted_dirt", new Object[0]);
        INFESTED_DEEPSLATE = Material.get("minecraft:infested_deepslate", new Object[0]);
        BAMBOO_NO_LEAVES = Material.get("minecraft:bamboo", "stage", 0, "age", 0, "leaves", "none");
        BAMBOO_SMALL_LEAVES = Material.get("minecraft:bamboo", "stage", 0, "age", 0, "leaves", "small");
        BAMBOO_LARGE_LEAVES = Material.get("minecraft:bamboo", "stage", 0, "age", 0, "leaves", "large");
        AZALEA = Material.get("minecraft:azalea", new Object[0]);
        FLOWERING_AZALEA = Material.get("minecraft:flowering_azalea", new Object[0]);
        CRIMSON_FUNGUS = Material.get("minecraft:crimson_fungus", new Object[0]);
        WARPED_FUNGUS = Material.get("minecraft:warped_fungus", new Object[0]);
        CRIMSON_ROOTS = Material.get("minecraft:crimson_roots", new Object[0]);
        WARPED_ROOTS = Material.get("minecraft:warped_roots", new Object[0]);
        NETHER_SPROUTS = Material.get("minecraft:nether_sprouts", new Object[0]);
        TWISTING_VINES_PLANT = Material.get("minecraft:twisting_vines_plant", new Object[0]);
        TWISTING_VINES_25 = Material.get("minecraft:twisting_vines", "age", 25);
        GLOW_LICHEN_NONE = Material.get("minecraft:glow_lichen", "up", false, "down", false, "north", false, "south", false, "east", false, "west", false, "waterlogged", false);
        GLOW_LICHEN_DOWN = Material.get("minecraft:glow_lichen", "up", false, "down", true, "north", false, "south", false, "east", false, "west", false, "waterlogged", false);
        GLOW_LICHEN_UP = Material.get("minecraft:glow_lichen", "up", true, "down", false, "north", false, "south", false, "east", false, "west", false, "waterlogged", false);
        MOSS_CARPET = Material.get("minecraft:moss_carpet", new Object[0]);
        BIG_DRIPLEAF_STEM_SOUTH = Material.get("minecraft:big_dripleaf_stem", "facing", "south");
        BIG_DRIPLEAF_SOUTH = Material.get("minecraft:big_dripleaf", "facing", "south");
        PUMPKIN = Material.get("minecraft:pumpkin", new Object[0]);
        CALCITE = Material.get("minecraft:calcite", new Object[0]);
        SPORE_BLOSSOM = Material.get("minecraft:spore_blossom", new Object[0]);
        WEEPING_VINES = Material.get("minecraft:weeping_vines", new Object[0]);
        WEEPING_VINES_PLANT = Material.get("minecraft:weeping_vines_plant", new Object[0]);
        HANGING_ROOTS = Material.get("minecraft:hanging_roots", new Object[0]);
        CAVE_VINES_NO_BERRIES = Material.get("minecraft:cave_vines", "berries", false);
        CAVE_VINES_PLANT_NO_BERRIES = Material.get("minecraft:cave_vines_plant", "berries", false);
        SMALL_DRIPLEAF_SOUTH_LOWER = Material.get("minecraft:small_dripleaf", "half", "lower", "facing", "south", "waterlogged", false);
        BARRIER = Material.get("minecraft:barrier", new Object[0]);
        POINTED_DRIPSTONE_UP_TIP = Material.get("minecraft:pointed_dripstone", "thickness", "tip", "vertical_direction", "up", "waterlogged", false);
        POINTED_DRIPSTONE_UP_FRUSTUM = Material.get("minecraft:pointed_dripstone", "thickness", "frustum", "vertical_direction", "up", "waterlogged", false);
        POINTED_DRIPSTONE_UP_MIDDLE = Material.get("minecraft:pointed_dripstone", "thickness", "middle", "vertical_direction", "up", "waterlogged", false);
        POINTED_DRIPSTONE_UP_BASE = Material.get("minecraft:pointed_dripstone", "thickness", "base", "vertical_direction", "up", "waterlogged", false);
        POINTED_DRIPSTONE_DOWN_TIP = Material.get("minecraft:pointed_dripstone", "thickness", "tip", "vertical_direction", "down", "waterlogged", false);
        POINTED_DRIPSTONE_DOWN_FRUSTUM = Material.get("minecraft:pointed_dripstone", "thickness", "frustum", "vertical_direction", "down", "waterlogged", false);
        POINTED_DRIPSTONE_DOWN_MIDDLE = Material.get("minecraft:pointed_dripstone", "thickness", "middle", "vertical_direction", "down", "waterlogged", false);
        POINTED_DRIPSTONE_DOWN_BASE = Material.get("minecraft:pointed_dripstone", "thickness", "base", "vertical_direction", "down", "waterlogged", false);
        MOSS_BLOCK = Material.get("minecraft:moss_block", new Object[0]);
        DRIPSTONE_BLOCK = Material.get("minecraft:dripstone_block", new Object[0]);
        MUD = Material.get("minecraft:mud", new Object[0]);
        INFESTED_STONE = Material.get("minecraft:infested_stone", new Object[0]);
        MANGROVE_PROPAGULE = Material.get("minecraft:mangrove_propagule", new Object[0]);
        STONE_ORES = ImmutableSet.of((Object)GOLD_ORE, (Object)IRON_ORE, (Object)COAL, (Object)LAPIS_LAZULI_ORE, (Object)DIAMOND_ORE, (Object)REDSTONE_ORE, (Object[])new Material[]{COPPER_ORE, EMERALD_ORE});
        DEEPSLATE_ORES = ImmutableSet.of((Object)DEEPSLATE_GOLD_ORE, (Object)DEEPSLATE_IRON_ORE, (Object)DEEPSLATE_COAL_ORE, (Object)DEEPSLATE_LAPIS_ORE, (Object)DEEPSLATE_DIAMOND_ORE, (Object)DEEPSLATE_REDSTONE_ORE, (Object[])new Material[]{DEEPSLATE_COPPER_ORE, DEEPSLATE_EMERALD_ORE});
        HashMap<String, Set> tileEntityMap = new HashMap<String, Set>();
        for (Map.Entry entry : MATERIAL_SPECS.entrySet()) {
            String name = (String)entry.getKey();
            for (Map spec : (Set)entry.getValue()) {
                if (!spec.containsKey("tileEntityId")) continue;
                tileEntityMap.computeIfAbsent((String)spec.get("tileEntityId"), k -> new HashSet()).add(name);
            }
        }
        TILE_ENTITY_MAP = Collections.unmodifiableMap(tileEntityMap);
    }

    public static enum PropertyType {
        BOOLEAN,
        INTEGER,
        ENUM;

    }

    public static class PropertyDescriptor {
        public final String name;
        public final PropertyType type;
        public final int minValue;
        public final int maxValue;
        public final String[] enumValues;

        private PropertyDescriptor(String name, PropertyType type, int minValue, int maxValue, String[] enumValues) {
            this.name = name;
            this.type = type;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.enumValues = enumValues;
        }

        static PropertyDescriptor fromString(String str) {
            int p = str.indexOf(58);
            String name = str.substring(0, p);
            String typeDescriptor = str.substring(p + 1);
            if (typeDescriptor.equals("b")) {
                return new PropertyDescriptor(name, PropertyType.BOOLEAN, 0, 0, null);
            }
            if (typeDescriptor.startsWith("i[")) {
                String[] parts = typeDescriptor.substring(2, typeDescriptor.length() - 1).split("-");
                int minValue = Integer.parseInt(parts[0]);
                int maxValue = Integer.parseInt(parts[1]);
                return new PropertyDescriptor(name, PropertyType.INTEGER, minValue, maxValue, null);
            }
            if (typeDescriptor.startsWith("e[")) {
                String[] enumValues = typeDescriptor.substring(2, typeDescriptor.length() - 1).split(";");
                return new PropertyDescriptor(name, PropertyType.ENUM, 0, 0, enumValues);
            }
            throw new IllegalArgumentException("Could not parse property descriptor \"" + str + '\"');
        }
    }

    static final class PropertyAndValue
    extends Pair<String, String> {
        PropertyAndValue(String property, String value) {
            super((Object)property, (Object)value);
        }
    }

    public static final class Identity
    implements Serializable {
        public final String name;
        public final Map<String, String> properties;
        private static final long serialVersionUID = 1L;

        public Identity(String name, Map<String, String> properties) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (name.indexOf(58) == -1) {
                throw new IllegalArgumentException("name \"" + name + "\"");
            }
            this.name = name.intern();
            this.properties = properties != null && !properties.isEmpty() ? ImmutableMap.copyOf(properties) : null;
        }

        boolean containsPropertyWithValue(String propertyName, String value) {
            return this.properties != null && value.equals(this.properties.get(propertyName));
        }

        boolean containsPropertyWithValues(String propertyName, String ... values) {
            if (this.properties == null) {
                return false;
            }
            String value = this.properties.get(propertyName);
            return value != null && Arrays.asList(values).contains(value);
        }

        public boolean equals(Object o) {
            return o instanceof Identity && this.name.equals(((Identity)o).name) && Objects.equals(this.properties, ((Identity)o).properties);
        }

        public int hashCode() {
            return this.name.hashCode() * 37 + (this.properties != null ? this.properties.hashCode() : 0);
        }

        public String toString() {
            return this.properties != null ? this.name + this.properties : this.name;
        }
    }
}

