/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.IntArrayTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.LongArrayTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.AbstractNBTItem;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.MCNamedBlocksChunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.SectionedChunk;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.PackedArrayCube;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MC118AnvilChunk
extends MCNamedBlocksChunk
implements SectionedChunk,
MinecraftWorld {
    public final boolean readOnly;
    final int xPos;
    final int zPos;
    final int minHeight;
    final int maxHeight;
    final int undergroundSections;
    final Section[] sections;
    final List<Entity> entities;
    final List<TileEntity> blockEntities;
    final Map<String, long[]> heightMaps;
    final List<CompoundTag> fluidTicks = new ArrayList<CompoundTag>();
    final Map<DataType, Map<String, Tag>> extraTags;
    final Integer inputDataVersion;
    int highestSectionWithSkylight = Integer.MIN_VALUE;
    boolean lightOn;
    long inhabitedTime;
    long lastUpdate;
    String status;
    public static final int LIGHT_ARRAY_SIZE = 2048;
    private static final Random RANDOM = new Random();
    private static final Map<DataType, Set<String>> KNOWN_TAGS = ImmutableMap.of((Object)((Object)DataType.REGION), (Object)ImmutableSet.of((Object)"DataVersion", (Object)"sections", (Object)"Heightmaps", (Object)"block_entities", (Object)"LastUpdate", (Object)"xPos", (Object[])new String[]{"zPos", "Status", "isLightOn", "InhabitedTime", "fluid_ticks"}), (Object)((Object)DataType.ENTITIES), (Object)ImmutableSet.of((Object)"DataVersion", (Object)"Entities", (Object)"Position"));
    private static final Logger logger = LoggerFactory.getLogger(MC118AnvilChunk.class);

    public MC118AnvilChunk(int xPos, int zPos, int minHeight, int maxHeight) {
        super((Map<DataType, CompoundTag>)ImmutableMap.of((Object)((Object)DataType.REGION), (Object)new CompoundTag("", new HashMap())));
        this.xPos = xPos;
        this.zPos = zPos;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.inputDataVersion = null;
        this.undergroundSections = -minHeight >> 4;
        this.sections = new Section[(maxHeight >> 4) + this.undergroundSections];
        this.heightMaps = new HashMap<String, long[]>();
        this.entities = new ArrayList<Entity>();
        this.blockEntities = new ArrayList<TileEntity>();
        this.readOnly = false;
        this.lightOn = true;
        this.extraTags = null;
        this.setTerrainPopulated(true);
    }

    public MC118AnvilChunk(Map<DataType, CompoundTag> tags, int minHeight, int maxHeight) {
        this(tags, minHeight, maxHeight, false);
    }

    public MC118AnvilChunk(Map<DataType, CompoundTag> tags, int minHeight, int maxHeight, boolean readOnly) {
        super(tags);
        try {
            List entityTags;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
            this.readOnly = readOnly;
            this.inputDataVersion = this.getInt(DataType.REGION, "DataVersion");
            this.undergroundSections = -minHeight >> 4;
            this.sections = new Section[(maxHeight >> 4) + this.undergroundSections];
            List sectionTags = this.getList(DataType.REGION, "sections");
            if (sectionTags != null) {
                for (Object sectionTag : sectionTags) {
                    try {
                        Section section = new Section((CompoundTag)sectionTag);
                        if (section.level >= -this.undergroundSections && section.level < this.sections.length - this.undergroundSections) {
                            this.sections[section.level + this.undergroundSections] = section;
                            if (section.skyLight == null || section.level <= this.highestSectionWithSkylight) continue;
                            this.highestSectionWithSkylight = section.level;
                            continue;
                        }
                        if (section.isEmpty()) continue;
                        logger.warn("Ignoring non-empty out of bounds chunk section @ " + this.getxPos() + "," + section.level + "," + this.getzPos());
                    }
                    catch (Section.IncompleteSectionException incompleteSectionException) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Ignoring chunk section with missing data @ " + this.getxPos() + "," + ((ByteTag)sectionTag.getTag("Y")).getValue() + "," + this.getzPos());
                    }
                }
            }
            this.heightMaps = new HashMap<String, long[]>();
            Map<String, Tag> heightMapTags = this.getMap(DataType.REGION, "Heightmaps");
            if (heightMapTags != null) {
                for (Map.Entry entry : heightMapTags.entrySet()) {
                    this.heightMaps.put(((String)entry.getKey()).intern(), ((LongArrayTag)entry.getValue()).getValue());
                }
            }
            if ((entityTags = this.getList(DataType.ENTITIES, "Entities")) != null) {
                this.entities = new ArrayList<Entity>(entityTags.size());
                this.entities.addAll(entityTags.stream().map(Entity::fromNBT).collect(Collectors.toList()));
            } else {
                this.entities = new ArrayList<Entity>();
            }
            List list = this.getList(DataType.REGION, "block_entities");
            if (list != null) {
                this.blockEntities = new ArrayList<TileEntity>(list.size());
                this.blockEntities.addAll(list.stream().map(TileEntity::fromNBT).collect(Collectors.toList()));
            } else {
                this.blockEntities = new ArrayList<TileEntity>();
            }
            this.lastUpdate = this.getLong(DataType.REGION, "LastUpdate");
            this.xPos = this.getInt(DataType.REGION, "xPos");
            this.zPos = this.getInt(DataType.REGION, "zPos");
            this.status = this.getString(DataType.REGION, "Status").intern();
            this.lightOn = this.getBoolean(DataType.REGION, "isLightOn");
            this.inhabitedTime = this.getLong(DataType.REGION, "InhabitedTime");
            if (this.containsTag(DataType.REGION, "fluid_ticks")) {
                this.fluidTicks.addAll(this.getList(DataType.REGION, "fluid_ticks"));
            }
            HashMap<DataType, Map<String, Tag>> myExtraTags = new HashMap<DataType, Map<String, Tag>>();
            this.forEachTag((dataType, name, tag) -> {
                if (!KNOWN_TAGS.containsKey((Object)dataType) || !KNOWN_TAGS.get((Object)dataType).contains(name)) {
                    myExtraTags.computeIfAbsent(dataType, t -> new HashMap()).put(name, tag);
                }
            });
            this.extraTags = !myExtraTags.isEmpty() ? myExtraTags : null;
        }
        catch (Section.ExceptionParsingSectionException e) {
            throw e;
        }
        catch (RuntimeException e) {
            logger.error("{} while creating chunk from NBT", (Object)e.getClass().getSimpleName());
            throw e;
        }
    }

    @Override
    public boolean isSectionPresent(int y) {
        return y + this.undergroundSections >= 0 && y + this.undergroundSections < this.sections.length && this.sections[y + this.undergroundSections] != null;
    }

    public Section[] getSections() {
        return this.sections;
    }

    public void setStatus(String status) {
        this.status = status.intern();
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, long[]> getHeightMaps() {
        return this.heightMaps;
    }

    public Integer getInputDataVersion() {
        return this.inputDataVersion;
    }

    private void addFluidTick(int x, int y, int z, Material material) {
        x = this.xPos << 4 | x;
        z = this.zPos << 4 | z;
        String id = material.containsWater() ? "minecraft:water" : (material.isNamed("minecraft:water") ? "minecraft:flowing_water" : (material.isNamed("minecraft:lava") ? (material.getProperty(Material.LEVEL) == 0 ? "minecraft:lava" : "minecraft:flowing_lava") : material.name));
        Iterator<CompoundTag> i = this.fluidTicks.iterator();
        while (i.hasNext()) {
            CompoundTag fluidTick = i.next();
            if (x != ((IntTag)fluidTick.getTag("x")).getValue() || y != ((IntTag)fluidTick.getTag("y")).getValue() || z != ((IntTag)fluidTick.getTag("z")).getValue()) continue;
            String existingId = ((StringTag)fluidTick.getTag("i")).getValue();
            if (id.equals(existingId)) {
                return;
            }
            logger.warn("Replacing fluid tick for type {} with type {} @ {},{},{}", new Object[]{existingId, id, x, y, z});
            i.remove();
            break;
        }
        this.fluidTicks.add(new CompoundTag("", (Map)ImmutableMap.builder().put((Object)"x", (Object)new IntTag("x", x)).put((Object)"y", (Object)new IntTag("y", y)).put((Object)"z", (Object)new IntTag("z", z)).put((Object)"i", (Object)new StringTag("i", id)).put((Object)"p", (Object)new IntTag("p", 0)).put((Object)"t", (Object)new IntTag("t", RANDOM.nextInt(30) + 1)).build()));
    }

    @Override
    public Map<DataType, ? extends Tag> toMultipleNBT() {
        this.normalise();
        if (this.sections != null) {
            ArrayList<CompoundTag> sectionTags = new ArrayList<CompoundTag>(this.maxHeight >> 4);
            for (Section section : this.sections) {
                if (section == null || section.isEmpty() && !section.hasBiomes()) continue;
                sectionTags.add(section.toNBT());
            }
            this.setList(DataType.REGION, "sections", CompoundTag.class, sectionTags);
        }
        HashMap<String, Tag> heightMapTags = new HashMap<String, Tag>(this.heightMaps.size());
        this.heightMaps.forEach((key, value) -> {
            Tag cfr_ignored_0 = (Tag)heightMapTags.put((String)key, (Tag)new LongArrayTag(key, value));
        });
        this.setMap(DataType.REGION, "Heightmaps", heightMapTags);
        ArrayList entityTags = new ArrayList(this.entities.size());
        if (!this.entities.isEmpty()) {
            this.entities.stream().map(AbstractNBTItem::toNBT).forEach(entityTags::add);
            this.setList(DataType.ENTITIES, "Entities", CompoundTag.class, entityTags);
        } else if (this.containsType(DataType.ENTITIES)) {
            this.setList(DataType.ENTITIES, "entities", CompoundTag.class, entityTags);
        }
        ArrayList blockEntityTags = new ArrayList(this.blockEntities.size());
        this.blockEntities.stream().map(AbstractNBTItem::toNBT).forEach(blockEntityTags::add);
        this.setList(DataType.REGION, "block_entities", CompoundTag.class, blockEntityTags);
        this.setLong(DataType.REGION, "LastUpdate", this.lastUpdate);
        this.setInt(DataType.REGION, "xPos", this.xPos);
        this.setInt(DataType.REGION, "yPos", -this.undergroundSections);
        this.setInt(DataType.REGION, "zPos", this.zPos);
        this.setString(DataType.REGION, "Status", this.status);
        this.setBoolean(DataType.REGION, "isLightOn", this.lightOn);
        this.setLong(DataType.REGION, "InhabitedTime", this.inhabitedTime);
        this.setList(DataType.REGION, "fluid_ticks", CompoundTag.class, this.fluidTicks);
        if (this.extraTags != null) {
            this.extraTags.forEach((type, tags) -> tags.forEach((name, tag) -> this.setTag((DataType)((Object)type), (String)name, (Tag)tag)));
        }
        int outputDataVersion = this.inputDataVersion != null ? this.inputDataVersion : 2860;
        this.setTag(DataType.REGION, "DataVersion", (Tag)new IntTag("DataVersion", outputDataVersion));
        if (this.containsType(DataType.ENTITIES)) {
            this.setTag(DataType.ENTITIES, "DataVersion", (Tag)new IntTag("DataVersion", outputDataVersion));
            this.setTag(DataType.ENTITIES, "Position", (Tag)new IntArrayTag("Position", new int[]{this.xPos, this.zPos}));
        }
        return super.toMultipleNBT();
    }

    @Override
    public int getMinHeight() {
        return -(this.undergroundSections << 4);
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public boolean isNamedBiomesSupported() {
        return true;
    }

    @Override
    public boolean isNamedBiomesAvailable() {
        return true;
    }

    @Override
    public int getxPos() {
        return this.xPos;
    }

    @Override
    public int getzPos() {
        return this.zPos;
    }

    @Override
    public MinecraftCoords getCoords() {
        return new MinecraftCoords(this.xPos, this.zPos);
    }

    @Override
    public int getBlockType(int x, int y, int z) {
        return this.getMaterial((int)x, (int)y, (int)z).blockType;
    }

    @Override
    @Deprecated
    public void setBlockType(int x, int y, int z, int blockType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDataValue(int x, int y, int z) {
        return this.getMaterial((int)x, (int)y, (int)z).data;
    }

    @Override
    @Deprecated
    public void setDataValue(int x, int y, int z, int dataValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        int level = y >> 4;
        if (this.sections[level + this.undergroundSections] == null || this.sections[level + this.undergroundSections].skyLight == null) {
            return level > this.highestSectionWithSkylight ? 15 : 0;
        }
        return this.getDataByte(this.sections[level + this.undergroundSections].skyLight, x, y, z);
    }

    @Override
    public void setSkyLightLevel(int x, int y, int z, int skyLightLevel) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level + this.undergroundSections];
        if (section == null) {
            if (skyLightLevel == (level > this.highestSectionWithSkylight ? 15 : 0)) {
                return;
            }
            this.sections[level + this.undergroundSections] = section = new Section((byte)level);
        }
        if (section.skyLight == null) {
            if (skyLightLevel == (level > this.highestSectionWithSkylight ? 15 : 0)) {
                return;
            }
            section.skyLight = new byte[2048];
            if (level > this.highestSectionWithSkylight) {
                Arrays.fill(section.skyLight, (byte)-1);
                this.highestSectionWithSkylight = level;
            }
        }
        this.setDataByte(section.skyLight, x, y, z, skyLightLevel);
    }

    @Override
    public int getBlockLightLevel(int x, int y, int z) {
        int level = y >> 4;
        if (this.sections[level + this.undergroundSections] == null || this.sections[level + this.undergroundSections].blockLight == null) {
            return 0;
        }
        return this.getDataByte(this.sections[level + this.undergroundSections].blockLight, x, y, z);
    }

    @Override
    public void setBlockLightLevel(int x, int y, int z, int blockLightLevel) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level + this.undergroundSections];
        if (section == null) {
            if (blockLightLevel == 0) {
                return;
            }
            this.sections[level + this.undergroundSections] = section = new Section((byte)level);
        }
        if (section.blockLight == null) {
            if (blockLightLevel == 0) {
                return;
            }
            section.blockLight = new byte[2048];
        }
        this.setDataByte(section.blockLight, x, y, z, blockLightLevel);
    }

    @Override
    public int getHeight(int x, int z) {
        return 62;
    }

    @Override
    public void setHeight(int x, int z, int height) {
        if (this.readOnly) {
            return;
        }
    }

    @Override
    public String getNamedBiome(int x, int y, int z) {
        Section section = this.sections[(y >> 2) + this.undergroundSections];
        return section != null ? (section.singleBiome != null ? section.singleBiome : (section.biomes != null ? section.biomes.getValue(x, z, y & 3) : null)) : null;
    }

    @Override
    public void setNamedBiome(int x, int y, int z, String biome) {
        if (this.readOnly) {
            return;
        }
        biome = biome.intern();
        int level = y >> 2;
        Section section = this.sections[level + this.undergroundSections];
        if (section == null) {
            section = new Section((byte)level);
            section.singleBiome = biome;
            this.sections[level + this.undergroundSections] = section;
        } else if (section.singleBiome != null) {
            if (biome != section.singleBiome) {
                section.biomes = new PackedArrayCube<String>(4, 1, false, String.class);
                section.biomes.fill(section.singleBiome);
                section.biomes.setValue(x, z, y & 3, biome);
                section.singleBiome = null;
            }
        } else if (section.biomes == null) {
            section.singleBiome = biome;
        } else {
            section.biomes.setValue(x, z, y & 3, biome);
        }
    }

    @Override
    public void markForUpdateChunk(int x, int y, int z) {
        Material material = this.getMaterial(x, y, z);
        if (!material.isNamedOneOf("minecraft:water", "minecraft:lava") && !material.containsWater()) {
            throw new UnsupportedOperationException("Don't know how to mark " + material + " for update");
        }
        this.addFluidTick(x, y, z, material);
    }

    @Override
    public boolean isTerrainPopulated() {
        return true;
    }

    @Override
    public void setTerrainPopulated(boolean terrainPopulated) {
        if (this.readOnly) {
            return;
        }
        this.status = terrainPopulated ? "full" : "liquid_carvers";
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.blockEntities;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        Section section = this.sections[(y >> 4) + this.undergroundSections];
        if (section == null) {
            return Material.AIR;
        }
        if (section.singleMaterial != null) {
            return section.singleMaterial;
        }
        Material material = section.materials.getValue(x, z, y & 0xF);
        return material != null ? material : Material.AIR;
    }

    @Override
    public void setMaterial(int x, int y, int z, Material material) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level + this.undergroundSections];
        if (section == null) {
            if (material == Material.AIR) {
                return;
            }
            this.sections[level + this.undergroundSections] = section = new Section((byte)level);
        }
        if (section.singleMaterial != null) {
            if (material != section.singleMaterial) {
                section.materials = new PackedArrayCube<Material>(16, 4, false, Material.class);
                if (section.singleMaterial != Material.AIR) {
                    section.materials.fill(section.singleMaterial);
                }
                section.singleMaterial = null;
            } else {
                return;
            }
        }
        section.materials.setValue(x, z, y & 0xF, material == Material.AIR ? null : material);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isLightPopulated() {
        return this.lightOn;
    }

    @Override
    public void setLightPopulated(boolean lightOn) {
        this.lightOn = lightOn;
    }

    @Override
    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    @Override
    public void setInhabitedTime(long inhabitedTime) {
        this.inhabitedTime = inhabitedTime;
    }

    @Override
    public int getHighestNonAirBlock(int x, int z) {
        for (int yy = this.sections.length - 1; yy >= 0; --yy) {
            if (this.sections[yy] == null || this.sections[yy].singleMaterial == Material.AIR) continue;
            if (this.sections[yy].singleMaterial != null) {
                return yy - this.undergroundSections << 4 | MC118AnvilChunk.blockOffset(x, 15, z) >> 8;
            }
            for (int y = 15; y >= 0; --y) {
                Material material = this.sections[yy].materials.getValue(x, z, y);
                if (material == null || material == Material.AIR) continue;
                return yy - this.undergroundSections << 4 | y;
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getHighestNonAirBlock() {
        for (int yy = this.sections.length - 1; yy >= 0; --yy) {
            if (this.sections[yy] == null || this.sections[yy].singleMaterial == Material.AIR) continue;
            if (this.sections[yy].singleMaterial != null) {
                return yy - this.undergroundSections << 4 | 0xF;
            }
            for (int y = 15; y >= 0; --y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        Material material = this.sections[yy].materials.getValue(x, z, y);
                        if (material == null || material == Material.AIR) continue;
                        return yy - this.undergroundSections << 4 | y;
                    }
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getBlockTypeAt(int x, int y, int height) {
        return this.getBlockType(x, height, y);
    }

    @Override
    public int getDataAt(int x, int y, int height) {
        return this.getDataValue(x, height, y);
    }

    @Override
    public Material getMaterialAt(int x, int y, int height) {
        return this.getMaterial(x, height, y);
    }

    @Override
    @Deprecated
    public void setBlockTypeAt(int x, int y, int height, int blockType) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setDataAt(int x, int y, int height, int data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaterialAt(int x, int y, int height, Material material) {
        this.setMaterial(x, height, y, material);
    }

    @Override
    public boolean isChunkPresent(int x, int y) {
        return x == this.xPos && y == this.zPos;
    }

    @Override
    public void addChunk(Chunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEntity(double x, double y, double height, Entity entity) {
        entity = entity.clone();
        entity.setPos(new double[]{x, height, y});
        this.getEntities().add(entity);
    }

    @Override
    public void addTileEntity(int x, int y, int height, TileEntity tileEntity) {
        tileEntity = (TileEntity)tileEntity.clone();
        tileEntity.setX(x);
        tileEntity.setZ(y);
        tileEntity.setY(height);
        this.getTileEntities().add(tileEntity);
    }

    @Override
    public Chunk getChunk(int x, int z) {
        if (x == this.xPos && z == this.zPos) {
            return this;
        }
        return null;
    }

    @Override
    public Chunk getChunkForEditing(int x, int z) {
        return this.getChunk(x, z);
    }

    @Override
    public void close() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MC118AnvilChunk other = (MC118AnvilChunk)obj;
        if (this.xPos != other.xPos) {
            return false;
        }
        return this.zPos == other.zPos;
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + this.xPos;
        hash = 37 * hash + this.zPos;
        return hash;
    }

    @Override
    public MC118AnvilChunk clone() {
        throw new UnsupportedOperationException("MC113AnvilChunk.clone() not supported");
    }

    private void fixNegativeValues(int[] biomes) {
        for (int i = 0; i < biomes.length; ++i) {
            if (biomes[i] >= 0) continue;
            biomes[i] = biomes[i] & 0xFF;
        }
    }

    private int getDataByte(byte[] array, int x, int y, int z) {
        int blockOffset = MC118AnvilChunk.blockOffset(x, y, z);
        byte dataByte = array[blockOffset / 2];
        if (blockOffset % 2 == 0) {
            return dataByte & 0xF;
        }
        return (dataByte & 0xF0) >> 4;
    }

    private void setDataByte(byte[] array, int x, int y, int z, int dataValue) {
        int blockOffset = MC118AnvilChunk.blockOffset(x, y, z);
        int offset = blockOffset / 2;
        byte dataByte = array[offset];
        if (blockOffset % 2 == 0) {
            dataByte = (byte)(dataByte & 0xF0);
            dataByte = (byte)(dataByte | dataValue & 0xF);
        } else {
            dataByte = (byte)(dataByte & 0xF);
            dataByte = (byte)(dataByte | (dataValue & 0xF) << 4);
        }
        array[offset] = dataByte;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("MC118AnvilChunk is not serializable");
    }

    static int blockOffset(int x, int y, int z) {
        return x | (z | (y & 0xF) << 4) << 4;
    }

    public static class Section
    extends AbstractNBTItem
    implements SectionedChunk.Section {
        public final int level;
        byte[] skyLight;
        byte[] blockLight;
        PackedArrayCube<Material> materials;
        Material singleMaterial;
        PackedArrayCube<String> biomes;
        String singleBiome;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Section(CompoundTag tag) {
            super(tag);
            try {
                Tag levelTag = this.getTag("Y");
                this.level = levelTag instanceof ByteTag ? ((ByteTag)levelTag).intValue() : ((IntTag)levelTag).intValue();
                CompoundTag blockStatesTag = (CompoundTag)this.getTag("block_states");
                if (blockStatesTag == null) {
                    throw new IncompleteSectionException("block_states tag missing");
                }
                List paletteList = ((ListTag)blockStatesTag.getTag("palette")).getValue();
                if (paletteList == null) throw new IncompleteSectionException("block_states.palette tag missing");
                Material[] palette = new Material[paletteList.size()];
                for (int i = 0; i < palette.length; ++i) {
                    palette[i] = this.getMaterial(paletteList, i);
                }
                LongArrayTag blockStatesDataTag = (LongArrayTag)blockStatesTag.getTag("data");
                if (blockStatesDataTag != null) {
                    long[] blockStates = blockStatesDataTag.getValue();
                    this.materials = new PackedArrayCube<Material>(16, blockStates, palette, 4, false, Material.class);
                } else {
                    if (palette.length != 1) throw new IncompleteSectionException("block_states.data tag missing");
                    this.singleMaterial = palette[0] == null ? Material.AIR : palette[0];
                }
                CompoundTag biomesTag = (CompoundTag)this.getTag("biomes");
                if (biomesTag != null) {
                    List biomesPaletteList = ((ListTag)biomesTag.getTag("palette")).getValue();
                    if (biomesPaletteList == null) throw new IncompleteSectionException("biomes.palette tag missing");
                    String[] palette2 = new String[biomesPaletteList.size()];
                    for (int i = 0; i < palette2.length; ++i) {
                        palette2[i] = ((StringTag)biomesPaletteList.get(i)).getValue().intern();
                    }
                    LongArrayTag biomeDataTag = (LongArrayTag)biomesTag.getTag("data");
                    if (biomeDataTag != null) {
                        long[] biomeData = biomeDataTag.getValue();
                        this.biomes = new PackedArrayCube<String>(4, biomeData, palette2, 1, false, String.class);
                    } else {
                        if (palette2.length != 1) throw new IncompleteSectionException("biomes.data tag missing");
                        this.singleBiome = palette2[0];
                    }
                }
                this.skyLight = this.getByteArray("SkyLight");
                this.blockLight = this.getByteArray("BlockLight");
                return;
            }
            catch (IncompleteSectionException e) {
                throw e;
            }
            catch (RuntimeException e) {
                logger.error("{} while creating chunk from NBT", (Object)e.getClass().getSimpleName());
                throw new ExceptionParsingSectionException(e);
            }
        }

        Section(byte level) {
            super(new CompoundTag("", new HashMap()));
            this.level = level;
            this.singleMaterial = Material.AIR;
        }

        @Override
        public CompoundTag toNBT() {
            ArrayList<Object> palette;
            this.setByte("Y", (byte)this.level);
            if (this.singleMaterial != null) {
                this.setMap("block_states", (Map<String, Tag>)ImmutableMap.of((Object)"palette", (Object)new ListTag("palette", CompoundTag.class, Collections.singletonList(this.createPaletteEntry(this.singleMaterial)))));
            } else {
                PackedArrayCube.PackedData packedMaterials = this.materials.pack();
                palette = new ArrayList<Object>(((Material[])packedMaterials.palette).length);
                for (Material material : (Material[])packedMaterials.palette) {
                    palette.add(this.createPaletteEntry(material));
                }
                this.setMap("block_states", (Map<String, Tag>)ImmutableMap.of((Object)"palette", (Object)new ListTag("palette", CompoundTag.class, palette), (Object)"data", (Object)new LongArrayTag("data", packedMaterials.data)));
            }
            if (this.singleBiome != null) {
                this.setMap("biomes", (Map<String, Tag>)ImmutableMap.of((Object)"palette", (Object)new ListTag("palette", StringTag.class, Collections.singletonList(new StringTag("", this.singleBiome)))));
            } else if (this.biomes != null) {
                PackedArrayCube.PackedData packedBiomes = this.biomes.pack();
                palette = new ArrayList(((String[])packedBiomes.palette).length);
                for (String biome : (String[])packedBiomes.palette) {
                    palette.add(new StringTag("", biome));
                }
                this.setMap("biomes", (Map<String, Tag>)ImmutableMap.of((Object)"palette", (Object)new ListTag("palette", StringTag.class, palette), (Object)"data", (Object)new LongArrayTag("data", packedBiomes.data)));
            }
            if (this.skyLight != null) {
                this.setByteArray("SkyLight", this.skyLight);
            }
            if (this.blockLight != null) {
                this.setByteArray("BlockLight", this.blockLight);
            }
            return super.toNBT();
        }

        @Override
        public boolean isEmpty() {
            if (this.singleMaterial != null && this.singleMaterial != Material.AIR) {
                return false;
            }
            if (this.materials != null && !this.materials.isEmpty()) {
                return false;
            }
            if (this.skyLight != null) {
                for (byte b : this.skyLight) {
                    if (b == 0) continue;
                    return false;
                }
            }
            if (this.blockLight != null) {
                for (byte b : this.blockLight) {
                    if (b == 0) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean hasBiomes() {
            return this.singleBiome != null && !this.singleBiome.equals("minecraft:plains") || this.biomes != null;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("MC118AnvilChunk.Section is not serializable");
        }

        private Material getMaterial(List<CompoundTag> palette, int index) {
            HashMap<String, String> properties;
            CompoundTag blockSpecTag = palette.get(index);
            String name = ((StringTag)blockSpecTag.getTag("Name")).getValue();
            CompoundTag propertiesTag = (CompoundTag)blockSpecTag.getTag("Properties");
            if (name.equals("minecraft:air") && propertiesTag == null) {
                return null;
            }
            if (propertiesTag != null) {
                properties = new HashMap<String, String>();
                for (Map.Entry entry : propertiesTag.getValue().entrySet()) {
                    Tag tag = (Tag)entry.getValue();
                    if (tag instanceof StringTag) {
                        properties.put((String)entry.getKey(), ((StringTag)tag).getValue());
                        continue;
                    }
                    logger.warn("Ignoring non-vanilla material property tag {} of unsupported type {}", entry.getKey(), (Object)tag.getClass().getSimpleName());
                }
            } else {
                properties = null;
            }
            return Material.get(name, properties);
        }

        @NotNull
        private CompoundTag createPaletteEntry(Material material) {
            CompoundTag paletteEntry = new CompoundTag("", Collections.emptyMap());
            if (material != null) {
                paletteEntry.setTag("Name", (Tag)new StringTag("Name", material.name));
                if (material.getProperties() != null) {
                    CompoundTag propertiesTag = new CompoundTag("Properties", Collections.emptyMap());
                    for (Map.Entry<String, String> property : material.getProperties().entrySet()) {
                        propertiesTag.setTag(property.getKey(), (Tag)new StringTag(property.getKey(), property.getValue()));
                    }
                    paletteEntry.setTag("Properties", (Tag)propertiesTag);
                }
            } else {
                paletteEntry.setTag("Name", (Tag)new StringTag("Name", "minecraft:air"));
            }
            return paletteEntry;
        }

        static class ExceptionParsingSectionException
        extends MDCCapturingRuntimeException {
            ExceptionParsingSectionException(Throwable cause) {
                super("Could not parse section", cause);
            }
        }

        static class IncompleteSectionException
        extends MDCCapturingRuntimeException {
            IncompleteSectionException(String message) {
                super(message);
            }
        }
    }
}

