/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.NBTInputStream;
import org.jnbt.NBTOutputStream;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.AbstractNBTItem;
import org.pepsoft.minecraft.Java115Level;
import org.pepsoft.minecraft.Java116Level;
import org.pepsoft.minecraft.Java118Level;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.datapack.DataPack;
import org.pepsoft.minecraft.datapack.Descriptor;
import org.pepsoft.minecraft.datapack.Dimension;
import org.pepsoft.minecraft.datapack.Meta;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.worldpainter.AccessDeniedException;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaLevel
extends AbstractNBTItem {
    protected final Platform platform;
    protected final int minHeight;
    protected final int maxHeight;
    protected final Set<Tag> extraTags;
    private static volatile File cachedFile;
    private static volatile JavaLevel cachedLevel;
    private static final Logger logger;
    private static final long serialVersionUID = 1L;

    protected JavaLevel(int minHeight, int maxHeight, Platform platform) {
        super(new CompoundTag("Data", new HashMap()));
        this.platform = platform;
        if (!DefaultPlugin.DEFAULT_JAVA_PLATFORMS.contains(platform)) {
            throw new IllegalArgumentException("Not a supported platform: " + platform);
        }
        if (maxHeight != (platform == DefaultPlugin.JAVA_MCREGION ? 128 : 256)) {
            this.setInt("MapHeight", maxHeight);
        }
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.extraTags = null;
        this.setInt("version", platform == DefaultPlugin.JAVA_MCREGION ? 19132 : 19133);
        Integer dataVersion = platform.getAttribute(DefaultPlugin.ATTRIBUTE_EXPORT_DATA_VERSION);
        if (dataVersion != null) {
            this.setInt("DataVersion", dataVersion);
            HashMap<String, Tag> versionTag = new HashMap<String, Tag>();
            versionTag.put("Id", (Tag)new IntTag("Id", dataVersion.intValue()));
            versionTag.put("Name", (Tag)new StringTag("Name", "WorldPainter"));
            versionTag.put("Snapshot", (Tag)new ByteTag("Snapshot", (byte)(Version.isSnapshot() ? 1 : 0)));
            this.setMap("Version", versionTag);
        }
    }

    protected JavaLevel(CompoundTag tag, int minHeight, int maxHeight) {
        super((CompoundTag)tag.getTag("Data"));
        int version = this.getInt("version");
        if (version != 0 && version != 19132 && version != 19133) {
            throw new IllegalArgumentException("Not a supported version: 0x" + Integer.toHexString(version));
        }
        if (maxHeight != (version == 19132 ? 128 : 256)) {
            this.setInt("MapHeight", maxHeight);
        }
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        if (tag.getValue().size() == 1) {
            this.extraTags = null;
        } else {
            this.extraTags = new HashSet<Tag>();
            tag.getValue().values().stream().filter(extraTag -> !extraTag.getName().equals("Data")).forEach(this.extraTags::add);
        }
        if (version == 19132) {
            this.platform = DefaultPlugin.JAVA_MCREGION;
        } else {
            int dataVersion = this.getInt("DataVersion");
            for (Platform platform : DefaultPlugin.DEFAULT_JAVA_PLATFORMS) {
                Integer platformLatestDataVersion = platform.getAttribute(DefaultPlugin.ATTRIBUTE_LATEST_DATA_VERSION);
                if (platformLatestDataVersion == null || dataVersion > platformLatestDataVersion) continue;
                this.platform = platform;
                return;
            }
            this.platform = DefaultPlugin.DEFAULT_JAVA_PLATFORMS.get(DefaultPlugin.DEFAULT_JAVA_PLATFORMS.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File worldDir) throws IOException {
        CompoundTag versionTag;
        if (!worldDir.exists() && !worldDir.mkdirs()) {
            throw new AccessDeniedException("Could not create directory " + worldDir);
        }
        File sessionLockFile = new File(worldDir, "session.lock");
        try (DataOutputStream sessionOut = new DataOutputStream(new FileOutputStream(sessionLockFile));){
            sessionOut.writeLong(System.currentTimeMillis());
        }
        int version = this.getVersion();
        int dataVersion = this.getInt("DataVersion");
        if (dataVersion == 0 && (versionTag = (CompoundTag)this.getTag("Version")) != null) {
            dataVersion = ((IntTag)versionTag.getTag("Id")).getValue();
        }
        if (version == 19133 && (dataVersion > 1976 && dataVersion <= 2730 && this.maxHeight != 256 || dataVersion > 2730 && (this.minHeight != -64 || this.maxHeight != 320))) {
            this.createWorldPainterDataPack(worldDir);
        }
        File levelDatFile = new File(worldDir, "level.dat");
        this.setLong("LastPlayed", System.currentTimeMillis());
        try (NBTOutputStream out = new NBTOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(levelDatFile)));){
            out.writeTag((Tag)this.toNBT());
        }
        if (version == 19132 && this.maxHeight != 128) {
            int exp = (int)(Math.log(this.maxHeight) / Math.log(2.0));
            try (PrintWriter writer = new PrintWriter(new File(worldDir, "maxheight.txt"), "US-ASCII");){
                writer.println("#DynamicHeight Save Format 2");
                writer.println("#" + new Date());
                writer.println("height=" + exp);
            }
            writer = new PrintWriter(new File(worldDir, "Height.txt"), "US-ASCII");
            try {
                writer.println("#HeightMod 1.5");
                writer.println("#" + new Date());
                writer.println("height=" + exp);
                writer.println("version=1");
                writer.println("midheight=" + this.maxHeight + ".0");
                writer.println("waterlevel=" + (this.maxHeight / 2 - 2) + ".0");
                writer.println("genheight=" + this.maxHeight + ".0");
            }
            finally {
                writer.close();
            }
        }
    }

    public String getName() {
        return this.getString("LevelName");
    }

    public abstract long getSeed();

    public int getSpawnX() {
        return this.getInt("SpawnX");
    }

    public int getSpawnY() {
        return this.getInt("SpawnY");
    }

    public int getSpawnZ() {
        return this.getInt("SpawnZ");
    }

    public long getTime() {
        return this.getLong("Time");
    }

    public int getVersion() {
        return this.getInt("version");
    }

    public int getDataVersion() {
        return this.getInt("DataVersion");
    }

    public abstract boolean isMapFeatures();

    public int getMapHeight() {
        return this.getInt("MapHeight");
    }

    public int getGameType() {
        return this.getInt("GameType");
    }

    public boolean isHardcore() {
        return this.getBoolean("hardcore");
    }

    public abstract MapGenerator getGenerator(int var1);

    public boolean isAllowCommands() {
        return this.getBoolean("allowCommands");
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getDifficulty() {
        return this.getByte("Difficulty");
    }

    public boolean isDifficultyLocked() {
        return this.getBoolean("DifficultyLocked");
    }

    public double getBorderCenterX() {
        return this.getDouble("BorderCenterX");
    }

    public double getBorderCenterZ() {
        return this.getDouble("BorderCenterZ");
    }

    public double getBorderSize() {
        return this.getDouble("BorderSize");
    }

    public double getBorderSafeZone() {
        return this.getDouble("BorderSafeZone");
    }

    public double getBorderWarningBlocks() {
        return this.getDouble("BorderWarningBlocks");
    }

    public double getBorderWarningTime() {
        return this.getDouble("BorderWarningTime");
    }

    public double getBorderSizeLerpTarget() {
        return this.getDouble("BorderSizeLerpTarget");
    }

    public long getBorderSizeLerpTime() {
        return this.getLong("BorderSizeLerpTime");
    }

    public double getBorderDamagePerBlock() {
        return this.getDouble("BorderDamagePerBlock");
    }

    public void setName(String name) {
        this.setString("LevelName", name);
    }

    public abstract void setSeed(long var1);

    public void setSpawnX(int spawnX) {
        this.setInt("SpawnX", spawnX);
    }

    public void setSpawnY(int spawnY) {
        this.setInt("SpawnY", spawnY);
    }

    public void setSpawnZ(int spawnZ) {
        this.setInt("SpawnZ", spawnZ);
    }

    public void setTime(long time) {
        this.setLong("Time", time);
    }

    public abstract void setMapFeatures(boolean var1);

    public void setGameType(int gameType) {
        this.setInt("GameType", gameType);
    }

    public void setHardcore(boolean hardcore) {
        this.setBoolean("hardcore", hardcore);
    }

    public abstract void setGenerator(int var1, MapGenerator var2);

    public void setAllowCommands(boolean allowCommands) {
        this.setBoolean("allowCommands", allowCommands);
    }

    public void setDifficulty(int difficulty) {
        this.setByte("Difficulty", (byte)difficulty);
    }

    public void setDifficultyLocked(boolean difficultyLocked) {
        this.setBoolean("DifficultyLocked", difficultyLocked);
    }

    public void setBorderCenterX(double borderCenterX) {
        this.setDouble("BorderCenterX", borderCenterX);
    }

    public void setBorderCenterZ(double borderCenterZ) {
        this.setDouble("BorderCenterZ", borderCenterZ);
    }

    public void setBorderSize(double borderSize) {
        this.setDouble("BorderSize", borderSize);
    }

    public void setBorderSafeZone(double borderSafeZone) {
        this.setDouble("BorderSafeZone", borderSafeZone);
    }

    public void setBorderWarningBlocks(double borderWarningBlocks) {
        this.setDouble("BorderWarningBlocks", borderWarningBlocks);
    }

    public void setBorderWarningTime(double borderWarningTime) {
        this.setDouble("BorderWarningTime", borderWarningTime);
    }

    public void setBorderSizeLerpTarget(double borderSizeLerpTarget) {
        this.setDouble("BorderSizeLerpTarget", borderSizeLerpTarget);
    }

    public void setBorderSizeLerpTime(long borderSizeLerpTime) {
        this.setLong("BorderSizeLerpTime", borderSizeLerpTime);
    }

    public void setBorderDamagePerBlock(double borderDamagePerBlock) {
        this.setDouble("BorderDamagePerBlock", borderDamagePerBlock);
    }

    public void setSpawn(int x, int y, int z) {
        this.setSpawnX(x);
        this.setSpawnY(y);
        this.setSpawnZ(z);
        Map<String, Tag> playerSettings = this.getMap("Player");
        if (playerSettings == null) {
            playerSettings = new HashMap<String, Tag>();
        }
        playerSettings.put("SpawnX", (Tag)new IntTag("SpawnX", x));
        playerSettings.put("SpawnY", (Tag)new IntTag("SpawnY", y));
        playerSettings.put("SpawnZ", (Tag)new IntTag("SpawnZ", x));
        playerSettings.put("SpawnForced", (Tag)new ByteTag("SpawnForced", 1));
        playerSettings.put("Pos", (Tag)new ListTag("Pos", DoubleTag.class, Arrays.asList(new DoubleTag("", (double)x + 0.5), new DoubleTag("", (double)y), new DoubleTag("", (double)z + 0.5))));
        this.setMap("Player", playerSettings);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public CompoundTag toNBT() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("Data", super.toNBT());
        if (this.extraTags != null) {
            for (Tag extraTag : this.extraTags) {
                values.put(extraTag.getName(), extraTag);
            }
        }
        return new CompoundTag("", values);
    }

    public static void setCachedLevel(File file, JavaLevel level) {
        if (file != null || level != null) {
            Objects.requireNonNull(file, "file");
            Objects.requireNonNull(level, "level");
            if (!file.getName().equals("level.dat")) {
                throw new IllegalArgumentException(file + " is not named level.dat");
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException(file + " does not exist or is not a file");
            }
        }
        cachedFile = file;
        cachedLevel = level;
    }

    public static JavaLevel create(Platform platform, int minHeight, int maxHeight) {
        org.pepsoft.util.Version platformMcVersion = platform.getAttribute(DefaultPlugin.ATTRIBUTE_MC_VERSION);
        if (platformMcVersion.isAtLeast(Constants.V_1_18)) {
            return new Java118Level(minHeight, maxHeight, platform);
        }
        if (platformMcVersion.isAtLeast(Constants.V_1_16)) {
            return new Java116Level(minHeight, maxHeight, platform);
        }
        return new Java115Level(maxHeight, platform);
    }

    public static JavaLevel load(File levelDatFile) throws IOException {
        int maxHeight;
        int minHeight;
        int dataVersion;
        Tag tag;
        if (levelDatFile.equals(cachedFile)) {
            return cachedLevel;
        }
        try (NBTInputStream in = new NBTInputStream((InputStream)new GZIPInputStream(new FileInputStream(levelDatFile)));){
            tag = in.readTag();
        }
        CompoundTag data = (CompoundTag)((CompoundTag)tag).getTag("Data");
        File worldDir = levelDatFile.getParentFile();
        int version = ((IntTag)data.getTag("version")).getValue();
        int n = dataVersion = data.containsTag("DataVersion") ? ((IntTag)data.getTag("DataVersion")).getValue() : -1;
        if (data.containsTag("isCubicWorld") && ((ByteTag)data.getTag("isCubicWorld")).getValue() == 1) {
            minHeight = 0;
            maxHeight = 0x800000;
        } else if (data.containsTag("version")) {
            int n2 = version == 19132 ? 0 : (minHeight = dataVersion <= 2730 ? 0 : -64);
            int n3 = version == 19132 ? 128 : (maxHeight = dataVersion <= 2730 ? 256 : 320);
            if (version == 19132) {
                File maxheightFile = new File(worldDir, "maxheight.txt");
                if (!maxheightFile.isFile()) {
                    maxheightFile = new File(worldDir, "Height.txt");
                }
                if (maxheightFile.isFile()) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(maxheightFile), StandardCharsets.US_ASCII));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (!line.startsWith("height=")) continue;
                            int exp = Integer.parseInt(line.substring(7));
                            maxHeight = 1 << exp;
                            logger.debug("Map height {} detected from {} while loading {}", new Object[]{maxHeight, maxheightFile.getName(), levelDatFile});
                        }
                    }
                }
            } else if (data.containsTag("DataPacks")) {
                CompoundTag dataPacksTag = (CompoundTag)data.getTag("DataPacks");
                ListTag enabledTag = (ListTag)dataPacksTag.getTag("Enabled");
                if (enabledTag != null) {
                    boolean buildLimitsEncounterd = false;
                    for (StringTag datapackTag : enabledTag.getValue()) {
                        String name = datapackTag.getValue();
                        if (name.startsWith("file/")) {
                            try {
                                DataPack datapack = DataPack.load(worldDir, name);
                                for (Map.Entry<String, Descriptor> entry : datapack.getDescriptors().entrySet()) {
                                    if (!(entry.getValue() instanceof Dimension) || !entry.getKey().endsWith("overworld.json")) continue;
                                    int minY = ((Dimension)entry.getValue()).getMinY();
                                    int height = ((Dimension)entry.getValue()).getHeight();
                                    if (height == 0) continue;
                                    if (buildLimitsEncounterd && minY != minHeight) {
                                        throw new IllegalArgumentException(String.format("Multiple different minHeights (%d and %d) encountered in data packs", minHeight, minY));
                                    }
                                    if (buildLimitsEncounterd && minY + height != maxHeight) {
                                        throw new IllegalArgumentException(String.format("Multiple different maxHeights (%d and %d) encountered in data packs", maxHeight, minY + height));
                                    }
                                    logger.debug("Map build limits {} to {} detected from data pack {} while loading {}", new Object[]{minY, minY + height, entry.getKey(), levelDatFile});
                                    minHeight = minY;
                                    maxHeight = minY + height;
                                    buildLimitsEncounterd = true;
                                }
                                continue;
                            }
                            catch (RuntimeException e) {
                                logger.error("{} while loading data pack {}; skipping data pack (message: \"{}\")", new Object[]{e.getClass().getSimpleName(), name, e.getMessage(), e});
                                continue;
                            }
                        }
                        logger.trace("Skipping internal data pack {} while loading level {}", (Object)name, (Object)levelDatFile);
                    }
                }
            } else if (data.getTag("MapHeight") != null) {
                maxHeight = ((IntTag)data.getTag("MapHeight")).getValue();
                logger.debug("Map height {} detected from {} tag while loading {}", new Object[]{maxHeight, "MapHeight", levelDatFile});
            }
        } else {
            throw new UnsupportedOperationException("Don't know how to determine height of this map");
        }
        if (dataVersion <= 2230) {
            return new Java115Level((CompoundTag)tag, maxHeight);
        }
        if (dataVersion <= 2730) {
            return new Java116Level((CompoundTag)tag, minHeight, maxHeight);
        }
        return new Java118Level((CompoundTag)tag, minHeight, maxHeight);
    }

    private void createWorldPainterDataPack(File worldDir) {
        try {
            File datapackDir = new File(worldDir, "datapacks");
            datapackDir.mkdirs();
            File datapackFile = new File(datapackDir, "worldpainter.zip");
            DataPack datapack = new DataPack();
            datapack.addDescriptor("pack.mcmeta", Meta.builder().pack(Meta.Pack.builder().packFormat(this.platform == DefaultPlugin.JAVA_ANVIL_1_17 ? 7 : 9).description("WorldPainter Settings").build()).build());
            datapack.addDescriptor("data/minecraft/dimension_type/overworld.json", Dimension.createDefault(this.platform, 0, this.minHeight, this.maxHeight));
            datapack.write(new FileOutputStream(datapackFile));
        }
        catch (IOException e) {
            throw new MDCCapturingRuntimeException("I/O error creating datapack", (Throwable)e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(JavaLevel.class);
    }
}

