/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.util.Arrays;
import java.util.Collections;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.MathUtils;

enum HorizontalOrientationScheme {
    AXIS{

        @Override
        public Material rotate(Material material, int steps) {
            if (steps % 2 != 0) {
                String axis = material.getProperty("axis");
                if ("x".equals(axis)) {
                    return material.withProperty("axis", "z");
                }
                if ("z".equals(axis)) {
                    return material.withProperty("axis", "x");
                }
            }
            return material;
        }

        @Override
        public Direction getDirection(Material material) {
            switch (material.getProperty(Material.AXIS)) {
                case "x": {
                    return Direction.EAST;
                }
                case "z": {
                    return Direction.SOUTH;
                }
            }
            return null;
        }

        @Override
        public Material setDirection(Material material, Direction direction) {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    return material.withProperty(Material.AXIS, "z");
                }
                case EAST: 
                case WEST: {
                    return material.withProperty(Material.AXIS, "x");
                }
            }
            throw new InternalError();
        }
    }
    ,
    CARDINAL_DIRECTIONS{

        @Override
        public Material mirror(Material material, Direction axis) {
            String north = material.getProperty("north");
            String east = material.getProperty("east");
            String south = material.getProperty("south");
            String west = material.getProperty("west");
            if (axis == Direction.WEST || axis == Direction.EAST) {
                String tmp = north;
                north = south;
                south = tmp;
            } else {
                String tmp = west;
                west = east;
                east = tmp;
            }
            return material.withProperties("north", north, "east", east, "south", south, "west", west);
        }

        @Override
        public Material rotate(Material material, int steps) {
            String[] directions = new String[]{material.getProperty("north"), material.getProperty("east"), material.getProperty("south"), material.getProperty("west")};
            Collections.rotate(Arrays.asList(directions), steps);
            return material.withProperties("north", directions[0], "east", directions[1], "south", directions[2], "west", directions[3]);
        }
    }
    ,
    FACING{

        @Override
        public Material mirror(Material material, Direction axis) {
            return material.withProperty(Material.FACING, material.getProperty(Material.FACING).mirror(axis));
        }

        @Override
        public Material rotate(Material material, int steps) {
            return material.withProperty(Material.FACING, material.getProperty(Material.FACING).rotate(steps));
        }

        @Override
        public Direction getDirection(Material material) {
            return material.getProperty(Material.FACING);
        }

        @Override
        public Material setDirection(Material material, Direction direction) {
            return material.withProperty(Material.FACING, direction);
        }
    }
    ,
    ROTATION{

        @Override
        public Material mirror(Material material, Direction axis) {
            int rotation = material.getProperty(Material.ROTATION);
            switch (axis) {
                case NORTH: 
                case SOUTH: {
                    return rotation == 0 || rotation == 8 ? material : material.withProperty(Material.ROTATION, 16 - rotation);
                }
                case EAST: 
                case WEST: {
                    if (rotation == 4 || rotation == 12) {
                        return material;
                    }
                    if (rotation <= 8) {
                        return material.withProperty(Material.ROTATION, 8 - rotation);
                    }
                    return material.withProperty(Material.ROTATION, 24 - rotation);
                }
            }
            throw new InternalError();
        }

        @Override
        public Material rotate(Material material, int steps) {
            return material.withProperty(Material.ROTATION, MathUtils.mod((int)(material.getProperty(Material.ROTATION) + steps * 4), (int)16));
        }

        @Override
        public Direction getDirection(Material material) {
            return null;
        }

        @Override
        public Material setDirection(Material material, Direction direction) {
            switch (direction) {
                case SOUTH: {
                    return material.withProperty(Material.ROTATION, 0);
                }
                case WEST: {
                    return material.withProperty(Material.ROTATION, 4);
                }
                case NORTH: {
                    return material.withProperty(Material.ROTATION, 8);
                }
                case EAST: {
                    return material.withProperty(Material.ROTATION, 12);
                }
            }
            throw new InternalError();
        }
    }
    ,
    SHAPE{
        private final String[] SHAPE_VALUES = new String[]{"south_west", "ascending_north", "east_west", "north_west", "ascending_east", "north_south", "north_east", "ascending_south", "east_west", "south_east", "ascending_west", "north_south"};

        @Override
        public Material mirror(Material material, Direction axis) {
            switch (axis) {
                case NORTH: 
                case SOUTH: {
                    switch (material.getProperty(Material.SHAPE)) {
                        case "south_west": {
                            return material.withProperty(Material.SHAPE, "south_east");
                        }
                        case "north_west": {
                            return material.withProperty(Material.SHAPE, "north_east");
                        }
                        case "north_east": {
                            return material.withProperty(Material.SHAPE, "north_west");
                        }
                        case "south_east": {
                            return material.withProperty(Material.SHAPE, "south_west");
                        }
                        case "ascending_east": {
                            return material.withProperty(Material.SHAPE, "ascending_west");
                        }
                        case "ascending_west": {
                            return material.withProperty(Material.SHAPE, "ascending_east");
                        }
                    }
                    return material;
                }
                case EAST: 
                case WEST: {
                    switch (material.getProperty(Material.SHAPE)) {
                        case "south_west": {
                            return material.withProperty(Material.SHAPE, "north_west");
                        }
                        case "north_west": {
                            return material.withProperty(Material.SHAPE, "south_west");
                        }
                        case "north_east": {
                            return material.withProperty(Material.SHAPE, "south_east");
                        }
                        case "south_east": {
                            return material.withProperty(Material.SHAPE, "north_east");
                        }
                        case "ascending_north": {
                            return material.withProperty(Material.SHAPE, "ascending_south");
                        }
                        case "ascending_south": {
                            return material.withProperty(Material.SHAPE, "ascending_north");
                        }
                    }
                    return material;
                }
            }
            throw new InternalError();
        }

        @Override
        public Material rotate(Material material, int steps) {
            int index = Arrays.asList(this.SHAPE_VALUES).indexOf(material.getProperty(Material.SHAPE));
            return material.withProperty(Material.SHAPE, this.SHAPE_VALUES[MathUtils.mod((int)(index + steps * 3), (int)12)]);
        }
    }
    ,
    STAIR_CORNER{

        @Override
        public Material mirror(Material material, Direction axis) {
            switch (material.getProperty(Material.SHAPE)) {
                case "inner_left": {
                    return material.withProperty(Material.SHAPE, "inner_right");
                }
                case "inner_right": {
                    return material.withProperty(Material.SHAPE, "inner_left");
                }
                case "outer_left": {
                    return material.withProperty(Material.SHAPE, "outer_right");
                }
                case "outer_right": {
                    return material.withProperty(Material.SHAPE, "outer_left");
                }
            }
            return material;
        }
    }
    ,
    TYPE{

        @Override
        public Material mirror(Material material, Direction axis) {
            if (material.getProperty(Material.TYPE).equals("left")) {
                return material.withProperty(Material.TYPE, "right");
            }
            return material.withProperty(Material.TYPE, "left");
        }
    }
    ,
    HINGE{

        @Override
        public Material mirror(Material material, Direction axis) {
            if (material.getProperty(Material.HINGE).equals("left")) {
                return material.withProperty(Material.HINGE, "right");
            }
            return material.withProperty(Material.HINGE, "left");
        }
    };


    public Material mirror(Material material, Direction axis) {
        return material;
    }

    public Material rotate(Material material, int steps) {
        return material;
    }

    public Direction getDirection(Material material) {
        return null;
    }

    public Material setDirection(Material material, Direction direction) {
        return material;
    }
}

