/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import org.pepsoft.minecraft.ChunkFactory;
import org.pepsoft.minecraft.MC12AnvilChunk;
import org.pepsoft.minecraft.MCRegionChunk;
import org.pepsoft.minecraft.Material;

public abstract class HeightMapChunkFactory
implements ChunkFactory {
    protected final int maxHeight;
    protected final int version;

    public HeightMapChunkFactory(int maxHeight, int version) {
        this.maxHeight = maxHeight;
        this.version = version;
    }

    @Override
    public int getMinHeight() {
        return 0;
    }

    @Override
    public final int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public final ChunkFactory.ChunkCreationResult createChunk(int chunkX, int chunkZ) {
        ChunkFactory.ChunkCreationResult result = new ChunkFactory.ChunkCreationResult();
        result.chunk = this.version == 19132 ? new MCRegionChunk(chunkX, chunkZ, this.maxHeight) : new MC12AnvilChunk(chunkX, chunkZ, this.maxHeight);
        int maxY = this.maxHeight - 1;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = this.getHeight(chunkX * 16 + x, chunkZ * 16 + z);
                for (int y = 0; y <= maxY; ++y) {
                    if (y == 0) {
                        result.chunk.setMaterial(x, y, z, Material.BEDROCK);
                        continue;
                    }
                    if (y <= height - 3) {
                        result.chunk.setMaterial(x, y, z, Material.STONE);
                        continue;
                    }
                    if (y < height) {
                        result.chunk.setMaterial(x, y, z, Material.DIRT);
                        continue;
                    }
                    if (y == height) {
                        result.chunk.setMaterial(x, y, z, Material.GRASS);
                        continue;
                    }
                    result.chunk.setSkyLightLevel(x, y, z, 15);
                }
                result.chunk.setHeight(x, z, height < maxY ? height + 1 : maxY);
            }
        }
        result.chunk.setTerrainPopulated(true);
        result.stats.surfaceArea = 256L;
        result.stats.landArea = 256L;
        return result;
    }

    protected abstract int getHeight(int var1, int var2);
}

