/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import org.jnbt.Tag;

public final class IntArrayTag
extends Tag {
    private int[] value;
    private static final long serialVersionUID = 1L;

    public IntArrayTag(String name, int[] value) {
        super(name);
        this.value = value;
    }

    public int[] getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder hex = new StringBuilder();
        if (this.value.length <= 8) {
            for (int i : this.value) {
                String hexDigits = Integer.toHexString(i).toUpperCase();
                hex.append("00000000", 0, 8 - hexDigits.length());
                hex.append(hexDigits).append(" ");
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                if (i != 6) {
                    String hexDigits = Integer.toHexString(this.value[i <= 6 ? i : this.value.length - 1]).toUpperCase();
                    hex.append("00000000", 0, 8 - hexDigits.length());
                    hex.append(hexDigits).append(" ");
                    continue;
                }
                hex.append("(");
                hex.append(this.value.length - 7);
                hex.append(" more) ");
            }
        }
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Int_Array" + append + ": " + (hex.length() > 0 ? hex.substring(0, hex.length() - 1) : "empty");
    }

    @Override
    public IntArrayTag clone() {
        IntArrayTag clone = (IntArrayTag)super.clone();
        clone.value = (int[])this.value.clone();
        return clone;
    }
}

