/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.xinput;

import java.util.logging.Logger;
import jpen.PKind;
import jpen.PenManager;
import jpen.PenProvider;
import jpen.internal.BuildInfo;
import jpen.provider.AbstractPenProvider;
import jpen.provider.NativeLibraryLoader;
import jpen.provider.VirtualScreenBounds;
import jpen.provider.xinput.XiBus;
import jpen.provider.xinput.XinputDevice;

public final class XinputProvider
extends AbstractPenProvider {
    private static final Logger L = Logger.getLogger(XinputProvider.class.getName());
    private static final NativeLibraryLoader LIB_LOADER = new NativeLibraryLoader(new String[]{""}, new String[]{"x86_64"}, Integer.valueOf(BuildInfo.getProperties().getString("jpen.provider.xinput.nativeVersion")));
    private final XinputDevice[] xinputDevices;
    final VirtualScreenBounds screenBounds = VirtualScreenBounds.getInstance();

    static void loadLibrary() {
        LIB_LOADER.load();
    }

    private XinputProvider(Constructor constructor) throws Exception {
        super(constructor);
        L.fine("start");
        XiBus xiBus = new XiBus();
        int xiDeviceIndex = xiBus.getXiDevicesSize();
        while (--xiDeviceIndex >= 0) {
            XiBus xiBus2 = new XiBus();
            try {
                xiBus2.setXiDevice(xiDeviceIndex);
            }
            catch (Exception ex) {
                continue;
            }
            XinputDevice xinputDevice = new XinputDevice(this, xiBus2.getXiDevice());
            this.devices.add(xinputDevice);
        }
        this.xinputDevices = this.devices.toArray(new XinputDevice[this.devices.size()]);
        if (this.devices.size() == 1) {
            this.xinputDevices[0].setKindTypeNumber(PKind.Type.STYLUS.ordinal());
        }
        L.fine("end");
    }

    private void resetXinputDevices() {
        int i = this.xinputDevices.length;
        while (--i >= 0) {
            this.xinputDevices[i].reset();
        }
    }

    private void pauseXinputDevices(boolean paused) {
        int i = this.xinputDevices.length;
        while (--i >= 0) {
            this.xinputDevices[i].setIsListening(!paused);
        }
    }

    public void penManagerPaused(boolean paused) {
        this.pauseXinputDevices(paused);
        if (!paused) {
            this.screenBounds.reset();
            this.resetXinputDevices();
        }
    }

    public static class Constructor
    extends AbstractPenProvider.AbstractConstructor {
        public String getName() {
            return "XInput";
        }

        public boolean constructable(PenManager penManager) {
            String os = System.getProperty("os.name").toLowerCase();
            return os.contains("linux") || os.contains("bsd");
        }

        public PenProvider constructProvider() throws Throwable {
            XinputProvider.loadLibrary();
            return new XinputProvider(this);
        }

        public int getNativeVersion() {
            return LIB_LOADER.nativeVersion;
        }

        public int getNativeBuild() {
            XinputProvider.loadLibrary();
            return XiBus.getNativeBuild();
        }

        public int getExpectedNativeBuild() {
            return Integer.valueOf(BuildInfo.getProperties().getString("jpen.provider.xinput.nativeBuild"));
        }
    }
}

