/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.xinput;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jpen.PKind;
import jpen.PLevel;
import jpen.PScroll;
import jpen.internal.ObjectUtils;
import jpen.internal.Range;
import jpen.provider.AbstractPenDevice;
import jpen.provider.xinput.XiDevice;
import jpen.provider.xinput.XinputProvider;

final class XinputDevice
extends AbstractPenDevice {
    private static final Logger L = Logger.getLogger(XinputDevice.class.getName());
    private final XiDevice xiDevice;
    private final Range[] levelRanges;
    private final XinputProvider xinputProvider;
    private final Point2D.Float componentLocation = new Point2D.Float();
    private final Dimension componentSize = new Dimension();
    private final boolean isPad;
    private final Thread thread;
    private boolean isListening;
    private final List<PLevel> changedLevels = new ArrayList<PLevel>();
    private static final float RADS_PER_DEG = (float)Math.PI / 180;
    private static final float PI_2 = (float)Math.PI * 2;

    XinputDevice(XinputProvider xinputProvider, XiDevice xiDevice) {
        super(xinputProvider);
        this.xiDevice = xiDevice;
        this.xinputProvider = xinputProvider;
        this.levelRanges = new Range[PLevel.Type.VALUES.size()];
        this.resetLevelRanges();
        this.isPad = this.getName().toLowerCase().contains(" pad");
        this.setKindTypeNumber(this.getDefaultKindTypeNumber());
        this.thread = new Thread("jpen-XinputDevice-" + this.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    if (!XinputDevice.this.isWorking()) {
                        ObjectUtils.synchronizedWait(this, 0L);
                        continue;
                    }
                    if (XinputDevice.this.xiDevice.waitNextEvent()) {
                        XinputDevice.this.processLastEvent();
                        continue;
                    }
                    XinputDevice xinputDevice = XinputDevice.this;
                    synchronized (xinputDevice) {
                    }
                }
            }
        };
        this.thread.setPriority(10);
        this.thread.setDaemon(true);
        this.thread.start();
        this.setEnabled(true);
    }

    private synchronized boolean isWorking() {
        return this.getIsListening() && this.getEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setIsListening(boolean isListening) {
        if (this.isListening == isListening) {
            return;
        }
        this.isListening = isListening;
        this.xiDevice.stopWaitingNextEvent();
        this.xiDevice.setIsListening(isListening);
        Thread thread = this.thread;
        synchronized (thread) {
            this.thread.notify();
        }
    }

    private synchronized boolean getIsListening() {
        return this.isListening;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setEnabled(boolean enabled) {
        if (this.getEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        Thread thread = this.thread;
        synchronized (thread) {
            this.thread.notify();
        }
    }

    public synchronized boolean getEnabled() {
        return super.getEnabled();
    }

    public synchronized String getName() {
        this.xiDevice.stopWaitingNextEvent();
        return this.xiDevice.getName();
    }

    public synchronized boolean getIsAbsoluteMode() {
        this.xiDevice.stopWaitingNextEvent();
        return this.xiDevice.getIsAbsoluteMode();
    }

    synchronized void reset() {
        this.xiDevice.stopWaitingNextEvent();
        while (this.xiDevice.nextEvent()) {
        }
        this.resetLevelRanges();
    }

    private void resetLevelRanges() {
        this.xiDevice.refreshLevelRanges();
        int i = PLevel.Type.VALUES.size();
        while (--i >= 0) {
            PLevel.Type levelType = PLevel.Type.VALUES.get(i);
            this.levelRanges[levelType.ordinal()] = this.xiDevice.getLevelRange(levelType);
        }
    }

    private int getDefaultKindTypeNumber() {
        if (this.isPad) {
            return PKind.Type.IGNORE.ordinal();
        }
        String lowerCaseName = this.getName().toLowerCase();
        if (lowerCaseName.contains("eraser")) {
            return PKind.Type.ERASER.ordinal();
        }
        if (lowerCaseName.contains("cursor")) {
            return PKind.Type.CURSOR.ordinal();
        }
        Range pressureRange = this.levelRanges[PLevel.Type.PRESSURE.ordinal()];
        return pressureRange.max - pressureRange.min > 1.0f ? PKind.Type.STYLUS.ordinal() : PKind.Type.CURSOR.ordinal();
    }

    private void processLastEvent() {
        XiDevice.EventType eventType = this.xiDevice.getLastEventType();
        switch (eventType) {
            case MOTION_NOTIFY: {
                this.scheduleLevelEvent();
                break;
            }
        }
    }

    private void scheduleScrollEvent(int number) {
        this.getPenManager().scheduleScrollEvent(this, this.xiDevice.getLastEventTime(), new PScroll(number == 5 ? PScroll.Type.DOWN.ordinal() : PScroll.Type.UP.ordinal(), 1));
    }

    private void scheduleLevelEvent() {
        int i = PLevel.Type.VALUES.size();
        while (--i >= 0) {
            PLevel.Type levelType = PLevel.Type.VALUES.get(i);
            float value = this.getMultRangedValue(levelType);
            this.changedLevels.add(new PLevel(levelType, value));
        }
        this.getPenManager().scheduleLevelEvent(this, this.xiDevice.getLastEventTime(), this.changedLevels, true);
        this.changedLevels.clear();
    }

    private final float getMultRangedValue(PLevel.Type levelType) {
        boolean isRotation = PLevel.Type.ROTATION.equals((Object)levelType);
        if (isRotation) {
            levelType = PLevel.Type.SIDE_PRESSURE;
        }
        float devValue = this.xiDevice.getValue(levelType);
        if (PLevel.Type.TILT_TYPES.contains((Object)levelType)) {
            return devValue * ((float)Math.PI / 180);
        }
        devValue = this.levelRanges[levelType.ordinal()].getRangedValue(devValue);
        if (isRotation) {
            return devValue * ((float)Math.PI * 2);
        }
        if (PLevel.Type.MOVEMENT_TYPES.contains((Object)levelType)) {
            devValue = this.xinputProvider.screenBounds.getLevelRangeOffset(levelType) + devValue * this.xinputProvider.screenBounds.getLevelRangeMult(levelType);
        }
        return devValue;
    }
}

