/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.pepsoft.worldpainter.vo.AttributeKeyVO;

public final class EventVO
implements Serializable {
    private final String key;
    private Map<AttributeKeyVO<? extends Serializable>, Serializable> attributes;
    public static final AttributeKeyVO<Long> ATTRIBUTE_COUNT = new AttributeKeyVO("count");
    public static final AttributeKeyVO<Long> ATTRIBUTE_DURATION = new AttributeKeyVO("duration");
    public static final AttributeKeyVO<Date> ATTRIBUTE_TIMESTAMP = new AttributeKeyVO("timestamp");
    private static final long serialVersionUID = 1L;

    public EventVO(String key) {
        this.key = key;
    }

    public EventVO count(long count) {
        this.setAttribute(ATTRIBUTE_COUNT, count);
        return this;
    }

    public EventVO duration(long duration) {
        this.setAttribute(ATTRIBUTE_DURATION, duration);
        return this;
    }

    public EventVO addTimestamp() {
        this.setAttribute(ATTRIBUTE_TIMESTAMP, new Date());
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, Serializable> getAttributes() {
        return this.attributes != null ? this.attributes.entrySet().stream().collect(Collectors.toMap(entry -> ((AttributeKeyVO)entry.getKey()).getKey(), Map.Entry::getValue)) : null;
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        this.attributes = attributes != null ? attributes.entrySet().stream().collect(Collectors.toMap(entry -> new AttributeKeyVO((String)entry.getKey()), Map.Entry::getValue)) : null;
    }

    public <T extends Serializable> EventVO setAttribute(AttributeKeyVO<T> key, T value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<AttributeKeyVO<? extends Serializable>, Serializable>();
            }
            this.attributes.put(key, value);
        } else if (this.attributes != null && this.attributes.containsKey(key)) {
            this.attributes.remove(key);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
        return this;
    }

    public <T extends Serializable> T getAttribute(AttributeKeyVO<T> key) {
        if (this.attributes != null) {
            return (T)this.attributes.get(key);
        }
        return null;
    }

    public String toString() {
        return "EventVO{key=" + this.key + ", attributes=" + this.attributes + '}';
    }
}

