/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Util;
import com.install4j.runtime.beans.applications.ExecutionMode;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.InstallerWizardScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.InstallerConsoleScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.InstallerUnattendedScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.NativeLogger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class Installer {
    private static String manualTempDir;

    public static void setManualTempDir(String manualTempDir) {
        if (manualTempDir != null) {
            if (manualTempDir.startsWith("\"") || manualTempDir.startsWith("'")) {
                manualTempDir = manualTempDir.substring(1);
            }
            if (manualTempDir.endsWith("\"") || manualTempDir.endsWith("'")) {
                manualTempDir = manualTempDir.substring(0, manualTempDir.length() - 1);
            }
        }
        Installer.manualTempDir = manualTempDir;
    }

    public static String getManualTempDir() {
        return manualTempDir;
    }

    private Installer() {
    }

    public static void main(String[] args) {
        if (!HelperCommunication.executeAsHelper(args)) {
            try {
                InstallerUtil.setInProcess(false);
                Installer.runInProcess(args);
            }
            catch (Throwable t) {
                InstallerUtil.reportException(t);
                System.exit(1);
            }
        }
    }

    public static void runInProcess(String[] args) {
        InstallerConfig.setCurrentApplicationId("installer");
        if (!InstallerUtil.isInProcess()) {
            NativeLogger.registerCleanup();
        }
        ScreenExecutor screenExecutor = Installer.getScreenExecutor(InstallerUtil.parseCommandLine(args), false, null);
        new Controller(screenExecutor).start();
    }

    static ScreenExecutor getScreenExecutor(InstallerUtil.CommandLineOptions commandLineOptions, boolean dialog, Window parentWindow) {
        ScreenExecutor screenExecutor;
        Installer.setManualTempDir(commandLineOptions.manualTempDir);
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        if (commandLineOptions.installDir != null) {
            config.setInstallationDirectory(commandLineOptions.installDir);
            InstallerVariables.setInstallationDirectoryFromCommandLine(true);
        }
        ExecutionMode executionMode = InstallerUtil.getExecutionMode(commandLineOptions, false);
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> System.err.println(Util.getAnnotatedStackTrace(e)));
        if (executionMode == ExecutionMode.UNATTENDED || executionMode == ExecutionMode.UNATTENDED_WITH_PROGRESS) {
            InstallerUtil.setUnattended(true);
            screenExecutor = new InstallerUnattendedScreenExecutor(commandLineOptions.quietOverwrite, commandLineOptions.noFileFailures, commandLineOptions.wait, InstallerUtil.getSplash(commandLineOptions, executionMode), InstallerUtil.isUnattendedAlerts(commandLineOptions, executionMode), dialog, parentWindow);
        } else if (executionMode == ExecutionMode.CONSOLE) {
            InstallerUtil.setConsole(true);
            screenExecutor = new InstallerConsoleScreenExecutor();
        } else {
            ScreenExecutor[] screenExecutors = new ScreenExecutor[1];
            try {
                SwingUtilities.invokeAndWait(() -> {
                    screenExecutors[0] = new InstallerWizardScreenExecutor(dialog, parentWindow);
                });
            }
            catch (InterruptedException | InvocationTargetException e2) {
                throw new RuntimeException(e2);
            }
            screenExecutor = screenExecutors[0];
        }
        InstallerVariables.initCommandLine(commandLineOptions.varFileName, commandLineOptions.commandLineVars);
        return screenExecutor;
    }
}

