/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Window;
import org.pepsoft.util.ProgressHelperWindowsJava8;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;

abstract class ProgressHelper {
    private static final ProgressHelper IMPL;

    ProgressHelper() {
    }

    static ProgressHelper getInstance() {
        return IMPL;
    }

    abstract void setProgress(Window var1, int var2);

    abstract void setProgressDone(Window var1);

    abstract void setProgressError(Window var1);

    static {
        if (SystemUtils.JAVA_VERSION.isAtLeast(SystemUtils.JAVA_9)) {
            try {
                IMPL = (ProgressHelper)Class.forName("org.pepsoft.util.ProgressHelperJava9").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new MDCCapturingRuntimeException(e.getClass().getSimpleName() + " while loading progress reporting support for Java 9", (Throwable)e);
            }
        } else {
            IMPL = SystemUtils.isWindows() ? new ProgressHelperWindowsJava8() : new ProgressHelper(){

                @Override
                void setProgress(Window window, int percentage) {
                }

                @Override
                void setProgressDone(Window window) {
                }

                @Override
                void setProgressError(Window window) {
                }
            };
        }
    }
}

