/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.web;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dynmap.Log;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.servlet.FilterHolder;

public class FilterHandler
extends AbstractHandler {
    private Handler handler;
    private LinkedList<FilterHolder> filters = new LinkedList();

    public FilterHandler() {
    }

    public FilterHandler(Handler handler, Iterable<Filter> filters) {
        this.handler = handler;
        for (Filter f : filters) {
            try {
                FilterHolder holder = new FilterHolder(f);
                holder.start();
                holder.initialize();
                this.filters.add(holder);
            }
            catch (Exception e) {
                Log.severe("Failed to initialize filter holder: " + e.toString());
            }
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Iterable<FilterHolder> getFilters() {
        return this.filters;
    }

    public void addFilter(Filter filter) {
        this.filters.add(new FilterHolder(filter));
    }

    public void handle(final String target, final Request baseRequest, final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        final Handler handler = this.getHandler();
        final Iterator<FilterHolder> iterator = this.getFilters().iterator();
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest re, ServletResponse rs) throws IOException, ServletException {
                if (iterator.hasNext()) {
                    Filter f = ((FilterHolder)iterator.next()).getFilter();
                    f.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)this);
                } else {
                    handler.handle(target, baseRequest, request, response);
                }
            }
        };
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

