/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.dynmap.modsupport.CuboidBlockModel;
import org.dynmap.modsupport.impl.BlockModelImpl;
import org.dynmap.modsupport.impl.ModModelDefinitionImpl;

public class CuboidBlockModelImpl
extends BlockModelImpl
implements CuboidBlockModel {
    private ArrayList<Cuboid> cuboids = new ArrayList();
    private ArrayList<Crossed> crosseds = new ArrayList();

    @Deprecated
    public CuboidBlockModelImpl(int blkid, ModModelDefinitionImpl mdf) {
        super(blkid, mdf);
    }

    public CuboidBlockModelImpl(String blkname, ModModelDefinitionImpl mdf) {
        super(blkname, mdf);
    }

    public void addCuboid(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax, int[] patchIndices) {
        Cuboid c = new Cuboid();
        c.xmin = xmin;
        c.xmax = xmax;
        c.ymin = ymin;
        c.ymax = ymax;
        c.zmin = zmin;
        c.zmax = zmax;
        c.textureidx = patchIndices != null ? Arrays.copyOf(patchIndices, 6) : new int[]{0, 1, 2, 3, 4, 5};
        this.cuboids.add(c);
    }

    public void addCrossedPatches(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax, int patchIndex) {
        Crossed c = new Crossed();
        c.xmin = xmin;
        c.xmax = xmax;
        c.ymin = ymin;
        c.ymax = ymax;
        c.zmin = zmin;
        c.zmax = zmax;
        c.textureidx = patchIndex;
        this.crosseds.add(c);
    }

    @Override
    public String getLine() {
        Object c;
        int i;
        String ids = this.getIDsAndMeta();
        if (ids == null) {
            return null;
        }
        String line = String.format(Locale.US, "customblock:%s,class=org.dynmap.hdmap.renderer.CuboidRenderer", ids);
        for (i = 0; i < this.cuboids.size(); ++i) {
            c = this.cuboids.get(i);
            line = line + String.format(Locale.US, ",cuboid%d=%f:%f:%f/%f:%f:%f/%d:%d:%d:%d:%d:%d", i, ((Cuboid)c).xmin, ((Cuboid)c).ymin, ((Cuboid)c).zmin, ((Cuboid)c).xmax, ((Cuboid)c).ymax, ((Cuboid)c).zmax, ((Cuboid)c).textureidx[0], ((Cuboid)c).textureidx[1], ((Cuboid)c).textureidx[4], ((Cuboid)c).textureidx[5], ((Cuboid)c).textureidx[2], ((Cuboid)c).textureidx[3]);
        }
        for (i = 0; i < this.crosseds.size(); ++i) {
            c = this.crosseds.get(i);
            line = line + String.format(Locale.US, ",cross%d=%f:%f:%f/%f:%f:%f/%d", i, ((Crossed)c).xmin, ((Crossed)c).ymin, ((Crossed)c).zmin, ((Crossed)c).xmax, ((Crossed)c).ymax, ((Crossed)c).zmax, ((Crossed)c).textureidx);
        }
        return line;
    }

    private static class Crossed {
        double xmin;
        double ymin;
        double zmin;
        double xmax;
        double ymax;
        double zmax;
        int textureidx;

        private Crossed() {
        }
    }

    private static class Cuboid {
        double xmin;
        double ymin;
        double zmin;
        double xmax;
        double ymax;
        double zmax;
        int[] textureidx;

        private Cuboid() {
        }
    }
}

