/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.markers.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dynmap.ConfigurationNode;
import org.dynmap.markers.PlayerSet;
import org.dynmap.markers.impl.MarkerAPIImpl;

class PlayerSetImpl
implements PlayerSet {
    private String setid;
    private HashSet<String> players;
    private boolean symmetric;
    private boolean ispersistent;

    PlayerSetImpl(String id) {
        this.setid = id;
        this.players = new HashSet();
        this.symmetric = true;
    }

    PlayerSetImpl(String id, boolean symmetric, Set<String> players, boolean persistent) {
        this.setid = id;
        this.symmetric = symmetric;
        this.players = new HashSet<String>(players);
        this.ispersistent = persistent;
    }

    void cleanup() {
        this.players.clear();
    }

    public String getSetID() {
        return this.setid;
    }

    public boolean isPersistentSet() {
        return this.ispersistent;
    }

    public void deleteSet() {
        MarkerAPIImpl.removePlayerSet(this);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
        this.cleanup();
    }

    Map<String, Object> getPersistentData() {
        if (!this.ispersistent) {
            return null;
        }
        HashMap<String, Object> setnode = new HashMap<String, Object>();
        ArrayList<String> playlist = new ArrayList<String>(this.players);
        setnode.put("players", playlist);
        setnode.put("symmetric", this.symmetric);
        return setnode;
    }

    boolean loadPersistentData(ConfigurationNode node) {
        List plist = node.getList("players");
        if (plist != null) {
            this.players.clear();
            for (String id : plist) {
                this.players.add(id.toLowerCase());
            }
        }
        this.symmetric = node.getBoolean("symmetric", true);
        this.ispersistent = true;
        return true;
    }

    public void setSymmetricSet(boolean symmetric) {
        if (this.symmetric != symmetric) {
            this.symmetric = symmetric;
            MarkerAPIImpl.playerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    public boolean isSymmetricSet() {
        return this.symmetric;
    }

    public Set<String> getPlayers() {
        return this.players;
    }

    public void setPlayers(Set<String> players) {
        if (players.size() == this.players.size()) {
            boolean match = true;
            for (String s : players) {
                if (this.players.contains(s.toLowerCase())) continue;
                match = false;
                break;
            }
            if (match) {
                return;
            }
        }
        this.players.clear();
        for (String id : players) {
            this.players.add(id.toLowerCase());
        }
        MarkerAPIImpl.playerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    public void addPlayer(String player) {
        if (!this.players.add(player = player.toLowerCase())) {
            return;
        }
        MarkerAPIImpl.playerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    public void removePlayer(String player) {
        if (!this.players.remove(player = player.toLowerCase())) {
            return;
        }
        MarkerAPIImpl.playerSetUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    public boolean isPlayerInSet(String player) {
        player = player.toLowerCase();
        return this.players.contains(player);
    }
}

