/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class BoxStateRenderer
extends CustomRenderer {
    private RenderPatch[][] models;

    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        double xmin = 0.0;
        double xmax = 1.0;
        double ymin = 0.0;
        double ymax = 1.0;
        double zmin = 0.0;
        double zmax = 1.0;
        String lim = custparm.get("xmin");
        if (lim != null && (xmin = Double.valueOf(lim).doubleValue()) < 0.0) {
            xmin = 0.0;
        }
        if ((lim = custparm.get("xmax")) != null && (xmax = Double.valueOf(lim).doubleValue()) > 1.0) {
            xmax = 1.0;
        }
        if ((lim = custparm.get("ymin")) != null && (ymin = Double.valueOf(lim).doubleValue()) < 0.0) {
            ymin = 0.0;
        }
        if ((lim = custparm.get("ymax")) != null && (ymax = Double.valueOf(lim).doubleValue()) > 1.0) {
            ymax = 1.0;
        }
        if ((lim = custparm.get("zmin")) != null && (zmin = Double.valueOf(lim).doubleValue()) < 0.0) {
            zmin = 0.0;
        }
        if ((lim = custparm.get("zmax")) != null && (zmax = Double.valueOf(lim).doubleValue()) > 1.0) {
            zmax = 1.0;
        }
        DynmapBlockState bs = DynmapBlockState.getBaseStateByName((String)blkname);
        this.models = new RenderPatch[bs.getStateCount()][];
        int[] patchlist = new int[6];
        for (int i = 0; i < this.models.length; ++i) {
            DynmapBlockState cbs = bs.getState(i);
            ArrayList list = new ArrayList();
            Object[] states = cbs.stateList;
            patchlist[0] = Arrays.binarySearch(states, "down=true") >= 0 ? 1 : 0;
            patchlist[1] = Arrays.binarySearch(states, "up=true") >= 0 ? 3 : 2;
            patchlist[2] = Arrays.binarySearch(states, "west=true") >= 0 ? 5 : 4;
            patchlist[3] = Arrays.binarySearch(states, "east=true") >= 0 ? 7 : 6;
            patchlist[4] = Arrays.binarySearch(states, "north=true") >= 0 ? 9 : 8;
            patchlist[5] = Arrays.binarySearch(states, "south=true") >= 0 ? 11 : 10;
            CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)xmin, (double)xmax, (double)ymin, (double)ymax, (double)zmin, (double)zmax, (int[])patchlist);
            this.models[i] = list.toArray(new RenderPatch[patchlist.length]);
        }
        return true;
    }

    public int getMaximumTextureCount() {
        return 12;
    }

    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        return this.models[ctx.getBlockType().stateIndex];
    }

    public boolean isOnlyBlockStateSensitive() {
        return true;
    }
}

