/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapWorld;
import org.dynmap.MapTile;
import org.dynmap.utils.TileFlags;
import org.json.simple.JSONObject;

public abstract class MapType {
    private boolean is_protected;
    protected int tileupdatedelay;
    private static final ImageVariant[] defVariant = new ImageVariant[]{ImageVariant.STANDARD};

    public abstract void addMapTiles(List<MapTile> var1, DynmapWorld var2, int var3, int var4);

    public abstract List<TileFlags.TileCoord> getTileCoords(DynmapWorld var1, int var2, int var3, int var4);

    public abstract List<TileFlags.TileCoord> getTileCoords(DynmapWorld var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract MapTile[] getAdjecentTiles(MapTile var1);

    public abstract List<DynmapChunk> getRequiredChunks(MapTile var1);

    public abstract int getTileSize();

    public void buildClientConfiguration(JSONObject worldObject, DynmapWorld w) {
    }

    public List<MapTile> getTiles(DynmapWorld w, int x, int y, int z) {
        List<TileFlags.TileCoord> coords = this.getTileCoords(w, x, y, z);
        ArrayList<MapTile> tiles = new ArrayList<MapTile>();
        for (TileFlags.TileCoord c : coords) {
            this.addMapTiles(tiles, w, c.x, c.y);
        }
        return tiles;
    }

    public abstract String getName();

    public abstract List<MapType> getMapsSharingRender(DynmapWorld var1);

    public abstract List<String> getMapNamesSharingRender(DynmapWorld var1);

    public int getMapZoomOutLevels() {
        return 0;
    }

    public ImageFormat getImageFormat() {
        return ImageFormat.FORMAT_PNG;
    }

    public int getBackgroundARGBNight() {
        return 0;
    }

    public int getBackgroundARGBDay() {
        return 0;
    }

    public int getBackgroundARGB(ImageVariant var) {
        if (var == ImageVariant.DAY) {
            return this.getBackgroundARGBDay();
        }
        return this.getBackgroundARGBNight();
    }

    public void purgeOldTiles(DynmapWorld world, TileFlags rendered) {
    }

    protected void walkMapTree(File root, FileCallback cb, boolean day) {
        LinkedList<File> dirs = new LinkedList<File>();
        String ext = "." + this.getImageFormat().getFileExt();
        dirs.add(root);
        while (!dirs.isEmpty()) {
            File dir = (File)dirs.pop();
            String[] lst = dir.list();
            if (lst == null) continue;
            for (String fn : lst) {
                if (fn.equals(".") || fn.equals("..")) continue;
                File f = new File(dir, fn);
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                if (!fn.endsWith(ext)) continue;
                cb.fileFound(f, dir, day);
            }
        }
    }

    public ConfigurationNode saveConfiguration() {
        ConfigurationNode cn = new ConfigurationNode();
        cn.put("class", (Object)this.getClass().getName());
        cn.put("name", (Object)this.getName());
        return cn;
    }

    public boolean isProtected() {
        return this.is_protected;
    }

    public boolean setProtected(boolean p) {
        if (this.is_protected != p) {
            this.is_protected = p;
            return true;
        }
        return false;
    }

    public abstract String getPrefix();

    public int getTileUpdateDelay(DynmapWorld w) {
        if (this.tileupdatedelay > 0) {
            return this.tileupdatedelay;
        }
        return w.getTileUpdateDelay();
    }

    public boolean setTileUpdateDelay(int delay) {
        if (this.tileupdatedelay != delay) {
            this.tileupdatedelay = delay;
            return true;
        }
        return false;
    }

    public ImageVariant[] getVariants() {
        return defVariant;
    }

    public static interface FileCallback {
        public void fileFound(File var1, File var2, boolean var3);
    }

    public static class ZoomInfo {
        public String prefix;
        public int background_argb;

        public ZoomInfo(String pre, int bg) {
            this.prefix = pre;
            this.background_argb = bg;
        }
    }

    public static enum ImageFormat {
        FORMAT_PNG("png", 0.0f, ImageEncoding.PNG),
        FORMAT_JPG75("jpg-q75", 0.75f, ImageEncoding.JPG),
        FORMAT_JPG80("jpg-q80", 0.8f, ImageEncoding.JPG),
        FORMAT_JPG85("jpg-q85", 0.85f, ImageEncoding.JPG),
        FORMAT_JPG("jpg", 0.85f, ImageEncoding.JPG),
        FORMAT_JPG90("jpg-q90", 0.9f, ImageEncoding.JPG),
        FORMAT_JPG95("jpg-q95", 0.95f, ImageEncoding.JPG),
        FORMAT_JPG100("jpg-q100", 1.0f, ImageEncoding.JPG),
        FORMAT_WEBP75("webp-q75", 75.0f, ImageEncoding.WEBP),
        FORMAT_WEBP80("webp-q80", 80.0f, ImageEncoding.WEBP),
        FORMAT_WEBP85("webp-q85", 85.0f, ImageEncoding.WEBP),
        FORMAT_WEBP("webp", 85.0f, ImageEncoding.WEBP),
        FORMAT_WEBP90("webp-q90", 90.0f, ImageEncoding.WEBP),
        FORMAT_WEBP95("webp-q95", 95.0f, ImageEncoding.WEBP),
        FORMAT_WEBP100("webp-q100", 100.0f, ImageEncoding.WEBP),
        FORMAT_WEBPL("webp-l", 85.0f, ImageEncoding.WEBP);

        String id;
        float qual;
        ImageEncoding enc;

        private ImageFormat(String id, float quality, ImageEncoding enc) {
            this.id = id;
            this.qual = quality;
            this.enc = enc;
        }

        public String getID() {
            return this.id;
        }

        public String getFileExt() {
            return this.enc.getFileExt();
        }

        public float getQuality() {
            return this.qual;
        }

        public ImageEncoding getEncoding() {
            return this.enc;
        }

        public static ImageFormat fromID(String imgfmt) {
            for (ImageFormat i_f : ImageFormat.values()) {
                if (!i_f.getID().equals(imgfmt)) continue;
                return i_f;
            }
            return null;
        }
    }

    public static enum ImageEncoding {
        PNG("png", "image/png", true),
        JPG("jpg", "image/jpeg", false),
        WEBP("webp", "image/webp", true);

        public final String ext;
        public final String mimetype;
        public final boolean hasAlpha;

        private ImageEncoding(String ext, String mime, boolean has_alpha) {
            this.ext = ext;
            this.mimetype = mime;
            this.hasAlpha = has_alpha;
        }

        public String getFileExt() {
            return this.ext;
        }

        public String getContentType() {
            return this.mimetype;
        }

        public static ImageEncoding fromOrd(int ix) {
            ImageEncoding[] v = ImageEncoding.values();
            if (ix >= 0 && ix < v.length) {
                return v[ix];
            }
            return null;
        }

        public static ImageEncoding fromContentType(String ct) {
            ImageEncoding[] v = ImageEncoding.values();
            for (int i = 0; i < v.length; ++i) {
                if (!v[i].mimetype.equalsIgnoreCase(ct)) continue;
                return v[i];
            }
            return null;
        }

        public static ImageEncoding fromExt(String x) {
            ImageEncoding[] v = ImageEncoding.values();
            for (int i = 0; i < v.length; ++i) {
                if (!v[i].ext.equalsIgnoreCase(x)) continue;
                return v[i];
            }
            return null;
        }
    }

    public static enum ImageVariant {
        STANDARD(""),
        DAY("day");

        public final String variantSuffix;
        public final String variantID;

        private ImageVariant(String varid) {
            this.variantSuffix = varid.length() > 0 ? "_" + varid : "";
            this.variantID = varid;
        }
    }
}

