/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

public class Color {
    private int val;
    public static final int TRANSPARENT = 0;

    public Color(int red, int green, int blue, int alpha) {
        this.setRGBA(red, green, blue, alpha);
    }

    public Color(int red, int green, int blue) {
        this.setRGBA(red, green, blue, 255);
    }

    public Color() {
        this.setTransparent();
    }

    public final int getRed() {
        return this.val >> 16 & 0xFF;
    }

    public final int getGreen() {
        return this.val >> 8 & 0xFF;
    }

    public final int getBlue() {
        return this.val & 0xFF;
    }

    public final int getAlpha() {
        return this.val >> 24 & 0xFF;
    }

    public final boolean isTransparent() {
        return (this.val & 0xFF000000) == 0;
    }

    public final void setTransparent() {
        this.val = 0;
    }

    public final void setGrayscale() {
        int alpha = this.val >> 24 & 0xFF;
        int red = this.val >> 16 & 0xFF;
        int green = this.val >> 8 & 0xFF;
        int blue = this.val & 0xFF;
        int gray = (red * 76 + green * 151 + blue * 28) / 255;
        this.setRGBA(gray, gray, gray, alpha);
    }

    public final void setColor(Color c) {
        this.val = c.val;
    }

    public final void setRGBA(int red, int green, int blue, int alpha) {
        this.val = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public final int getARGB() {
        return this.val;
    }

    public final void setARGB(int c) {
        this.val = c;
    }

    public final int getComponent(int idx) {
        return 0xFF & this.val >> (3 - idx) * 8;
    }

    public final void setAlpha(int v) {
        this.val = this.val & 0xFFFFFF | v << 24;
    }

    public final void scaleColor(Color minimum, Color maximum) {
        int alpha = this.val >> 24 & 0xFF;
        int red = this.val >> 16 & 0xFF;
        int green = this.val >> 8 & 0xFF;
        int blue = this.val & 0xFF;
        red = minimum.getRed() + (maximum.getRed() - minimum.getRed()) * red / 256;
        green = minimum.getGreen() + (maximum.getGreen() - minimum.getGreen()) * green / 256;
        blue = minimum.getBlue() + (maximum.getBlue() - minimum.getBlue()) * blue / 256;
        this.setRGBA(red, green, blue, alpha);
    }

    public final void blendColor(Color c) {
        this.blendColor(c.val);
    }

    public final void blendColor(int argb) {
        int nval = (this.val >> 24 & 0xFF) * (argb >> 24 & 0xFF) / 255 << 24;
        nval |= (this.val >> 16 & 0xFF) * (argb >> 16 & 0xFF) / 255 << 16;
        nval |= (this.val >> 8 & 0xFF) * (argb >> 8 & 0xFF) / 255 << 8;
        this.val = nval |= (this.val & 0xFF) * (argb & 0xFF) / 255;
    }

    public static final int blendColor(int argb0, int argb1) {
        int nval = (argb0 >> 24 & 0xFF) * (argb1 >> 24 & 0xFF) / 255 << 24;
        nval |= (argb0 >> 16 & 0xFF) * (argb1 >> 16 & 0xFF) / 255 << 16;
        nval |= (argb0 >> 8 & 0xFF) * (argb1 >> 8 & 0xFF) / 255 << 8;
        return nval |= (argb0 & 0xFF) * (argb1 & 0xFF) / 255;
    }
}

