/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.List;
import org.dynmap.Client;
import org.dynmap.ClientUpdateEvent;
import org.dynmap.Component;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.Event;
import org.dynmap.JSONUtils;
import org.dynmap.MapManager;
import org.dynmap.common.DynmapPlayer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ClientUpdateComponent
extends Component {
    private int hideifshadow;
    private int hideifunder;
    private boolean hideifsneaking;
    private boolean hideifinvisiblepotion;
    private boolean is_protected;
    public static boolean usePlayerColors;
    public static boolean hideNames;

    public ClientUpdateComponent(DynmapCore core, ConfigurationNode configuration) {
        super(core, configuration);
        hideNames = configuration.getBoolean("hidenames", false);
        this.hideifshadow = configuration.getInteger("hideifshadow", 15);
        this.hideifunder = configuration.getInteger("hideifundercover", 15);
        this.hideifsneaking = configuration.getBoolean("hideifsneaking", false);
        this.hideifinvisiblepotion = configuration.getBoolean("hide-if-invisiblity-potion", true);
        this.is_protected = configuration.getBoolean("protected-player-info", false);
        usePlayerColors = configuration.getBoolean("use-name-colors", false);
        if (this.is_protected) {
            core.player_info_protected = true;
        }
        core.events.addListener("buildclientupdate", new Event.Listener<ClientUpdateEvent>(){

            @Override
            public void triggered(ClientUpdateEvent e) {
                ClientUpdateComponent.this.buildClientUpdate(e);
            }
        });
    }

    protected void buildClientUpdate(ClientUpdateEvent e) {
        DynmapWorld world = e.world;
        JSONObject u = e.update;
        long since = e.timestamp;
        String worldName = world.getName();
        boolean see_all = true;
        if (this.is_protected && !e.include_all_users) {
            see_all = e.user != null ? this.core.getServer().checkPlayerPermission(e.user, "playermarkers.seeall") : false;
        }
        if (e.include_all_users && this.is_protected) {
            JSONUtils.s(u, "protected", true);
        }
        JSONUtils.s(u, "confighash", this.core.getConfigHashcode());
        JSONUtils.s(u, "servertime", world.getTime() % 24000L);
        JSONUtils.s(u, "hasStorm", world.hasStorm());
        JSONUtils.s(u, "isThundering", world.isThundering());
        JSONUtils.s(u, "players", new JSONArray());
        List<DynmapPlayer> players = this.core.playerList.getVisiblePlayers();
        for (DynmapPlayer p : players) {
            boolean hide = false;
            DynmapLocation pl = p.getLocation();
            DynmapWorld pw = this.core.getWorld(pl.world);
            if (pw == null) {
                hide = true;
            }
            JSONObject jp = new JSONObject();
            JSONUtils.s(jp, "type", "player");
            if (hideNames) {
                JSONUtils.s(jp, "name", "");
            } else if (usePlayerColors) {
                JSONUtils.s(jp, "name", Client.encodeColorInHTML(p.getDisplayName()));
            } else {
                JSONUtils.s(jp, "name", Client.stripColor(p.getDisplayName()));
            }
            JSONUtils.s(jp, "account", p.getName());
            if (!hide && this.hideifshadow < 15 && pw.getLightLevel((int)pl.x, (int)pl.y, (int)pl.z) <= this.hideifshadow) {
                hide = true;
            }
            if (!hide && this.hideifunder < 15) {
                if (pw.canGetSkyLightLevel()) {
                    if (pw.getSkyLightLevel((int)pl.x, (int)pl.y, (int)pl.z) <= this.hideifunder) {
                        hide = true;
                    }
                } else if (!pw.isNether() && (double)pw.getHighestBlockYAt((int)pl.x, (int)pl.z) > pl.y) {
                    hide = true;
                }
            }
            if (!hide && this.hideifsneaking && p.isSneaking()) {
                hide = true;
            }
            if (!hide && this.is_protected && !see_all) {
                hide = e.user != null ? !this.core.testIfPlayerVisibleToPlayer(e.user, p.getName()) : true;
            }
            if (!hide && this.hideifinvisiblepotion && p.isInvisible()) {
                hide = true;
            }
            DynmapWorld pworld = MapManager.mapman.worldsLookup.get(pl.world);
            if (this.configuration.getBoolean("sendposition", true) && this.configuration.getBoolean("sendpositon", true) && pworld != null && pworld.sendposition && !hide) {
                JSONUtils.s(jp, "world", pl.world);
                JSONUtils.s(jp, "x", pl.x);
                JSONUtils.s(jp, "y", pl.y);
                JSONUtils.s(jp, "z", pl.z);
            } else {
                JSONUtils.s(jp, "world", "-some-other-bogus-world-");
                JSONUtils.s(jp, "x", 0.0);
                JSONUtils.s(jp, "y", 64.0);
                JSONUtils.s(jp, "z", 0.0);
            }
            if (this.configuration.getBoolean("sendhealth", false) && pworld != null && pworld.sendhealth && !hide) {
                JSONUtils.s(jp, "health", p.getHealth());
                JSONUtils.s(jp, "armor", p.getArmorPoints());
            } else {
                JSONUtils.s(jp, "health", 0);
                JSONUtils.s(jp, "armor", 0);
            }
            JSONUtils.s(jp, "sort", p.getSortWeight());
            JSONUtils.a(u, "players", jp);
        }
        List<DynmapPlayer> hidden = this.core.playerList.getHiddenPlayers();
        if (this.configuration.getBoolean("includehiddenplayers", false)) {
            for (DynmapPlayer p : hidden) {
                JSONObject jp = new JSONObject();
                JSONUtils.s(jp, "type", "player");
                if (hideNames) {
                    JSONUtils.s(jp, "name", "");
                } else if (usePlayerColors) {
                    JSONUtils.s(jp, "name", Client.encodeColorInHTML(p.getDisplayName()));
                } else {
                    JSONUtils.s(jp, "name", Client.stripColor(p.getDisplayName()));
                }
                JSONUtils.s(jp, "account", p.getName());
                JSONUtils.s(jp, "world", "-hidden-player-");
                JSONUtils.s(jp, "x", 0.0);
                JSONUtils.s(jp, "y", 64.0);
                JSONUtils.s(jp, "z", 0.0);
                JSONUtils.s(jp, "health", 0);
                JSONUtils.s(jp, "armor", 0);
                JSONUtils.s(jp, "sort", p.getSortWeight());
                JSONUtils.a(u, "players", jp);
            }
            JSONUtils.s(u, "currentcount", this.core.getCurrentPlayers());
        } else {
            JSONUtils.s(u, "currentcount", this.core.getCurrentPlayers() - hidden.size());
        }
        JSONUtils.s(u, "updates", new JSONArray());
        for (Client.Update update : this.core.mapManager.getWorldUpdates(worldName, since)) {
            JSONUtils.a(u, "updates", update);
        }
    }
}

