/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.List;
import java.util.Map;
import org.dynmap.Component;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.Event;
import org.dynmap.JSONUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ClientComponent
extends Component {
    private boolean disabled;

    public ClientComponent(DynmapCore plugin, ConfigurationNode configuration) {
        super(plugin, configuration);
        plugin.events.addListener("buildclientconfiguration", new Event.Listener<JSONObject>(){

            @Override
            public void triggered(JSONObject root) {
                if (!ClientComponent.this.disabled) {
                    ClientComponent.this.buildClientConfiguration(root);
                }
            }
        });
    }

    protected void disableComponent() {
        this.disabled = true;
    }

    protected void buildClientConfiguration(JSONObject root) {
        JSONObject o = this.createClientConfiguration();
        JSONUtils.a(root, "components", o);
    }

    protected JSONObject createClientConfiguration() {
        JSONObject o = ClientComponent.convertMap(this.configuration);
        o.remove((Object)"class");
        return o;
    }

    protected static final JSONObject convertMap(Map<String, ?> m) {
        JSONObject o = new JSONObject();
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            JSONUtils.s(o, entry.getKey(), ClientComponent.convert(entry.getValue()));
        }
        return o;
    }

    protected static final JSONArray convertList(List<?> l) {
        JSONArray o = new JSONArray();
        for (Object entry : l) {
            o.add(ClientComponent.convert(entry));
        }
        return o;
    }

    protected static final Object convert(Object o) {
        if (o instanceof Map) {
            return ClientComponent.convertMap((Map)o);
        }
        if (o instanceof List) {
            return ClientComponent.convertList((List)o);
        }
        return o;
    }
}

