/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.dark;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.netbeans.swing.laf.dark.DarkMetalLookAndFeel;
import org.netbeans.swing.laf.dark.DarkNimbusLookAndFeel;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private static boolean switchEditorColors = false;
    private static final String COLOR_MODEL_CLASS_NAME = "org.netbeans.modules.options.colors.ColorModel";
    private static final String DARK_COLOR_THEME_NAME = "Norway Today";

    public void restored() {
        if (switchEditorColors) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    Installer.this.switchEditorColorsProfile();
                }
            });
        }
    }

    public void validate() throws IllegalStateException {
        Preferences prefs = this.getPreferences();
        if (!prefs.getBoolean("dark.themes.installed", false)) {
            prefs.put("laf", DarkMetalLookAndFeel.class.getName());
            switchEditorColors = true;
        }
        prefs.putBoolean("dark.themes.installed", true);
        UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo(NbBundle.getMessage(Installer.class, (String)"LBL_DARK_METAL"), DarkMetalLookAndFeel.class.getName()));
        UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo(NbBundle.getMessage(Installer.class, (String)"LBL_DARK_NIMBUS"), DarkNimbusLookAndFeel.class.getName()));
    }

    private boolean isChangeEditorColorsPossible() {
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == cl) {
            cl = Installer.class.getClassLoader();
        }
        try {
            Class<?> klz = cl.loadClass(COLOR_MODEL_CLASS_NAME);
            Object colorModel = klz.newInstance();
            Method m = klz.getDeclaredMethod("getCurrentProfile", new Class[0]);
            Object res = m.invoke(colorModel, new Object[0]);
            return res != null && !DARK_COLOR_THEME_NAME.equals(res);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void switchEditorColorsProfile() {
        if (!this.isChangeEditorColorsPossible()) {
            return;
        }
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == cl) {
            cl = Installer.class.getClassLoader();
        }
        try {
            Class<?> klz = cl.loadClass(COLOR_MODEL_CLASS_NAME);
            Object colorModel = klz.newInstance();
            Method m = klz.getDeclaredMethod("setCurrentProfile", String.class);
            m.invoke(colorModel, DARK_COLOR_THEME_NAME);
        }
        catch (Exception ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.INFO, "Cannot change editor colors profile.", ex);
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.root().node("laf");
    }
}

