/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.undo;

import java.util.HashMap;
import java.util.Map;
import org.pepsoft.util.undo.BufferKey;
import org.pepsoft.util.undo.UndoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Snapshot {
    private final UndoManager undoManager;
    int frame;
    private final Map<BufferKey<?>, Object> bufferCache = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(Snapshot.class);

    Snapshot(UndoManager undoManager, int frame) {
        this.undoManager = undoManager;
        this.frame = frame;
    }

    public <T> T getBuffer(BufferKey<T> key) {
        if (this.frame == -1) {
            throw new IllegalStateException("Undo history frame no longer available");
        }
        if (this.bufferCache.containsKey(key)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Getting buffer " + key + " for reading from buffer cache");
            }
            return (T)this.bufferCache.get(key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Getting buffer " + key + " for reading from history");
        }
        T buffer = this.undoManager.findMostRecentCopy(key, this.frame);
        this.bufferCache.put(key, buffer);
        return buffer;
    }
}

