/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.jobqueue;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;

public class HashList<E>
extends AbstractList<E>
implements Set<E> {
    private final Map<E, Element<E>> map;
    private final Element<E> anchor = new Element<Object>(null);

    public HashList() {
        this.anchor.previous = this.anchor;
        this.anchor.next = this.anchor;
        this.map = new HashMap<E, Element<E>>();
    }

    public HashList(int initialCapacity) {
        this.anchor.previous = this.anchor;
        this.anchor.next = this.anchor;
        this.map = new HashMap<E, Element<E>>(initialCapacity);
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public boolean addToEnd(E e) {
        Element<E> element = this.map.get(e);
        if (element != null) {
            if (this.anchor.previous == element) {
                return false;
            }
            element.previous.next = element.next;
            element.next.previous = element.previous;
            element.next = this.anchor;
            element.previous = this.anchor.previous;
            element.previous.next = element;
            this.anchor.previous = element;
            return true;
        }
        element = new Element<E>(e);
        this.map.put(e, element);
        element.next = this.anchor;
        element.previous = this.anchor.previous;
        element.previous.next = element;
        this.anchor.previous = element;
        return true;
    }

    @Override
    public boolean add(E e) {
        if (this.map.containsKey(e)) {
            return false;
        }
        Element<E> element = new Element<E>(e);
        this.map.put(e, element);
        element.next = this.anchor;
        element.previous = this.anchor.previous;
        element.previous.next = element;
        this.anchor.previous = element;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (this.map.containsKey(o)) {
            Element<E> element = this.map.remove(o);
            element.previous.next = element.next;
            element.next.previous = element.previous;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.anchor.next = this.anchor;
        this.anchor.previous = this.anchor;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.map.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        Element<Object> element = this.anchor;
        for (int i = 0; i <= index; ++i) {
            element = element.next;
        }
        return (E)element.object;
    }

    @Override
    public E set(int index, E e) {
        if (index < 0 || index >= this.map.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        Element<Object> element = this.anchor;
        for (int i = 0; i <= index; ++i) {
            element = element.next;
        }
        Object previous = element.object;
        element.object = e;
        this.map.put(e, element);
        return (E)previous;
    }

    @Override
    public void add(int index, E e) {
        if (index < 0 || index > this.map.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        Element<Object> element = this.anchor;
        for (int i = 0; i < index; ++i) {
            element = element.next;
        }
        Element<E> newElement = new Element<E>(e);
        newElement.previous = element;
        newElement.next = element.next;
        element.next.previous = newElement;
        element.next = newElement;
        if (this.map.containsKey(e)) {
            Element<E> existingElement = this.map.get(e);
            existingElement.previous.next = existingElement.next;
            existingElement.next.previous = existingElement.previous;
        }
        this.map.put(e, newElement);
    }

    @Override
    public E remove(int index) {
        if (index < 0 || index >= this.map.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        Element<Object> element = this.anchor;
        for (int i = 0; i <= index; ++i) {
            element = element.next;
        }
        element.previous.next = element.next;
        element.next.previous = element.previous;
        this.map.remove(element.object);
        return (E)element.object;
    }

    @Override
    public int indexOf(Object o) {
        if (!this.map.containsKey(o)) {
            return -1;
        }
        Element<Object> element = this.map.get(o);
        int count = 0;
        while (element.previous != this.anchor) {
            element = element.previous;
            ++count;
        }
        return count;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<E> listIterator(final int initialIndex) {
        if (initialIndex < 0 || initialIndex >= this.map.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(initialIndex));
        }
        Element<Object> element = this.anchor;
        for (int i = 0; i <= initialIndex; ++i) {
            element = element.next;
        }
        final Element<E> startElement = element;
        return new ListIterator<E>(){
            private Element<E> element;
            private int index;
            {
                this.element = startElement;
                this.index = initialIndex - 1;
            }

            @Override
            public boolean hasNext() {
                return this.element.next != HashList.this.anchor;
            }

            @Override
            public E next() {
                if (this.element.next == HashList.this.anchor) {
                    throw new NoSuchElementException();
                }
                this.element = this.element.next;
                ++this.index;
                return this.element.object;
            }

            @Override
            public boolean hasPrevious() {
                return this.element != HashList.this.anchor;
            }

            @Override
            public E previous() {
                if (this.element == HashList.this.anchor) {
                    throw new NoSuchElementException();
                }
                Object obj = this.element.object;
                this.element = this.element.previous;
                --this.index;
                return obj;
            }

            @Override
            public int nextIndex() {
                return this.index + 1;
            }

            @Override
            public int previousIndex() {
                return this.index;
            }

            @Override
            public void remove() {
                HashList.this.remove(this.element.object);
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException("Not supported");
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 17);
    }

    static class Element<T> {
        T object;
        Element<T> previous;
        Element<T> next;

        Element(T object) {
            this.object = object;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Element other = (Element)obj;
            return this.object == other.object || this.object != null && this.object.equals(other.object);
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.object != null ? this.object.hashCode() : 0);
            return hash;
        }
    }
}

